# coding: utf-8

"""
Specification file for tiledb-server v4 API

This spec is exposed to the public under /v4 route group  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: info@tiledb.com
Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from tiledb.client._common.api_v4.configuration import Configuration


class User(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "id": "str",
        "display_name": "str",
        "image_id": "str",
        "email": "str",
        "is_valid_email": "bool",
        "role": "UserRole",
        "username": "str",
        "timezone": "str",
        "created_at": "datetime",
        "updated_at": "datetime",
        "deleted_at": "datetime",
    }

    attribute_map = {
        "id": "id",
        "display_name": "display_name",
        "image_id": "image_id",
        "email": "email",
        "is_valid_email": "is_valid_email",
        "role": "role",
        "username": "username",
        "timezone": "timezone",
        "created_at": "created_at",
        "updated_at": "updated_at",
        "deleted_at": "deleted_at",
    }

    def __init__(
        self,
        id=None,
        display_name=None,
        image_id=None,
        email=None,
        is_valid_email=None,
        role=None,
        username=None,
        timezone=None,
        created_at=None,
        updated_at=None,
        deleted_at=None,
        local_vars_configuration=None,
    ):  # noqa: E501
        """User - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._display_name = None
        self._image_id = None
        self._email = None
        self._is_valid_email = None
        self._role = None
        self._username = None
        self._timezone = None
        self._created_at = None
        self._updated_at = None
        self._deleted_at = None
        self.discriminator = None

        self.id = id
        self.display_name = display_name
        if image_id is not None:
            self.image_id = image_id
        self.email = email
        if is_valid_email is not None:
            self.is_valid_email = is_valid_email
        self.role = role
        self.username = username
        self.timezone = timezone
        self.created_at = created_at
        if updated_at is not None:
            self.updated_at = updated_at
        if deleted_at is not None:
            self.deleted_at = deleted_at

    @property
    def id(self):
        """Gets the id of this User.  # noqa: E501

        The user's ID  # noqa: E501

        :return: The id of this User.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this User.

        The user's ID  # noqa: E501

        :param id: The id of this User.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation and id is None
        ):  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def display_name(self):
        """Gets the display_name of this User.  # noqa: E501

        display name of the user  # noqa: E501

        :return: The display_name of this User.  # noqa: E501
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """Sets the display_name of this User.

        display name of the user  # noqa: E501

        :param display_name: The display_name of this User.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation
            and display_name is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `display_name`, must not be `None`"
            )  # noqa: E501

        self._display_name = display_name

    @property
    def image_id(self):
        """Gets the image_id of this User.  # noqa: E501

        The image's ID  # noqa: E501

        :return: The image_id of this User.  # noqa: E501
        :rtype: str
        """
        return self._image_id

    @image_id.setter
    def image_id(self, image_id):
        """Sets the image_id of this User.

        The image's ID  # noqa: E501

        :param image_id: The image_id of this User.  # noqa: E501
        :type: str
        """

        self._image_id = image_id

    @property
    def email(self):
        """Gets the email of this User.  # noqa: E501

        user email  # noqa: E501

        :return: The email of this User.  # noqa: E501
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """Sets the email of this User.

        user email  # noqa: E501

        :param email: The email of this User.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation and email is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `email`, must not be `None`"
            )  # noqa: E501

        self._email = email

    @property
    def is_valid_email(self):
        """Gets the is_valid_email of this User.  # noqa: E501

        if a user has validated their email  # noqa: E501

        :return: The is_valid_email of this User.  # noqa: E501
        :rtype: bool
        """
        return self._is_valid_email

    @is_valid_email.setter
    def is_valid_email(self, is_valid_email):
        """Sets the is_valid_email of this User.

        if a user has validated their email  # noqa: E501

        :param is_valid_email: The is_valid_email of this User.  # noqa: E501
        :type: bool
        """

        self._is_valid_email = is_valid_email

    @property
    def role(self):
        """Gets the role of this User.  # noqa: E501


        :return: The role of this User.  # noqa: E501
        :rtype: UserRole
        """
        return self._role

    @role.setter
    def role(self, role):
        """Sets the role of this User.


        :param role: The role of this User.  # noqa: E501
        :type: UserRole
        """
        if (
            self.local_vars_configuration.client_side_validation and role is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `role`, must not be `None`"
            )  # noqa: E501

        self._role = role

    @property
    def username(self):
        """Gets the username of this User.  # noqa: E501

        user email  # noqa: E501

        :return: The username of this User.  # noqa: E501
        :rtype: str
        """
        return self._username

    @username.setter
    def username(self, username):
        """Sets the username of this User.

        user email  # noqa: E501

        :param username: The username of this User.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation and username is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `username`, must not be `None`"
            )  # noqa: E501

        self._username = username

    @property
    def timezone(self):
        """Gets the timezone of this User.  # noqa: E501

        user timezone  # noqa: E501

        :return: The timezone of this User.  # noqa: E501
        :rtype: str
        """
        return self._timezone

    @timezone.setter
    def timezone(self, timezone):
        """Sets the timezone of this User.

        user timezone  # noqa: E501

        :param timezone: The timezone of this User.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation and timezone is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `timezone`, must not be `None`"
            )  # noqa: E501

        self._timezone = timezone

    @property
    def created_at(self):
        """Gets the created_at of this User.  # noqa: E501

        Datetime the user was created in UTC  # noqa: E501

        :return: The created_at of this User.  # noqa: E501
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this User.

        Datetime the user was created in UTC  # noqa: E501

        :param created_at: The created_at of this User.  # noqa: E501
        :type: datetime
        """
        if (
            self.local_vars_configuration.client_side_validation and created_at is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `created_at`, must not be `None`"
            )  # noqa: E501

        self._created_at = created_at

    @property
    def updated_at(self):
        """Gets the updated_at of this User.  # noqa: E501

        Datetime the user was updated in UTC  # noqa: E501

        :return: The updated_at of this User.  # noqa: E501
        :rtype: datetime
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """Sets the updated_at of this User.

        Datetime the user was updated in UTC  # noqa: E501

        :param updated_at: The updated_at of this User.  # noqa: E501
        :type: datetime
        """

        self._updated_at = updated_at

    @property
    def deleted_at(self):
        """Gets the deleted_at of this User.  # noqa: E501

        Datetime the user was deleted in UTC  # noqa: E501

        :return: The deleted_at of this User.  # noqa: E501
        :rtype: datetime
        """
        return self._deleted_at

    @deleted_at.setter
    def deleted_at(self, deleted_at):
        """Sets the deleted_at of this User.

        Datetime the user was deleted in UTC  # noqa: E501

        :param deleted_at: The deleted_at of this User.  # noqa: E501
        :type: datetime
        """

        self._deleted_at = deleted_at

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (
                            (item[0], item[1].to_dict())
                            if hasattr(item[1], "to_dict")
                            else item
                        ),
                        value.items(),
                    )
                )
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, User):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, User):
            return True

        return self.to_dict() != other.to_dict()
