# coding: utf-8

"""
Specification file for tiledb-server v4 API

This spec is exposed to the public under /v4 route group  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: info@tiledb.com
Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from tiledb.client._common.api_v4.configuration import Configuration


class Versions(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "go_version": "str",
        "tiledb_version": "str",
        "udf_images_version": "list[str]",
        "vcs_name": "str",
        "vcs_revision": "str",
        "vcs_time": "datetime",
        "build_id": "str",
    }

    attribute_map = {
        "go_version": "go_version",
        "tiledb_version": "tiledb_version",
        "udf_images_version": "udf_images_version",
        "vcs_name": "vcs_name",
        "vcs_revision": "vcs_revision",
        "vcs_time": "vcs_time",
        "build_id": "build_id",
    }

    def __init__(
        self,
        go_version=None,
        tiledb_version=None,
        udf_images_version=None,
        vcs_name=None,
        vcs_revision=None,
        vcs_time=None,
        build_id=None,
        local_vars_configuration=None,
    ):  # noqa: E501
        """Versions - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._go_version = None
        self._tiledb_version = None
        self._udf_images_version = None
        self._vcs_name = None
        self._vcs_revision = None
        self._vcs_time = None
        self._build_id = None
        self.discriminator = None

        self.go_version = go_version
        self.tiledb_version = tiledb_version
        self.udf_images_version = udf_images_version
        if vcs_name is not None:
            self.vcs_name = vcs_name
        if vcs_revision is not None:
            self.vcs_revision = vcs_revision
        if vcs_time is not None:
            self.vcs_time = vcs_time
        if build_id is not None:
            self.build_id = build_id

    @property
    def go_version(self):
        """Gets the go_version of this Versions.  # noqa: E501

        The version of Go used to build the server  # noqa: E501

        :return: The go_version of this Versions.  # noqa: E501
        :rtype: str
        """
        return self._go_version

    @go_version.setter
    def go_version(self, go_version):
        """Sets the go_version of this Versions.

        The version of Go used to build the server  # noqa: E501

        :param go_version: The go_version of this Versions.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation and go_version is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `go_version`, must not be `None`"
            )  # noqa: E501

        self._go_version = go_version

    @property
    def tiledb_version(self):
        """Gets the tiledb_version of this Versions.  # noqa: E501

        The version of TileDB used by the server  # noqa: E501

        :return: The tiledb_version of this Versions.  # noqa: E501
        :rtype: str
        """
        return self._tiledb_version

    @tiledb_version.setter
    def tiledb_version(self, tiledb_version):
        """Sets the tiledb_version of this Versions.

        The version of TileDB used by the server  # noqa: E501

        :param tiledb_version: The tiledb_version of this Versions.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation
            and tiledb_version is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `tiledb_version`, must not be `None`"
            )  # noqa: E501

        self._tiledb_version = tiledb_version

    @property
    def udf_images_version(self):
        """Gets the udf_images_version of this Versions.  # noqa: E501

        The UDF images that the server supports  # noqa: E501

        :return: The udf_images_version of this Versions.  # noqa: E501
        :rtype: list[str]
        """
        return self._udf_images_version

    @udf_images_version.setter
    def udf_images_version(self, udf_images_version):
        """Sets the udf_images_version of this Versions.

        The UDF images that the server supports  # noqa: E501

        :param udf_images_version: The udf_images_version of this Versions.  # noqa: E501
        :type: list[str]
        """
        if (
            self.local_vars_configuration.client_side_validation
            and udf_images_version is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `udf_images_version`, must not be `None`"
            )  # noqa: E501

        self._udf_images_version = udf_images_version

    @property
    def vcs_name(self):
        """Gets the vcs_name of this Versions.  # noqa: E501

        The name of the version control system (vcs) used to develop the server   # noqa: E501

        :return: The vcs_name of this Versions.  # noqa: E501
        :rtype: str
        """
        return self._vcs_name

    @vcs_name.setter
    def vcs_name(self, vcs_name):
        """Sets the vcs_name of this Versions.

        The name of the version control system (vcs) used to develop the server   # noqa: E501

        :param vcs_name: The vcs_name of this Versions.  # noqa: E501
        :type: str
        """

        self._vcs_name = vcs_name

    @property
    def vcs_revision(self):
        """Gets the vcs_revision of this Versions.  # noqa: E501

        The vcs revision of the server  # noqa: E501

        :return: The vcs_revision of this Versions.  # noqa: E501
        :rtype: str
        """
        return self._vcs_revision

    @vcs_revision.setter
    def vcs_revision(self, vcs_revision):
        """Sets the vcs_revision of this Versions.

        The vcs revision of the server  # noqa: E501

        :param vcs_revision: The vcs_revision of this Versions.  # noqa: E501
        :type: str
        """

        self._vcs_revision = vcs_revision

    @property
    def vcs_time(self):
        """Gets the vcs_time of this Versions.  # noqa: E501

        The modification time associated with the vcs revision  # noqa: E501

        :return: The vcs_time of this Versions.  # noqa: E501
        :rtype: datetime
        """
        return self._vcs_time

    @vcs_time.setter
    def vcs_time(self, vcs_time):
        """Sets the vcs_time of this Versions.

        The modification time associated with the vcs revision  # noqa: E501

        :param vcs_time: The vcs_time of this Versions.  # noqa: E501
        :type: datetime
        """

        self._vcs_time = vcs_time

    @property
    def build_id(self):
        """Gets the build_id of this Versions.  # noqa: E501

        The build ID of the server. If set, this will be either the branch name or the git tag.   # noqa: E501

        :return: The build_id of this Versions.  # noqa: E501
        :rtype: str
        """
        return self._build_id

    @build_id.setter
    def build_id(self, build_id):
        """Sets the build_id of this Versions.

        The build ID of the server. If set, this will be either the branch name or the git tag.   # noqa: E501

        :param build_id: The build_id of this Versions.  # noqa: E501
        :type: str
        """

        self._build_id = build_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (
                            (item[0], item[1].to_dict())
                            if hasattr(item[1], "to_dict")
                            else item
                        ),
                        value.items(),
                    )
                )
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Versions):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Versions):
            return True

        return self.to_dict() != other.to_dict()
