# coding: utf-8

"""
Specification file for tiledb-server v4 API

This spec is exposed to the public under /v4 route group  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: info@tiledb.com
Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from tiledb.client._common.api_v4.configuration import Configuration


class WorkspaceCreateRequest(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "name": "str",
        "description": "str",
        "image": "str",
        "default_credential": "CredentialCreateRequest",
        "default_storage_setting": "StorageSettingsCreateRequest",
    }

    attribute_map = {
        "name": "name",
        "description": "description",
        "image": "image",
        "default_credential": "default_credential",
        "default_storage_setting": "default_storage_setting",
    }

    def __init__(
        self,
        name=None,
        description=None,
        image=None,
        default_credential=None,
        default_storage_setting=None,
        local_vars_configuration=None,
    ):  # noqa: E501
        """WorkspaceCreateRequest - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._name = None
        self._description = None
        self._image = None
        self._default_credential = None
        self._default_storage_setting = None
        self.discriminator = None

        self.name = name
        if description is not None:
            self.description = description
        if image is not None:
            self.image = image
        self.default_credential = default_credential
        self.default_storage_setting = default_storage_setting

    @property
    def name(self):
        """Gets the name of this WorkspaceCreateRequest.  # noqa: E501

        workspace name  # noqa: E501

        :return: The name of this WorkspaceCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this WorkspaceCreateRequest.

        workspace name  # noqa: E501

        :param name: The name of this WorkspaceCreateRequest.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation and name is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `name`, must not be `None`"
            )  # noqa: E501
        if (
            self.local_vars_configuration.client_side_validation
            and name is not None
            and len(name) > 64
        ):
            raise ValueError(
                "Invalid value for `name`, length must be less than or equal to `64`"
            )  # noqa: E501

        self._name = name

    @property
    def description(self):
        """Gets the description of this WorkspaceCreateRequest.  # noqa: E501

        Workspace description  # noqa: E501

        :return: The description of this WorkspaceCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this WorkspaceCreateRequest.

        Workspace description  # noqa: E501

        :param description: The description of this WorkspaceCreateRequest.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def image(self):
        """Gets the image of this WorkspaceCreateRequest.  # noqa: E501

        Image data in the form data:image/png;base64,iVBORw0KGgoAAAA  # noqa: E501

        :return: The image of this WorkspaceCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._image

    @image.setter
    def image(self, image):
        """Sets the image of this WorkspaceCreateRequest.

        Image data in the form data:image/png;base64,iVBORw0KGgoAAAA  # noqa: E501

        :param image: The image of this WorkspaceCreateRequest.  # noqa: E501
        :type: str
        """

        self._image = image

    @property
    def default_credential(self):
        """Gets the default_credential of this WorkspaceCreateRequest.  # noqa: E501


        :return: The default_credential of this WorkspaceCreateRequest.  # noqa: E501
        :rtype: CredentialCreateRequest
        """
        return self._default_credential

    @default_credential.setter
    def default_credential(self, default_credential):
        """Sets the default_credential of this WorkspaceCreateRequest.


        :param default_credential: The default_credential of this WorkspaceCreateRequest.  # noqa: E501
        :type: CredentialCreateRequest
        """
        if (
            self.local_vars_configuration.client_side_validation
            and default_credential is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `default_credential`, must not be `None`"
            )  # noqa: E501

        self._default_credential = default_credential

    @property
    def default_storage_setting(self):
        """Gets the default_storage_setting of this WorkspaceCreateRequest.  # noqa: E501


        :return: The default_storage_setting of this WorkspaceCreateRequest.  # noqa: E501
        :rtype: StorageSettingsCreateRequest
        """
        return self._default_storage_setting

    @default_storage_setting.setter
    def default_storage_setting(self, default_storage_setting):
        """Sets the default_storage_setting of this WorkspaceCreateRequest.


        :param default_storage_setting: The default_storage_setting of this WorkspaceCreateRequest.  # noqa: E501
        :type: StorageSettingsCreateRequest
        """
        if (
            self.local_vars_configuration.client_side_validation
            and default_storage_setting is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `default_storage_setting`, must not be `None`"
            )  # noqa: E501

        self._default_storage_setting = default_storage_setting

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (
                            (item[0], item[1].to_dict())
                            if hasattr(item[1], "to_dict")
                            else item
                        ),
                        value.items(),
                    )
                )
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, WorkspaceCreateRequest):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, WorkspaceCreateRequest):
            return True

        return self.to_dict() != other.to_dict()
