# coding: utf-8

"""
TileDB Storage Platform API

TileDB Storage Platform REST API  # noqa: E501

The version of the OpenAPI document: 2.17.51
Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from tiledb.client.rest_api.api_client import ApiClient
from tiledb.client.rest_api.exceptions import ApiTypeError  # noqa: F401
from tiledb.client.rest_api.exceptions import ApiValueError  # noqa: F401


class AssetsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def change_asset_credentials(
        self, workspace, teamspace, change_credentials_request, **kwargs
    ):  # noqa: E501
        """change_asset_credentials  # noqa: E501

        Changes the access credentials to the given assets  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.change_asset_credentials(workspace, teamspace, change_credentials_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workspace: the workspace containing the teamspace the array belongs to (required)
        :param str teamspace: the teamspace the array belongs to (required)
        :param ChangeAssetCredentialsRequest change_credentials_request: aws access credentials to store for a namespace (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.change_asset_credentials_with_http_info(
            workspace, teamspace, change_credentials_request, **kwargs
        )  # noqa: E501

    def change_asset_credentials_with_http_info(
        self, workspace, teamspace, change_credentials_request, **kwargs
    ):  # noqa: E501
        """change_asset_credentials  # noqa: E501

        Changes the access credentials to the given assets  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.change_asset_credentials_with_http_info(workspace, teamspace, change_credentials_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workspace: the workspace containing the teamspace the array belongs to (required)
        :param str teamspace: the teamspace the array belongs to (required)
        :param ChangeAssetCredentialsRequest change_credentials_request: aws access credentials to store for a namespace (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["workspace", "teamspace", "change_credentials_request"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method change_asset_credentials" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'workspace' is set
        if self.api_client.client_side_validation and (
            "workspace" not in local_var_params  # noqa: E501
            or local_var_params["workspace"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `workspace` when calling `change_asset_credentials`"
            )  # noqa: E501
        # verify the required parameter 'teamspace' is set
        if self.api_client.client_side_validation and (
            "teamspace" not in local_var_params  # noqa: E501
            or local_var_params["teamspace"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `teamspace` when calling `change_asset_credentials`"
            )  # noqa: E501
        # verify the required parameter 'change_credentials_request' is set
        if self.api_client.client_side_validation and (
            "change_credentials_request" not in local_var_params  # noqa: E501
            or local_var_params["change_credentials_request"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `change_credentials_request` when calling `change_asset_credentials`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "workspace" in local_var_params:
            path_params["workspace"] = local_var_params["workspace"]  # noqa: E501
        if "teamspace" in local_var_params:
            path_params["teamspace"] = local_var_params["teamspace"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "change_credentials_request" in local_var_params:
            body_params = local_var_params["change_credentials_request"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params["Content-Type"] = (
            self.api_client.select_header_content_type(  # noqa: E501
                ["application/json"]
            )
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKeyAuth", "BasicAuth"]  # noqa: E501

        return self.api_client.call_api(
            "/v1/assets/{workspace}/{teamspace}/change_credentials",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def list_assets(self, workspace, teamspace, **kwargs):  # noqa: E501
        """list_assets  # noqa: E501

        List assets in a namespace  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_assets(workspace, teamspace, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workspace: the workspace containing the teamspace the array belongs to (required)
        :param str teamspace: the teamspace the array belongs to (required)
        :param str asset_type: asset_type to filter to
        :param str ownership_level: ownership_level to filter to (owned, shared)
        :param str depth: depth of assets to be returned
        :param str search: search string
        :param int page: pagination offset
        :param int per_page: pagination limit
        :param str order_by: order by a specific property, defaults to `created_at desc` supported values are created_at, name, asset_type can also include the order type (asc or desc) separated by space i.e. `name asc` `name desc` etc.
        :param str expand: expansion option for the AssetInfo object to be added to the response
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AssetListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.list_assets_with_http_info(
            workspace, teamspace, **kwargs
        )  # noqa: E501

    def list_assets_with_http_info(self, workspace, teamspace, **kwargs):  # noqa: E501
        """list_assets  # noqa: E501

        List assets in a namespace  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_assets_with_http_info(workspace, teamspace, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workspace: the workspace containing the teamspace the array belongs to (required)
        :param str teamspace: the teamspace the array belongs to (required)
        :param str asset_type: asset_type to filter to
        :param str ownership_level: ownership_level to filter to (owned, shared)
        :param str depth: depth of assets to be returned
        :param str search: search string
        :param int page: pagination offset
        :param int per_page: pagination limit
        :param str order_by: order by a specific property, defaults to `created_at desc` supported values are created_at, name, asset_type can also include the order type (asc or desc) separated by space i.e. `name asc` `name desc` etc.
        :param str expand: expansion option for the AssetInfo object to be added to the response
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AssetListResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            "workspace",
            "teamspace",
            "asset_type",
            "ownership_level",
            "depth",
            "search",
            "page",
            "per_page",
            "order_by",
            "expand",
        ]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_assets" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'workspace' is set
        if self.api_client.client_side_validation and (
            "workspace" not in local_var_params  # noqa: E501
            or local_var_params["workspace"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `workspace` when calling `list_assets`"
            )  # noqa: E501
        # verify the required parameter 'teamspace' is set
        if self.api_client.client_side_validation and (
            "teamspace" not in local_var_params  # noqa: E501
            or local_var_params["teamspace"] is None
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `teamspace` when calling `list_assets`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "workspace" in local_var_params:
            path_params["workspace"] = local_var_params["workspace"]  # noqa: E501
        if "teamspace" in local_var_params:
            path_params["teamspace"] = local_var_params["teamspace"]  # noqa: E501

        query_params = []
        if (
            "asset_type" in local_var_params
            and local_var_params["asset_type"] is not None
        ):  # noqa: E501
            query_params.append(
                ("asset_type", local_var_params["asset_type"])
            )  # noqa: E501
        if (
            "ownership_level" in local_var_params
            and local_var_params["ownership_level"] is not None
        ):  # noqa: E501
            query_params.append(
                ("ownership_level", local_var_params["ownership_level"])
            )  # noqa: E501
        if (
            "depth" in local_var_params and local_var_params["depth"] is not None
        ):  # noqa: E501
            query_params.append(("depth", local_var_params["depth"]))  # noqa: E501
        if (
            "search" in local_var_params and local_var_params["search"] is not None
        ):  # noqa: E501
            query_params.append(("search", local_var_params["search"]))  # noqa: E501
        if (
            "page" in local_var_params and local_var_params["page"] is not None
        ):  # noqa: E501
            query_params.append(("page", local_var_params["page"]))  # noqa: E501
        if (
            "per_page" in local_var_params and local_var_params["per_page"] is not None
        ):  # noqa: E501
            query_params.append(
                ("per_page", local_var_params["per_page"])
            )  # noqa: E501
        if (
            "order_by" in local_var_params and local_var_params["order_by"] is not None
        ):  # noqa: E501
            query_params.append(
                ("order_by", local_var_params["order_by"])
            )  # noqa: E501
        if (
            "expand" in local_var_params and local_var_params["expand"] is not None
        ):  # noqa: E501
            query_params.append(("expand", local_var_params["expand"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKeyAuth", "BasicAuth"]  # noqa: E501

        return self.api_client.call_api(
            "/v1/assets/{workspace}/{teamspace}",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="AssetListResponse",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def list_public_assets(self, **kwargs):  # noqa: E501
        """list_public_assets  # noqa: E501

        List public assets  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_public_assets(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str asset_type: asset_type to filter to
        :param str depth: depth of assets to be returned
        :param str search: search string
        :param int page: pagination offset
        :param int per_page: pagination limit
        :param str order_by: order by a specific property, defaults to `created_at desc` supported values are created_at, name, asset_type can also include the order type (asc or desc) separated by space i.e. `name asc` `name desc` etc.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AssetListResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.list_public_assets_with_http_info(**kwargs)  # noqa: E501

    def list_public_assets_with_http_info(self, **kwargs):  # noqa: E501
        """list_public_assets  # noqa: E501

        List public assets  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_public_assets_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str asset_type: asset_type to filter to
        :param str depth: depth of assets to be returned
        :param str search: search string
        :param int page: pagination offset
        :param int per_page: pagination limit
        :param str order_by: order by a specific property, defaults to `created_at desc` supported values are created_at, name, asset_type can also include the order type (asc or desc) separated by space i.e. `name asc` `name desc` etc.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AssetListResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["asset_type", "depth", "search", "page", "per_page", "order_by"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_public_assets" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]

        collection_formats = {}

        path_params = {}

        query_params = []
        if (
            "asset_type" in local_var_params
            and local_var_params["asset_type"] is not None
        ):  # noqa: E501
            query_params.append(
                ("asset_type", local_var_params["asset_type"])
            )  # noqa: E501
        if (
            "depth" in local_var_params and local_var_params["depth"] is not None
        ):  # noqa: E501
            query_params.append(("depth", local_var_params["depth"]))  # noqa: E501
        if (
            "search" in local_var_params and local_var_params["search"] is not None
        ):  # noqa: E501
            query_params.append(("search", local_var_params["search"]))  # noqa: E501
        if (
            "page" in local_var_params and local_var_params["page"] is not None
        ):  # noqa: E501
            query_params.append(("page", local_var_params["page"]))  # noqa: E501
        if (
            "per_page" in local_var_params and local_var_params["per_page"] is not None
        ):  # noqa: E501
            query_params.append(
                ("per_page", local_var_params["per_page"])
            )  # noqa: E501
        if (
            "order_by" in local_var_params and local_var_params["order_by"] is not None
        ):  # noqa: E501
            query_params.append(
                ("order_by", local_var_params["order_by"])
            )  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApiKeyAuth", "BasicAuth"]  # noqa: E501

        return self.api_client.call_api(
            "/v1/public_assets",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="AssetListResponse",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )
