# coding: utf-8

"""
TileDB Storage Platform API

TileDB Storage Platform REST API  # noqa: E501

The version of the OpenAPI document: 2.17.51
Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from tiledb.client.rest_api.configuration import Configuration


class AssetInfo(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "uuid": "str",
        "asset_type": "AssetType",
        "asset_backing_type": "AssetBackingType",
        "asset_ownership_level": "AssetOwnershipLevel",
        "namespace_name": "str",
        "namespace_uuid": "str",
        "name": "str",
        "mime_type": "str",
        "created_at": "datetime",
        "metadata": "MetadataStringified",
    }

    attribute_map = {
        "uuid": "uuid",
        "asset_type": "asset_type",
        "asset_backing_type": "asset_backing_type",
        "asset_ownership_level": "asset_ownership_level",
        "namespace_name": "namespace_name",
        "namespace_uuid": "namespace_uuid",
        "name": "name",
        "mime_type": "mime_type",
        "created_at": "created_at",
        "metadata": "metadata",
    }

    def __init__(
        self,
        uuid=None,
        asset_type=None,
        asset_backing_type=None,
        asset_ownership_level=None,
        namespace_name=None,
        namespace_uuid=None,
        name=None,
        mime_type=None,
        created_at=None,
        metadata=None,
        local_vars_configuration=None,
    ):  # noqa: E501
        """AssetInfo - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._uuid = None
        self._asset_type = None
        self._asset_backing_type = None
        self._asset_ownership_level = None
        self._namespace_name = None
        self._namespace_uuid = None
        self._name = None
        self._mime_type = None
        self._created_at = None
        self._metadata = None
        self.discriminator = None

        if uuid is not None:
            self.uuid = uuid
        if asset_type is not None:
            self.asset_type = asset_type
        if asset_backing_type is not None:
            self.asset_backing_type = asset_backing_type
        if asset_ownership_level is not None:
            self.asset_ownership_level = asset_ownership_level
        if namespace_name is not None:
            self.namespace_name = namespace_name
        if namespace_uuid is not None:
            self.namespace_uuid = namespace_uuid
        if name is not None:
            self.name = name
        if mime_type is not None:
            self.mime_type = mime_type
        if created_at is not None:
            self.created_at = created_at
        if metadata is not None:
            self.metadata = metadata

    @property
    def uuid(self):
        """Gets the uuid of this AssetInfo.  # noqa: E501

        unique ID of a registered asset  # noqa: E501

        :return: The uuid of this AssetInfo.  # noqa: E501
        :rtype: str
        """
        return self._uuid

    @uuid.setter
    def uuid(self, uuid):
        """Sets the uuid of this AssetInfo.

        unique ID of a registered asset  # noqa: E501

        :param uuid: The uuid of this AssetInfo.  # noqa: E501
        :type: str
        """

        self._uuid = uuid

    @property
    def asset_type(self):
        """Gets the asset_type of this AssetInfo.  # noqa: E501


        :return: The asset_type of this AssetInfo.  # noqa: E501
        :rtype: AssetType
        """
        return self._asset_type

    @asset_type.setter
    def asset_type(self, asset_type):
        """Sets the asset_type of this AssetInfo.


        :param asset_type: The asset_type of this AssetInfo.  # noqa: E501
        :type: AssetType
        """

        self._asset_type = asset_type

    @property
    def asset_backing_type(self):
        """Gets the asset_backing_type of this AssetInfo.  # noqa: E501


        :return: The asset_backing_type of this AssetInfo.  # noqa: E501
        :rtype: AssetBackingType
        """
        return self._asset_backing_type

    @asset_backing_type.setter
    def asset_backing_type(self, asset_backing_type):
        """Sets the asset_backing_type of this AssetInfo.


        :param asset_backing_type: The asset_backing_type of this AssetInfo.  # noqa: E501
        :type: AssetBackingType
        """

        self._asset_backing_type = asset_backing_type

    @property
    def asset_ownership_level(self):
        """Gets the asset_ownership_level of this AssetInfo.  # noqa: E501


        :return: The asset_ownership_level of this AssetInfo.  # noqa: E501
        :rtype: AssetOwnershipLevel
        """
        return self._asset_ownership_level

    @asset_ownership_level.setter
    def asset_ownership_level(self, asset_ownership_level):
        """Sets the asset_ownership_level of this AssetInfo.


        :param asset_ownership_level: The asset_ownership_level of this AssetInfo.  # noqa: E501
        :type: AssetOwnershipLevel
        """

        self._asset_ownership_level = asset_ownership_level

    @property
    def namespace_name(self):
        """Gets the namespace_name of this AssetInfo.  # noqa: E501

        namespace_name that the asset is registered to  # noqa: E501

        :return: The namespace_name of this AssetInfo.  # noqa: E501
        :rtype: str
        """
        return self._namespace_name

    @namespace_name.setter
    def namespace_name(self, namespace_name):
        """Sets the namespace_name of this AssetInfo.

        namespace_name that the asset is registered to  # noqa: E501

        :param namespace_name: The namespace_name of this AssetInfo.  # noqa: E501
        :type: str
        """

        self._namespace_name = namespace_name

    @property
    def namespace_uuid(self):
        """Gets the namespace_uuid of this AssetInfo.  # noqa: E501

        namespace_uuid that the asset is registered to  # noqa: E501

        :return: The namespace_uuid of this AssetInfo.  # noqa: E501
        :rtype: str
        """
        return self._namespace_uuid

    @namespace_uuid.setter
    def namespace_uuid(self, namespace_uuid):
        """Sets the namespace_uuid of this AssetInfo.

        namespace_uuid that the asset is registered to  # noqa: E501

        :param namespace_uuid: The namespace_uuid of this AssetInfo.  # noqa: E501
        :type: str
        """

        self._namespace_uuid = namespace_uuid

    @property
    def name(self):
        """Gets the name of this AssetInfo.  # noqa: E501

        name of asset  # noqa: E501

        :return: The name of this AssetInfo.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this AssetInfo.

        name of asset  # noqa: E501

        :param name: The name of this AssetInfo.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def mime_type(self):
        """Gets the mime_type of this AssetInfo.  # noqa: E501

        mime type of the asset  # noqa: E501

        :return: The mime_type of this AssetInfo.  # noqa: E501
        :rtype: str
        """
        return self._mime_type

    @mime_type.setter
    def mime_type(self, mime_type):
        """Sets the mime_type of this AssetInfo.

        mime type of the asset  # noqa: E501

        :param mime_type: The mime_type of this AssetInfo.  # noqa: E501
        :type: str
        """

        self._mime_type = mime_type

    @property
    def created_at(self):
        """Gets the created_at of this AssetInfo.  # noqa: E501

        Time when the asset was created (rfc3339)  # noqa: E501

        :return: The created_at of this AssetInfo.  # noqa: E501
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this AssetInfo.

        Time when the asset was created (rfc3339)  # noqa: E501

        :param created_at: The created_at of this AssetInfo.  # noqa: E501
        :type: datetime
        """

        self._created_at = created_at

    @property
    def metadata(self):
        """Gets the metadata of this AssetInfo.  # noqa: E501


        :return: The metadata of this AssetInfo.  # noqa: E501
        :rtype: MetadataStringified
        """
        return self._metadata

    @metadata.setter
    def metadata(self, metadata):
        """Sets the metadata of this AssetInfo.


        :param metadata: The metadata of this AssetInfo.  # noqa: E501
        :type: MetadataStringified
        """

        self._metadata = metadata

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (
                            (item[0], item[1].to_dict())
                            if hasattr(item[1], "to_dict")
                            else item
                        ),
                        value.items(),
                    )
                )
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AssetInfo):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, AssetInfo):
            return True

        return self.to_dict() != other.to_dict()
