# coding: utf-8

"""
TileDB Storage Platform API

TileDB Storage Platform REST API  # noqa: E501

The version of the OpenAPI document: 2.17.51
Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from tiledb.client.rest_api.configuration import Configuration


class TGUDFEnvironment(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "language": "UDFLanguage",
        "language_version": "str",
        "image_name": "str",
        "access_credentials_name": "str",
        "resource_class": "str",
        "resources": "TGUDFEnvironmentResources",
        "run_client_side": "bool",
        "timeout": "float",
        "storage": "list[TGUDFStorage]",
    }

    attribute_map = {
        "language": "language",
        "language_version": "language_version",
        "image_name": "image_name",
        "access_credentials_name": "access_credentials_name",
        "resource_class": "resource_class",
        "resources": "resources",
        "run_client_side": "run_client_side",
        "timeout": "timeout",
        "storage": "storage",
    }

    def __init__(
        self,
        language=None,
        language_version=None,
        image_name=None,
        access_credentials_name=None,
        resource_class=None,
        resources=None,
        run_client_side=None,
        timeout=None,
        storage=None,
        local_vars_configuration=None,
    ):  # noqa: E501
        """TGUDFEnvironment - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._language = None
        self._language_version = None
        self._image_name = None
        self._access_credentials_name = None
        self._resource_class = None
        self._resources = None
        self._run_client_side = None
        self._timeout = None
        self._storage = None
        self.discriminator = None

        if language is not None:
            self.language = language
        if language_version is not None:
            self.language_version = language_version
        if image_name is not None:
            self.image_name = image_name
        if access_credentials_name is not None:
            self.access_credentials_name = access_credentials_name
        if resource_class is not None:
            self.resource_class = resource_class
        if resources is not None:
            self.resources = resources
        if run_client_side is not None:
            self.run_client_side = run_client_side
        self.timeout = timeout
        if storage is not None:
            self.storage = storage

    @property
    def language(self):
        """Gets the language of this TGUDFEnvironment.  # noqa: E501


        :return: The language of this TGUDFEnvironment.  # noqa: E501
        :rtype: UDFLanguage
        """
        return self._language

    @language.setter
    def language(self, language):
        """Sets the language of this TGUDFEnvironment.


        :param language: The language of this TGUDFEnvironment.  # noqa: E501
        :type: UDFLanguage
        """

        self._language = language

    @property
    def language_version(self):
        """Gets the language_version of this TGUDFEnvironment.  # noqa: E501

        The language version used to execute this UDF. Neither this nor `language` needs to be set for registered UDFs, since the language and version are stored server-side with the UDF itself.   # noqa: E501

        :return: The language_version of this TGUDFEnvironment.  # noqa: E501
        :rtype: str
        """
        return self._language_version

    @language_version.setter
    def language_version(self, language_version):
        """Sets the language_version of this TGUDFEnvironment.

        The language version used to execute this UDF. Neither this nor `language` needs to be set for registered UDFs, since the language and version are stored server-side with the UDF itself.   # noqa: E501

        :param language_version: The language_version of this TGUDFEnvironment.  # noqa: E501
        :type: str
        """

        self._language_version = language_version

    @property
    def image_name(self):
        """Gets the image_name of this TGUDFEnvironment.  # noqa: E501

        The name of the image to use for the execution environment.   # noqa: E501

        :return: The image_name of this TGUDFEnvironment.  # noqa: E501
        :rtype: str
        """
        return self._image_name

    @image_name.setter
    def image_name(self, image_name):
        """Sets the image_name of this TGUDFEnvironment.

        The name of the image to use for the execution environment.   # noqa: E501

        :param image_name: The image_name of this TGUDFEnvironment.  # noqa: E501
        :type: str
        """

        self._image_name = image_name

    @property
    def access_credentials_name(self):
        """Gets the access_credentials_name of this TGUDFEnvironment.  # noqa: E501

        The name of the access credentials to use. if unset, no credentials will be configured in the environment.   # noqa: E501

        :return: The access_credentials_name of this TGUDFEnvironment.  # noqa: E501
        :rtype: str
        """
        return self._access_credentials_name

    @access_credentials_name.setter
    def access_credentials_name(self, access_credentials_name):
        """Sets the access_credentials_name of this TGUDFEnvironment.

        The name of the access credentials to use. if unset, no credentials will be configured in the environment.   # noqa: E501

        :param access_credentials_name: The access_credentials_name of this TGUDFEnvironment.  # noqa: E501
        :type: str
        """

        self._access_credentials_name = access_credentials_name

    @property
    def resource_class(self):
        """Gets the resource_class of this TGUDFEnvironment.  # noqa: E501

        The resource class to use for the UDF execution. Resource classes define resource limits for memory and CPUs. If this is empty, then the UDF will execute in the standard resource class of the TileDB Cloud provider.   # noqa: E501

        :return: The resource_class of this TGUDFEnvironment.  # noqa: E501
        :rtype: str
        """
        return self._resource_class

    @resource_class.setter
    def resource_class(self, resource_class):
        """Sets the resource_class of this TGUDFEnvironment.

        The resource class to use for the UDF execution. Resource classes define resource limits for memory and CPUs. If this is empty, then the UDF will execute in the standard resource class of the TileDB Cloud provider.   # noqa: E501

        :param resource_class: The resource_class of this TGUDFEnvironment.  # noqa: E501
        :type: str
        """

        self._resource_class = resource_class

    @property
    def resources(self):
        """Gets the resources of this TGUDFEnvironment.  # noqa: E501


        :return: The resources of this TGUDFEnvironment.  # noqa: E501
        :rtype: TGUDFEnvironmentResources
        """
        return self._resources

    @resources.setter
    def resources(self, resources):
        """Sets the resources of this TGUDFEnvironment.


        :param resources: The resources of this TGUDFEnvironment.  # noqa: E501
        :type: TGUDFEnvironmentResources
        """

        self._resources = resources

    @property
    def run_client_side(self):
        """Gets the run_client_side of this TGUDFEnvironment.  # noqa: E501

        A hint that, if possible, this function should be executed on the client side rather than on the server. Registered UDFs and functions which take arrays as inputs can never be executed client-side. If the client’s environment is incompatible, or the client does not support client-side execution, the function will be executed on the server.   # noqa: E501

        :return: The run_client_side of this TGUDFEnvironment.  # noqa: E501
        :rtype: bool
        """
        return self._run_client_side

    @run_client_side.setter
    def run_client_side(self, run_client_side):
        """Sets the run_client_side of this TGUDFEnvironment.

        A hint that, if possible, this function should be executed on the client side rather than on the server. Registered UDFs and functions which take arrays as inputs can never be executed client-side. If the client’s environment is incompatible, or the client does not support client-side execution, the function will be executed on the server.   # noqa: E501

        :param run_client_side: The run_client_side of this TGUDFEnvironment.  # noqa: E501
        :type: bool
        """

        self._run_client_side = run_client_side

    @property
    def timeout(self):
        """Gets the timeout of this TGUDFEnvironment.  # noqa: E501

        The maximum length of time this UDF is allowed to execute for before it is killed and fails. If not present (or zero), the function is allowed to run indefinitely (subject to the server’s global limits).   # noqa: E501

        :return: The timeout of this TGUDFEnvironment.  # noqa: E501
        :rtype: float
        """
        return self._timeout

    @timeout.setter
    def timeout(self, timeout):
        """Sets the timeout of this TGUDFEnvironment.

        The maximum length of time this UDF is allowed to execute for before it is killed and fails. If not present (or zero), the function is allowed to run indefinitely (subject to the server’s global limits).   # noqa: E501

        :param timeout: The timeout of this TGUDFEnvironment.  # noqa: E501
        :type: float
        """

        self._timeout = timeout

    @property
    def storage(self):
        """Gets the storage of this TGUDFEnvironment.  # noqa: E501

        Storage options for mounting persistent volumes.   # noqa: E501

        :return: The storage of this TGUDFEnvironment.  # noqa: E501
        :rtype: list[TGUDFStorage]
        """
        return self._storage

    @storage.setter
    def storage(self, storage):
        """Sets the storage of this TGUDFEnvironment.

        Storage options for mounting persistent volumes.   # noqa: E501

        :param storage: The storage of this TGUDFEnvironment.  # noqa: E501
        :type: list[TGUDFStorage]
        """

        self._storage = storage

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (
                            (item[0], item[1].to_dict())
                            if hasattr(item[1], "to_dict")
                            else item
                        ),
                        value.items(),
                    )
                )
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TGUDFEnvironment):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, TGUDFEnvironment):
            return True

        return self.to_dict() != other.to_dict()
