# coding: utf-8

"""
TileDB Storage Platform API

TileDB Storage Platform REST API  # noqa: E501

The version of the OpenAPI document: 2.17.51
Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from tiledb.client.rest_api.configuration import Configuration


class TGUDFStorage(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "path": "str",
        "tiledb_uri": "str",
        "size": "str",
        "storage_class": "str",
    }

    attribute_map = {
        "path": "path",
        "tiledb_uri": "tiledb_uri",
        "size": "size",
        "storage_class": "storage_class",
    }

    def __init__(
        self,
        path=None,
        tiledb_uri=None,
        size=None,
        storage_class=None,
        local_vars_configuration=None,
    ):  # noqa: E501
        """TGUDFStorage - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._path = None
        self._tiledb_uri = None
        self._size = None
        self._storage_class = None
        self.discriminator = None

        if path is not None:
            self.path = path
        if tiledb_uri is not None:
            self.tiledb_uri = tiledb_uri
        if size is not None:
            self.size = size
        if storage_class is not None:
            self.storage_class = storage_class

    @property
    def path(self):
        """Gets the path of this TGUDFStorage.  # noqa: E501

        Mount path for the attached volume.   # noqa: E501

        :return: The path of this TGUDFStorage.  # noqa: E501
        :rtype: str
        """
        return self._path

    @path.setter
    def path(self, path):
        """Sets the path of this TGUDFStorage.

        Mount path for the attached volume.   # noqa: E501

        :param path: The path of this TGUDFStorage.  # noqa: E501
        :type: str
        """

        self._path = path

    @property
    def tiledb_uri(self):
        """Gets the tiledb_uri of this TGUDFStorage.  # noqa: E501

        TileDB filesystem to mount   # noqa: E501

        :return: The tiledb_uri of this TGUDFStorage.  # noqa: E501
        :rtype: str
        """
        return self._tiledb_uri

    @tiledb_uri.setter
    def tiledb_uri(self, tiledb_uri):
        """Sets the tiledb_uri of this TGUDFStorage.

        TileDB filesystem to mount   # noqa: E501

        :param tiledb_uri: The tiledb_uri of this TGUDFStorage.  # noqa: E501
        :type: str
        """

        self._tiledb_uri = tiledb_uri

    @property
    def size(self):
        """Gets the size of this TGUDFStorage.  # noqa: E501

        Storage size.   # noqa: E501

        :return: The size of this TGUDFStorage.  # noqa: E501
        :rtype: str
        """
        return self._size

    @size.setter
    def size(self, size):
        """Sets the size of this TGUDFStorage.

        Storage size.   # noqa: E501

        :param size: The size of this TGUDFStorage.  # noqa: E501
        :type: str
        """

        self._size = size

    @property
    def storage_class(self):
        """Gets the storage_class of this TGUDFStorage.  # noqa: E501

        Storage class to use for creating the volume.   # noqa: E501

        :return: The storage_class of this TGUDFStorage.  # noqa: E501
        :rtype: str
        """
        return self._storage_class

    @storage_class.setter
    def storage_class(self, storage_class):
        """Sets the storage_class of this TGUDFStorage.

        Storage class to use for creating the volume.   # noqa: E501

        :param storage_class: The storage_class of this TGUDFStorage.  # noqa: E501
        :type: str
        """

        self._storage_class = storage_class

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (
                            (item[0], item[1].to_dict())
                            if hasattr(item[1], "to_dict")
                            else item
                        ),
                        value.items(),
                    )
                )
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TGUDFStorage):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, TGUDFStorage):
            return True

        return self.to_dict() != other.to_dict()
