# coding: utf-8

"""
    Kadoa API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 3.0.0
    Contact: support@kadoa.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictStr
from typing import Optional
from typing_extensions import Annotated
from openapi_client.models.v4_adhoc_schema_id_post200_response import V4AdhocSchemaIdPost200Response
from openapi_client.models.v4_adhoc_schema_id_post_request import V4AdhocSchemaIdPostRequest

from openapi_client.api_client import ApiClient, RequestSerialized
from openapi_client.api_response import ApiResponse
from openapi_client.rest import RESTResponseType


class AdhocApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def v4_adhoc_schema_id_post(
        self,
        schema_id: Annotated[StrictStr, Field(description="Either a custom schema ID or one of the following special values: * `html` - Returns raw HTML of the page * `body` - Returns cleaned HTML body content * `markdown` - Returns content converted to markdown format ")],
        v4_adhoc_schema_id_post_request: Optional[V4AdhocSchemaIdPostRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V4AdhocSchemaIdPost200Response:
        """Extract data from a single webpage (Proxy to Scraper API)

        Instantly extracts data from a webpage using either a schema for structured data or markdown/html for unstructured content. This endpoint proxies requests to the scraper API.

        :param schema_id: Either a custom schema ID or one of the following special values: * `html` - Returns raw HTML of the page * `body` - Returns cleaned HTML body content * `markdown` - Returns content converted to markdown format  (required)
        :type schema_id: str
        :param v4_adhoc_schema_id_post_request:
        :type v4_adhoc_schema_id_post_request: V4AdhocSchemaIdPostRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v4_adhoc_schema_id_post_serialize(
            schema_id=schema_id,
            v4_adhoc_schema_id_post_request=v4_adhoc_schema_id_post_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V4AdhocSchemaIdPost200Response",
            '400': "V4AdhocSchemaIdPost400Response",
            '404': "V4AdhocSchemaIdPost400Response",
            '429': "V4AdhocSchemaIdPost400Response",
            '500': "V4AdhocSchemaIdPost500Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def v4_adhoc_schema_id_post_with_http_info(
        self,
        schema_id: Annotated[StrictStr, Field(description="Either a custom schema ID or one of the following special values: * `html` - Returns raw HTML of the page * `body` - Returns cleaned HTML body content * `markdown` - Returns content converted to markdown format ")],
        v4_adhoc_schema_id_post_request: Optional[V4AdhocSchemaIdPostRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V4AdhocSchemaIdPost200Response]:
        """Extract data from a single webpage (Proxy to Scraper API)

        Instantly extracts data from a webpage using either a schema for structured data or markdown/html for unstructured content. This endpoint proxies requests to the scraper API.

        :param schema_id: Either a custom schema ID or one of the following special values: * `html` - Returns raw HTML of the page * `body` - Returns cleaned HTML body content * `markdown` - Returns content converted to markdown format  (required)
        :type schema_id: str
        :param v4_adhoc_schema_id_post_request:
        :type v4_adhoc_schema_id_post_request: V4AdhocSchemaIdPostRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v4_adhoc_schema_id_post_serialize(
            schema_id=schema_id,
            v4_adhoc_schema_id_post_request=v4_adhoc_schema_id_post_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V4AdhocSchemaIdPost200Response",
            '400': "V4AdhocSchemaIdPost400Response",
            '404': "V4AdhocSchemaIdPost400Response",
            '429': "V4AdhocSchemaIdPost400Response",
            '500': "V4AdhocSchemaIdPost500Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def v4_adhoc_schema_id_post_without_preload_content(
        self,
        schema_id: Annotated[StrictStr, Field(description="Either a custom schema ID or one of the following special values: * `html` - Returns raw HTML of the page * `body` - Returns cleaned HTML body content * `markdown` - Returns content converted to markdown format ")],
        v4_adhoc_schema_id_post_request: Optional[V4AdhocSchemaIdPostRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Extract data from a single webpage (Proxy to Scraper API)

        Instantly extracts data from a webpage using either a schema for structured data or markdown/html for unstructured content. This endpoint proxies requests to the scraper API.

        :param schema_id: Either a custom schema ID or one of the following special values: * `html` - Returns raw HTML of the page * `body` - Returns cleaned HTML body content * `markdown` - Returns content converted to markdown format  (required)
        :type schema_id: str
        :param v4_adhoc_schema_id_post_request:
        :type v4_adhoc_schema_id_post_request: V4AdhocSchemaIdPostRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v4_adhoc_schema_id_post_serialize(
            schema_id=schema_id,
            v4_adhoc_schema_id_post_request=v4_adhoc_schema_id_post_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V4AdhocSchemaIdPost200Response",
            '400': "V4AdhocSchemaIdPost400Response",
            '404': "V4AdhocSchemaIdPost400Response",
            '429': "V4AdhocSchemaIdPost400Response",
            '500': "V4AdhocSchemaIdPost500Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _v4_adhoc_schema_id_post_serialize(
        self,
        schema_id,
        v4_adhoc_schema_id_post_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if schema_id is not None:
            _path_params['schemaId'] = schema_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if v4_adhoc_schema_id_post_request is not None:
            _body_params = v4_adhoc_schema_id_post_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/v4/adhoc/{schemaId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


