# coding: utf-8

"""
    Kadoa API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 3.0.0
    Contact: support@kadoa.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from datetime import datetime
from pydantic import Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import List, Optional
from typing_extensions import Annotated
from openapi_client.models.create_workflow_body import CreateWorkflowBody
from openapi_client.models.create_workflow_response import CreateWorkflowResponse
from openapi_client.models.v4_changes_get200_response import V4ChangesGet200Response
from openapi_client.models.v4_changes_get200_response_changes_inner import V4ChangesGet200ResponseChangesInner
from openapi_client.models.v4_workflows_get200_response import V4WorkflowsGet200Response
from openapi_client.models.v4_workflows_workflow_id_auditlog_get200_response import V4WorkflowsWorkflowIdAuditlogGet200Response
from openapi_client.models.v4_workflows_workflow_id_compliance_approve_put200_response import V4WorkflowsWorkflowIdComplianceApprovePut200Response
from openapi_client.models.v4_workflows_workflow_id_compliance_reject_put200_response import V4WorkflowsWorkflowIdComplianceRejectPut200Response
from openapi_client.models.v4_workflows_workflow_id_compliance_reject_put_request import V4WorkflowsWorkflowIdComplianceRejectPutRequest
from openapi_client.models.v4_workflows_workflow_id_data_get200_response import V4WorkflowsWorkflowIdDataGet200Response
from openapi_client.models.v4_workflows_workflow_id_get200_response import V4WorkflowsWorkflowIdGet200Response
from openapi_client.models.v4_workflows_workflow_id_history_get200_response import V4WorkflowsWorkflowIdHistoryGet200Response
from openapi_client.models.v4_workflows_workflow_id_jobs_job_id_get200_response import V4WorkflowsWorkflowIdJobsJobIdGet200Response
from openapi_client.models.v4_workflows_workflow_id_metadata_put200_response import V4WorkflowsWorkflowIdMetadataPut200Response
from openapi_client.models.v4_workflows_workflow_id_metadata_put_request import V4WorkflowsWorkflowIdMetadataPutRequest
from openapi_client.models.v4_workflows_workflow_id_resume_put200_response import V4WorkflowsWorkflowIdResumePut200Response
from openapi_client.models.v4_workflows_workflow_id_run_put200_response import V4WorkflowsWorkflowIdRunPut200Response
from openapi_client.models.v4_workflows_workflow_id_run_put_request import V4WorkflowsWorkflowIdRunPutRequest
from openapi_client.models.v4_workflows_workflow_id_schedule_put_request import V4WorkflowsWorkflowIdSchedulePutRequest

from openapi_client.api_client import ApiClient, RequestSerialized
from openapi_client.api_response import ApiResponse
from openapi_client.rest import RESTResponseType


class WorkflowsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def v4_changes_change_id_get(
        self,
        change_id: Annotated[StrictStr, Field(description="ID of the workflow change to retrieve")],
        x_api_key: Annotated[Optional[StrictStr], Field(description="API key for authorization")] = None,
        authorization: Annotated[Optional[StrictStr], Field(description="Bearer token for authorization")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V4ChangesGet200ResponseChangesInner:
        """Get data change by ID


        :param change_id: ID of the workflow change to retrieve (required)
        :type change_id: str
        :param x_api_key: API key for authorization
        :type x_api_key: str
        :param authorization: Bearer token for authorization
        :type authorization: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v4_changes_change_id_get_serialize(
            change_id=change_id,
            x_api_key=x_api_key,
            authorization=authorization,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V4ChangesGet200ResponseChangesInner",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def v4_changes_change_id_get_with_http_info(
        self,
        change_id: Annotated[StrictStr, Field(description="ID of the workflow change to retrieve")],
        x_api_key: Annotated[Optional[StrictStr], Field(description="API key for authorization")] = None,
        authorization: Annotated[Optional[StrictStr], Field(description="Bearer token for authorization")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V4ChangesGet200ResponseChangesInner]:
        """Get data change by ID


        :param change_id: ID of the workflow change to retrieve (required)
        :type change_id: str
        :param x_api_key: API key for authorization
        :type x_api_key: str
        :param authorization: Bearer token for authorization
        :type authorization: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v4_changes_change_id_get_serialize(
            change_id=change_id,
            x_api_key=x_api_key,
            authorization=authorization,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V4ChangesGet200ResponseChangesInner",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def v4_changes_change_id_get_without_preload_content(
        self,
        change_id: Annotated[StrictStr, Field(description="ID of the workflow change to retrieve")],
        x_api_key: Annotated[Optional[StrictStr], Field(description="API key for authorization")] = None,
        authorization: Annotated[Optional[StrictStr], Field(description="Bearer token for authorization")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get data change by ID


        :param change_id: ID of the workflow change to retrieve (required)
        :type change_id: str
        :param x_api_key: API key for authorization
        :type x_api_key: str
        :param authorization: Bearer token for authorization
        :type authorization: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v4_changes_change_id_get_serialize(
            change_id=change_id,
            x_api_key=x_api_key,
            authorization=authorization,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V4ChangesGet200ResponseChangesInner",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _v4_changes_change_id_get_serialize(
        self,
        change_id,
        x_api_key,
        authorization,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if change_id is not None:
            _path_params['changeId'] = change_id
        # process the query parameters
        # process the header parameters
        if x_api_key is not None:
            _header_params['x-api-key'] = x_api_key
        if authorization is not None:
            _header_params['Authorization'] = authorization
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth', 
            'BearerAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v4/changes/{changeId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def v4_changes_get(
        self,
        x_api_key: Annotated[Optional[StrictStr], Field(description="API key for authorization")] = None,
        authorization: Annotated[Optional[StrictStr], Field(description="Bearer token for authorization")] = None,
        workflow_ids: Annotated[Optional[StrictStr], Field(description="Comma-separated list of workflow IDs. If not provided, returns changes for all ACTIVE workflows")] = None,
        start_date: Annotated[Optional[datetime], Field(description="Start date to filter changes (ISO format)")] = None,
        end_date: Annotated[Optional[datetime], Field(description="End date to filter changes (ISO format)")] = None,
        skip: Annotated[Optional[StrictInt], Field(description="Number of records to skip for pagination")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Number of records to return for pagination")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V4ChangesGet200Response:
        """Get all data changes


        :param x_api_key: API key for authorization
        :type x_api_key: str
        :param authorization: Bearer token for authorization
        :type authorization: str
        :param workflow_ids: Comma-separated list of workflow IDs. If not provided, returns changes for all ACTIVE workflows
        :type workflow_ids: str
        :param start_date: Start date to filter changes (ISO format)
        :type start_date: datetime
        :param end_date: End date to filter changes (ISO format)
        :type end_date: datetime
        :param skip: Number of records to skip for pagination
        :type skip: int
        :param limit: Number of records to return for pagination
        :type limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v4_changes_get_serialize(
            x_api_key=x_api_key,
            authorization=authorization,
            workflow_ids=workflow_ids,
            start_date=start_date,
            end_date=end_date,
            skip=skip,
            limit=limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V4ChangesGet200Response",
            '400': None,
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def v4_changes_get_with_http_info(
        self,
        x_api_key: Annotated[Optional[StrictStr], Field(description="API key for authorization")] = None,
        authorization: Annotated[Optional[StrictStr], Field(description="Bearer token for authorization")] = None,
        workflow_ids: Annotated[Optional[StrictStr], Field(description="Comma-separated list of workflow IDs. If not provided, returns changes for all ACTIVE workflows")] = None,
        start_date: Annotated[Optional[datetime], Field(description="Start date to filter changes (ISO format)")] = None,
        end_date: Annotated[Optional[datetime], Field(description="End date to filter changes (ISO format)")] = None,
        skip: Annotated[Optional[StrictInt], Field(description="Number of records to skip for pagination")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Number of records to return for pagination")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V4ChangesGet200Response]:
        """Get all data changes


        :param x_api_key: API key for authorization
        :type x_api_key: str
        :param authorization: Bearer token for authorization
        :type authorization: str
        :param workflow_ids: Comma-separated list of workflow IDs. If not provided, returns changes for all ACTIVE workflows
        :type workflow_ids: str
        :param start_date: Start date to filter changes (ISO format)
        :type start_date: datetime
        :param end_date: End date to filter changes (ISO format)
        :type end_date: datetime
        :param skip: Number of records to skip for pagination
        :type skip: int
        :param limit: Number of records to return for pagination
        :type limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v4_changes_get_serialize(
            x_api_key=x_api_key,
            authorization=authorization,
            workflow_ids=workflow_ids,
            start_date=start_date,
            end_date=end_date,
            skip=skip,
            limit=limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V4ChangesGet200Response",
            '400': None,
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def v4_changes_get_without_preload_content(
        self,
        x_api_key: Annotated[Optional[StrictStr], Field(description="API key for authorization")] = None,
        authorization: Annotated[Optional[StrictStr], Field(description="Bearer token for authorization")] = None,
        workflow_ids: Annotated[Optional[StrictStr], Field(description="Comma-separated list of workflow IDs. If not provided, returns changes for all ACTIVE workflows")] = None,
        start_date: Annotated[Optional[datetime], Field(description="Start date to filter changes (ISO format)")] = None,
        end_date: Annotated[Optional[datetime], Field(description="End date to filter changes (ISO format)")] = None,
        skip: Annotated[Optional[StrictInt], Field(description="Number of records to skip for pagination")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Number of records to return for pagination")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get all data changes


        :param x_api_key: API key for authorization
        :type x_api_key: str
        :param authorization: Bearer token for authorization
        :type authorization: str
        :param workflow_ids: Comma-separated list of workflow IDs. If not provided, returns changes for all ACTIVE workflows
        :type workflow_ids: str
        :param start_date: Start date to filter changes (ISO format)
        :type start_date: datetime
        :param end_date: End date to filter changes (ISO format)
        :type end_date: datetime
        :param skip: Number of records to skip for pagination
        :type skip: int
        :param limit: Number of records to return for pagination
        :type limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v4_changes_get_serialize(
            x_api_key=x_api_key,
            authorization=authorization,
            workflow_ids=workflow_ids,
            start_date=start_date,
            end_date=end_date,
            skip=skip,
            limit=limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V4ChangesGet200Response",
            '400': None,
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _v4_changes_get_serialize(
        self,
        x_api_key,
        authorization,
        workflow_ids,
        start_date,
        end_date,
        skip,
        limit,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if workflow_ids is not None:
            
            _query_params.append(('workflowIds', workflow_ids))
            
        if start_date is not None:
            if isinstance(start_date, datetime):
                _query_params.append(
                    (
                        'startDate',
                        start_date.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('startDate', start_date))
            
        if end_date is not None:
            if isinstance(end_date, datetime):
                _query_params.append(
                    (
                        'endDate',
                        end_date.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('endDate', end_date))
            
        if skip is not None:
            
            _query_params.append(('skip', skip))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        # process the header parameters
        if x_api_key is not None:
            _header_params['x-api-key'] = x_api_key
        if authorization is not None:
            _header_params['Authorization'] = authorization
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth', 
            'BearerAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v4/changes',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def v4_workflows_get(
        self,
        search: Annotated[Optional[StrictStr], Field(description="Search term to filter workflows by name, URL, or workflow ID")] = None,
        skip: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Number of items to skip")] = None,
        limit: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Maximum number of items to return")] = None,
        state: Annotated[Optional[StrictStr], Field(description="Filter workflows by state")] = None,
        tags: Annotated[Optional[List[StrictStr]], Field(description="Filter workflows by tags")] = None,
        monitoring: Annotated[Optional[StrictStr], Field(description="Filter workflows by monitoring status")] = None,
        update_interval: Annotated[Optional[StrictStr], Field(description="Filter workflows by update interval")] = None,
        template_id: Annotated[Optional[StrictStr], Field(description="Filter workflows by template ID (DEPRECATED - templates replaced by schemas)")] = None,
        user_id: Annotated[Optional[StrictStr], Field(description="Filter workflows by user ID (only works in team context)")] = None,
        include_deleted: Annotated[Optional[StrictStr], Field(description="Include deleted workflows (for compliance officers)")] = None,
        format: Annotated[Optional[StrictStr], Field(description="Response format (json or csv for export)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V4WorkflowsGet200Response:
        """Get a list of workflows

        Retrieves a list of workflows with pagination and search capabilities

        :param search: Search term to filter workflows by name, URL, or workflow ID
        :type search: str
        :param skip: Number of items to skip
        :type skip: int
        :param limit: Maximum number of items to return
        :type limit: int
        :param state: Filter workflows by state
        :type state: str
        :param tags: Filter workflows by tags
        :type tags: List[str]
        :param monitoring: Filter workflows by monitoring status
        :type monitoring: str
        :param update_interval: Filter workflows by update interval
        :type update_interval: str
        :param template_id: Filter workflows by template ID (DEPRECATED - templates replaced by schemas)
        :type template_id: str
        :param user_id: Filter workflows by user ID (only works in team context)
        :type user_id: str
        :param include_deleted: Include deleted workflows (for compliance officers)
        :type include_deleted: str
        :param format: Response format (json or csv for export)
        :type format: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v4_workflows_get_serialize(
            search=search,
            skip=skip,
            limit=limit,
            state=state,
            tags=tags,
            monitoring=monitoring,
            update_interval=update_interval,
            template_id=template_id,
            user_id=user_id,
            include_deleted=include_deleted,
            format=format,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V4WorkflowsGet200Response",
            '401': None,
            '403': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def v4_workflows_get_with_http_info(
        self,
        search: Annotated[Optional[StrictStr], Field(description="Search term to filter workflows by name, URL, or workflow ID")] = None,
        skip: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Number of items to skip")] = None,
        limit: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Maximum number of items to return")] = None,
        state: Annotated[Optional[StrictStr], Field(description="Filter workflows by state")] = None,
        tags: Annotated[Optional[List[StrictStr]], Field(description="Filter workflows by tags")] = None,
        monitoring: Annotated[Optional[StrictStr], Field(description="Filter workflows by monitoring status")] = None,
        update_interval: Annotated[Optional[StrictStr], Field(description="Filter workflows by update interval")] = None,
        template_id: Annotated[Optional[StrictStr], Field(description="Filter workflows by template ID (DEPRECATED - templates replaced by schemas)")] = None,
        user_id: Annotated[Optional[StrictStr], Field(description="Filter workflows by user ID (only works in team context)")] = None,
        include_deleted: Annotated[Optional[StrictStr], Field(description="Include deleted workflows (for compliance officers)")] = None,
        format: Annotated[Optional[StrictStr], Field(description="Response format (json or csv for export)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V4WorkflowsGet200Response]:
        """Get a list of workflows

        Retrieves a list of workflows with pagination and search capabilities

        :param search: Search term to filter workflows by name, URL, or workflow ID
        :type search: str
        :param skip: Number of items to skip
        :type skip: int
        :param limit: Maximum number of items to return
        :type limit: int
        :param state: Filter workflows by state
        :type state: str
        :param tags: Filter workflows by tags
        :type tags: List[str]
        :param monitoring: Filter workflows by monitoring status
        :type monitoring: str
        :param update_interval: Filter workflows by update interval
        :type update_interval: str
        :param template_id: Filter workflows by template ID (DEPRECATED - templates replaced by schemas)
        :type template_id: str
        :param user_id: Filter workflows by user ID (only works in team context)
        :type user_id: str
        :param include_deleted: Include deleted workflows (for compliance officers)
        :type include_deleted: str
        :param format: Response format (json or csv for export)
        :type format: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v4_workflows_get_serialize(
            search=search,
            skip=skip,
            limit=limit,
            state=state,
            tags=tags,
            monitoring=monitoring,
            update_interval=update_interval,
            template_id=template_id,
            user_id=user_id,
            include_deleted=include_deleted,
            format=format,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V4WorkflowsGet200Response",
            '401': None,
            '403': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def v4_workflows_get_without_preload_content(
        self,
        search: Annotated[Optional[StrictStr], Field(description="Search term to filter workflows by name, URL, or workflow ID")] = None,
        skip: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Number of items to skip")] = None,
        limit: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Maximum number of items to return")] = None,
        state: Annotated[Optional[StrictStr], Field(description="Filter workflows by state")] = None,
        tags: Annotated[Optional[List[StrictStr]], Field(description="Filter workflows by tags")] = None,
        monitoring: Annotated[Optional[StrictStr], Field(description="Filter workflows by monitoring status")] = None,
        update_interval: Annotated[Optional[StrictStr], Field(description="Filter workflows by update interval")] = None,
        template_id: Annotated[Optional[StrictStr], Field(description="Filter workflows by template ID (DEPRECATED - templates replaced by schemas)")] = None,
        user_id: Annotated[Optional[StrictStr], Field(description="Filter workflows by user ID (only works in team context)")] = None,
        include_deleted: Annotated[Optional[StrictStr], Field(description="Include deleted workflows (for compliance officers)")] = None,
        format: Annotated[Optional[StrictStr], Field(description="Response format (json or csv for export)")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a list of workflows

        Retrieves a list of workflows with pagination and search capabilities

        :param search: Search term to filter workflows by name, URL, or workflow ID
        :type search: str
        :param skip: Number of items to skip
        :type skip: int
        :param limit: Maximum number of items to return
        :type limit: int
        :param state: Filter workflows by state
        :type state: str
        :param tags: Filter workflows by tags
        :type tags: List[str]
        :param monitoring: Filter workflows by monitoring status
        :type monitoring: str
        :param update_interval: Filter workflows by update interval
        :type update_interval: str
        :param template_id: Filter workflows by template ID (DEPRECATED - templates replaced by schemas)
        :type template_id: str
        :param user_id: Filter workflows by user ID (only works in team context)
        :type user_id: str
        :param include_deleted: Include deleted workflows (for compliance officers)
        :type include_deleted: str
        :param format: Response format (json or csv for export)
        :type format: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v4_workflows_get_serialize(
            search=search,
            skip=skip,
            limit=limit,
            state=state,
            tags=tags,
            monitoring=monitoring,
            update_interval=update_interval,
            template_id=template_id,
            user_id=user_id,
            include_deleted=include_deleted,
            format=format,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V4WorkflowsGet200Response",
            '401': None,
            '403': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _v4_workflows_get_serialize(
        self,
        search,
        skip,
        limit,
        state,
        tags,
        monitoring,
        update_interval,
        template_id,
        user_id,
        include_deleted,
        format,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'tags': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if search is not None:
            
            _query_params.append(('search', search))
            
        if skip is not None:
            
            _query_params.append(('skip', skip))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if state is not None:
            
            _query_params.append(('state', state))
            
        if tags is not None:
            
            _query_params.append(('tags', tags))
            
        if monitoring is not None:
            
            _query_params.append(('monitoring', monitoring))
            
        if update_interval is not None:
            
            _query_params.append(('updateInterval', update_interval))
            
        if template_id is not None:
            
            _query_params.append(('templateId', template_id))
            
        if user_id is not None:
            
            _query_params.append(('userId', user_id))
            
        if include_deleted is not None:
            
            _query_params.append(('includeDeleted', include_deleted))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v4/workflows',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def v4_workflows_post(
        self,
        create_workflow_body: Annotated[Optional[CreateWorkflowBody], Field(description="Body")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CreateWorkflowResponse:
        """Create a new workflow

        Create a new workflow with schema, custom fields, or agentic navigation mode

        :param create_workflow_body: Body
        :type create_workflow_body: CreateWorkflowBody
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v4_workflows_post_serialize(
            create_workflow_body=create_workflow_body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "CreateWorkflowResponse",
            '400': "V4CrawlConfigPost400Response",
            '401': "V4CrawlConfigPost400Response",
            '403': "V4CrawlConfigPost400Response",
            '500': "V4CrawlConfigPost400Response",
            '503': "V4CrawlConfigPost400Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def v4_workflows_post_with_http_info(
        self,
        create_workflow_body: Annotated[Optional[CreateWorkflowBody], Field(description="Body")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CreateWorkflowResponse]:
        """Create a new workflow

        Create a new workflow with schema, custom fields, or agentic navigation mode

        :param create_workflow_body: Body
        :type create_workflow_body: CreateWorkflowBody
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v4_workflows_post_serialize(
            create_workflow_body=create_workflow_body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "CreateWorkflowResponse",
            '400': "V4CrawlConfigPost400Response",
            '401': "V4CrawlConfigPost400Response",
            '403': "V4CrawlConfigPost400Response",
            '500': "V4CrawlConfigPost400Response",
            '503': "V4CrawlConfigPost400Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def v4_workflows_post_without_preload_content(
        self,
        create_workflow_body: Annotated[Optional[CreateWorkflowBody], Field(description="Body")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create a new workflow

        Create a new workflow with schema, custom fields, or agentic navigation mode

        :param create_workflow_body: Body
        :type create_workflow_body: CreateWorkflowBody
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v4_workflows_post_serialize(
            create_workflow_body=create_workflow_body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "CreateWorkflowResponse",
            '400': "V4CrawlConfigPost400Response",
            '401': "V4CrawlConfigPost400Response",
            '403': "V4CrawlConfigPost400Response",
            '500': "V4CrawlConfigPost400Response",
            '503': "V4CrawlConfigPost400Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _v4_workflows_post_serialize(
        self,
        create_workflow_body,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if create_workflow_body is not None:
            _body_params = create_workflow_body


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/v4/workflows/',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def v4_workflows_workflow_id_auditlog_get(
        self,
        workflow_id: Annotated[StrictStr, Field(description="ID of the workflow to retrieve audit logs from")],
        x_api_key: Annotated[Optional[StrictStr], Field(description="API key for authorization")] = None,
        authorization: Annotated[Optional[StrictStr], Field(description="Bearer token for authorization")] = None,
        page: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Page number for pagination")] = None,
        limit: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Number of items per page")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V4WorkflowsWorkflowIdAuditlogGet200Response:
        """Get workflow audit log entries


        :param workflow_id: ID of the workflow to retrieve audit logs from (required)
        :type workflow_id: str
        :param x_api_key: API key for authorization
        :type x_api_key: str
        :param authorization: Bearer token for authorization
        :type authorization: str
        :param page: Page number for pagination
        :type page: int
        :param limit: Number of items per page
        :type limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v4_workflows_workflow_id_auditlog_get_serialize(
            workflow_id=workflow_id,
            x_api_key=x_api_key,
            authorization=authorization,
            page=page,
            limit=limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V4WorkflowsWorkflowIdAuditlogGet200Response",
            '400': None,
            '401': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def v4_workflows_workflow_id_auditlog_get_with_http_info(
        self,
        workflow_id: Annotated[StrictStr, Field(description="ID of the workflow to retrieve audit logs from")],
        x_api_key: Annotated[Optional[StrictStr], Field(description="API key for authorization")] = None,
        authorization: Annotated[Optional[StrictStr], Field(description="Bearer token for authorization")] = None,
        page: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Page number for pagination")] = None,
        limit: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Number of items per page")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V4WorkflowsWorkflowIdAuditlogGet200Response]:
        """Get workflow audit log entries


        :param workflow_id: ID of the workflow to retrieve audit logs from (required)
        :type workflow_id: str
        :param x_api_key: API key for authorization
        :type x_api_key: str
        :param authorization: Bearer token for authorization
        :type authorization: str
        :param page: Page number for pagination
        :type page: int
        :param limit: Number of items per page
        :type limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v4_workflows_workflow_id_auditlog_get_serialize(
            workflow_id=workflow_id,
            x_api_key=x_api_key,
            authorization=authorization,
            page=page,
            limit=limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V4WorkflowsWorkflowIdAuditlogGet200Response",
            '400': None,
            '401': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def v4_workflows_workflow_id_auditlog_get_without_preload_content(
        self,
        workflow_id: Annotated[StrictStr, Field(description="ID of the workflow to retrieve audit logs from")],
        x_api_key: Annotated[Optional[StrictStr], Field(description="API key for authorization")] = None,
        authorization: Annotated[Optional[StrictStr], Field(description="Bearer token for authorization")] = None,
        page: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Page number for pagination")] = None,
        limit: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Number of items per page")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get workflow audit log entries


        :param workflow_id: ID of the workflow to retrieve audit logs from (required)
        :type workflow_id: str
        :param x_api_key: API key for authorization
        :type x_api_key: str
        :param authorization: Bearer token for authorization
        :type authorization: str
        :param page: Page number for pagination
        :type page: int
        :param limit: Number of items per page
        :type limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v4_workflows_workflow_id_auditlog_get_serialize(
            workflow_id=workflow_id,
            x_api_key=x_api_key,
            authorization=authorization,
            page=page,
            limit=limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V4WorkflowsWorkflowIdAuditlogGet200Response",
            '400': None,
            '401': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _v4_workflows_workflow_id_auditlog_get_serialize(
        self,
        workflow_id,
        x_api_key,
        authorization,
        page,
        limit,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if workflow_id is not None:
            _path_params['workflowId'] = workflow_id
        # process the query parameters
        if page is not None:
            
            _query_params.append(('page', page))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        # process the header parameters
        if x_api_key is not None:
            _header_params['x-api-key'] = x_api_key
        if authorization is not None:
            _header_params['Authorization'] = authorization
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth', 
            'BearerAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v4/workflows/{workflowId}/auditlog',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def v4_workflows_workflow_id_compliance_approve_put(
        self,
        workflow_id: Annotated[StrictStr, Field(description="ID of the workflow to approve")],
        x_api_key: Annotated[Optional[StrictStr], Field(description="API key for authorization")] = None,
        authorization: Annotated[Optional[StrictStr], Field(description="Bearer token for authorization")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V4WorkflowsWorkflowIdComplianceApprovePut200Response:
        """Approve workflow for compliance


        :param workflow_id: ID of the workflow to approve (required)
        :type workflow_id: str
        :param x_api_key: API key for authorization
        :type x_api_key: str
        :param authorization: Bearer token for authorization
        :type authorization: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v4_workflows_workflow_id_compliance_approve_put_serialize(
            workflow_id=workflow_id,
            x_api_key=x_api_key,
            authorization=authorization,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V4WorkflowsWorkflowIdComplianceApprovePut200Response",
            '400': None,
            '403': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def v4_workflows_workflow_id_compliance_approve_put_with_http_info(
        self,
        workflow_id: Annotated[StrictStr, Field(description="ID of the workflow to approve")],
        x_api_key: Annotated[Optional[StrictStr], Field(description="API key for authorization")] = None,
        authorization: Annotated[Optional[StrictStr], Field(description="Bearer token for authorization")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V4WorkflowsWorkflowIdComplianceApprovePut200Response]:
        """Approve workflow for compliance


        :param workflow_id: ID of the workflow to approve (required)
        :type workflow_id: str
        :param x_api_key: API key for authorization
        :type x_api_key: str
        :param authorization: Bearer token for authorization
        :type authorization: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v4_workflows_workflow_id_compliance_approve_put_serialize(
            workflow_id=workflow_id,
            x_api_key=x_api_key,
            authorization=authorization,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V4WorkflowsWorkflowIdComplianceApprovePut200Response",
            '400': None,
            '403': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def v4_workflows_workflow_id_compliance_approve_put_without_preload_content(
        self,
        workflow_id: Annotated[StrictStr, Field(description="ID of the workflow to approve")],
        x_api_key: Annotated[Optional[StrictStr], Field(description="API key for authorization")] = None,
        authorization: Annotated[Optional[StrictStr], Field(description="Bearer token for authorization")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Approve workflow for compliance


        :param workflow_id: ID of the workflow to approve (required)
        :type workflow_id: str
        :param x_api_key: API key for authorization
        :type x_api_key: str
        :param authorization: Bearer token for authorization
        :type authorization: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v4_workflows_workflow_id_compliance_approve_put_serialize(
            workflow_id=workflow_id,
            x_api_key=x_api_key,
            authorization=authorization,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V4WorkflowsWorkflowIdComplianceApprovePut200Response",
            '400': None,
            '403': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _v4_workflows_workflow_id_compliance_approve_put_serialize(
        self,
        workflow_id,
        x_api_key,
        authorization,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if workflow_id is not None:
            _path_params['workflowId'] = workflow_id
        # process the query parameters
        # process the header parameters
        if x_api_key is not None:
            _header_params['x-api-key'] = x_api_key
        if authorization is not None:
            _header_params['Authorization'] = authorization
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/v4/workflows/{workflowId}/compliance-approve',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def v4_workflows_workflow_id_compliance_reject_put(
        self,
        workflow_id: Annotated[StrictStr, Field(description="ID of the workflow to reject")],
        v4_workflows_workflow_id_compliance_reject_put_request: V4WorkflowsWorkflowIdComplianceRejectPutRequest,
        x_api_key: Annotated[Optional[StrictStr], Field(description="API key for authorization")] = None,
        authorization: Annotated[Optional[StrictStr], Field(description="Bearer token for authorization")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V4WorkflowsWorkflowIdComplianceRejectPut200Response:
        """Reject workflow for compliance


        :param workflow_id: ID of the workflow to reject (required)
        :type workflow_id: str
        :param v4_workflows_workflow_id_compliance_reject_put_request: (required)
        :type v4_workflows_workflow_id_compliance_reject_put_request: V4WorkflowsWorkflowIdComplianceRejectPutRequest
        :param x_api_key: API key for authorization
        :type x_api_key: str
        :param authorization: Bearer token for authorization
        :type authorization: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v4_workflows_workflow_id_compliance_reject_put_serialize(
            workflow_id=workflow_id,
            v4_workflows_workflow_id_compliance_reject_put_request=v4_workflows_workflow_id_compliance_reject_put_request,
            x_api_key=x_api_key,
            authorization=authorization,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V4WorkflowsWorkflowIdComplianceRejectPut200Response",
            '400': None,
            '403': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def v4_workflows_workflow_id_compliance_reject_put_with_http_info(
        self,
        workflow_id: Annotated[StrictStr, Field(description="ID of the workflow to reject")],
        v4_workflows_workflow_id_compliance_reject_put_request: V4WorkflowsWorkflowIdComplianceRejectPutRequest,
        x_api_key: Annotated[Optional[StrictStr], Field(description="API key for authorization")] = None,
        authorization: Annotated[Optional[StrictStr], Field(description="Bearer token for authorization")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V4WorkflowsWorkflowIdComplianceRejectPut200Response]:
        """Reject workflow for compliance


        :param workflow_id: ID of the workflow to reject (required)
        :type workflow_id: str
        :param v4_workflows_workflow_id_compliance_reject_put_request: (required)
        :type v4_workflows_workflow_id_compliance_reject_put_request: V4WorkflowsWorkflowIdComplianceRejectPutRequest
        :param x_api_key: API key for authorization
        :type x_api_key: str
        :param authorization: Bearer token for authorization
        :type authorization: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v4_workflows_workflow_id_compliance_reject_put_serialize(
            workflow_id=workflow_id,
            v4_workflows_workflow_id_compliance_reject_put_request=v4_workflows_workflow_id_compliance_reject_put_request,
            x_api_key=x_api_key,
            authorization=authorization,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V4WorkflowsWorkflowIdComplianceRejectPut200Response",
            '400': None,
            '403': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def v4_workflows_workflow_id_compliance_reject_put_without_preload_content(
        self,
        workflow_id: Annotated[StrictStr, Field(description="ID of the workflow to reject")],
        v4_workflows_workflow_id_compliance_reject_put_request: V4WorkflowsWorkflowIdComplianceRejectPutRequest,
        x_api_key: Annotated[Optional[StrictStr], Field(description="API key for authorization")] = None,
        authorization: Annotated[Optional[StrictStr], Field(description="Bearer token for authorization")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Reject workflow for compliance


        :param workflow_id: ID of the workflow to reject (required)
        :type workflow_id: str
        :param v4_workflows_workflow_id_compliance_reject_put_request: (required)
        :type v4_workflows_workflow_id_compliance_reject_put_request: V4WorkflowsWorkflowIdComplianceRejectPutRequest
        :param x_api_key: API key for authorization
        :type x_api_key: str
        :param authorization: Bearer token for authorization
        :type authorization: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v4_workflows_workflow_id_compliance_reject_put_serialize(
            workflow_id=workflow_id,
            v4_workflows_workflow_id_compliance_reject_put_request=v4_workflows_workflow_id_compliance_reject_put_request,
            x_api_key=x_api_key,
            authorization=authorization,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V4WorkflowsWorkflowIdComplianceRejectPut200Response",
            '400': None,
            '403': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _v4_workflows_workflow_id_compliance_reject_put_serialize(
        self,
        workflow_id,
        v4_workflows_workflow_id_compliance_reject_put_request,
        x_api_key,
        authorization,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if workflow_id is not None:
            _path_params['workflowId'] = workflow_id
        # process the query parameters
        # process the header parameters
        if x_api_key is not None:
            _header_params['x-api-key'] = x_api_key
        if authorization is not None:
            _header_params['Authorization'] = authorization
        # process the form parameters
        # process the body parameter
        if v4_workflows_workflow_id_compliance_reject_put_request is not None:
            _body_params = v4_workflows_workflow_id_compliance_reject_put_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/v4/workflows/{workflowId}/compliance-reject',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def v4_workflows_workflow_id_data_get(
        self,
        workflow_id: Annotated[StrictStr, Field(description="ID of the workflow to retrieve data from")],
        x_api_key: Annotated[Optional[StrictStr], Field(description="API key for authorization")] = None,
        authorization: Annotated[Optional[StrictStr], Field(description="Bearer token for authorization")] = None,
        run_id: Annotated[Optional[StrictStr], Field(description="ID of a specific run to retrieve data from")] = None,
        format: Annotated[Optional[StrictStr], Field(description="Format of the response data")] = None,
        sort_by: Annotated[Optional[StrictStr], Field(description="Field to sort the results by")] = None,
        order: Annotated[Optional[StrictStr], Field(description="Sort order (ascending or descending)")] = None,
        filters: Annotated[Optional[StrictStr], Field(description="JSON-encoded array of filter objects")] = None,
        page: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Page number for pagination")] = None,
        limit: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Number of items per page (0 for streaming all data)")] = None,
        gzip: Annotated[Optional[StrictBool], Field(description="Enable gzip compression for the response")] = None,
        row_ids: Annotated[Optional[StrictStr], Field(description="Filter results by specific row IDs (comma-separated or JSON array)")] = None,
        include_anomalies: Annotated[Optional[StrictBool], Field(description="Include validation anomalies for each row in the response")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V4WorkflowsWorkflowIdDataGet200Response:
        """Get workflow data by ID


        :param workflow_id: ID of the workflow to retrieve data from (required)
        :type workflow_id: str
        :param x_api_key: API key for authorization
        :type x_api_key: str
        :param authorization: Bearer token for authorization
        :type authorization: str
        :param run_id: ID of a specific run to retrieve data from
        :type run_id: str
        :param format: Format of the response data
        :type format: str
        :param sort_by: Field to sort the results by
        :type sort_by: str
        :param order: Sort order (ascending or descending)
        :type order: str
        :param filters: JSON-encoded array of filter objects
        :type filters: str
        :param page: Page number for pagination
        :type page: int
        :param limit: Number of items per page (0 for streaming all data)
        :type limit: int
        :param gzip: Enable gzip compression for the response
        :type gzip: bool
        :param row_ids: Filter results by specific row IDs (comma-separated or JSON array)
        :type row_ids: str
        :param include_anomalies: Include validation anomalies for each row in the response
        :type include_anomalies: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v4_workflows_workflow_id_data_get_serialize(
            workflow_id=workflow_id,
            x_api_key=x_api_key,
            authorization=authorization,
            run_id=run_id,
            format=format,
            sort_by=sort_by,
            order=order,
            filters=filters,
            page=page,
            limit=limit,
            gzip=gzip,
            row_ids=row_ids,
            include_anomalies=include_anomalies,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V4WorkflowsWorkflowIdDataGet200Response",
            '400': None,
            '401': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def v4_workflows_workflow_id_data_get_with_http_info(
        self,
        workflow_id: Annotated[StrictStr, Field(description="ID of the workflow to retrieve data from")],
        x_api_key: Annotated[Optional[StrictStr], Field(description="API key for authorization")] = None,
        authorization: Annotated[Optional[StrictStr], Field(description="Bearer token for authorization")] = None,
        run_id: Annotated[Optional[StrictStr], Field(description="ID of a specific run to retrieve data from")] = None,
        format: Annotated[Optional[StrictStr], Field(description="Format of the response data")] = None,
        sort_by: Annotated[Optional[StrictStr], Field(description="Field to sort the results by")] = None,
        order: Annotated[Optional[StrictStr], Field(description="Sort order (ascending or descending)")] = None,
        filters: Annotated[Optional[StrictStr], Field(description="JSON-encoded array of filter objects")] = None,
        page: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Page number for pagination")] = None,
        limit: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Number of items per page (0 for streaming all data)")] = None,
        gzip: Annotated[Optional[StrictBool], Field(description="Enable gzip compression for the response")] = None,
        row_ids: Annotated[Optional[StrictStr], Field(description="Filter results by specific row IDs (comma-separated or JSON array)")] = None,
        include_anomalies: Annotated[Optional[StrictBool], Field(description="Include validation anomalies for each row in the response")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V4WorkflowsWorkflowIdDataGet200Response]:
        """Get workflow data by ID


        :param workflow_id: ID of the workflow to retrieve data from (required)
        :type workflow_id: str
        :param x_api_key: API key for authorization
        :type x_api_key: str
        :param authorization: Bearer token for authorization
        :type authorization: str
        :param run_id: ID of a specific run to retrieve data from
        :type run_id: str
        :param format: Format of the response data
        :type format: str
        :param sort_by: Field to sort the results by
        :type sort_by: str
        :param order: Sort order (ascending or descending)
        :type order: str
        :param filters: JSON-encoded array of filter objects
        :type filters: str
        :param page: Page number for pagination
        :type page: int
        :param limit: Number of items per page (0 for streaming all data)
        :type limit: int
        :param gzip: Enable gzip compression for the response
        :type gzip: bool
        :param row_ids: Filter results by specific row IDs (comma-separated or JSON array)
        :type row_ids: str
        :param include_anomalies: Include validation anomalies for each row in the response
        :type include_anomalies: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v4_workflows_workflow_id_data_get_serialize(
            workflow_id=workflow_id,
            x_api_key=x_api_key,
            authorization=authorization,
            run_id=run_id,
            format=format,
            sort_by=sort_by,
            order=order,
            filters=filters,
            page=page,
            limit=limit,
            gzip=gzip,
            row_ids=row_ids,
            include_anomalies=include_anomalies,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V4WorkflowsWorkflowIdDataGet200Response",
            '400': None,
            '401': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def v4_workflows_workflow_id_data_get_without_preload_content(
        self,
        workflow_id: Annotated[StrictStr, Field(description="ID of the workflow to retrieve data from")],
        x_api_key: Annotated[Optional[StrictStr], Field(description="API key for authorization")] = None,
        authorization: Annotated[Optional[StrictStr], Field(description="Bearer token for authorization")] = None,
        run_id: Annotated[Optional[StrictStr], Field(description="ID of a specific run to retrieve data from")] = None,
        format: Annotated[Optional[StrictStr], Field(description="Format of the response data")] = None,
        sort_by: Annotated[Optional[StrictStr], Field(description="Field to sort the results by")] = None,
        order: Annotated[Optional[StrictStr], Field(description="Sort order (ascending or descending)")] = None,
        filters: Annotated[Optional[StrictStr], Field(description="JSON-encoded array of filter objects")] = None,
        page: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Page number for pagination")] = None,
        limit: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="Number of items per page (0 for streaming all data)")] = None,
        gzip: Annotated[Optional[StrictBool], Field(description="Enable gzip compression for the response")] = None,
        row_ids: Annotated[Optional[StrictStr], Field(description="Filter results by specific row IDs (comma-separated or JSON array)")] = None,
        include_anomalies: Annotated[Optional[StrictBool], Field(description="Include validation anomalies for each row in the response")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get workflow data by ID


        :param workflow_id: ID of the workflow to retrieve data from (required)
        :type workflow_id: str
        :param x_api_key: API key for authorization
        :type x_api_key: str
        :param authorization: Bearer token for authorization
        :type authorization: str
        :param run_id: ID of a specific run to retrieve data from
        :type run_id: str
        :param format: Format of the response data
        :type format: str
        :param sort_by: Field to sort the results by
        :type sort_by: str
        :param order: Sort order (ascending or descending)
        :type order: str
        :param filters: JSON-encoded array of filter objects
        :type filters: str
        :param page: Page number for pagination
        :type page: int
        :param limit: Number of items per page (0 for streaming all data)
        :type limit: int
        :param gzip: Enable gzip compression for the response
        :type gzip: bool
        :param row_ids: Filter results by specific row IDs (comma-separated or JSON array)
        :type row_ids: str
        :param include_anomalies: Include validation anomalies for each row in the response
        :type include_anomalies: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v4_workflows_workflow_id_data_get_serialize(
            workflow_id=workflow_id,
            x_api_key=x_api_key,
            authorization=authorization,
            run_id=run_id,
            format=format,
            sort_by=sort_by,
            order=order,
            filters=filters,
            page=page,
            limit=limit,
            gzip=gzip,
            row_ids=row_ids,
            include_anomalies=include_anomalies,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V4WorkflowsWorkflowIdDataGet200Response",
            '400': None,
            '401': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _v4_workflows_workflow_id_data_get_serialize(
        self,
        workflow_id,
        x_api_key,
        authorization,
        run_id,
        format,
        sort_by,
        order,
        filters,
        page,
        limit,
        gzip,
        row_ids,
        include_anomalies,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if workflow_id is not None:
            _path_params['workflowId'] = workflow_id
        # process the query parameters
        if run_id is not None:
            
            _query_params.append(('runId', run_id))
            
        if format is not None:
            
            _query_params.append(('format', format))
            
        if sort_by is not None:
            
            _query_params.append(('sortBy', sort_by))
            
        if order is not None:
            
            _query_params.append(('order', order))
            
        if filters is not None:
            
            _query_params.append(('filters', filters))
            
        if page is not None:
            
            _query_params.append(('page', page))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if gzip is not None:
            
            _query_params.append(('gzip', gzip))
            
        if row_ids is not None:
            
            _query_params.append(('rowIds', row_ids))
            
        if include_anomalies is not None:
            
            _query_params.append(('includeAnomalies', include_anomalies))
            
        # process the header parameters
        if x_api_key is not None:
            _header_params['x-api-key'] = x_api_key
        if authorization is not None:
            _header_params['Authorization'] = authorization
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    'text/csv'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth', 
            'BearerAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v4/workflows/{workflowId}/data',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def v4_workflows_workflow_id_delete(
        self,
        workflow_id: Annotated[StrictStr, Field(description="The ID of the workflow to delete")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> str:
        """Delete a workflow


        :param workflow_id: The ID of the workflow to delete (required)
        :type workflow_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v4_workflows_workflow_id_delete_serialize(
            workflow_id=workflow_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "str",
            '401': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def v4_workflows_workflow_id_delete_with_http_info(
        self,
        workflow_id: Annotated[StrictStr, Field(description="The ID of the workflow to delete")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[str]:
        """Delete a workflow


        :param workflow_id: The ID of the workflow to delete (required)
        :type workflow_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v4_workflows_workflow_id_delete_serialize(
            workflow_id=workflow_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "str",
            '401': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def v4_workflows_workflow_id_delete_without_preload_content(
        self,
        workflow_id: Annotated[StrictStr, Field(description="The ID of the workflow to delete")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete a workflow


        :param workflow_id: The ID of the workflow to delete (required)
        :type workflow_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v4_workflows_workflow_id_delete_serialize(
            workflow_id=workflow_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "str",
            '401': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _v4_workflows_workflow_id_delete_serialize(
        self,
        workflow_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if workflow_id is not None:
            _path_params['workflowId'] = workflow_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/v4/workflows/{workflowId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def v4_workflows_workflow_id_get(
        self,
        workflow_id: Annotated[StrictStr, Field(description="ID of the workflow to retrieve")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V4WorkflowsWorkflowIdGet200Response:
        """Get workflow by ID

        Retrieves detailed information about a specific workflow. This endpoint requires authentication and proper team access permissions. 

        :param workflow_id: ID of the workflow to retrieve (required)
        :type workflow_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v4_workflows_workflow_id_get_serialize(
            workflow_id=workflow_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V4WorkflowsWorkflowIdGet200Response",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def v4_workflows_workflow_id_get_with_http_info(
        self,
        workflow_id: Annotated[StrictStr, Field(description="ID of the workflow to retrieve")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V4WorkflowsWorkflowIdGet200Response]:
        """Get workflow by ID

        Retrieves detailed information about a specific workflow. This endpoint requires authentication and proper team access permissions. 

        :param workflow_id: ID of the workflow to retrieve (required)
        :type workflow_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v4_workflows_workflow_id_get_serialize(
            workflow_id=workflow_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V4WorkflowsWorkflowIdGet200Response",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def v4_workflows_workflow_id_get_without_preload_content(
        self,
        workflow_id: Annotated[StrictStr, Field(description="ID of the workflow to retrieve")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get workflow by ID

        Retrieves detailed information about a specific workflow. This endpoint requires authentication and proper team access permissions. 

        :param workflow_id: ID of the workflow to retrieve (required)
        :type workflow_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v4_workflows_workflow_id_get_serialize(
            workflow_id=workflow_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V4WorkflowsWorkflowIdGet200Response",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _v4_workflows_workflow_id_get_serialize(
        self,
        workflow_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if workflow_id is not None:
            _path_params['workflowId'] = workflow_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v4/workflows/{workflowId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def v4_workflows_workflow_id_history_get(
        self,
        workflow_id: Annotated[StrictStr, Field(description="The unique identifier of the workflow whose runs history is to be retrieved")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V4WorkflowsWorkflowIdHistoryGet200Response:
        """Get the workflow run history


        :param workflow_id: The unique identifier of the workflow whose runs history is to be retrieved (required)
        :type workflow_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v4_workflows_workflow_id_history_get_serialize(
            workflow_id=workflow_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V4WorkflowsWorkflowIdHistoryGet200Response",
            '401': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def v4_workflows_workflow_id_history_get_with_http_info(
        self,
        workflow_id: Annotated[StrictStr, Field(description="The unique identifier of the workflow whose runs history is to be retrieved")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V4WorkflowsWorkflowIdHistoryGet200Response]:
        """Get the workflow run history


        :param workflow_id: The unique identifier of the workflow whose runs history is to be retrieved (required)
        :type workflow_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v4_workflows_workflow_id_history_get_serialize(
            workflow_id=workflow_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V4WorkflowsWorkflowIdHistoryGet200Response",
            '401': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def v4_workflows_workflow_id_history_get_without_preload_content(
        self,
        workflow_id: Annotated[StrictStr, Field(description="The unique identifier of the workflow whose runs history is to be retrieved")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get the workflow run history


        :param workflow_id: The unique identifier of the workflow whose runs history is to be retrieved (required)
        :type workflow_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v4_workflows_workflow_id_history_get_serialize(
            workflow_id=workflow_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V4WorkflowsWorkflowIdHistoryGet200Response",
            '401': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _v4_workflows_workflow_id_history_get_serialize(
        self,
        workflow_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if workflow_id is not None:
            _path_params['workflowId'] = workflow_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v4/workflows/{workflowId}/history',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def v4_workflows_workflow_id_jobs_job_id_get(
        self,
        workflow_id: Annotated[StrictStr, Field(description="The ID of the workflow")],
        job_id: Annotated[StrictStr, Field(description="The ID of the job")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V4WorkflowsWorkflowIdJobsJobIdGet200Response:
        """Get job status and telemetry


        :param workflow_id: The ID of the workflow (required)
        :type workflow_id: str
        :param job_id: The ID of the job (required)
        :type job_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v4_workflows_workflow_id_jobs_job_id_get_serialize(
            workflow_id=workflow_id,
            job_id=job_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V4WorkflowsWorkflowIdJobsJobIdGet200Response",
            '400': "V4AdhocSchemaIdPost400Response",
            '401': None,
            '404': "V4AdhocSchemaIdPost400Response",
            '500': "V4AdhocSchemaIdPost400Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def v4_workflows_workflow_id_jobs_job_id_get_with_http_info(
        self,
        workflow_id: Annotated[StrictStr, Field(description="The ID of the workflow")],
        job_id: Annotated[StrictStr, Field(description="The ID of the job")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V4WorkflowsWorkflowIdJobsJobIdGet200Response]:
        """Get job status and telemetry


        :param workflow_id: The ID of the workflow (required)
        :type workflow_id: str
        :param job_id: The ID of the job (required)
        :type job_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v4_workflows_workflow_id_jobs_job_id_get_serialize(
            workflow_id=workflow_id,
            job_id=job_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V4WorkflowsWorkflowIdJobsJobIdGet200Response",
            '400': "V4AdhocSchemaIdPost400Response",
            '401': None,
            '404': "V4AdhocSchemaIdPost400Response",
            '500': "V4AdhocSchemaIdPost400Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def v4_workflows_workflow_id_jobs_job_id_get_without_preload_content(
        self,
        workflow_id: Annotated[StrictStr, Field(description="The ID of the workflow")],
        job_id: Annotated[StrictStr, Field(description="The ID of the job")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get job status and telemetry


        :param workflow_id: The ID of the workflow (required)
        :type workflow_id: str
        :param job_id: The ID of the job (required)
        :type job_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v4_workflows_workflow_id_jobs_job_id_get_serialize(
            workflow_id=workflow_id,
            job_id=job_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V4WorkflowsWorkflowIdJobsJobIdGet200Response",
            '400': "V4AdhocSchemaIdPost400Response",
            '401': None,
            '404': "V4AdhocSchemaIdPost400Response",
            '500': "V4AdhocSchemaIdPost400Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _v4_workflows_workflow_id_jobs_job_id_get_serialize(
        self,
        workflow_id,
        job_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if workflow_id is not None:
            _path_params['workflowId'] = workflow_id
        if job_id is not None:
            _path_params['jobId'] = job_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v4/workflows/{workflowId}/jobs/{jobId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def v4_workflows_workflow_id_metadata_put(
        self,
        workflow_id: Annotated[StrictStr, Field(description="ID of the workflow to update")],
        v4_workflows_workflow_id_metadata_put_request: V4WorkflowsWorkflowIdMetadataPutRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V4WorkflowsWorkflowIdMetadataPut200Response:
        """Update workflow metadata


        :param workflow_id: ID of the workflow to update (required)
        :type workflow_id: str
        :param v4_workflows_workflow_id_metadata_put_request: (required)
        :type v4_workflows_workflow_id_metadata_put_request: V4WorkflowsWorkflowIdMetadataPutRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v4_workflows_workflow_id_metadata_put_serialize(
            workflow_id=workflow_id,
            v4_workflows_workflow_id_metadata_put_request=v4_workflows_workflow_id_metadata_put_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V4WorkflowsWorkflowIdMetadataPut200Response",
            '400': None,
            '401': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def v4_workflows_workflow_id_metadata_put_with_http_info(
        self,
        workflow_id: Annotated[StrictStr, Field(description="ID of the workflow to update")],
        v4_workflows_workflow_id_metadata_put_request: V4WorkflowsWorkflowIdMetadataPutRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V4WorkflowsWorkflowIdMetadataPut200Response]:
        """Update workflow metadata


        :param workflow_id: ID of the workflow to update (required)
        :type workflow_id: str
        :param v4_workflows_workflow_id_metadata_put_request: (required)
        :type v4_workflows_workflow_id_metadata_put_request: V4WorkflowsWorkflowIdMetadataPutRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v4_workflows_workflow_id_metadata_put_serialize(
            workflow_id=workflow_id,
            v4_workflows_workflow_id_metadata_put_request=v4_workflows_workflow_id_metadata_put_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V4WorkflowsWorkflowIdMetadataPut200Response",
            '400': None,
            '401': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def v4_workflows_workflow_id_metadata_put_without_preload_content(
        self,
        workflow_id: Annotated[StrictStr, Field(description="ID of the workflow to update")],
        v4_workflows_workflow_id_metadata_put_request: V4WorkflowsWorkflowIdMetadataPutRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Update workflow metadata


        :param workflow_id: ID of the workflow to update (required)
        :type workflow_id: str
        :param v4_workflows_workflow_id_metadata_put_request: (required)
        :type v4_workflows_workflow_id_metadata_put_request: V4WorkflowsWorkflowIdMetadataPutRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v4_workflows_workflow_id_metadata_put_serialize(
            workflow_id=workflow_id,
            v4_workflows_workflow_id_metadata_put_request=v4_workflows_workflow_id_metadata_put_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V4WorkflowsWorkflowIdMetadataPut200Response",
            '400': None,
            '401': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _v4_workflows_workflow_id_metadata_put_serialize(
        self,
        workflow_id,
        v4_workflows_workflow_id_metadata_put_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if workflow_id is not None:
            _path_params['workflowId'] = workflow_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if v4_workflows_workflow_id_metadata_put_request is not None:
            _body_params = v4_workflows_workflow_id_metadata_put_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/v4/workflows/{workflowId}/metadata',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def v4_workflows_workflow_id_pause_put(
        self,
        workflow_id: Annotated[StrictStr, Field(description="The ID of the workflow to pause")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> str:
        """Pause a workflow


        :param workflow_id: The ID of the workflow to pause (required)
        :type workflow_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v4_workflows_workflow_id_pause_put_serialize(
            workflow_id=workflow_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "str",
            '401': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def v4_workflows_workflow_id_pause_put_with_http_info(
        self,
        workflow_id: Annotated[StrictStr, Field(description="The ID of the workflow to pause")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[str]:
        """Pause a workflow


        :param workflow_id: The ID of the workflow to pause (required)
        :type workflow_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v4_workflows_workflow_id_pause_put_serialize(
            workflow_id=workflow_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "str",
            '401': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def v4_workflows_workflow_id_pause_put_without_preload_content(
        self,
        workflow_id: Annotated[StrictStr, Field(description="The ID of the workflow to pause")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Pause a workflow


        :param workflow_id: The ID of the workflow to pause (required)
        :type workflow_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v4_workflows_workflow_id_pause_put_serialize(
            workflow_id=workflow_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "str",
            '401': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _v4_workflows_workflow_id_pause_put_serialize(
        self,
        workflow_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if workflow_id is not None:
            _path_params['workflowId'] = workflow_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/v4/workflows/{workflowId}/pause',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def v4_workflows_workflow_id_resume_put(
        self,
        workflow_id: Annotated[StrictStr, Field(description="The ID of the workflow to resume")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V4WorkflowsWorkflowIdResumePut200Response:
        """Resume a workflow

        Resumes a paused, preview, or error workflow. If the user's team/organization or any of the user's organizations has the COMPLIANCE_REVIEW rule enabled, the workflow will be sent for compliance review instead of being directly activated.

        :param workflow_id: The ID of the workflow to resume (required)
        :type workflow_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v4_workflows_workflow_id_resume_put_serialize(
            workflow_id=workflow_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V4WorkflowsWorkflowIdResumePut200Response",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def v4_workflows_workflow_id_resume_put_with_http_info(
        self,
        workflow_id: Annotated[StrictStr, Field(description="The ID of the workflow to resume")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V4WorkflowsWorkflowIdResumePut200Response]:
        """Resume a workflow

        Resumes a paused, preview, or error workflow. If the user's team/organization or any of the user's organizations has the COMPLIANCE_REVIEW rule enabled, the workflow will be sent for compliance review instead of being directly activated.

        :param workflow_id: The ID of the workflow to resume (required)
        :type workflow_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v4_workflows_workflow_id_resume_put_serialize(
            workflow_id=workflow_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V4WorkflowsWorkflowIdResumePut200Response",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def v4_workflows_workflow_id_resume_put_without_preload_content(
        self,
        workflow_id: Annotated[StrictStr, Field(description="The ID of the workflow to resume")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Resume a workflow

        Resumes a paused, preview, or error workflow. If the user's team/organization or any of the user's organizations has the COMPLIANCE_REVIEW rule enabled, the workflow will be sent for compliance review instead of being directly activated.

        :param workflow_id: The ID of the workflow to resume (required)
        :type workflow_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v4_workflows_workflow_id_resume_put_serialize(
            workflow_id=workflow_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V4WorkflowsWorkflowIdResumePut200Response",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _v4_workflows_workflow_id_resume_put_serialize(
        self,
        workflow_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if workflow_id is not None:
            _path_params['workflowId'] = workflow_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/v4/workflows/{workflowId}/resume',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def v4_workflows_workflow_id_run_put(
        self,
        workflow_id: Annotated[StrictStr, Field(description="The ID of the workflow to run")],
        v4_workflows_workflow_id_run_put_request: Optional[V4WorkflowsWorkflowIdRunPutRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V4WorkflowsWorkflowIdRunPut200Response:
        """Run a workflow


        :param workflow_id: The ID of the workflow to run (required)
        :type workflow_id: str
        :param v4_workflows_workflow_id_run_put_request:
        :type v4_workflows_workflow_id_run_put_request: V4WorkflowsWorkflowIdRunPutRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v4_workflows_workflow_id_run_put_serialize(
            workflow_id=workflow_id,
            v4_workflows_workflow_id_run_put_request=v4_workflows_workflow_id_run_put_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V4WorkflowsWorkflowIdRunPut200Response",
            '400': "V4AdhocSchemaIdPost400Response",
            '401': None,
            '429': "V4WorkflowsWorkflowIdRunPut429Response",
            '500': "V4WorkflowsWorkflowIdRunPut500Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def v4_workflows_workflow_id_run_put_with_http_info(
        self,
        workflow_id: Annotated[StrictStr, Field(description="The ID of the workflow to run")],
        v4_workflows_workflow_id_run_put_request: Optional[V4WorkflowsWorkflowIdRunPutRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V4WorkflowsWorkflowIdRunPut200Response]:
        """Run a workflow


        :param workflow_id: The ID of the workflow to run (required)
        :type workflow_id: str
        :param v4_workflows_workflow_id_run_put_request:
        :type v4_workflows_workflow_id_run_put_request: V4WorkflowsWorkflowIdRunPutRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v4_workflows_workflow_id_run_put_serialize(
            workflow_id=workflow_id,
            v4_workflows_workflow_id_run_put_request=v4_workflows_workflow_id_run_put_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V4WorkflowsWorkflowIdRunPut200Response",
            '400': "V4AdhocSchemaIdPost400Response",
            '401': None,
            '429': "V4WorkflowsWorkflowIdRunPut429Response",
            '500': "V4WorkflowsWorkflowIdRunPut500Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def v4_workflows_workflow_id_run_put_without_preload_content(
        self,
        workflow_id: Annotated[StrictStr, Field(description="The ID of the workflow to run")],
        v4_workflows_workflow_id_run_put_request: Optional[V4WorkflowsWorkflowIdRunPutRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Run a workflow


        :param workflow_id: The ID of the workflow to run (required)
        :type workflow_id: str
        :param v4_workflows_workflow_id_run_put_request:
        :type v4_workflows_workflow_id_run_put_request: V4WorkflowsWorkflowIdRunPutRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v4_workflows_workflow_id_run_put_serialize(
            workflow_id=workflow_id,
            v4_workflows_workflow_id_run_put_request=v4_workflows_workflow_id_run_put_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V4WorkflowsWorkflowIdRunPut200Response",
            '400': "V4AdhocSchemaIdPost400Response",
            '401': None,
            '429': "V4WorkflowsWorkflowIdRunPut429Response",
            '500': "V4WorkflowsWorkflowIdRunPut500Response",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _v4_workflows_workflow_id_run_put_serialize(
        self,
        workflow_id,
        v4_workflows_workflow_id_run_put_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if workflow_id is not None:
            _path_params['workflowId'] = workflow_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if v4_workflows_workflow_id_run_put_request is not None:
            _body_params = v4_workflows_workflow_id_run_put_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/v4/workflows/{workflowId}/run',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def v4_workflows_workflow_id_schedule_put(
        self,
        workflow_id: Annotated[StrictStr, Field(description="The ID of the workflow to schedule")],
        v4_workflows_workflow_id_schedule_put_request: Annotated[V4WorkflowsWorkflowIdSchedulePutRequest, Field(description="ISO date (attention its timezone UTC) string required in request body")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> str:
        """Schedule a workflow


        :param workflow_id: The ID of the workflow to schedule (required)
        :type workflow_id: str
        :param v4_workflows_workflow_id_schedule_put_request: ISO date (attention its timezone UTC) string required in request body (required)
        :type v4_workflows_workflow_id_schedule_put_request: V4WorkflowsWorkflowIdSchedulePutRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v4_workflows_workflow_id_schedule_put_serialize(
            workflow_id=workflow_id,
            v4_workflows_workflow_id_schedule_put_request=v4_workflows_workflow_id_schedule_put_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "str",
            '400': None,
            '401': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def v4_workflows_workflow_id_schedule_put_with_http_info(
        self,
        workflow_id: Annotated[StrictStr, Field(description="The ID of the workflow to schedule")],
        v4_workflows_workflow_id_schedule_put_request: Annotated[V4WorkflowsWorkflowIdSchedulePutRequest, Field(description="ISO date (attention its timezone UTC) string required in request body")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[str]:
        """Schedule a workflow


        :param workflow_id: The ID of the workflow to schedule (required)
        :type workflow_id: str
        :param v4_workflows_workflow_id_schedule_put_request: ISO date (attention its timezone UTC) string required in request body (required)
        :type v4_workflows_workflow_id_schedule_put_request: V4WorkflowsWorkflowIdSchedulePutRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v4_workflows_workflow_id_schedule_put_serialize(
            workflow_id=workflow_id,
            v4_workflows_workflow_id_schedule_put_request=v4_workflows_workflow_id_schedule_put_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "str",
            '400': None,
            '401': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def v4_workflows_workflow_id_schedule_put_without_preload_content(
        self,
        workflow_id: Annotated[StrictStr, Field(description="The ID of the workflow to schedule")],
        v4_workflows_workflow_id_schedule_put_request: Annotated[V4WorkflowsWorkflowIdSchedulePutRequest, Field(description="ISO date (attention its timezone UTC) string required in request body")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Schedule a workflow


        :param workflow_id: The ID of the workflow to schedule (required)
        :type workflow_id: str
        :param v4_workflows_workflow_id_schedule_put_request: ISO date (attention its timezone UTC) string required in request body (required)
        :type v4_workflows_workflow_id_schedule_put_request: V4WorkflowsWorkflowIdSchedulePutRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v4_workflows_workflow_id_schedule_put_serialize(
            workflow_id=workflow_id,
            v4_workflows_workflow_id_schedule_put_request=v4_workflows_workflow_id_schedule_put_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "str",
            '400': None,
            '401': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _v4_workflows_workflow_id_schedule_put_serialize(
        self,
        workflow_id,
        v4_workflows_workflow_id_schedule_put_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if workflow_id is not None:
            _path_params['workflowId'] = workflow_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if v4_workflows_workflow_id_schedule_put_request is not None:
            _body_params = v4_workflows_workflow_id_schedule_put_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/plain'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/v4/workflows/{workflowId}/schedule',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def v5_changes_change_id_get(
        self,
        change_id: Annotated[StrictStr, Field(description="ID of the workflow change to retrieve")],
        x_api_key: Annotated[Optional[StrictStr], Field(description="API key for authorization")] = None,
        authorization: Annotated[Optional[StrictStr], Field(description="Bearer token for authorization")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V4ChangesGet200ResponseChangesInner:
        """Get data change by ID (PostgreSQL)


        :param change_id: ID of the workflow change to retrieve (required)
        :type change_id: str
        :param x_api_key: API key for authorization
        :type x_api_key: str
        :param authorization: Bearer token for authorization
        :type authorization: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v5_changes_change_id_get_serialize(
            change_id=change_id,
            x_api_key=x_api_key,
            authorization=authorization,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V4ChangesGet200ResponseChangesInner",
            '400': None,
            '401': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def v5_changes_change_id_get_with_http_info(
        self,
        change_id: Annotated[StrictStr, Field(description="ID of the workflow change to retrieve")],
        x_api_key: Annotated[Optional[StrictStr], Field(description="API key for authorization")] = None,
        authorization: Annotated[Optional[StrictStr], Field(description="Bearer token for authorization")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V4ChangesGet200ResponseChangesInner]:
        """Get data change by ID (PostgreSQL)


        :param change_id: ID of the workflow change to retrieve (required)
        :type change_id: str
        :param x_api_key: API key for authorization
        :type x_api_key: str
        :param authorization: Bearer token for authorization
        :type authorization: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v5_changes_change_id_get_serialize(
            change_id=change_id,
            x_api_key=x_api_key,
            authorization=authorization,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V4ChangesGet200ResponseChangesInner",
            '400': None,
            '401': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def v5_changes_change_id_get_without_preload_content(
        self,
        change_id: Annotated[StrictStr, Field(description="ID of the workflow change to retrieve")],
        x_api_key: Annotated[Optional[StrictStr], Field(description="API key for authorization")] = None,
        authorization: Annotated[Optional[StrictStr], Field(description="Bearer token for authorization")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get data change by ID (PostgreSQL)


        :param change_id: ID of the workflow change to retrieve (required)
        :type change_id: str
        :param x_api_key: API key for authorization
        :type x_api_key: str
        :param authorization: Bearer token for authorization
        :type authorization: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v5_changes_change_id_get_serialize(
            change_id=change_id,
            x_api_key=x_api_key,
            authorization=authorization,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V4ChangesGet200ResponseChangesInner",
            '400': None,
            '401': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _v5_changes_change_id_get_serialize(
        self,
        change_id,
        x_api_key,
        authorization,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if change_id is not None:
            _path_params['changeId'] = change_id
        # process the query parameters
        # process the header parameters
        if x_api_key is not None:
            _header_params['x-api-key'] = x_api_key
        if authorization is not None:
            _header_params['Authorization'] = authorization
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth', 
            'BearerAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v5/changes/{changeId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def v5_changes_get(
        self,
        x_api_key: Annotated[Optional[StrictStr], Field(description="API key for authorization")] = None,
        authorization: Annotated[Optional[StrictStr], Field(description="Bearer token for authorization")] = None,
        workflow_ids: Annotated[Optional[StrictStr], Field(description="Comma-separated list of workflow IDs. If not provided, returns changes for all ACTIVE workflows")] = None,
        start_date: Annotated[Optional[datetime], Field(description="Start date to filter changes (ISO format)")] = None,
        end_date: Annotated[Optional[datetime], Field(description="End date to filter changes (ISO format)")] = None,
        skip: Annotated[Optional[StrictInt], Field(description="Number of records to skip for pagination")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Number of records to return for pagination")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V4ChangesGet200Response:
        """Get all data changes (PostgreSQL)


        :param x_api_key: API key for authorization
        :type x_api_key: str
        :param authorization: Bearer token for authorization
        :type authorization: str
        :param workflow_ids: Comma-separated list of workflow IDs. If not provided, returns changes for all ACTIVE workflows
        :type workflow_ids: str
        :param start_date: Start date to filter changes (ISO format)
        :type start_date: datetime
        :param end_date: End date to filter changes (ISO format)
        :type end_date: datetime
        :param skip: Number of records to skip for pagination
        :type skip: int
        :param limit: Number of records to return for pagination
        :type limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v5_changes_get_serialize(
            x_api_key=x_api_key,
            authorization=authorization,
            workflow_ids=workflow_ids,
            start_date=start_date,
            end_date=end_date,
            skip=skip,
            limit=limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V4ChangesGet200Response",
            '400': None,
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def v5_changes_get_with_http_info(
        self,
        x_api_key: Annotated[Optional[StrictStr], Field(description="API key for authorization")] = None,
        authorization: Annotated[Optional[StrictStr], Field(description="Bearer token for authorization")] = None,
        workflow_ids: Annotated[Optional[StrictStr], Field(description="Comma-separated list of workflow IDs. If not provided, returns changes for all ACTIVE workflows")] = None,
        start_date: Annotated[Optional[datetime], Field(description="Start date to filter changes (ISO format)")] = None,
        end_date: Annotated[Optional[datetime], Field(description="End date to filter changes (ISO format)")] = None,
        skip: Annotated[Optional[StrictInt], Field(description="Number of records to skip for pagination")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Number of records to return for pagination")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V4ChangesGet200Response]:
        """Get all data changes (PostgreSQL)


        :param x_api_key: API key for authorization
        :type x_api_key: str
        :param authorization: Bearer token for authorization
        :type authorization: str
        :param workflow_ids: Comma-separated list of workflow IDs. If not provided, returns changes for all ACTIVE workflows
        :type workflow_ids: str
        :param start_date: Start date to filter changes (ISO format)
        :type start_date: datetime
        :param end_date: End date to filter changes (ISO format)
        :type end_date: datetime
        :param skip: Number of records to skip for pagination
        :type skip: int
        :param limit: Number of records to return for pagination
        :type limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v5_changes_get_serialize(
            x_api_key=x_api_key,
            authorization=authorization,
            workflow_ids=workflow_ids,
            start_date=start_date,
            end_date=end_date,
            skip=skip,
            limit=limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V4ChangesGet200Response",
            '400': None,
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def v5_changes_get_without_preload_content(
        self,
        x_api_key: Annotated[Optional[StrictStr], Field(description="API key for authorization")] = None,
        authorization: Annotated[Optional[StrictStr], Field(description="Bearer token for authorization")] = None,
        workflow_ids: Annotated[Optional[StrictStr], Field(description="Comma-separated list of workflow IDs. If not provided, returns changes for all ACTIVE workflows")] = None,
        start_date: Annotated[Optional[datetime], Field(description="Start date to filter changes (ISO format)")] = None,
        end_date: Annotated[Optional[datetime], Field(description="End date to filter changes (ISO format)")] = None,
        skip: Annotated[Optional[StrictInt], Field(description="Number of records to skip for pagination")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="Number of records to return for pagination")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get all data changes (PostgreSQL)


        :param x_api_key: API key for authorization
        :type x_api_key: str
        :param authorization: Bearer token for authorization
        :type authorization: str
        :param workflow_ids: Comma-separated list of workflow IDs. If not provided, returns changes for all ACTIVE workflows
        :type workflow_ids: str
        :param start_date: Start date to filter changes (ISO format)
        :type start_date: datetime
        :param end_date: End date to filter changes (ISO format)
        :type end_date: datetime
        :param skip: Number of records to skip for pagination
        :type skip: int
        :param limit: Number of records to return for pagination
        :type limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v5_changes_get_serialize(
            x_api_key=x_api_key,
            authorization=authorization,
            workflow_ids=workflow_ids,
            start_date=start_date,
            end_date=end_date,
            skip=skip,
            limit=limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V4ChangesGet200Response",
            '400': None,
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _v5_changes_get_serialize(
        self,
        x_api_key,
        authorization,
        workflow_ids,
        start_date,
        end_date,
        skip,
        limit,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if workflow_ids is not None:
            
            _query_params.append(('workflowIds', workflow_ids))
            
        if start_date is not None:
            if isinstance(start_date, datetime):
                _query_params.append(
                    (
                        'startDate',
                        start_date.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('startDate', start_date))
            
        if end_date is not None:
            if isinstance(end_date, datetime):
                _query_params.append(
                    (
                        'endDate',
                        end_date.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('endDate', end_date))
            
        if skip is not None:
            
            _query_params.append(('skip', skip))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        # process the header parameters
        if x_api_key is not None:
            _header_params['x-api-key'] = x_api_key
        if authorization is not None:
            _header_params['Authorization'] = authorization
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth', 
            'BearerAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v5/changes',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def v5_workflows_workflow_id_auditlog_get(
        self,
        workflow_id: Annotated[StrictStr, Field(description="ID of the workflow to retrieve audit logs from")],
        x_api_key: Annotated[Optional[StrictStr], Field(description="API key for authorization")] = None,
        authorization: Annotated[Optional[StrictStr], Field(description="Bearer token for authorization")] = None,
        page: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Page number for pagination")] = None,
        limit: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Number of items per page")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> V4WorkflowsWorkflowIdAuditlogGet200Response:
        """Get workflow audit log entries


        :param workflow_id: ID of the workflow to retrieve audit logs from (required)
        :type workflow_id: str
        :param x_api_key: API key for authorization
        :type x_api_key: str
        :param authorization: Bearer token for authorization
        :type authorization: str
        :param page: Page number for pagination
        :type page: int
        :param limit: Number of items per page
        :type limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v5_workflows_workflow_id_auditlog_get_serialize(
            workflow_id=workflow_id,
            x_api_key=x_api_key,
            authorization=authorization,
            page=page,
            limit=limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V4WorkflowsWorkflowIdAuditlogGet200Response",
            '400': None,
            '401': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def v5_workflows_workflow_id_auditlog_get_with_http_info(
        self,
        workflow_id: Annotated[StrictStr, Field(description="ID of the workflow to retrieve audit logs from")],
        x_api_key: Annotated[Optional[StrictStr], Field(description="API key for authorization")] = None,
        authorization: Annotated[Optional[StrictStr], Field(description="Bearer token for authorization")] = None,
        page: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Page number for pagination")] = None,
        limit: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Number of items per page")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[V4WorkflowsWorkflowIdAuditlogGet200Response]:
        """Get workflow audit log entries


        :param workflow_id: ID of the workflow to retrieve audit logs from (required)
        :type workflow_id: str
        :param x_api_key: API key for authorization
        :type x_api_key: str
        :param authorization: Bearer token for authorization
        :type authorization: str
        :param page: Page number for pagination
        :type page: int
        :param limit: Number of items per page
        :type limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v5_workflows_workflow_id_auditlog_get_serialize(
            workflow_id=workflow_id,
            x_api_key=x_api_key,
            authorization=authorization,
            page=page,
            limit=limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V4WorkflowsWorkflowIdAuditlogGet200Response",
            '400': None,
            '401': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def v5_workflows_workflow_id_auditlog_get_without_preload_content(
        self,
        workflow_id: Annotated[StrictStr, Field(description="ID of the workflow to retrieve audit logs from")],
        x_api_key: Annotated[Optional[StrictStr], Field(description="API key for authorization")] = None,
        authorization: Annotated[Optional[StrictStr], Field(description="Bearer token for authorization")] = None,
        page: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Page number for pagination")] = None,
        limit: Annotated[Optional[Annotated[int, Field(strict=True, ge=1)]], Field(description="Number of items per page")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get workflow audit log entries


        :param workflow_id: ID of the workflow to retrieve audit logs from (required)
        :type workflow_id: str
        :param x_api_key: API key for authorization
        :type x_api_key: str
        :param authorization: Bearer token for authorization
        :type authorization: str
        :param page: Page number for pagination
        :type page: int
        :param limit: Number of items per page
        :type limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._v5_workflows_workflow_id_auditlog_get_serialize(
            workflow_id=workflow_id,
            x_api_key=x_api_key,
            authorization=authorization,
            page=page,
            limit=limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "V4WorkflowsWorkflowIdAuditlogGet200Response",
            '400': None,
            '401': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _v5_workflows_workflow_id_auditlog_get_serialize(
        self,
        workflow_id,
        x_api_key,
        authorization,
        page,
        limit,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if workflow_id is not None:
            _path_params['workflowId'] = workflow_id
        # process the query parameters
        if page is not None:
            
            _query_params.append(('page', page))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        # process the header parameters
        if x_api_key is not None:
            _header_params['x-api-key'] = x_api_key
        if authorization is not None:
            _header_params['Authorization'] = authorization
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'ApiKeyAuth', 
            'BearerAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v5/workflows/{workflowId}/auditlog',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


