# coding: utf-8

"""
    Kadoa API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 3.0.0
    Contact: support@kadoa.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from openapi_client.models.interaction import Interaction
from openapi_client.models.location import Location
from openapi_client.models.monitoring_config import MonitoringConfig
from openapi_client.models.schema_response_schema_inner import SchemaResponseSchemaInner
from typing import Optional, Set
from typing_extensions import Self

class AgenticWorkflow(BaseModel):
    """
    Create an AI-powered workflow that uses natural language instructions to intelligently extract and adapt data extraction based on page content. The agent can navigate complex sites and understand context.  Example: `{\"urls\": [\"https://example.com\"], \"navigationMode\": \"agentic-navigation\", \"userPrompt\": \"Extract all job listings with title, company, salary, and location. Click on each listing to get full details.\"}`
    """ # noqa: E501
    urls: Annotated[List[StrictStr], Field(min_length=1)] = Field(description="List of URLs to scrape. Can be a single URL or multiple URLs to scrape across different pages or domains.")
    navigation_mode: StrictStr = Field(description="Must be set to 'agentic-navigation' for agentic workflows", alias="navigationMode")
    name: Optional[Annotated[str, Field(min_length=1, strict=True)]] = Field(default=None, description="Human-readable name for this workflow (e.g., 'Product Catalog Scraper')")
    description: Optional[Annotated[str, Field(strict=True, max_length=500)]] = Field(default=None, description="Detailed description of what this workflow does and why it was created (maximum 500 characters)")
    tags: Optional[List[Annotated[str, Field(min_length=3, strict=True)]]] = Field(default=None, description="Tags for organizing and categorizing workflows (minimum 3 characters per tag)")
    limit: Optional[Annotated[int, Field(strict=True, ge=1)]] = Field(default=None, description="Maximum number of items to scrape. Useful for limiting scope during development or cost control")
    location: Optional[Location] = None
    monitoring: Optional[MonitoringConfig] = None
    interval: Optional[StrictStr] = Field(default=None, description="How frequently this workflow should run (ONLY_ONCE, HOURLY, DAILY, WEEKLY, etc.)")
    schedules: Optional[List[StrictStr]] = Field(default=None, description="Cron expressions for custom schedules. Overrides the interval setting for fine-grained control")
    bypass_preview: Optional[StrictBool] = Field(default=False, description="Skip preview and validation, deploy scraper immediately. Use with caution - set to true only when you're confident the configuration is correct", alias="bypassPreview")
    auto_start: Optional[StrictBool] = Field(default=True, description="Automatically start the workflow after creation. Set to false if you want to test/review before starting", alias="autoStart")
    interactions: Optional[List[Interaction]] = Field(default=None, description="Browser interactions to perform before scraping (e.g., clicking buttons, filling forms, scrolling). See Interaction schema for available action types")
    data_validation_enabled: Optional[StrictBool] = Field(default=None, description="Enable data quality validation. When true, scraped data is validated against the schema and anomalies are detected", alias="dataValidationEnabled")
    additional_data: Optional[Any] = Field(default=None, description="Additional data for the workflow (e.g. IDs from your system to link data)", alias="additionalData")
    user_prompt: Annotated[str, Field(min_length=10, strict=True, max_length=5000)] = Field(description="Natural language instructions for the AI agent (10-5000 characters). Describe what data to extract and how to navigate the site", alias="userPrompt")
    schema_id: Optional[StrictStr] = Field(default=None, description="Optional: Schema ID to use with agentic extraction", alias="schemaId")
    entity: Optional[StrictStr] = Field(default=None, description="Optional: Entity name for agentic extraction")
    fields: Optional[List[SchemaResponseSchemaInner]] = Field(default=None, description="Optional: Additional extraction fields to guide the agent")
    __properties: ClassVar[List[str]] = ["urls", "navigationMode", "name", "description", "tags", "limit", "location", "monitoring", "interval", "schedules", "bypassPreview", "autoStart", "interactions", "dataValidationEnabled", "additionalData", "userPrompt", "schemaId", "entity", "fields"]

    @field_validator('navigation_mode')
    def navigation_mode_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['agentic-navigation']):
            raise ValueError("must be one of enum values ('agentic-navigation')")
        return value

    @field_validator('interval')
    def interval_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['ONLY_ONCE', 'EVERY_10_MINUTES', 'HALF_HOURLY', 'HOURLY', 'THREE_HOURLY', 'SIX_HOURLY', 'TWELVE_HOURLY', 'EIGHTEEN_HOURLY', 'DAILY', 'TWO_DAY', 'THREE_DAY', 'WEEKLY', 'BIWEEKLY', 'TRIWEEKLY', 'FOUR_WEEKS', 'MONTHLY', 'REAL_TIME', 'CUSTOM']):
            raise ValueError("must be one of enum values ('ONLY_ONCE', 'EVERY_10_MINUTES', 'HALF_HOURLY', 'HOURLY', 'THREE_HOURLY', 'SIX_HOURLY', 'TWELVE_HOURLY', 'EIGHTEEN_HOURLY', 'DAILY', 'TWO_DAY', 'THREE_DAY', 'WEEKLY', 'BIWEEKLY', 'TRIWEEKLY', 'FOUR_WEEKS', 'MONTHLY', 'REAL_TIME', 'CUSTOM')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AgenticWorkflow from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of location
        if self.location:
            _dict['location'] = self.location.to_dict()
        # override the default output from pydantic by calling `to_dict()` of monitoring
        if self.monitoring:
            _dict['monitoring'] = self.monitoring.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in interactions (list)
        _items = []
        if self.interactions:
            for _item_interactions in self.interactions:
                if _item_interactions:
                    _items.append(_item_interactions.to_dict())
            _dict['interactions'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in fields (list)
        _items = []
        if self.fields:
            for _item_fields in self.fields:
                if _item_fields:
                    _items.append(_item_fields.to_dict())
            _dict['fields'] = _items
        # set to None if additional_data (nullable) is None
        # and model_fields_set contains the field
        if self.additional_data is None and "additional_data" in self.model_fields_set:
            _dict['additionalData'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AgenticWorkflow from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "urls": obj.get("urls"),
            "navigationMode": obj.get("navigationMode"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "tags": obj.get("tags"),
            "limit": obj.get("limit"),
            "location": Location.from_dict(obj["location"]) if obj.get("location") is not None else None,
            "monitoring": MonitoringConfig.from_dict(obj["monitoring"]) if obj.get("monitoring") is not None else None,
            "interval": obj.get("interval"),
            "schedules": obj.get("schedules"),
            "bypassPreview": obj.get("bypassPreview") if obj.get("bypassPreview") is not None else False,
            "autoStart": obj.get("autoStart") if obj.get("autoStart") is not None else True,
            "interactions": [Interaction.from_dict(_item) for _item in obj["interactions"]] if obj.get("interactions") is not None else None,
            "dataValidationEnabled": obj.get("dataValidationEnabled"),
            "additionalData": obj.get("additionalData"),
            "userPrompt": obj.get("userPrompt"),
            "schemaId": obj.get("schemaId"),
            "entity": obj.get("entity"),
            "fields": [SchemaResponseSchemaInner.from_dict(_item) for _item in obj["fields"]] if obj.get("fields") is not None else None
        })
        return _obj


