# coding: utf-8

"""
    Kadoa API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 3.0.0
    Contact: support@kadoa.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class AnomalyRow(BaseModel):
    """
    Raw anomaly data with rule and column information
    """ # noqa: E501
    rule__: StrictStr = Field(alias="__rule__")
    id__: StrictStr = Field(alias="__id__")
    column__: StrictStr = Field(alias="__column__")
    type__: StrictStr = Field(alias="__type__")
    bad_value__: Optional[Any] = Field(default=None, alias="__bad_value__")
    status__: Optional[StrictStr] = Field(default=None, alias="__status__")
    __properties: ClassVar[List[str]] = ["__rule__", "__id__", "__column__", "__type__", "__bad_value__", "__status__"]

    @field_validator('status__')
    def status___validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['NEW', 'ONGOING', 'RESOLVED', 'REOPENED']):
            raise ValueError("must be one of enum values ('NEW', 'ONGOING', 'RESOLVED', 'REOPENED')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AnomalyRow from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if bad_value__ (nullable) is None
        # and model_fields_set contains the field
        if self.bad_value__ is None and "bad_value__" in self.model_fields_set:
            _dict['__bad_value__'] = None

        # set to None if status__ (nullable) is None
        # and model_fields_set contains the field
        if self.status__ is None and "status__" in self.model_fields_set:
            _dict['__status__'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AnomalyRow from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "__rule__": obj.get("__rule__"),
            "__id__": obj.get("__id__"),
            "__column__": obj.get("__column__"),
            "__type__": obj.get("__type__"),
            "__bad_value__": obj.get("__bad_value__"),
            "__status__": obj.get("__status__")
        })
        return _obj


