# coding: utf-8

"""
    Kadoa API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 3.0.0
    Contact: support@kadoa.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List
from openapi_client.models.anomaly_row import AnomalyRow
from openapi_client.models.pagination_meta import PaginationMeta
from typing import Optional, Set
from typing_extensions import Self

class AnomalyRulePageResponse(BaseModel):
    """
    Paginated anomalies for a specific rule
    """ # noqa: E501
    rule_name: StrictStr = Field(alias="ruleName")
    anomalies: List[AnomalyRow]
    pagination: PaginationMeta
    __properties: ClassVar[List[str]] = ["ruleName", "anomalies", "pagination"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AnomalyRulePageResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in anomalies (list)
        _items = []
        if self.anomalies:
            for _item_anomalies in self.anomalies:
                if _item_anomalies:
                    _items.append(_item_anomalies.to_dict())
            _dict['anomalies'] = _items
        # override the default output from pydantic by calling `to_dict()` of pagination
        if self.pagination:
            _dict['pagination'] = self.pagination.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AnomalyRulePageResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "ruleName": obj.get("ruleName"),
            "anomalies": [AnomalyRow.from_dict(_item) for _item in obj["anomalies"]] if obj.get("anomalies") is not None else None,
            "pagination": PaginationMeta.from_dict(obj["pagination"]) if obj.get("pagination") is not None else None
        })
        return _obj


