# coding: utf-8

"""
    Kadoa API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 3.0.0
    Contact: support@kadoa.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class BrowserInteraction(BaseModel):
    """
    Browser interaction definition. Examples: - CLICK: {type: 'CLICK', selector: '#submit-btn'} - TYPE: {type: 'TYPE', text: 'hello world'} - WAIT: {type: 'WAIT', timeMs: 2000} - GOTO: {type: 'GOTO', url: 'https://example.com'} - ENTER/TAB/BACKSPACE/DELETE/REFRESH/NAVIGATE_BACK/SCROLL/HOVER/SELECT/LOAD/KEYPRESS: {type: 'ENTER'} (no additional parameters needed)
    """ # noqa: E501
    type: StrictStr = Field(description="Type of interaction")
    selector: Optional[StrictStr] = Field(default=None, description="CSS selector for the target element (required for CLICK, HOVER)")
    text: Optional[StrictStr] = Field(default=None, description="Text to type (required for TYPE)")
    time_ms: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Time in milliseconds (required for WAIT)", alias="timeMs")
    url: Optional[StrictStr] = Field(default=None, description="URL to navigate to (required for GOTO)")
    tag_name: Optional[StrictStr] = Field(default=None, description="HTML tag name of the element", alias="tagName")
    inner_text: Optional[StrictStr] = Field(default=None, description="Inner text content of the element", alias="innerText")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["type", "selector", "text", "timeMs", "url", "tagName", "innerText"]

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['CLICK', 'TYPE', 'HOVER', 'SCROLL', 'WAIT', 'KEYPRESS', 'LOAD', 'SELECT', 'BACKSPACE', 'ENTER', 'TAB', 'DELETE', 'GOTO', 'REFRESH', 'NAVIGATE_BACK']):
            raise ValueError("must be one of enum values ('CLICK', 'TYPE', 'HOVER', 'SCROLL', 'WAIT', 'KEYPRESS', 'LOAD', 'SELECT', 'BACKSPACE', 'ENTER', 'TAB', 'DELETE', 'GOTO', 'REFRESH', 'NAVIGATE_BACK')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BrowserInteraction from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BrowserInteraction from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "type": obj.get("type"),
            "selector": obj.get("selector"),
            "text": obj.get("text"),
            "timeMs": obj.get("timeMs"),
            "url": obj.get("url"),
            "tagName": obj.get("tagName"),
            "innerText": obj.get("innerText")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


