# coding: utf-8

"""
    Kadoa API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 3.0.0
    Contact: support@kadoa.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from openapi_client.models.change_detection_result_anomaly_count_changes import ChangeDetectionResultAnomalyCountChanges
from openapi_client.models.change_detection_result_status_counts import ChangeDetectionResultStatusCounts
from typing import Optional, Set
from typing_extensions import Self

class ChangeDetectionResult(BaseModel):
    """
    ChangeDetectionResult
    """ # noqa: E501
    strategy: Optional[StrictStr] = Field(default='ISOLATED', description="ISOLATED validates each dataset independently. LINKING_COLUMNS validates data integrity across linked columns between datasets.")
    anomaly_count_changes: Optional[ChangeDetectionResultAnomalyCountChanges] = Field(default=None, alias="anomalyCountChanges")
    anomalies_status_parquet_path: Optional[StrictStr] = Field(default=None, alias="anomaliesStatusParquetPath")
    status_counts: Optional[ChangeDetectionResultStatusCounts] = Field(default=None, alias="statusCounts")
    __properties: ClassVar[List[str]] = ["strategy", "anomalyCountChanges", "anomaliesStatusParquetPath", "statusCounts"]

    @field_validator('strategy')
    def strategy_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['ISOLATED', 'LINKING_COLUMNS']):
            raise ValueError("must be one of enum values ('ISOLATED', 'LINKING_COLUMNS')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ChangeDetectionResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of anomaly_count_changes
        if self.anomaly_count_changes:
            _dict['anomalyCountChanges'] = self.anomaly_count_changes.to_dict()
        # override the default output from pydantic by calling `to_dict()` of status_counts
        if self.status_counts:
            _dict['statusCounts'] = self.status_counts.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ChangeDetectionResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "strategy": obj.get("strategy") if obj.get("strategy") is not None else 'ISOLATED',
            "anomalyCountChanges": ChangeDetectionResultAnomalyCountChanges.from_dict(obj["anomalyCountChanges"]) if obj.get("anomalyCountChanges") is not None else None,
            "anomaliesStatusParquetPath": obj.get("anomaliesStatusParquetPath"),
            "statusCounts": ChangeDetectionResultStatusCounts.from_dict(obj["statusCounts"]) if obj.get("statusCounts") is not None else None
        })
        return _obj


