# coding: utf-8

"""
    Kadoa API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 3.0.0
    Contact: support@kadoa.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class CreateCrawlerConfigRequestExtractionOptions(BaseModel):
    """
    Extraction-related options derived from legacy launch summary
    """ # noqa: E501
    extractions: Optional[Dict[str, StrictBool]] = Field(default=None, description="Feature toggles for available extraction helpers")
    var_schema: Optional[Any] = Field(default=None, description="Schema definition for structured extractions", alias="schema")
    entity: Optional[Any] = Field(default=None, description="Entity metadata used for extraction mappings")
    main_context_selector: Optional[StrictStr] = Field(default=None, description="CSS selector anchoring focus-driven extractors", alias="mainContextSelector")
    xhr_extractor_configs: Optional[List[Any]] = Field(default=None, description="XHR extractor configuration entries", alias="xhrExtractorConfigs")
    __properties: ClassVar[List[str]] = ["extractions", "schema", "entity", "mainContextSelector", "xhrExtractorConfigs"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateCrawlerConfigRequestExtractionOptions from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if var_schema (nullable) is None
        # and model_fields_set contains the field
        if self.var_schema is None and "var_schema" in self.model_fields_set:
            _dict['schema'] = None

        # set to None if entity (nullable) is None
        # and model_fields_set contains the field
        if self.entity is None and "entity" in self.model_fields_set:
            _dict['entity'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateCrawlerConfigRequestExtractionOptions from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "extractions": obj.get("extractions"),
            "schema": obj.get("schema"),
            "entity": obj.get("entity"),
            "mainContextSelector": obj.get("mainContextSelector"),
            "xhrExtractorConfigs": obj.get("xhrExtractorConfigs")
        })
        return _obj


