# coding: utf-8

"""
    Kadoa API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 3.0.0
    Contact: support@kadoa.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from openapi_client.models.create_crawler_config_request_navigation_options_cached_cookie_accept import CreateCrawlerConfigRequestNavigationOptionsCachedCookieAccept
from typing import Optional, Set
from typing_extensions import Self

class CreateCrawlerConfigRequestNavigationOptions(BaseModel):
    """
    Navigation-related options derived from legacy launch summary
    """ # noqa: E501
    browser_actions: Optional[List[Dict[str, Any]]] = Field(default=None, description="Ordered list of scripted browser actions executed after navigation", alias="browserActions")
    pre_browser_actions: Optional[List[Dict[str, Any]]] = Field(default=None, description="Browser actions performed before the main action chain", alias="preBrowserActions")
    scroll_html: Optional[StrictBool] = Field(default=None, description="Enable HTML capture while scrolling through the page", alias="scrollHtml")
    scroll_html_timeout: Optional[Union[Annotated[float, Field(strict=True, ge=0)], Annotated[int, Field(strict=True, ge=0)]]] = Field(default=None, description="Maximum scroll duration in milliseconds", alias="scrollHtmlTimeout")
    visual_html: Optional[StrictBool] = Field(default=None, description="Enable visual HTML capture for navigation heuristics", alias="visualHtml")
    navigation_strategy: Optional[StrictStr] = Field(default=None, description="Primary navigation strategy identifier", alias="navigationStrategy")
    navigation_strategies: Optional[List[StrictStr]] = Field(default=None, description="Fallback navigation strategy order", alias="navigationStrategies")
    limit: Optional[Union[Annotated[float, Field(strict=True, ge=0)], Annotated[int, Field(strict=True, ge=0)]]] = Field(default=None, description="Maximum number of navigation steps")
    disable_navigation: Optional[StrictBool] = Field(default=None, description="Skip automated navigation heuristics", alias="disableNavigation")
    ignore_iframes: Optional[StrictBool] = Field(default=None, description="Disable iframe traversal during navigation", alias="ignoreIframes")
    navigation_exploration: Optional[Dict[str, Any]] = Field(default=None, description="Navigation exploration tuning payload", alias="navigationExploration")
    load_html_only: Optional[StrictBool] = Field(default=None, description="Skip scripted interactions and only capture HTML", alias="loadHtmlOnly")
    accept_cookies: Optional[StrictBool] = Field(default=None, description="Force cookie acceptance automation", alias="acceptCookies")
    cached_cookie_accept: Optional[CreateCrawlerConfigRequestNavigationOptionsCachedCookieAccept] = Field(default=None, alias="cachedCookieAccept")
    __properties: ClassVar[List[str]] = ["browserActions", "preBrowserActions", "scrollHtml", "scrollHtmlTimeout", "visualHtml", "navigationStrategy", "navigationStrategies", "limit", "disableNavigation", "ignoreIframes", "navigationExploration", "loadHtmlOnly", "acceptCookies", "cachedCookieAccept"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateCrawlerConfigRequestNavigationOptions from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of cached_cookie_accept
        if self.cached_cookie_accept:
            _dict['cachedCookieAccept'] = self.cached_cookie_accept.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateCrawlerConfigRequestNavigationOptions from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "browserActions": obj.get("browserActions"),
            "preBrowserActions": obj.get("preBrowserActions"),
            "scrollHtml": obj.get("scrollHtml"),
            "scrollHtmlTimeout": obj.get("scrollHtmlTimeout"),
            "visualHtml": obj.get("visualHtml"),
            "navigationStrategy": obj.get("navigationStrategy"),
            "navigationStrategies": obj.get("navigationStrategies"),
            "limit": obj.get("limit"),
            "disableNavigation": obj.get("disableNavigation"),
            "ignoreIframes": obj.get("ignoreIframes"),
            "navigationExploration": obj.get("navigationExploration"),
            "loadHtmlOnly": obj.get("loadHtmlOnly"),
            "acceptCookies": obj.get("acceptCookies"),
            "cachedCookieAccept": CreateCrawlerConfigRequestNavigationOptionsCachedCookieAccept.from_dict(obj["cachedCookieAccept"]) if obj.get("cachedCookieAccept") is not None else None
        })
        return _obj


