# coding: utf-8

"""
    Kadoa API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 3.0.0
    Contact: support@kadoa.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from openapi_client.models.create_rule_parameters import CreateRuleParameters
from typing import Optional, Set
from typing_extensions import Self

class CreateRule(BaseModel):
    """
    Request body for creating a new validation rule
    """ # noqa: E501
    name: Annotated[str, Field(min_length=1, strict=True, max_length=255)]
    description: Optional[StrictStr] = None
    rule_type: StrictStr = Field(alias="ruleType")
    workflow_id: Optional[Annotated[str, Field(min_length=1, strict=True)]] = Field(default=None, alias="workflowId")
    target_columns: Optional[List[StrictStr]] = Field(default=None, alias="targetColumns")
    parameters: CreateRuleParameters
    status: Optional[StrictStr] = None
    metadata: Optional[Dict[str, Any]] = None
    __properties: ClassVar[List[str]] = ["name", "description", "ruleType", "workflowId", "targetColumns", "parameters", "status", "metadata"]

    @field_validator('rule_type')
    def rule_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['custom_sql']):
            raise ValueError("must be one of enum values ('custom_sql')")
        return value

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['preview', 'enabled', 'disabled']):
            raise ValueError("must be one of enum values ('preview', 'enabled', 'disabled')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateRule from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of parameters
        if self.parameters:
            _dict['parameters'] = self.parameters.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateRule from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "description": obj.get("description"),
            "ruleType": obj.get("ruleType"),
            "workflowId": obj.get("workflowId"),
            "targetColumns": obj.get("targetColumns"),
            "parameters": CreateRuleParameters.from_dict(obj["parameters"]) if obj.get("parameters") is not None else None,
            "status": obj.get("status"),
            "metadata": obj.get("metadata")
        })
        return _obj


