# coding: utf-8

"""
    Kadoa API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 3.0.0
    Contact: support@kadoa.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from openapi_client.models.data_field_example import DataFieldExample
from typing import Optional, Set
from typing_extensions import Self

class DataField(BaseModel):
    """
    Extract and structure specific data from web pages with typed values (e.g., product prices, article titles, dates). Use this for actual data you want to capture.
    """ # noqa: E501
    name: Annotated[str, Field(strict=True)] = Field(description="Field name (letters and numbers only)")
    description: Annotated[str, Field(min_length=1, strict=True)] = Field(description="Field description")
    field_type: Optional[StrictStr] = Field(default='SCHEMA', alias="fieldType")
    example: Optional[DataFieldExample] = None
    data_type: StrictStr = Field(description="Data type of the field", alias="dataType")
    is_key: Optional[StrictBool] = Field(default=None, description="Whether the field is a key field", alias="isKey")
    __properties: ClassVar[List[str]] = ["name", "description", "fieldType", "example", "dataType", "isKey"]

    @field_validator('name')
    def name_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^[A-Za-z0-9]+$", value):
            raise ValueError(r"must validate the regular expression /^[A-Za-z0-9]+$/")
        return value

    @field_validator('field_type')
    def field_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['SCHEMA']):
            raise ValueError("must be one of enum values ('SCHEMA')")
        return value

    @field_validator('data_type')
    def data_type_validate_enum(cls, value):
        """Validates the enum"""
        # Normalize invalid enum values to 'OBJECT' instead of raising an error
        # This handles backend-specific values like 'JOB_DESCRIPTION' that aren't in the enum
        valid_values = {'STRING', 'NUMBER', 'BOOLEAN', 'DATE', 'DATETIME', 'MONEY', 'IMAGE', 'LINK', 'OBJECT', 'ARRAY'}
        if value not in valid_values:
            return 'OBJECT'
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DataField from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of example
        if self.example:
            _dict['example'] = self.example.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DataField from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "description": obj.get("description"),
            "fieldType": obj.get("fieldType") if obj.get("fieldType") is not None else 'SCHEMA',
            "example": DataFieldExample.from_dict(obj["example"]) if obj.get("example") is not None else None,
            "dataType": obj.get("dataType"),
            "isKey": obj.get("isKey")
        })
        return _obj


