# coding: utf-8

"""
    Kadoa API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 3.0.0
    Contact: support@kadoa.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from openapi_client.models.dynamic_rule_config import DynamicRuleConfig
from typing import Optional, Set
from typing_extensions import Self

class DataValidationRequestBody(BaseModel):
    """
    Request body for scheduling validation with custom rules and options
    """ # noqa: E501
    custom_rules: Optional[List[DynamicRuleConfig]] = Field(default=None, alias="customRules")
    used_prompt: Optional[StrictStr] = Field(default=None, description="Optional LLM prompt used to generate or explain rules", alias="usedPrompt")
    skip_library_rules: Optional[StrictBool] = Field(default=None, description="If true, only custom rules will be used", alias="skipLibraryRules")
    dry_run: Optional[StrictBool] = Field(default=None, description="If true, validation runs without persisting results", alias="dryRun")
    strategy: Optional[StrictStr] = Field(default='ISOLATED', description="Strategy for data validation execution")
    is_workflow_triggered: Optional[StrictBool] = Field(default=None, description="Internal flag: true when validation is triggered by workflow execution", alias="isWorkflowTriggered")
    __properties: ClassVar[List[str]] = ["customRules", "usedPrompt", "skipLibraryRules", "dryRun", "strategy", "isWorkflowTriggered"]

    @field_validator('strategy')
    def strategy_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['ISOLATED', 'LINKING_COLUMNS']):
            raise ValueError("must be one of enum values ('ISOLATED', 'LINKING_COLUMNS')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DataValidationRequestBody from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in custom_rules (list)
        _items = []
        if self.custom_rules:
            for _item_custom_rules in self.custom_rules:
                if _item_custom_rules:
                    _items.append(_item_custom_rules.to_dict())
            _dict['customRules'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DataValidationRequestBody from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "customRules": [DynamicRuleConfig.from_dict(_item) for _item in obj["customRules"]] if obj.get("customRules") is not None else None,
            "usedPrompt": obj.get("usedPrompt"),
            "skipLibraryRules": obj.get("skipLibraryRules"),
            "dryRun": obj.get("dryRun"),
            "strategy": obj.get("strategy") if obj.get("strategy") is not None else 'ISOLATED',
            "isWorkflowTriggered": obj.get("isWorkflowTriggered")
        })
        return _obj


