# coding: utf-8

"""
    Kadoa API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 3.0.0
    Contact: support@kadoa.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from openapi_client.models.dynamic_rule_config_parameters import DynamicRuleConfigParameters
from typing import Optional, Set
from typing_extensions import Self

class DynamicRuleConfig(BaseModel):
    """
    Configuration for custom SQL validation rules with optional parameters
    """ # noqa: E501
    name: StrictStr = Field(description="Rule name")
    description: StrictStr = Field(description="What the rule checks for")
    rule_type: StrictStr = Field(description="Execution type for dynamic rules", alias="ruleType")
    target_columns: Optional[List[StrictStr]] = Field(default=None, description="Columns to which the rule applies", alias="targetColumns")
    parameters: DynamicRuleConfigParameters
    __properties: ClassVar[List[str]] = ["name", "description", "ruleType", "targetColumns", "parameters"]

    @field_validator('rule_type')
    def rule_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['custom_sql']):
            raise ValueError("must be one of enum values ('custom_sql')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DynamicRuleConfig from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of parameters
        if self.parameters:
            _dict['parameters'] = self.parameters.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DynamicRuleConfig from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "description": obj.get("description"),
            "ruleType": obj.get("ruleType"),
            "targetColumns": obj.get("targetColumns"),
            "parameters": DynamicRuleConfigParameters.from_dict(obj["parameters"]) if obj.get("parameters") is not None else None
        })
        return _obj


