# coding: utf-8

"""
    Kadoa API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 3.0.0
    Contact: support@kadoa.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class GetCrawlerSessionDataListResponseDataInner(BaseModel):
    """
    GetCrawlerSessionDataListResponseDataInner
    """ # noqa: E501
    url: StrictStr = Field(description="URL of the page")
    status: StrictStr = Field(description="Status of the page")
    created_at: StrictStr = Field(description="Timestamp when the entry was created")
    html_filename: Optional[StrictStr] = Field(description="Base64 encoded filename for the HTML content (null when HTML not stored)")
    screenshot_filename: Optional[StrictStr] = Field(description="Base64 encoded filename for the screenshot (null when screenshot not available)")
    processed_html_filename: Optional[StrictStr] = Field(description="Base64 encoded filename for the processed Kadoa HTML")
    json_filename: Optional[StrictStr] = Field(description="Base64 encoded filename for the crawler result JSON")
    match_score: Optional[Union[StrictFloat, StrictInt]] = Field(description="Match score between 0 and 1 (null when blueprint not provided)")
    matched_fields: Optional[Union[StrictFloat, StrictInt]] = Field(description="Number of blueprint fields populated for the page")
    total_fields: Optional[Union[StrictFloat, StrictInt]] = Field(description="Total blueprint fields evaluated for matching")
    is_match: StrictBool = Field(description="Whether the page met the blueprint match threshold")
    __properties: ClassVar[List[str]] = ["url", "status", "created_at", "html_filename", "screenshot_filename", "processed_html_filename", "json_filename", "match_score", "matched_fields", "total_fields", "is_match"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetCrawlerSessionDataListResponseDataInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if html_filename (nullable) is None
        # and model_fields_set contains the field
        if self.html_filename is None and "html_filename" in self.model_fields_set:
            _dict['html_filename'] = None

        # set to None if screenshot_filename (nullable) is None
        # and model_fields_set contains the field
        if self.screenshot_filename is None and "screenshot_filename" in self.model_fields_set:
            _dict['screenshot_filename'] = None

        # set to None if processed_html_filename (nullable) is None
        # and model_fields_set contains the field
        if self.processed_html_filename is None and "processed_html_filename" in self.model_fields_set:
            _dict['processed_html_filename'] = None

        # set to None if json_filename (nullable) is None
        # and model_fields_set contains the field
        if self.json_filename is None and "json_filename" in self.model_fields_set:
            _dict['json_filename'] = None

        # set to None if match_score (nullable) is None
        # and model_fields_set contains the field
        if self.match_score is None and "match_score" in self.model_fields_set:
            _dict['match_score'] = None

        # set to None if matched_fields (nullable) is None
        # and model_fields_set contains the field
        if self.matched_fields is None and "matched_fields" in self.model_fields_set:
            _dict['matched_fields'] = None

        # set to None if total_fields (nullable) is None
        # and model_fields_set contains the field
        if self.total_fields is None and "total_fields" in self.model_fields_set:
            _dict['total_fields'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetCrawlerSessionDataListResponseDataInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "url": obj.get("url"),
            "status": obj.get("status"),
            "created_at": obj.get("created_at"),
            "html_filename": obj.get("html_filename"),
            "screenshot_filename": obj.get("screenshot_filename"),
            "processed_html_filename": obj.get("processed_html_filename"),
            "json_filename": obj.get("json_filename"),
            "match_score": obj.get("match_score"),
            "matched_fields": obj.get("matched_fields"),
            "total_fields": obj.get("total_fields"),
            "is_match": obj.get("is_match")
        })
        return _obj


