# coding: utf-8

"""
    Kadoa API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 3.0.0
    Contact: support@kadoa.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from openapi_client.models.monitored_field import MonitoredField
from typing import Optional, Set
from typing_extensions import Self

class MonitoringConfig(BaseModel):
    """
    Monitoring configuration
    """ # noqa: E501
    enabled: StrictBool = Field(description="Whether monitoring is enabled")
    fields: Optional[List[MonitoredField]] = Field(default=None, description="Fields to monitor")
    channels: Optional[List[Any]] = Field(default=None, description="Notification channels")
    conditions: Optional[List[Any]] = Field(default=None, description="Array of conditions")
    logical_operator: Optional[StrictStr] = Field(default=None, description="Logical operator for conditions", alias="logicalOperator")
    __properties: ClassVar[List[str]] = ["enabled", "fields", "channels", "conditions", "logicalOperator"]

    @field_validator('logical_operator')
    def logical_operator_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['AND', 'OR']):
            raise ValueError("must be one of enum values ('AND', 'OR')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MonitoringConfig from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in fields (list)
        _items = []
        if self.fields:
            for _item_fields in self.fields:
                if _item_fields:
                    _items.append(_item_fields.to_dict())
            _dict['fields'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in conditions (list)
        _items = []
        if self.conditions:
            for _item_conditions in self.conditions:
                if _item_conditions:
                    _items.append(_item_conditions.to_dict())
            _dict['conditions'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MonitoringConfig from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "enabled": obj.get("enabled"),
            "fields": [MonitoredField.from_dict(_item) for _item in obj["fields"]] if obj.get("fields") is not None else None,
            "channels": obj.get("channels"),
            "conditions": [OneOf.from_dict(_item) for _item in obj["conditions"]] if obj.get("conditions") is not None else None,
            "logicalOperator": obj.get("logicalOperator")
        })
        return _obj


