# coding: utf-8

"""
    Kadoa API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 3.0.0
    Contact: support@kadoa.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from openapi_client.models.rule_parameters import RuleParameters
from typing import Optional, Set
from typing_extensions import Self

class Rule(BaseModel):
    """
    Complete validation rule with metadata and lifecycle information
    """ # noqa: E501
    id: StrictStr = Field(description="Unique identifier")
    name: StrictStr = Field(description="Human-readable rule name")
    description: Optional[StrictStr] = None
    rule_type: Optional[StrictStr] = Field(default=None, alias="ruleType")
    workflow_id: Optional[StrictStr] = Field(default=None, alias="workflowId")
    group_id: Optional[StrictStr] = Field(default=None, alias="groupId")
    user_id: Optional[StrictStr] = Field(default=None, alias="userId")
    team_id: Optional[StrictStr] = Field(default=None, alias="teamId")
    target_columns: Optional[List[StrictStr]] = Field(default=None, alias="targetColumns")
    parameters: Optional[RuleParameters] = None
    status: StrictStr
    disabled_reason: Optional[StrictStr] = Field(default=None, alias="disabledReason")
    metadata: Optional[Dict[str, Any]] = None
    created_at: StrictStr = Field(description="ISO 8601 timestamp", alias="createdAt")
    updated_at: StrictStr = Field(description="ISO 8601 timestamp", alias="updatedAt")
    deleted_at: Optional[StrictStr] = Field(default=None, description="ISO 8601 timestamp", alias="deletedAt")
    deleted_reason: Optional[StrictStr] = Field(default=None, alias="deletedReason")
    __properties: ClassVar[List[str]] = ["id", "name", "description", "ruleType", "workflowId", "groupId", "userId", "teamId", "targetColumns", "parameters", "status", "disabledReason", "metadata", "createdAt", "updatedAt", "deletedAt", "deletedReason"]

    @field_validator('rule_type')
    def rule_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['custom_sql']):
            raise ValueError("must be one of enum values ('custom_sql')")
        return value

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['preview', 'enabled', 'disabled']):
            raise ValueError("must be one of enum values ('preview', 'enabled', 'disabled')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Rule from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of parameters
        if self.parameters:
            _dict['parameters'] = self.parameters.to_dict()
        # set to None if disabled_reason (nullable) is None
        # and model_fields_set contains the field
        if self.disabled_reason is None and "disabled_reason" in self.model_fields_set:
            _dict['disabledReason'] = None

        # set to None if deleted_at (nullable) is None
        # and model_fields_set contains the field
        if self.deleted_at is None and "deleted_at" in self.model_fields_set:
            _dict['deletedAt'] = None

        # set to None if deleted_reason (nullable) is None
        # and model_fields_set contains the field
        if self.deleted_reason is None and "deleted_reason" in self.model_fields_set:
            _dict['deletedReason'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Rule from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "ruleType": obj.get("ruleType"),
            "workflowId": obj.get("workflowId"),
            "groupId": obj.get("groupId"),
            "userId": obj.get("userId"),
            "teamId": obj.get("teamId"),
            "targetColumns": obj.get("targetColumns"),
            "parameters": RuleParameters.from_dict(obj["parameters"]) if obj.get("parameters") is not None else None,
            "status": obj.get("status"),
            "disabledReason": obj.get("disabledReason"),
            "metadata": obj.get("metadata"),
            "createdAt": obj.get("createdAt"),
            "updatedAt": obj.get("updatedAt"),
            "deletedAt": obj.get("deletedAt"),
            "deletedReason": obj.get("deletedReason")
        })
        return _obj


