# coding: utf-8

"""
    Kadoa API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 3.0.0
    Contact: support@kadoa.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Union
from typing import Optional, Set
from typing_extensions import Self

class ScheduleValidationResponse(BaseModel):
    """
    Confirmation details after successfully scheduling a validation job
    """ # noqa: E501
    error: StrictBool
    message: StrictStr
    validation_id: StrictStr = Field(description="UUID of the scheduled validation job", alias="validationId")
    workflow_id: StrictStr = Field(alias="workflowId")
    job_id: StrictStr = Field(alias="jobId")
    skip_library_rules: StrictBool = Field(alias="skipLibraryRules")
    library_rules_count: Union[StrictFloat, StrictInt] = Field(alias="libraryRulesCount")
    custom_rules_count: Union[StrictFloat, StrictInt] = Field(alias="customRulesCount")
    total_rules_count: Union[StrictFloat, StrictInt] = Field(alias="totalRulesCount")
    created_at: datetime = Field(alias="createdAt")
    __properties: ClassVar[List[str]] = ["error", "message", "validationId", "workflowId", "jobId", "skipLibraryRules", "libraryRulesCount", "customRulesCount", "totalRulesCount", "createdAt"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ScheduleValidationResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ScheduleValidationResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "error": obj.get("error"),
            "message": obj.get("message"),
            "validationId": obj.get("validationId"),
            "workflowId": obj.get("workflowId"),
            "jobId": obj.get("jobId"),
            "skipLibraryRules": obj.get("skipLibraryRules"),
            "libraryRulesCount": obj.get("libraryRulesCount"),
            "customRulesCount": obj.get("customRulesCount"),
            "totalRulesCount": obj.get("totalRulesCount"),
            "createdAt": obj.get("createdAt")
        })
        return _obj


