# coding: utf-8

"""
    Kadoa API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 3.0.0
    Contact: support@kadoa.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from openapi_client.models.create_crawler_config_request_artifact_options import CreateCrawlerConfigRequestArtifactOptions
from openapi_client.models.create_crawler_config_request_blueprint_inner import CreateCrawlerConfigRequestBlueprintInner
from openapi_client.models.create_crawler_config_request_crawl_method import CreateCrawlerConfigRequestCrawlMethod
from openapi_client.models.create_crawler_config_request_extraction_options import CreateCrawlerConfigRequestExtractionOptions
from openapi_client.models.create_crawler_config_request_navigation_options import CreateCrawlerConfigRequestNavigationOptions
from typing import Optional, Set
from typing_extensions import Self

class StartCrawlerSessionRequest(BaseModel):
    """
    Schema for starting a crawling session with support for both single URL and multiple URLs
    """ # noqa: E501
    url: Optional[StrictStr] = Field(default=None, description="Single URL to start crawling (for backward compatibility)")
    start_urls: Optional[List[Annotated[str, Field(min_length=1, strict=True)]]] = Field(default=None, description="List of URLs for crawling", alias="startUrls")
    paths_filter_in: Optional[List[StrictStr]] = Field(default=None, description="Regex patterns to include specific paths", alias="pathsFilterIn")
    paths_filter_out: Optional[List[StrictStr]] = Field(default=None, description="Regex patterns to exclude specific paths", alias="pathsFilterOut")
    proxy_type: Optional[StrictStr] = Field(default=None, description="Type of proxy to use", alias="proxyType")
    proxy_country: Optional[StrictStr] = Field(default=None, description="Country for proxy selection", alias="proxyCountry")
    timeout: Optional[Union[Annotated[float, Field(strict=True, ge=1)], Annotated[int, Field(strict=True, ge=1)]]] = Field(default=None, description="Timeout in milliseconds")
    max_depth: Optional[Union[Annotated[float, Field(strict=True, ge=1)], Annotated[int, Field(strict=True, ge=1)]]] = Field(default=None, description="Maximum crawling depth", alias="maxDepth")
    max_pages: Optional[Union[Annotated[float, Field(strict=True, ge=1)], Annotated[int, Field(strict=True, ge=1)]]] = Field(default=None, description="Maximum number of pages to crawl", alias="maxPages")
    max_matches: Optional[Union[Annotated[float, Field(strict=True, ge=1)], Annotated[int, Field(strict=True, ge=1)]]] = Field(default=None, description="Maximum number of matched pages to crawl before stopping", alias="maxMatches")
    concurrency: Optional[Union[Annotated[float, Field(strict=True, ge=1)], Annotated[int, Field(strict=True, ge=1)]]] = Field(default=None, description="Number of concurrent crawlers")
    strict_domain: Optional[StrictBool] = Field(default=True, description="Whether to stay within the same domain", alias="strictDomain")
    load_images: Optional[StrictBool] = Field(default=True, description="Whether to load images during crawling", alias="loadImages")
    safe_mode: Optional[StrictBool] = Field(default=False, description="Enable safe mode for crawling", alias="safeMode")
    callback_url: Optional[StrictStr] = Field(default=None, description="Webhook URL for completion notifications", alias="callbackUrl")
    process_during_crawl: Optional[StrictBool] = Field(default=None, description="Whether to run preprocessing and extraction during the crawl phase", alias="processDuringCrawl")
    crawl_method: Optional[CreateCrawlerConfigRequestCrawlMethod] = Field(default=None, alias="crawlMethod")
    match_threshold: Optional[Union[Annotated[float, Field(le=1, strict=True, ge=0)], Annotated[int, Field(le=1, strict=True, ge=0)]]] = Field(default=None, description="Match threshold override for blueprint filtering", alias="matchThreshold")
    blueprint: Optional[List[CreateCrawlerConfigRequestBlueprintInner]] = Field(default=None, description="Blueprint fields applied during crawling")
    extraction_options: Optional[CreateCrawlerConfigRequestExtractionOptions] = Field(default=None, alias="extractionOptions")
    navigation_options: Optional[CreateCrawlerConfigRequestNavigationOptions] = Field(default=None, alias="navigationOptions")
    artifact_options: Optional[CreateCrawlerConfigRequestArtifactOptions] = Field(default=None, alias="artifactOptions")
    __properties: ClassVar[List[str]] = ["url", "startUrls", "pathsFilterIn", "pathsFilterOut", "proxyType", "proxyCountry", "timeout", "maxDepth", "maxPages", "maxMatches", "concurrency", "strictDomain", "loadImages", "safeMode", "callbackUrl", "processDuringCrawl", "crawlMethod", "matchThreshold", "blueprint", "extractionOptions", "navigationOptions", "artifactOptions"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of StartCrawlerSessionRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of crawl_method
        if self.crawl_method:
            _dict['crawlMethod'] = self.crawl_method.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in blueprint (list)
        _items = []
        if self.blueprint:
            for _item_blueprint in self.blueprint:
                if _item_blueprint:
                    _items.append(_item_blueprint.to_dict())
            _dict['blueprint'] = _items
        # override the default output from pydantic by calling `to_dict()` of extraction_options
        if self.extraction_options:
            _dict['extractionOptions'] = self.extraction_options.to_dict()
        # override the default output from pydantic by calling `to_dict()` of navigation_options
        if self.navigation_options:
            _dict['navigationOptions'] = self.navigation_options.to_dict()
        # override the default output from pydantic by calling `to_dict()` of artifact_options
        if self.artifact_options:
            _dict['artifactOptions'] = self.artifact_options.to_dict()
        # set to None if proxy_type (nullable) is None
        # and model_fields_set contains the field
        if self.proxy_type is None and "proxy_type" in self.model_fields_set:
            _dict['proxyType'] = None

        # set to None if proxy_country (nullable) is None
        # and model_fields_set contains the field
        if self.proxy_country is None and "proxy_country" in self.model_fields_set:
            _dict['proxyCountry'] = None

        # set to None if callback_url (nullable) is None
        # and model_fields_set contains the field
        if self.callback_url is None and "callback_url" in self.model_fields_set:
            _dict['callbackUrl'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of StartCrawlerSessionRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "url": obj.get("url"),
            "startUrls": obj.get("startUrls"),
            "pathsFilterIn": obj.get("pathsFilterIn"),
            "pathsFilterOut": obj.get("pathsFilterOut"),
            "proxyType": obj.get("proxyType"),
            "proxyCountry": obj.get("proxyCountry"),
            "timeout": obj.get("timeout"),
            "maxDepth": obj.get("maxDepth"),
            "maxPages": obj.get("maxPages"),
            "maxMatches": obj.get("maxMatches"),
            "concurrency": obj.get("concurrency"),
            "strictDomain": obj.get("strictDomain") if obj.get("strictDomain") is not None else True,
            "loadImages": obj.get("loadImages") if obj.get("loadImages") is not None else True,
            "safeMode": obj.get("safeMode") if obj.get("safeMode") is not None else False,
            "callbackUrl": obj.get("callbackUrl"),
            "processDuringCrawl": obj.get("processDuringCrawl"),
            "crawlMethod": CreateCrawlerConfigRequestCrawlMethod.from_dict(obj["crawlMethod"]) if obj.get("crawlMethod") is not None else None,
            "matchThreshold": obj.get("matchThreshold"),
            "blueprint": [CreateCrawlerConfigRequestBlueprintInner.from_dict(_item) for _item in obj["blueprint"]] if obj.get("blueprint") is not None else None,
            "extractionOptions": CreateCrawlerConfigRequestExtractionOptions.from_dict(obj["extractionOptions"]) if obj.get("extractionOptions") is not None else None,
            "navigationOptions": CreateCrawlerConfigRequestNavigationOptions.from_dict(obj["navigationOptions"]) if obj.get("navigationOptions") is not None else None,
            "artifactOptions": CreateCrawlerConfigRequestArtifactOptions.from_dict(obj["artifactOptions"]) if obj.get("artifactOptions") is not None else None
        })
        return _obj


