# coding: utf-8

"""
    Kadoa API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 3.0.0
    Contact: support@kadoa.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from openapi_client.models.create_rule_parameters import CreateRuleParameters
from typing import Optional, Set
from typing_extensions import Self

class UpdateRule(BaseModel):
    """
    Partial update request for modifying validation rules
    """ # noqa: E501
    name: Optional[Annotated[str, Field(min_length=1, strict=True, max_length=255)]] = None
    description: Optional[StrictStr] = None
    target_columns: Optional[List[StrictStr]] = Field(default=None, alias="targetColumns")
    parameters: Optional[CreateRuleParameters] = None
    status: Optional[StrictStr] = None
    disabled_reason: Optional[Annotated[str, Field(strict=True, max_length=500)]] = Field(default=None, alias="disabledReason")
    metadata: Optional[Dict[str, Any]] = None
    __properties: ClassVar[List[str]] = ["name", "description", "targetColumns", "parameters", "status", "disabledReason", "metadata"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['preview', 'enabled', 'disabled']):
            raise ValueError("must be one of enum values ('preview', 'enabled', 'disabled')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UpdateRule from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of parameters
        if self.parameters:
            _dict['parameters'] = self.parameters.to_dict()
        # set to None if disabled_reason (nullable) is None
        # and model_fields_set contains the field
        if self.disabled_reason is None and "disabled_reason" in self.model_fields_set:
            _dict['disabledReason'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UpdateRule from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "description": obj.get("description"),
            "targetColumns": obj.get("targetColumns"),
            "parameters": CreateRuleParameters.from_dict(obj["parameters"]) if obj.get("parameters") is not None else None,
            "status": obj.get("status"),
            "disabledReason": obj.get("disabledReason"),
            "metadata": obj.get("metadata")
        })
        return _obj


