# coding: utf-8

"""
    Kadoa API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 3.0.0
    Contact: support@kadoa.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from openapi_client.models.v4_workflows_workflow_id_get200_response_browser_actions_inner import V4WorkflowsWorkflowIdGet200ResponseBrowserActionsInner
from openapi_client.models.v4_workflows_workflow_id_get200_response_data_linking import V4WorkflowsWorkflowIdGet200ResponseDataLinking
from openapi_client.models.v4_workflows_workflow_id_get200_response_data_validation import V4WorkflowsWorkflowIdGet200ResponseDataValidation
from openapi_client.models.v4_workflows_workflow_id_get200_response_errors_inner import V4WorkflowsWorkflowIdGet200ResponseErrorsInner
from openapi_client.models.v4_workflows_workflow_id_get200_response_location import V4WorkflowsWorkflowIdGet200ResponseLocation
from openapi_client.models.v4_workflows_workflow_id_get200_response_notification_config import V4WorkflowsWorkflowIdGet200ResponseNotificationConfig
from openapi_client.models.v4_workflows_workflow_id_get200_response_schema_inner import V4WorkflowsWorkflowIdGet200ResponseSchemaInner
from openapi_client.models.v4_workflows_workflow_id_get200_response_validation_statistics import V4WorkflowsWorkflowIdGet200ResponseValidationStatistics
from typing import Optional, Set
from typing_extensions import Self

class V4WorkflowsWorkflowIdGet200Response(BaseModel):
    """
    V4WorkflowsWorkflowIdGet200Response
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="Unique identifier for the workflow")
    name: Optional[StrictStr] = Field(default=None, description="Name of the workflow")
    description: Optional[StrictStr] = Field(default=None, description="Description of the workflow")
    state: Optional[StrictStr] = Field(default=None, description="Current state of the workflow")
    display_state: Optional[StrictStr] = Field(default=None, description="Display state for frontend", alias="displayState")
    user_id: Optional[StrictStr] = Field(default=None, description="ID of the user who owns the workflow", alias="userId")
    created_at: Optional[datetime] = Field(default=None, description="Timestamp when the workflow was created", alias="createdAt")
    update_interval: Optional[StrictStr] = Field(default=None, description="Update frequency", alias="updateInterval")
    schedules: Optional[List[StrictStr]] = Field(default=None, description="Cron schedules for updates")
    next_invocation: Optional[datetime] = Field(default=None, description="Next scheduled execution time", alias="nextInvocation")
    monitoring: Optional[StrictBool] = Field(default=None, description="Whether monitoring is enabled")
    location: Optional[V4WorkflowsWorkflowIdGet200ResponseLocation] = None
    tags: Optional[List[StrictStr]] = Field(default=None, description="Tags associated with the workflow")
    template_name: Optional[StrictStr] = Field(default=None, description="Name of the template used", alias="templateName")
    template_id: Optional[StrictStr] = Field(default=None, description="ID of the template used", alias="templateId")
    job_id: Optional[StrictStr] = Field(default=None, description="ID of the last job", alias="jobId")
    finished_at: Optional[datetime] = Field(default=None, description="When the last job finished", alias="finishedAt")
    started_at: Optional[datetime] = Field(default=None, description="When the last job started", alias="startedAt")
    data_key: Optional[StrictStr] = Field(default=None, description="Database key for the workflow data", alias="dataKey")
    errors: Optional[List[V4WorkflowsWorkflowIdGet200ResponseErrorsInner]] = Field(default=None, description="Errors from the last job run")
    run_costs: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Cost of the last job run in credits", alias="runCosts")
    run_state: Optional[StrictStr] = Field(default=None, description="State of the last job run", alias="runState")
    total_records: Optional[StrictInt] = Field(default=None, description="Total number of records extracted", alias="totalRecords")
    url: Optional[StrictStr] = Field(default=None, description="Primary URL being scraped")
    urls: Optional[List[StrictStr]] = Field(default=None, description="List of URLs being scraped")
    browser_actions: Optional[List[V4WorkflowsWorkflowIdGet200ResponseBrowserActionsInner]] = Field(default=None, description="Optional browser actions to perform before extraction", alias="browserActions")
    var_schema: Optional[List[V4WorkflowsWorkflowIdGet200ResponseSchemaInner]] = Field(default=None, description="Extraction schema fields", alias="schema")
    entity: Optional[Dict[str, Any]] = Field(default=None, description="Entity information")
    is_schema_editable: Optional[StrictBool] = Field(default=None, description="Whether the schema can be edited", alias="isSchemaEditable")
    limit: Optional[StrictInt] = Field(default=None, description="Maximum number of items to scrape")
    additional_data: Optional[Dict[str, Any]] = Field(default=None, description="Additional static data for the workflow", alias="additionalData")
    data_validation: Optional[V4WorkflowsWorkflowIdGet200ResponseDataValidation] = Field(default=None, alias="dataValidation")
    linking_columns: Optional[List[StrictStr]] = Field(default=None, description="Columns configured for data linking", alias="linkingColumns")
    data_linking: Optional[V4WorkflowsWorkflowIdGet200ResponseDataLinking] = Field(default=None, alias="dataLinking")
    validation_statistics: Optional[V4WorkflowsWorkflowIdGet200ResponseValidationStatistics] = Field(default=None, alias="validationStatistics")
    notification_config: Optional[V4WorkflowsWorkflowIdGet200ResponseNotificationConfig] = Field(default=None, alias="notificationConfig")
    channel_counts: Optional[Dict[str, StrictInt]] = Field(default=None, description="Number of connected channels per event type", alias="channelCounts")
    __properties: ClassVar[List[str]] = ["id", "name", "description", "state", "displayState", "userId", "createdAt", "updateInterval", "schedules", "nextInvocation", "monitoring", "location", "tags", "templateName", "templateId", "jobId", "finishedAt", "startedAt", "dataKey", "errors", "runCosts", "runState", "totalRecords", "url", "urls", "browserActions", "schema", "entity", "isSchemaEditable", "limit", "additionalData", "dataValidation", "linkingColumns", "dataLinking", "validationStatistics", "notificationConfig", "channelCounts"]

    @field_validator('state')
    def state_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['ACTIVE', 'ERROR', 'PAUSED', 'NOT_SUPPORTED', 'PREVIEW', 'COMPLIANCE_REVIEW', 'COMPLIANCE_REJECTED', 'QUEUED', 'SETUP', 'DELETED']):
            raise ValueError("must be one of enum values ('ACTIVE', 'ERROR', 'PAUSED', 'NOT_SUPPORTED', 'PREVIEW', 'COMPLIANCE_REVIEW', 'COMPLIANCE_REJECTED', 'QUEUED', 'SETUP', 'DELETED')")
        return value

    @field_validator('display_state')
    def display_state_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['ACTIVE', 'ERROR', 'PAUSED', 'NOT_SUPPORTED', 'PREVIEW', 'COMPLIANCE_REVIEW', 'COMPLIANCE_REJECTED', 'QUEUED', 'SETUP', 'RUNNING']):
            raise ValueError("must be one of enum values ('ACTIVE', 'ERROR', 'PAUSED', 'NOT_SUPPORTED', 'PREVIEW', 'COMPLIANCE_REVIEW', 'COMPLIANCE_REJECTED', 'QUEUED', 'SETUP', 'RUNNING')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V4WorkflowsWorkflowIdGet200Response from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of location
        if self.location:
            _dict['location'] = self.location.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in errors (list)
        _items = []
        if self.errors:
            for _item_errors in self.errors:
                if _item_errors:
                    _items.append(_item_errors.to_dict())
            _dict['errors'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in browser_actions (list)
        _items = []
        if self.browser_actions:
            for _item_browser_actions in self.browser_actions:
                if _item_browser_actions:
                    _items.append(_item_browser_actions.to_dict())
            _dict['browserActions'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in var_schema (list)
        _items = []
        if self.var_schema:
            for _item_var_schema in self.var_schema:
                if _item_var_schema:
                    _items.append(_item_var_schema.to_dict())
            _dict['schema'] = _items
        # override the default output from pydantic by calling `to_dict()` of data_validation
        if self.data_validation:
            _dict['dataValidation'] = self.data_validation.to_dict()
        # override the default output from pydantic by calling `to_dict()` of data_linking
        if self.data_linking:
            _dict['dataLinking'] = self.data_linking.to_dict()
        # override the default output from pydantic by calling `to_dict()` of validation_statistics
        if self.validation_statistics:
            _dict['validationStatistics'] = self.validation_statistics.to_dict()
        # override the default output from pydantic by calling `to_dict()` of notification_config
        if self.notification_config:
            _dict['notificationConfig'] = self.notification_config.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V4WorkflowsWorkflowIdGet200Response from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "state": obj.get("state"),
            "displayState": obj.get("displayState"),
            "userId": obj.get("userId"),
            "createdAt": obj.get("createdAt"),
            "updateInterval": obj.get("updateInterval"),
            "schedules": obj.get("schedules"),
            "nextInvocation": obj.get("nextInvocation"),
            "monitoring": obj.get("monitoring"),
            "location": V4WorkflowsWorkflowIdGet200ResponseLocation.from_dict(obj["location"]) if obj.get("location") is not None else None,
            "tags": obj.get("tags"),
            "templateName": obj.get("templateName"),
            "templateId": obj.get("templateId"),
            "jobId": obj.get("jobId"),
            "finishedAt": obj.get("finishedAt"),
            "startedAt": obj.get("startedAt"),
            "dataKey": obj.get("dataKey"),
            "errors": [V4WorkflowsWorkflowIdGet200ResponseErrorsInner.from_dict(_item) for _item in obj["errors"]] if obj.get("errors") is not None else None,
            "runCosts": obj.get("runCosts"),
            "runState": obj.get("runState"),
            "totalRecords": obj.get("totalRecords"),
            "url": obj.get("url"),
            "urls": obj.get("urls"),
            "browserActions": [V4WorkflowsWorkflowIdGet200ResponseBrowserActionsInner.from_dict(_item) for _item in obj["browserActions"]] if obj.get("browserActions") is not None else None,
            "schema": [V4WorkflowsWorkflowIdGet200ResponseSchemaInner.from_dict(_item) for _item in obj["schema"]] if obj.get("schema") is not None else None,
            "entity": {"name": obj.get("entity")} if isinstance(obj.get("entity"), str) else obj.get("entity"),  # Handle string entity values from backend,
            "isSchemaEditable": obj.get("isSchemaEditable"),
            "limit": obj.get("limit"),
            "additionalData": obj.get("additionalData"),
            "dataValidation": V4WorkflowsWorkflowIdGet200ResponseDataValidation.from_dict(obj["dataValidation"]) if obj.get("dataValidation") is not None else None,
            "linkingColumns": obj.get("linkingColumns"),
            "dataLinking": V4WorkflowsWorkflowIdGet200ResponseDataLinking.from_dict(obj["dataLinking"]) if obj.get("dataLinking") is not None else None,
            "validationStatistics": V4WorkflowsWorkflowIdGet200ResponseValidationStatistics.from_dict(obj["validationStatistics"]) if obj.get("validationStatistics") is not None else None,
            "notificationConfig": V4WorkflowsWorkflowIdGet200ResponseNotificationConfig.from_dict(obj["notificationConfig"]) if obj.get("notificationConfig") is not None else None,
            "channelCounts": obj.get("channelCounts")
        })
        return _obj


