# coding: utf-8

"""
    Kadoa API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 3.0.0
    Contact: support@kadoa.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from openapi_client.models.v4_workflows_workflow_id_history_get200_response_workflow_runs_inner_errors_inner import V4WorkflowsWorkflowIdHistoryGet200ResponseWorkflowRunsInnerErrorsInner
from typing import Optional, Set
from typing_extensions import Self

class V4WorkflowsWorkflowIdHistoryGet200ResponseWorkflowRunsInner(BaseModel):
    """
    V4WorkflowsWorkflowIdHistoryGet200ResponseWorkflowRunsInner
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="Unique identifier of the workflow run")
    state: Optional[StrictStr] = Field(default=None, description="State of the workflow run")
    started_at: Optional[datetime] = Field(default=None, description="Start date and time of the workflow run", alias="startedAt")
    finished_at: Optional[datetime] = Field(default=None, description="Finish date and time of the workflow run", alias="finishedAt")
    screenshot: Optional[StrictStr] = Field(default=None, description="Screenshot of the navigation during the workflow run")
    records: Optional[StrictInt] = Field(default=None, description="Number of records processed in the workflow run")
    errors: Optional[List[V4WorkflowsWorkflowIdHistoryGet200ResponseWorkflowRunsInnerErrorsInner]] = Field(default=None, description="Errors that occurred during the workflow run")
    credits: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Number of credits used for this workflow run")
    __properties: ClassVar[List[str]] = ["id", "state", "startedAt", "finishedAt", "screenshot", "records", "errors", "credits"]

    @field_validator('state')
    def state_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['IN_PROGRESS', 'FINISHED', 'FAILED', 'NOT_SUPPORTED', 'FAILED_INSUFFICIENT_FUNDS']):
            raise ValueError("must be one of enum values ('IN_PROGRESS', 'FINISHED', 'FAILED', 'NOT_SUPPORTED', 'FAILED_INSUFFICIENT_FUNDS')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V4WorkflowsWorkflowIdHistoryGet200ResponseWorkflowRunsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in errors (list)
        _items = []
        if self.errors:
            for _item_errors in self.errors:
                if _item_errors:
                    _items.append(_item_errors.to_dict())
            _dict['errors'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V4WorkflowsWorkflowIdHistoryGet200ResponseWorkflowRunsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "state": obj.get("state"),
            "startedAt": obj.get("startedAt"),
            "finishedAt": obj.get("finishedAt"),
            "screenshot": obj.get("screenshot"),
            "records": obj.get("records"),
            "errors": [V4WorkflowsWorkflowIdHistoryGet200ResponseWorkflowRunsInnerErrorsInner.from_dict(_item) for _item in obj["errors"]] if obj.get("errors") is not None else None,
            "credits": obj.get("credits")
        })
        return _obj


