# coding: utf-8

"""
    Kadoa API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 3.0.0
    Contact: support@kadoa.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from openapi_client.models.v4_workflows_workflow_id_jobs_job_id_get200_response_protocol import V4WorkflowsWorkflowIdJobsJobIdGet200ResponseProtocol
from typing import Optional, Set
from typing_extensions import Self

class V4WorkflowsWorkflowIdJobsJobIdGet200Response(BaseModel):
    """
    V4WorkflowsWorkflowIdJobsJobIdGet200Response
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="The job ID")
    state: Optional[StrictStr] = Field(default=None, description="Current state of the job")
    started_at: Optional[datetime] = Field(default=None, description="Start date and time of the job", alias="startedAt")
    finished_at: Optional[datetime] = Field(default=None, description="Finish date and time of the job (if completed)", alias="finishedAt")
    limit: Optional[StrictInt] = Field(default=None, description="Record limit for the job")
    workflow_id: Optional[StrictStr] = Field(default=None, description="ID of the workflow/scraper", alias="workflowId")
    variables: Optional[Dict[str, Any]] = Field(default=None, description="Job variables (optional)")
    protocol: Optional[V4WorkflowsWorkflowIdJobsJobIdGet200ResponseProtocol] = None
    __properties: ClassVar[List[str]] = ["id", "state", "startedAt", "finishedAt", "limit", "workflowId", "variables", "protocol"]

    @field_validator('state')
    def state_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['IN_PROGRESS', 'FINISHED', 'FAILED', 'NOT_SUPPORTED', 'FAILED_INSUFFICIENT_FUNDS']):
            raise ValueError("must be one of enum values ('IN_PROGRESS', 'FINISHED', 'FAILED', 'NOT_SUPPORTED', 'FAILED_INSUFFICIENT_FUNDS')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V4WorkflowsWorkflowIdJobsJobIdGet200Response from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of protocol
        if self.protocol:
            _dict['protocol'] = self.protocol.to_dict()
        # set to None if limit (nullable) is None
        # and model_fields_set contains the field
        if self.limit is None and "limit" in self.model_fields_set:
            _dict['limit'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V4WorkflowsWorkflowIdJobsJobIdGet200Response from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "state": obj.get("state"),
            "startedAt": obj.get("startedAt"),
            "finishedAt": obj.get("finishedAt"),
            "limit": obj.get("limit"),
            "workflowId": obj.get("workflowId"),
            "variables": obj.get("variables"),
            "protocol": V4WorkflowsWorkflowIdJobsJobIdGet200ResponseProtocol.from_dict(obj["protocol"]) if obj.get("protocol") is not None else None
        })
        return _obj


