# coding: utf-8

"""
    Kadoa API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 3.0.0
    Contact: support@kadoa.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from openapi_client.models.v4_workflows_workflow_id_metadata_put_request_data_linking import V4WorkflowsWorkflowIdMetadataPutRequestDataLinking
from openapi_client.models.v4_workflows_workflow_id_metadata_put_request_location import V4WorkflowsWorkflowIdMetadataPutRequestLocation
from openapi_client.models.v4_workflows_workflow_id_metadata_put_request_monitoring import V4WorkflowsWorkflowIdMetadataPutRequestMonitoring
from openapi_client.models.v4_workflows_workflow_id_metadata_put_request_schema_inner import V4WorkflowsWorkflowIdMetadataPutRequestSchemaInner
from typing import Optional, Set
from typing_extensions import Self

class V4WorkflowsWorkflowIdMetadataPutRequest(BaseModel):
    """
    V4WorkflowsWorkflowIdMetadataPutRequest
    """ # noqa: E501
    urls: Optional[List[StrictStr]] = Field(default=None, description="List of target URLs for the workflow")
    limit: Optional[StrictInt] = Field(default=None, description="The new limit for the workflow")
    update_interval: Optional[StrictStr] = Field(default=None, description="The new update interval for the workflow", alias="updateInterval")
    schedules: Optional[List[StrictStr]] = Field(default=None, description="Array of cron expressions for the workflow schedule")
    name: Optional[StrictStr] = Field(default=None, description="The new name for the workflow")
    description: Optional[StrictStr] = Field(default=None, description="The new description for the workflow")
    tags: Optional[List[StrictStr]] = Field(default=None, description="The tags for the workflow")
    location: Optional[V4WorkflowsWorkflowIdMetadataPutRequestLocation] = None
    monitoring: Optional[V4WorkflowsWorkflowIdMetadataPutRequestMonitoring] = None
    entity: Optional[StrictStr] = Field(default=None, description="The new entity for the workflow")
    var_schema: Optional[List[V4WorkflowsWorkflowIdMetadataPutRequestSchemaInner]] = Field(default=None, description="The new extraction schema for the workflow", alias="schema")
    data_linking: Optional[V4WorkflowsWorkflowIdMetadataPutRequestDataLinking] = Field(default=None, alias="dataLinking")
    additional_data: Optional[Dict[str, Any]] = Field(default=None, description="Additional static data for the workflow", alias="additionalData")
    __properties: ClassVar[List[str]] = ["urls", "limit", "updateInterval", "schedules", "name", "description", "tags", "location", "monitoring", "entity", "schema", "dataLinking", "additionalData"]

    @field_validator('update_interval')
    def update_interval_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['ONLY_ONCE', 'HOURLY', 'DAILY', 'WEEKLY', 'MONTHLY', 'CUSTOM']):
            raise ValueError("must be one of enum values ('ONLY_ONCE', 'HOURLY', 'DAILY', 'WEEKLY', 'MONTHLY', 'CUSTOM')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V4WorkflowsWorkflowIdMetadataPutRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of location
        if self.location:
            _dict['location'] = self.location.to_dict()
        # override the default output from pydantic by calling `to_dict()` of monitoring
        if self.monitoring:
            _dict['monitoring'] = self.monitoring.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in var_schema (list)
        _items = []
        if self.var_schema:
            for _item_var_schema in self.var_schema:
                if _item_var_schema:
                    _items.append(_item_var_schema.to_dict())
            _dict['schema'] = _items
        # override the default output from pydantic by calling `to_dict()` of data_linking
        if self.data_linking:
            _dict['dataLinking'] = self.data_linking.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V4WorkflowsWorkflowIdMetadataPutRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "urls": obj.get("urls"),
            "limit": obj.get("limit"),
            "updateInterval": obj.get("updateInterval"),
            "schedules": obj.get("schedules"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "tags": obj.get("tags"),
            "location": V4WorkflowsWorkflowIdMetadataPutRequestLocation.from_dict(obj["location"]) if obj.get("location") is not None else None,
            "monitoring": V4WorkflowsWorkflowIdMetadataPutRequestMonitoring.from_dict(obj["monitoring"]) if obj.get("monitoring") is not None else None,
            "entity": obj.get("entity"),
            "schema": [V4WorkflowsWorkflowIdMetadataPutRequestSchemaInner.from_dict(_item) for _item in obj["schema"]] if obj.get("schema") is not None else None,
            "dataLinking": V4WorkflowsWorkflowIdMetadataPutRequestDataLinking.from_dict(obj["dataLinking"]) if obj.get("dataLinking") is not None else None,
            "additionalData": obj.get("additionalData")
        })
        return _obj


