# coding: utf-8

"""
    Kadoa API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 3.0.0
    Contact: support@kadoa.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class V5NotificationsSettingsPostRequest(BaseModel):
    """
    V5NotificationsSettingsPostRequest
    """ # noqa: E501
    workflow_id: Optional[StrictStr] = Field(default=None, description="Workflow ID (optional, if not provided creates workspace-level settings)", alias="workflowId")
    event_type: StrictStr = Field(alias="eventType")
    event_configuration: Dict[str, Any] = Field(description="Settings specific to the event type. Currently accepts an empty object {}. This object will be extended in future releases to support event-specific configuration options.", alias="eventConfiguration")
    enabled: Optional[StrictBool] = True
    channel_ids: Optional[List[StrictStr]] = Field(default=None, description="Array of channel IDs to link to this Settings", alias="channelIds")
    __properties: ClassVar[List[str]] = ["workflowId", "eventType", "eventConfiguration", "enabled", "channelIds"]

    @field_validator('event_type')
    def event_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['workflow_started', 'workflow_finished', 'workflow_failed', 'workflow_sample_finished', 'workflow_data_change', 'system_maintenance', 'service_degradation', 'credits_low', 'free_trial_ending']):
            raise ValueError("must be one of enum values ('workflow_started', 'workflow_finished', 'workflow_failed', 'workflow_sample_finished', 'workflow_data_change', 'system_maintenance', 'service_degradation', 'credits_low', 'free_trial_ending')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of V5NotificationsSettingsPostRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of V5NotificationsSettingsPostRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "workflowId": obj.get("workflowId"),
            "eventType": obj.get("eventType"),
            "eventConfiguration": obj.get("eventConfiguration"),
            "enabled": obj.get("enabled") if obj.get("enabled") is not None else True,
            "channelIds": obj.get("channelIds")
        })
        return _obj


