# coding: utf-8

"""
    Kadoa API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 3.0.0
    Contact: support@kadoa.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from openapi_client.models.validation_completed_at import ValidationCompletedAt
from openapi_client.models.validation_created_at import ValidationCreatedAt
from openapi_client.models.validation_metadata import ValidationMetadata
from typing import Optional, Set
from typing_extensions import Self

class Validation(BaseModel):
    """
    Complete validation run record with anomalies count and metadata
    """ # noqa: E501
    id: StrictStr = Field(description="Unique identifier")
    workflow_id: StrictStr = Field(alias="workflowId")
    job_id: StrictStr = Field(alias="jobId")
    anomalies_count_total: Union[StrictFloat, StrictInt] = Field(alias="anomaliesCountTotal")
    anomalies_count_by_rule: Dict[str, Union[StrictFloat, StrictInt]] = Field(alias="anomaliesCountByRule")
    created_at: ValidationCreatedAt = Field(alias="createdAt")
    updated_at: ValidationCreatedAt = Field(alias="updatedAt")
    completed_at: Optional[ValidationCompletedAt] = Field(default=None, alias="completedAt")
    metadata: Optional[ValidationMetadata] = None
    error: Optional[StrictStr] = None
    is_dry_run: Optional[StrictBool] = Field(default=None, alias="isDryRun")
    is_workflow_triggered: Optional[StrictBool] = Field(default=None, alias="isWorkflowTriggered")
    dataset_uri: Optional[StrictStr] = Field(default=None, alias="datasetUri")
    anomalies_parquet_path: Optional[StrictStr] = Field(default=None, alias="anomaliesParquetPath")
    strategy: Optional[StrictStr] = Field(default='ISOLATED', description="ISOLATED validates each dataset independently. LINKING_COLUMNS validates data integrity across linked columns between datasets.")
    __properties: ClassVar[List[str]] = ["id", "workflowId", "jobId", "anomaliesCountTotal", "anomaliesCountByRule", "createdAt", "updatedAt", "completedAt", "metadata", "error", "isDryRun", "isWorkflowTriggered", "datasetUri", "anomaliesParquetPath", "strategy"]

    @field_validator('strategy')
    def strategy_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['ISOLATED', 'LINKING_COLUMNS']):
            raise ValueError("must be one of enum values ('ISOLATED', 'LINKING_COLUMNS')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Validation from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of created_at
        if self.created_at:
            _dict['createdAt'] = self.created_at.to_dict()
        # override the default output from pydantic by calling `to_dict()` of updated_at
        if self.updated_at:
            _dict['updatedAt'] = self.updated_at.to_dict()
        # override the default output from pydantic by calling `to_dict()` of completed_at
        if self.completed_at:
            _dict['completedAt'] = self.completed_at.to_dict()
        # override the default output from pydantic by calling `to_dict()` of metadata
        if self.metadata:
            _dict['metadata'] = self.metadata.to_dict()
        # set to None if completed_at (nullable) is None
        # and model_fields_set contains the field
        if self.completed_at is None and "completed_at" in self.model_fields_set:
            _dict['completedAt'] = None

        # set to None if dataset_uri (nullable) is None
        # and model_fields_set contains the field
        if self.dataset_uri is None and "dataset_uri" in self.model_fields_set:
            _dict['datasetUri'] = None

        # set to None if anomalies_parquet_path (nullable) is None
        # and model_fields_set contains the field
        if self.anomalies_parquet_path is None and "anomalies_parquet_path" in self.model_fields_set:
            _dict['anomaliesParquetPath'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Validation from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "workflowId": obj.get("workflowId"),
            "jobId": obj.get("jobId"),
            "anomaliesCountTotal": obj.get("anomaliesCountTotal"),
            "anomaliesCountByRule": obj.get("anomaliesCountByRule"),
            "createdAt": ValidationCreatedAt.from_dict(obj["createdAt"]) if obj.get("createdAt") is not None else None,
            "updatedAt": ValidationCreatedAt.from_dict(obj["updatedAt"]) if obj.get("updatedAt") is not None else None,
            "completedAt": ValidationCompletedAt.from_dict(obj["completedAt"]) if obj.get("completedAt") is not None else None,
            "metadata": ValidationMetadata.from_dict(obj["metadata"]) if obj.get("metadata") is not None else None,
            "error": obj.get("error"),
            "isDryRun": obj.get("isDryRun"),
            "isWorkflowTriggered": obj.get("isWorkflowTriggered"),
            "datasetUri": obj.get("datasetUri"),
            "anomaliesParquetPath": obj.get("anomaliesParquetPath"),
            "strategy": obj.get("strategy") if obj.get("strategy") is not None else 'ISOLATED'
        })
        return _obj


