# coding: utf-8

"""
    Kadoa API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 3.0.0
    Contact: support@kadoa.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from openapi_client.models.dynamic_rule_config import DynamicRuleConfig
from openapi_client.models.validation_metadata_invalid_rules_inner import ValidationMetadataInvalidRulesInner
from openapi_client.models.validation_metadata_library_rules_inner import ValidationMetadataLibraryRulesInner
from typing import Optional, Set
from typing_extensions import Self

class ValidationMetadata(BaseModel):
    """
    ValidationMetadata
    """ # noqa: E501
    custom_rules: List[DynamicRuleConfig] = Field(alias="customRules")
    library_rules: List[ValidationMetadataLibraryRulesInner] = Field(alias="libraryRules")
    total_rules_executed: Union[StrictFloat, StrictInt] = Field(alias="totalRulesExecuted")
    used_prompt: Optional[StrictStr] = Field(default=None, alias="usedPrompt")
    invalid_rules: Optional[List[ValidationMetadataInvalidRulesInner]] = Field(default=None, alias="invalidRules")
    records_validated: Union[StrictFloat, StrictInt] = Field(alias="recordsValidated")
    __properties: ClassVar[List[str]] = ["customRules", "libraryRules", "totalRulesExecuted", "usedPrompt", "invalidRules", "recordsValidated"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ValidationMetadata from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in custom_rules (list)
        _items = []
        if self.custom_rules:
            for _item_custom_rules in self.custom_rules:
                if _item_custom_rules:
                    _items.append(_item_custom_rules.to_dict())
            _dict['customRules'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in library_rules (list)
        _items = []
        if self.library_rules:
            for _item_library_rules in self.library_rules:
                if _item_library_rules:
                    _items.append(_item_library_rules.to_dict())
            _dict['libraryRules'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in invalid_rules (list)
        _items = []
        if self.invalid_rules:
            for _item_invalid_rules in self.invalid_rules:
                if _item_invalid_rules:
                    _items.append(_item_invalid_rules.to_dict())
            _dict['invalidRules'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ValidationMetadata from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "customRules": [DynamicRuleConfig.from_dict(_item) for _item in obj["customRules"]] if obj.get("customRules") is not None else None,
            "libraryRules": [ValidationMetadataLibraryRulesInner.from_dict(_item) for _item in obj["libraryRules"]] if obj.get("libraryRules") is not None else None,
            "totalRulesExecuted": obj.get("totalRulesExecuted"),
            "usedPrompt": obj.get("usedPrompt"),
            "invalidRules": [ValidationMetadataInvalidRulesInner.from_dict(_item) for _item in obj["invalidRules"]] if obj.get("invalidRules") is not None else None,
            "recordsValidated": obj.get("recordsValidated")
        })
        return _obj


