# coding: utf-8

"""
    Kadoa API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 3.0.0
    Contact: support@kadoa.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from openapi_client.models.web_extension_interaction_meta_keys import WebExtensionInteractionMetaKeys
from openapi_client.models.web_extension_interaction_target import WebExtensionInteractionTarget
from typing import Optional, Set
from typing_extensions import Self

class WebExtensionInteraction(BaseModel):
    """
    Web extension interaction in complex format
    """ # noqa: E501
    type: StrictStr = Field(description="Type of interaction")
    id: Optional[StrictStr] = Field(default=None, description="Unique interaction ID")
    x: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="X coordinate")
    y: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Y coordinate")
    link: Optional[StrictStr] = Field(default=None, description="Page URL")
    time: Optional[StrictStr] = Field(default=None, description="Timestamp")
    body_html_url: Optional[StrictStr] = Field(default=None, description="URL to captured HTML body", alias="bodyHTMLUrl")
    screenshot_url: Optional[StrictStr] = Field(default=None, description="URL to captured screenshot", alias="screenshotUrl")
    target: Optional[WebExtensionInteractionTarget] = None
    key: Optional[StrictStr] = Field(default=None, description="Key value")
    code: Optional[StrictStr] = Field(default=None, description="Key code")
    meta_keys: Optional[WebExtensionInteractionMetaKeys] = Field(default=None, alias="metaKeys")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["type", "id", "x", "y", "link", "time", "bodyHTMLUrl", "screenshotUrl", "target", "key", "code", "metaKeys"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WebExtensionInteraction from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of target
        if self.target:
            _dict['target'] = self.target.to_dict()
        # override the default output from pydantic by calling `to_dict()` of meta_keys
        if self.meta_keys:
            _dict['metaKeys'] = self.meta_keys.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WebExtensionInteraction from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "type": obj.get("type"),
            "id": obj.get("id"),
            "x": obj.get("x"),
            "y": obj.get("y"),
            "link": obj.get("link"),
            "time": obj.get("time"),
            "bodyHTMLUrl": obj.get("bodyHTMLUrl"),
            "screenshotUrl": obj.get("screenshotUrl"),
            "target": WebExtensionInteractionTarget.from_dict(obj["target"]) if obj.get("target") is not None else None,
            "key": obj.get("key"),
            "code": obj.get("code"),
            "metaKeys": WebExtensionInteractionMetaKeys.from_dict(obj["metaKeys"]) if obj.get("metaKeys") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


