# coding: utf-8

"""
    Kadoa API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 3.0.0
    Contact: support@kadoa.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from openapi_client.models.webhook_channel_config_auth import WebhookChannelConfigAuth
from typing import Optional, Set
from typing_extensions import Self

class WebhookChannelConfig(BaseModel):
    """
    WebhookChannelConfig
    """ # noqa: E501
    webhook_url: StrictStr = Field(description="Webhook endpoint URL", alias="webhookUrl")
    http_method: StrictStr = Field(description="HTTP method for the webhook", alias="httpMethod")
    auth: Optional[WebhookChannelConfigAuth] = None
    __properties: ClassVar[List[str]] = ["webhookUrl", "httpMethod", "auth"]

    @field_validator('http_method')
    def http_method_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['POST', 'GET', 'PUT', 'PATCH']):
            raise ValueError("must be one of enum values ('POST', 'GET', 'PUT', 'PATCH')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WebhookChannelConfig from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of auth
        if self.auth:
            _dict['auth'] = self.auth.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WebhookChannelConfig from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "webhookUrl": obj.get("webhookUrl"),
            "httpMethod": obj.get("httpMethod"),
            "auth": WebhookChannelConfigAuth.from_dict(obj["auth"]) if obj.get("auth") is not None else None
        })
        return _obj


