# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['CseContextActionArgs', 'CseContextAction']

@pulumi.input_type
class CseContextActionArgs:
    def __init__(__self__, *,
                 ioc_types: pulumi.Input[Sequence[pulumi.Input[str]]],
                 all_record_fields: Optional[pulumi.Input[bool]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 entity_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 record_fields: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 template: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a CseContextAction resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ioc_types: IOC Data types. Valid values: "ASN", "DOMAIN", "HASH", "IP_ADDRESS", "MAC_ADDRESS", "PORT", "RECORD_PROPERTY", "URL".
        :param pulumi.Input[bool] all_record_fields: Use all record fields.
        :param pulumi.Input[bool] enabled: Whether the context action is enabled.
               
               The following attributes are exported:
        :param pulumi.Input[Sequence[pulumi.Input[str]]] entity_types: Applicable to given entity types.
        :param pulumi.Input[str] name: Context Action name.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] record_fields: Specific record fields.
        :param pulumi.Input[str] template: The URL/QUERY template.
        :param pulumi.Input[str] type: Context Action type. Valid values: "URL", "QUERY".
        """
        CseContextActionArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            ioc_types=ioc_types,
            all_record_fields=all_record_fields,
            enabled=enabled,
            entity_types=entity_types,
            name=name,
            record_fields=record_fields,
            template=template,
            type=type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             ioc_types: pulumi.Input[Sequence[pulumi.Input[str]]],
             all_record_fields: Optional[pulumi.Input[bool]] = None,
             enabled: Optional[pulumi.Input[bool]] = None,
             entity_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             name: Optional[pulumi.Input[str]] = None,
             record_fields: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             template: Optional[pulumi.Input[str]] = None,
             type: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("ioc_types", ioc_types)
        if all_record_fields is not None:
            _setter("all_record_fields", all_record_fields)
        if enabled is not None:
            _setter("enabled", enabled)
        if entity_types is not None:
            _setter("entity_types", entity_types)
        if name is not None:
            _setter("name", name)
        if record_fields is not None:
            _setter("record_fields", record_fields)
        if template is not None:
            _setter("template", template)
        if type is not None:
            _setter("type", type)

    @property
    @pulumi.getter(name="iocTypes")
    def ioc_types(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        IOC Data types. Valid values: "ASN", "DOMAIN", "HASH", "IP_ADDRESS", "MAC_ADDRESS", "PORT", "RECORD_PROPERTY", "URL".
        """
        return pulumi.get(self, "ioc_types")

    @ioc_types.setter
    def ioc_types(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "ioc_types", value)

    @property
    @pulumi.getter(name="allRecordFields")
    def all_record_fields(self) -> Optional[pulumi.Input[bool]]:
        """
        Use all record fields.
        """
        return pulumi.get(self, "all_record_fields")

    @all_record_fields.setter
    def all_record_fields(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "all_record_fields", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the context action is enabled.

        The following attributes are exported:
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="entityTypes")
    def entity_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Applicable to given entity types.
        """
        return pulumi.get(self, "entity_types")

    @entity_types.setter
    def entity_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "entity_types", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Context Action name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="recordFields")
    def record_fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specific record fields.
        """
        return pulumi.get(self, "record_fields")

    @record_fields.setter
    def record_fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "record_fields", value)

    @property
    @pulumi.getter
    def template(self) -> Optional[pulumi.Input[str]]:
        """
        The URL/QUERY template.
        """
        return pulumi.get(self, "template")

    @template.setter
    def template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "template", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Context Action type. Valid values: "URL", "QUERY".
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _CseContextActionState:
    def __init__(__self__, *,
                 all_record_fields: Optional[pulumi.Input[bool]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 entity_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ioc_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 record_fields: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 template: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering CseContextAction resources.
        :param pulumi.Input[bool] all_record_fields: Use all record fields.
        :param pulumi.Input[bool] enabled: Whether the context action is enabled.
               
               The following attributes are exported:
        :param pulumi.Input[Sequence[pulumi.Input[str]]] entity_types: Applicable to given entity types.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ioc_types: IOC Data types. Valid values: "ASN", "DOMAIN", "HASH", "IP_ADDRESS", "MAC_ADDRESS", "PORT", "RECORD_PROPERTY", "URL".
        :param pulumi.Input[str] name: Context Action name.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] record_fields: Specific record fields.
        :param pulumi.Input[str] template: The URL/QUERY template.
        :param pulumi.Input[str] type: Context Action type. Valid values: "URL", "QUERY".
        """
        _CseContextActionState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            all_record_fields=all_record_fields,
            enabled=enabled,
            entity_types=entity_types,
            ioc_types=ioc_types,
            name=name,
            record_fields=record_fields,
            template=template,
            type=type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             all_record_fields: Optional[pulumi.Input[bool]] = None,
             enabled: Optional[pulumi.Input[bool]] = None,
             entity_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             ioc_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             name: Optional[pulumi.Input[str]] = None,
             record_fields: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             template: Optional[pulumi.Input[str]] = None,
             type: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if all_record_fields is not None:
            _setter("all_record_fields", all_record_fields)
        if enabled is not None:
            _setter("enabled", enabled)
        if entity_types is not None:
            _setter("entity_types", entity_types)
        if ioc_types is not None:
            _setter("ioc_types", ioc_types)
        if name is not None:
            _setter("name", name)
        if record_fields is not None:
            _setter("record_fields", record_fields)
        if template is not None:
            _setter("template", template)
        if type is not None:
            _setter("type", type)

    @property
    @pulumi.getter(name="allRecordFields")
    def all_record_fields(self) -> Optional[pulumi.Input[bool]]:
        """
        Use all record fields.
        """
        return pulumi.get(self, "all_record_fields")

    @all_record_fields.setter
    def all_record_fields(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "all_record_fields", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the context action is enabled.

        The following attributes are exported:
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="entityTypes")
    def entity_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Applicable to given entity types.
        """
        return pulumi.get(self, "entity_types")

    @entity_types.setter
    def entity_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "entity_types", value)

    @property
    @pulumi.getter(name="iocTypes")
    def ioc_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        IOC Data types. Valid values: "ASN", "DOMAIN", "HASH", "IP_ADDRESS", "MAC_ADDRESS", "PORT", "RECORD_PROPERTY", "URL".
        """
        return pulumi.get(self, "ioc_types")

    @ioc_types.setter
    def ioc_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ioc_types", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Context Action name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="recordFields")
    def record_fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specific record fields.
        """
        return pulumi.get(self, "record_fields")

    @record_fields.setter
    def record_fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "record_fields", value)

    @property
    @pulumi.getter
    def template(self) -> Optional[pulumi.Input[str]]:
        """
        The URL/QUERY template.
        """
        return pulumi.get(self, "template")

    @template.setter
    def template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "template", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Context Action type. Valid values: "URL", "QUERY".
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


class CseContextAction(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 all_record_fields: Optional[pulumi.Input[bool]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 entity_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ioc_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 record_fields: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 template: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a Sumologic CSE Context Action.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sumologic as sumologic

        context_action = sumologic.CseContextAction("contextAction",
            all_record_fields=False,
            enabled=True,
            entity_types=["_hostname"],
            ioc_types=["IP_ADDRESS"],
            record_fields=["request_url"],
            template="https://bar.com/?q={{value}}",
            type="URL")
        ```

        ## Import

        Context Action can be imported using the field id, e.g.hcl

        ```sh
         $ pulumi import sumologic:index/cseContextAction:CseContextAction context_action id
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] all_record_fields: Use all record fields.
        :param pulumi.Input[bool] enabled: Whether the context action is enabled.
               
               The following attributes are exported:
        :param pulumi.Input[Sequence[pulumi.Input[str]]] entity_types: Applicable to given entity types.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ioc_types: IOC Data types. Valid values: "ASN", "DOMAIN", "HASH", "IP_ADDRESS", "MAC_ADDRESS", "PORT", "RECORD_PROPERTY", "URL".
        :param pulumi.Input[str] name: Context Action name.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] record_fields: Specific record fields.
        :param pulumi.Input[str] template: The URL/QUERY template.
        :param pulumi.Input[str] type: Context Action type. Valid values: "URL", "QUERY".
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CseContextActionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Sumologic CSE Context Action.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sumologic as sumologic

        context_action = sumologic.CseContextAction("contextAction",
            all_record_fields=False,
            enabled=True,
            entity_types=["_hostname"],
            ioc_types=["IP_ADDRESS"],
            record_fields=["request_url"],
            template="https://bar.com/?q={{value}}",
            type="URL")
        ```

        ## Import

        Context Action can be imported using the field id, e.g.hcl

        ```sh
         $ pulumi import sumologic:index/cseContextAction:CseContextAction context_action id
        ```

        :param str resource_name: The name of the resource.
        :param CseContextActionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CseContextActionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            CseContextActionArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 all_record_fields: Optional[pulumi.Input[bool]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 entity_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ioc_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 record_fields: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 template: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CseContextActionArgs.__new__(CseContextActionArgs)

            __props__.__dict__["all_record_fields"] = all_record_fields
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["entity_types"] = entity_types
            if ioc_types is None and not opts.urn:
                raise TypeError("Missing required property 'ioc_types'")
            __props__.__dict__["ioc_types"] = ioc_types
            __props__.__dict__["name"] = name
            __props__.__dict__["record_fields"] = record_fields
            __props__.__dict__["template"] = template
            __props__.__dict__["type"] = type
        super(CseContextAction, __self__).__init__(
            'sumologic:index/cseContextAction:CseContextAction',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            all_record_fields: Optional[pulumi.Input[bool]] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            entity_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            ioc_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            record_fields: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            template: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None) -> 'CseContextAction':
        """
        Get an existing CseContextAction resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] all_record_fields: Use all record fields.
        :param pulumi.Input[bool] enabled: Whether the context action is enabled.
               
               The following attributes are exported:
        :param pulumi.Input[Sequence[pulumi.Input[str]]] entity_types: Applicable to given entity types.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ioc_types: IOC Data types. Valid values: "ASN", "DOMAIN", "HASH", "IP_ADDRESS", "MAC_ADDRESS", "PORT", "RECORD_PROPERTY", "URL".
        :param pulumi.Input[str] name: Context Action name.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] record_fields: Specific record fields.
        :param pulumi.Input[str] template: The URL/QUERY template.
        :param pulumi.Input[str] type: Context Action type. Valid values: "URL", "QUERY".
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CseContextActionState.__new__(_CseContextActionState)

        __props__.__dict__["all_record_fields"] = all_record_fields
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["entity_types"] = entity_types
        __props__.__dict__["ioc_types"] = ioc_types
        __props__.__dict__["name"] = name
        __props__.__dict__["record_fields"] = record_fields
        __props__.__dict__["template"] = template
        __props__.__dict__["type"] = type
        return CseContextAction(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allRecordFields")
    def all_record_fields(self) -> pulumi.Output[Optional[bool]]:
        """
        Use all record fields.
        """
        return pulumi.get(self, "all_record_fields")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether the context action is enabled.

        The following attributes are exported:
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="entityTypes")
    def entity_types(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Applicable to given entity types.
        """
        return pulumi.get(self, "entity_types")

    @property
    @pulumi.getter(name="iocTypes")
    def ioc_types(self) -> pulumi.Output[Sequence[str]]:
        """
        IOC Data types. Valid values: "ASN", "DOMAIN", "HASH", "IP_ADDRESS", "MAC_ADDRESS", "PORT", "RECORD_PROPERTY", "URL".
        """
        return pulumi.get(self, "ioc_types")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Context Action name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="recordFields")
    def record_fields(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Specific record fields.
        """
        return pulumi.get(self, "record_fields")

    @property
    @pulumi.getter
    def template(self) -> pulumi.Output[Optional[str]]:
        """
        The URL/QUERY template.
        """
        return pulumi.get(self, "template")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional[str]]:
        """
        Context Action type. Valid values: "URL", "QUERY".
        """
        return pulumi.get(self, "type")

