# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['CseInventoryEntityGroupConfigurationArgs', 'CseInventoryEntityGroupConfiguration']

@pulumi.input_type
class CseInventoryEntityGroupConfigurationArgs:
    def __init__(__self__, *,
                 inventory_source: pulumi.Input[str],
                 inventory_type: pulumi.Input[str],
                 criticality: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dynamic_tags: Optional[pulumi.Input[bool]] = None,
                 group: Optional[pulumi.Input[str]] = None,
                 inventory_key: Optional[pulumi.Input[str]] = None,
                 inventory_value: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 suppressed: Optional[pulumi.Input[bool]] = None,
                 tag_schema: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a CseInventoryEntityGroupConfiguration resource.
        :param pulumi.Input[str] inventory_source: The inventory source Examples: "Active Directory", "Okta".
        :param pulumi.Input[str] inventory_type: The inventory type Examples: "computer", "username".
        :param pulumi.Input[str] criticality: The entity group configuration criticality Examples: "HIGH", "CRITICALITY".
        :param pulumi.Input[str] description: The entity group configuration description.
        :param pulumi.Input[bool] dynamic_tags: If dynamic tags are enabled for configuration.
        :param pulumi.Input[str] group: (Deprecated) The entity group configuration inventory group. The field `group` is deprecated and will be removed in a future release of the provider -- please make usage of `inventory_key`, `inventory_value`  instead.
        :param pulumi.Input[str] inventory_key: The inventory key to apply configuration Examples: "groups", "normalizedHostname", "normalizedComputerName".
        :param pulumi.Input[str] inventory_value: The inventory value to match.
        :param pulumi.Input[str] name: The entity group configuration name.
        :param pulumi.Input[str] tag_schema: The tag schema to be used for dynamic tags.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The entity group configuration tags list.
               
               The following attributes are exported:
        """
        CseInventoryEntityGroupConfigurationArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            inventory_source=inventory_source,
            inventory_type=inventory_type,
            criticality=criticality,
            description=description,
            dynamic_tags=dynamic_tags,
            group=group,
            inventory_key=inventory_key,
            inventory_value=inventory_value,
            name=name,
            suppressed=suppressed,
            tag_schema=tag_schema,
            tags=tags,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             inventory_source: pulumi.Input[str],
             inventory_type: pulumi.Input[str],
             criticality: Optional[pulumi.Input[str]] = None,
             description: Optional[pulumi.Input[str]] = None,
             dynamic_tags: Optional[pulumi.Input[bool]] = None,
             group: Optional[pulumi.Input[str]] = None,
             inventory_key: Optional[pulumi.Input[str]] = None,
             inventory_value: Optional[pulumi.Input[str]] = None,
             name: Optional[pulumi.Input[str]] = None,
             suppressed: Optional[pulumi.Input[bool]] = None,
             tag_schema: Optional[pulumi.Input[str]] = None,
             tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("inventory_source", inventory_source)
        _setter("inventory_type", inventory_type)
        if criticality is not None:
            _setter("criticality", criticality)
        if description is not None:
            _setter("description", description)
        if dynamic_tags is not None:
            _setter("dynamic_tags", dynamic_tags)
        if group is not None:
            warnings.warn("""The field `group` is deprecated and will be removed in a future release of the provider -- please make usage of `inventory_key`, `inventory_value` instead.""", DeprecationWarning)
            pulumi.log.warn("""group is deprecated: The field `group` is deprecated and will be removed in a future release of the provider -- please make usage of `inventory_key`, `inventory_value` instead.""")
        if group is not None:
            _setter("group", group)
        if inventory_key is not None:
            _setter("inventory_key", inventory_key)
        if inventory_value is not None:
            _setter("inventory_value", inventory_value)
        if name is not None:
            _setter("name", name)
        if suppressed is not None:
            _setter("suppressed", suppressed)
        if tag_schema is not None:
            _setter("tag_schema", tag_schema)
        if tags is not None:
            _setter("tags", tags)

    @property
    @pulumi.getter(name="inventorySource")
    def inventory_source(self) -> pulumi.Input[str]:
        """
        The inventory source Examples: "Active Directory", "Okta".
        """
        return pulumi.get(self, "inventory_source")

    @inventory_source.setter
    def inventory_source(self, value: pulumi.Input[str]):
        pulumi.set(self, "inventory_source", value)

    @property
    @pulumi.getter(name="inventoryType")
    def inventory_type(self) -> pulumi.Input[str]:
        """
        The inventory type Examples: "computer", "username".
        """
        return pulumi.get(self, "inventory_type")

    @inventory_type.setter
    def inventory_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "inventory_type", value)

    @property
    @pulumi.getter
    def criticality(self) -> Optional[pulumi.Input[str]]:
        """
        The entity group configuration criticality Examples: "HIGH", "CRITICALITY".
        """
        return pulumi.get(self, "criticality")

    @criticality.setter
    def criticality(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "criticality", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The entity group configuration description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="dynamicTags")
    def dynamic_tags(self) -> Optional[pulumi.Input[bool]]:
        """
        If dynamic tags are enabled for configuration.
        """
        return pulumi.get(self, "dynamic_tags")

    @dynamic_tags.setter
    def dynamic_tags(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "dynamic_tags", value)

    @property
    @pulumi.getter
    def group(self) -> Optional[pulumi.Input[str]]:
        """
        (Deprecated) The entity group configuration inventory group. The field `group` is deprecated and will be removed in a future release of the provider -- please make usage of `inventory_key`, `inventory_value`  instead.
        """
        warnings.warn("""The field `group` is deprecated and will be removed in a future release of the provider -- please make usage of `inventory_key`, `inventory_value` instead.""", DeprecationWarning)
        pulumi.log.warn("""group is deprecated: The field `group` is deprecated and will be removed in a future release of the provider -- please make usage of `inventory_key`, `inventory_value` instead.""")

        return pulumi.get(self, "group")

    @group.setter
    def group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group", value)

    @property
    @pulumi.getter(name="inventoryKey")
    def inventory_key(self) -> Optional[pulumi.Input[str]]:
        """
        The inventory key to apply configuration Examples: "groups", "normalizedHostname", "normalizedComputerName".
        """
        return pulumi.get(self, "inventory_key")

    @inventory_key.setter
    def inventory_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "inventory_key", value)

    @property
    @pulumi.getter(name="inventoryValue")
    def inventory_value(self) -> Optional[pulumi.Input[str]]:
        """
        The inventory value to match.
        """
        return pulumi.get(self, "inventory_value")

    @inventory_value.setter
    def inventory_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "inventory_value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The entity group configuration name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def suppressed(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "suppressed")

    @suppressed.setter
    def suppressed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "suppressed", value)

    @property
    @pulumi.getter(name="tagSchema")
    def tag_schema(self) -> Optional[pulumi.Input[str]]:
        """
        The tag schema to be used for dynamic tags.
        """
        return pulumi.get(self, "tag_schema")

    @tag_schema.setter
    def tag_schema(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tag_schema", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The entity group configuration tags list.

        The following attributes are exported:
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _CseInventoryEntityGroupConfigurationState:
    def __init__(__self__, *,
                 criticality: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dynamic_tags: Optional[pulumi.Input[bool]] = None,
                 group: Optional[pulumi.Input[str]] = None,
                 inventory_key: Optional[pulumi.Input[str]] = None,
                 inventory_source: Optional[pulumi.Input[str]] = None,
                 inventory_type: Optional[pulumi.Input[str]] = None,
                 inventory_value: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 suppressed: Optional[pulumi.Input[bool]] = None,
                 tag_schema: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering CseInventoryEntityGroupConfiguration resources.
        :param pulumi.Input[str] criticality: The entity group configuration criticality Examples: "HIGH", "CRITICALITY".
        :param pulumi.Input[str] description: The entity group configuration description.
        :param pulumi.Input[bool] dynamic_tags: If dynamic tags are enabled for configuration.
        :param pulumi.Input[str] group: (Deprecated) The entity group configuration inventory group. The field `group` is deprecated and will be removed in a future release of the provider -- please make usage of `inventory_key`, `inventory_value`  instead.
        :param pulumi.Input[str] inventory_key: The inventory key to apply configuration Examples: "groups", "normalizedHostname", "normalizedComputerName".
        :param pulumi.Input[str] inventory_source: The inventory source Examples: "Active Directory", "Okta".
        :param pulumi.Input[str] inventory_type: The inventory type Examples: "computer", "username".
        :param pulumi.Input[str] inventory_value: The inventory value to match.
        :param pulumi.Input[str] name: The entity group configuration name.
        :param pulumi.Input[str] tag_schema: The tag schema to be used for dynamic tags.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The entity group configuration tags list.
               
               The following attributes are exported:
        """
        _CseInventoryEntityGroupConfigurationState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            criticality=criticality,
            description=description,
            dynamic_tags=dynamic_tags,
            group=group,
            inventory_key=inventory_key,
            inventory_source=inventory_source,
            inventory_type=inventory_type,
            inventory_value=inventory_value,
            name=name,
            suppressed=suppressed,
            tag_schema=tag_schema,
            tags=tags,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             criticality: Optional[pulumi.Input[str]] = None,
             description: Optional[pulumi.Input[str]] = None,
             dynamic_tags: Optional[pulumi.Input[bool]] = None,
             group: Optional[pulumi.Input[str]] = None,
             inventory_key: Optional[pulumi.Input[str]] = None,
             inventory_source: Optional[pulumi.Input[str]] = None,
             inventory_type: Optional[pulumi.Input[str]] = None,
             inventory_value: Optional[pulumi.Input[str]] = None,
             name: Optional[pulumi.Input[str]] = None,
             suppressed: Optional[pulumi.Input[bool]] = None,
             tag_schema: Optional[pulumi.Input[str]] = None,
             tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if criticality is not None:
            _setter("criticality", criticality)
        if description is not None:
            _setter("description", description)
        if dynamic_tags is not None:
            _setter("dynamic_tags", dynamic_tags)
        if group is not None:
            warnings.warn("""The field `group` is deprecated and will be removed in a future release of the provider -- please make usage of `inventory_key`, `inventory_value` instead.""", DeprecationWarning)
            pulumi.log.warn("""group is deprecated: The field `group` is deprecated and will be removed in a future release of the provider -- please make usage of `inventory_key`, `inventory_value` instead.""")
        if group is not None:
            _setter("group", group)
        if inventory_key is not None:
            _setter("inventory_key", inventory_key)
        if inventory_source is not None:
            _setter("inventory_source", inventory_source)
        if inventory_type is not None:
            _setter("inventory_type", inventory_type)
        if inventory_value is not None:
            _setter("inventory_value", inventory_value)
        if name is not None:
            _setter("name", name)
        if suppressed is not None:
            _setter("suppressed", suppressed)
        if tag_schema is not None:
            _setter("tag_schema", tag_schema)
        if tags is not None:
            _setter("tags", tags)

    @property
    @pulumi.getter
    def criticality(self) -> Optional[pulumi.Input[str]]:
        """
        The entity group configuration criticality Examples: "HIGH", "CRITICALITY".
        """
        return pulumi.get(self, "criticality")

    @criticality.setter
    def criticality(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "criticality", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The entity group configuration description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="dynamicTags")
    def dynamic_tags(self) -> Optional[pulumi.Input[bool]]:
        """
        If dynamic tags are enabled for configuration.
        """
        return pulumi.get(self, "dynamic_tags")

    @dynamic_tags.setter
    def dynamic_tags(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "dynamic_tags", value)

    @property
    @pulumi.getter
    def group(self) -> Optional[pulumi.Input[str]]:
        """
        (Deprecated) The entity group configuration inventory group. The field `group` is deprecated and will be removed in a future release of the provider -- please make usage of `inventory_key`, `inventory_value`  instead.
        """
        warnings.warn("""The field `group` is deprecated and will be removed in a future release of the provider -- please make usage of `inventory_key`, `inventory_value` instead.""", DeprecationWarning)
        pulumi.log.warn("""group is deprecated: The field `group` is deprecated and will be removed in a future release of the provider -- please make usage of `inventory_key`, `inventory_value` instead.""")

        return pulumi.get(self, "group")

    @group.setter
    def group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group", value)

    @property
    @pulumi.getter(name="inventoryKey")
    def inventory_key(self) -> Optional[pulumi.Input[str]]:
        """
        The inventory key to apply configuration Examples: "groups", "normalizedHostname", "normalizedComputerName".
        """
        return pulumi.get(self, "inventory_key")

    @inventory_key.setter
    def inventory_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "inventory_key", value)

    @property
    @pulumi.getter(name="inventorySource")
    def inventory_source(self) -> Optional[pulumi.Input[str]]:
        """
        The inventory source Examples: "Active Directory", "Okta".
        """
        return pulumi.get(self, "inventory_source")

    @inventory_source.setter
    def inventory_source(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "inventory_source", value)

    @property
    @pulumi.getter(name="inventoryType")
    def inventory_type(self) -> Optional[pulumi.Input[str]]:
        """
        The inventory type Examples: "computer", "username".
        """
        return pulumi.get(self, "inventory_type")

    @inventory_type.setter
    def inventory_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "inventory_type", value)

    @property
    @pulumi.getter(name="inventoryValue")
    def inventory_value(self) -> Optional[pulumi.Input[str]]:
        """
        The inventory value to match.
        """
        return pulumi.get(self, "inventory_value")

    @inventory_value.setter
    def inventory_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "inventory_value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The entity group configuration name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def suppressed(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "suppressed")

    @suppressed.setter
    def suppressed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "suppressed", value)

    @property
    @pulumi.getter(name="tagSchema")
    def tag_schema(self) -> Optional[pulumi.Input[str]]:
        """
        The tag schema to be used for dynamic tags.
        """
        return pulumi.get(self, "tag_schema")

    @tag_schema.setter
    def tag_schema(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tag_schema", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The entity group configuration tags list.

        The following attributes are exported:
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


class CseInventoryEntityGroupConfiguration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 criticality: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dynamic_tags: Optional[pulumi.Input[bool]] = None,
                 group: Optional[pulumi.Input[str]] = None,
                 inventory_key: Optional[pulumi.Input[str]] = None,
                 inventory_source: Optional[pulumi.Input[str]] = None,
                 inventory_type: Optional[pulumi.Input[str]] = None,
                 inventory_value: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 suppressed: Optional[pulumi.Input[bool]] = None,
                 tag_schema: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_sumologic as sumologic

        inventory_entity_group_configuration = sumologic.CseInventoryEntityGroupConfiguration("inventoryEntityGroupConfiguration",
            criticality="HIGH",
            description="Inventory entity group description",
            inventory_key="groups",
            inventory_source="Active Directory",
            inventory_type="username",
            inventory_value="http_servers",
            suppressed=False,
            tags=["tag"])
        ```

        ## Import

        Inventory Entity Group Configuration can be imported using the field id, e.g.hcl

        ```sh
         $ pulumi import sumologic:index/cseInventoryEntityGroupConfiguration:CseInventoryEntityGroupConfiguration inventory_entity_group_configuration id
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] criticality: The entity group configuration criticality Examples: "HIGH", "CRITICALITY".
        :param pulumi.Input[str] description: The entity group configuration description.
        :param pulumi.Input[bool] dynamic_tags: If dynamic tags are enabled for configuration.
        :param pulumi.Input[str] group: (Deprecated) The entity group configuration inventory group. The field `group` is deprecated and will be removed in a future release of the provider -- please make usage of `inventory_key`, `inventory_value`  instead.
        :param pulumi.Input[str] inventory_key: The inventory key to apply configuration Examples: "groups", "normalizedHostname", "normalizedComputerName".
        :param pulumi.Input[str] inventory_source: The inventory source Examples: "Active Directory", "Okta".
        :param pulumi.Input[str] inventory_type: The inventory type Examples: "computer", "username".
        :param pulumi.Input[str] inventory_value: The inventory value to match.
        :param pulumi.Input[str] name: The entity group configuration name.
        :param pulumi.Input[str] tag_schema: The tag schema to be used for dynamic tags.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The entity group configuration tags list.
               
               The following attributes are exported:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CseInventoryEntityGroupConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_sumologic as sumologic

        inventory_entity_group_configuration = sumologic.CseInventoryEntityGroupConfiguration("inventoryEntityGroupConfiguration",
            criticality="HIGH",
            description="Inventory entity group description",
            inventory_key="groups",
            inventory_source="Active Directory",
            inventory_type="username",
            inventory_value="http_servers",
            suppressed=False,
            tags=["tag"])
        ```

        ## Import

        Inventory Entity Group Configuration can be imported using the field id, e.g.hcl

        ```sh
         $ pulumi import sumologic:index/cseInventoryEntityGroupConfiguration:CseInventoryEntityGroupConfiguration inventory_entity_group_configuration id
        ```

        :param str resource_name: The name of the resource.
        :param CseInventoryEntityGroupConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CseInventoryEntityGroupConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            CseInventoryEntityGroupConfigurationArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 criticality: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dynamic_tags: Optional[pulumi.Input[bool]] = None,
                 group: Optional[pulumi.Input[str]] = None,
                 inventory_key: Optional[pulumi.Input[str]] = None,
                 inventory_source: Optional[pulumi.Input[str]] = None,
                 inventory_type: Optional[pulumi.Input[str]] = None,
                 inventory_value: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 suppressed: Optional[pulumi.Input[bool]] = None,
                 tag_schema: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CseInventoryEntityGroupConfigurationArgs.__new__(CseInventoryEntityGroupConfigurationArgs)

            __props__.__dict__["criticality"] = criticality
            __props__.__dict__["description"] = description
            __props__.__dict__["dynamic_tags"] = dynamic_tags
            __props__.__dict__["group"] = group
            __props__.__dict__["inventory_key"] = inventory_key
            if inventory_source is None and not opts.urn:
                raise TypeError("Missing required property 'inventory_source'")
            __props__.__dict__["inventory_source"] = inventory_source
            if inventory_type is None and not opts.urn:
                raise TypeError("Missing required property 'inventory_type'")
            __props__.__dict__["inventory_type"] = inventory_type
            __props__.__dict__["inventory_value"] = inventory_value
            __props__.__dict__["name"] = name
            __props__.__dict__["suppressed"] = suppressed
            __props__.__dict__["tag_schema"] = tag_schema
            __props__.__dict__["tags"] = tags
        super(CseInventoryEntityGroupConfiguration, __self__).__init__(
            'sumologic:index/cseInventoryEntityGroupConfiguration:CseInventoryEntityGroupConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            criticality: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            dynamic_tags: Optional[pulumi.Input[bool]] = None,
            group: Optional[pulumi.Input[str]] = None,
            inventory_key: Optional[pulumi.Input[str]] = None,
            inventory_source: Optional[pulumi.Input[str]] = None,
            inventory_type: Optional[pulumi.Input[str]] = None,
            inventory_value: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            suppressed: Optional[pulumi.Input[bool]] = None,
            tag_schema: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'CseInventoryEntityGroupConfiguration':
        """
        Get an existing CseInventoryEntityGroupConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] criticality: The entity group configuration criticality Examples: "HIGH", "CRITICALITY".
        :param pulumi.Input[str] description: The entity group configuration description.
        :param pulumi.Input[bool] dynamic_tags: If dynamic tags are enabled for configuration.
        :param pulumi.Input[str] group: (Deprecated) The entity group configuration inventory group. The field `group` is deprecated and will be removed in a future release of the provider -- please make usage of `inventory_key`, `inventory_value`  instead.
        :param pulumi.Input[str] inventory_key: The inventory key to apply configuration Examples: "groups", "normalizedHostname", "normalizedComputerName".
        :param pulumi.Input[str] inventory_source: The inventory source Examples: "Active Directory", "Okta".
        :param pulumi.Input[str] inventory_type: The inventory type Examples: "computer", "username".
        :param pulumi.Input[str] inventory_value: The inventory value to match.
        :param pulumi.Input[str] name: The entity group configuration name.
        :param pulumi.Input[str] tag_schema: The tag schema to be used for dynamic tags.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The entity group configuration tags list.
               
               The following attributes are exported:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CseInventoryEntityGroupConfigurationState.__new__(_CseInventoryEntityGroupConfigurationState)

        __props__.__dict__["criticality"] = criticality
        __props__.__dict__["description"] = description
        __props__.__dict__["dynamic_tags"] = dynamic_tags
        __props__.__dict__["group"] = group
        __props__.__dict__["inventory_key"] = inventory_key
        __props__.__dict__["inventory_source"] = inventory_source
        __props__.__dict__["inventory_type"] = inventory_type
        __props__.__dict__["inventory_value"] = inventory_value
        __props__.__dict__["name"] = name
        __props__.__dict__["suppressed"] = suppressed
        __props__.__dict__["tag_schema"] = tag_schema
        __props__.__dict__["tags"] = tags
        return CseInventoryEntityGroupConfiguration(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def criticality(self) -> pulumi.Output[Optional[str]]:
        """
        The entity group configuration criticality Examples: "HIGH", "CRITICALITY".
        """
        return pulumi.get(self, "criticality")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The entity group configuration description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="dynamicTags")
    def dynamic_tags(self) -> pulumi.Output[Optional[bool]]:
        """
        If dynamic tags are enabled for configuration.
        """
        return pulumi.get(self, "dynamic_tags")

    @property
    @pulumi.getter
    def group(self) -> pulumi.Output[Optional[str]]:
        """
        (Deprecated) The entity group configuration inventory group. The field `group` is deprecated and will be removed in a future release of the provider -- please make usage of `inventory_key`, `inventory_value`  instead.
        """
        warnings.warn("""The field `group` is deprecated and will be removed in a future release of the provider -- please make usage of `inventory_key`, `inventory_value` instead.""", DeprecationWarning)
        pulumi.log.warn("""group is deprecated: The field `group` is deprecated and will be removed in a future release of the provider -- please make usage of `inventory_key`, `inventory_value` instead.""")

        return pulumi.get(self, "group")

    @property
    @pulumi.getter(name="inventoryKey")
    def inventory_key(self) -> pulumi.Output[Optional[str]]:
        """
        The inventory key to apply configuration Examples: "groups", "normalizedHostname", "normalizedComputerName".
        """
        return pulumi.get(self, "inventory_key")

    @property
    @pulumi.getter(name="inventorySource")
    def inventory_source(self) -> pulumi.Output[str]:
        """
        The inventory source Examples: "Active Directory", "Okta".
        """
        return pulumi.get(self, "inventory_source")

    @property
    @pulumi.getter(name="inventoryType")
    def inventory_type(self) -> pulumi.Output[str]:
        """
        The inventory type Examples: "computer", "username".
        """
        return pulumi.get(self, "inventory_type")

    @property
    @pulumi.getter(name="inventoryValue")
    def inventory_value(self) -> pulumi.Output[Optional[str]]:
        """
        The inventory value to match.
        """
        return pulumi.get(self, "inventory_value")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The entity group configuration name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def suppressed(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "suppressed")

    @property
    @pulumi.getter(name="tagSchema")
    def tag_schema(self) -> pulumi.Output[Optional[str]]:
        """
        The tag schema to be used for dynamic tags.
        """
        return pulumi.get(self, "tag_schema")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The entity group configuration tags list.

        The following attributes are exported:
        """
        return pulumi.get(self, "tags")

