# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CseMatchRuleArgs', 'CseMatchRule']

@pulumi.input_type
class CseMatchRuleArgs:
    def __init__(__self__, *,
                 description_expression: pulumi.Input[str],
                 enabled: pulumi.Input[bool],
                 entity_selectors: pulumi.Input[Sequence[pulumi.Input['CseMatchRuleEntitySelectorArgs']]],
                 expression: pulumi.Input[str],
                 name_expression: pulumi.Input[str],
                 severity_mapping: pulumi.Input['CseMatchRuleSeverityMappingArgs'],
                 is_prototype: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 summary_expression: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a CseMatchRule resource.
        :param pulumi.Input[str] description_expression: The description of the generated Signals
        :param pulumi.Input[bool] enabled: Whether the rule should generate Signals
        :param pulumi.Input[Sequence[pulumi.Input['CseMatchRuleEntitySelectorArgs']]] entity_selectors: The entities to generate Signals on
        :param pulumi.Input[str] expression: The expression for which records to match on
        :param pulumi.Input[str] name_expression: The name of the generated Signals
        :param pulumi.Input['CseMatchRuleSeverityMappingArgs'] severity_mapping: The configuration of how the severity of the Signals should be mapped from the Records
        :param pulumi.Input[bool] is_prototype: Whether the generated Signals should be prototype Signals
        :param pulumi.Input[str] name: The name of the Rule
        :param pulumi.Input[str] summary_expression: The summary of the generated Signals
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The tags of the generated Signals
               
               The following attributes are exported:
        """
        CseMatchRuleArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            description_expression=description_expression,
            enabled=enabled,
            entity_selectors=entity_selectors,
            expression=expression,
            name_expression=name_expression,
            severity_mapping=severity_mapping,
            is_prototype=is_prototype,
            name=name,
            summary_expression=summary_expression,
            tags=tags,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             description_expression: pulumi.Input[str],
             enabled: pulumi.Input[bool],
             entity_selectors: pulumi.Input[Sequence[pulumi.Input['CseMatchRuleEntitySelectorArgs']]],
             expression: pulumi.Input[str],
             name_expression: pulumi.Input[str],
             severity_mapping: pulumi.Input['CseMatchRuleSeverityMappingArgs'],
             is_prototype: Optional[pulumi.Input[bool]] = None,
             name: Optional[pulumi.Input[str]] = None,
             summary_expression: Optional[pulumi.Input[str]] = None,
             tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("description_expression", description_expression)
        _setter("enabled", enabled)
        _setter("entity_selectors", entity_selectors)
        _setter("expression", expression)
        _setter("name_expression", name_expression)
        _setter("severity_mapping", severity_mapping)
        if is_prototype is not None:
            _setter("is_prototype", is_prototype)
        if name is not None:
            _setter("name", name)
        if summary_expression is not None:
            _setter("summary_expression", summary_expression)
        if tags is not None:
            _setter("tags", tags)

    @property
    @pulumi.getter(name="descriptionExpression")
    def description_expression(self) -> pulumi.Input[str]:
        """
        The description of the generated Signals
        """
        return pulumi.get(self, "description_expression")

    @description_expression.setter
    def description_expression(self, value: pulumi.Input[str]):
        pulumi.set(self, "description_expression", value)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        Whether the rule should generate Signals
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="entitySelectors")
    def entity_selectors(self) -> pulumi.Input[Sequence[pulumi.Input['CseMatchRuleEntitySelectorArgs']]]:
        """
        The entities to generate Signals on
        """
        return pulumi.get(self, "entity_selectors")

    @entity_selectors.setter
    def entity_selectors(self, value: pulumi.Input[Sequence[pulumi.Input['CseMatchRuleEntitySelectorArgs']]]):
        pulumi.set(self, "entity_selectors", value)

    @property
    @pulumi.getter
    def expression(self) -> pulumi.Input[str]:
        """
        The expression for which records to match on
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: pulumi.Input[str]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter(name="nameExpression")
    def name_expression(self) -> pulumi.Input[str]:
        """
        The name of the generated Signals
        """
        return pulumi.get(self, "name_expression")

    @name_expression.setter
    def name_expression(self, value: pulumi.Input[str]):
        pulumi.set(self, "name_expression", value)

    @property
    @pulumi.getter(name="severityMapping")
    def severity_mapping(self) -> pulumi.Input['CseMatchRuleSeverityMappingArgs']:
        """
        The configuration of how the severity of the Signals should be mapped from the Records
        """
        return pulumi.get(self, "severity_mapping")

    @severity_mapping.setter
    def severity_mapping(self, value: pulumi.Input['CseMatchRuleSeverityMappingArgs']):
        pulumi.set(self, "severity_mapping", value)

    @property
    @pulumi.getter(name="isPrototype")
    def is_prototype(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the generated Signals should be prototype Signals
        """
        return pulumi.get(self, "is_prototype")

    @is_prototype.setter
    def is_prototype(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_prototype", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Rule
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="summaryExpression")
    def summary_expression(self) -> Optional[pulumi.Input[str]]:
        """
        The summary of the generated Signals
        """
        return pulumi.get(self, "summary_expression")

    @summary_expression.setter
    def summary_expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "summary_expression", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The tags of the generated Signals

        The following attributes are exported:
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _CseMatchRuleState:
    def __init__(__self__, *,
                 description_expression: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 entity_selectors: Optional[pulumi.Input[Sequence[pulumi.Input['CseMatchRuleEntitySelectorArgs']]]] = None,
                 expression: Optional[pulumi.Input[str]] = None,
                 is_prototype: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 name_expression: Optional[pulumi.Input[str]] = None,
                 severity_mapping: Optional[pulumi.Input['CseMatchRuleSeverityMappingArgs']] = None,
                 summary_expression: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering CseMatchRule resources.
        :param pulumi.Input[str] description_expression: The description of the generated Signals
        :param pulumi.Input[bool] enabled: Whether the rule should generate Signals
        :param pulumi.Input[Sequence[pulumi.Input['CseMatchRuleEntitySelectorArgs']]] entity_selectors: The entities to generate Signals on
        :param pulumi.Input[str] expression: The expression for which records to match on
        :param pulumi.Input[bool] is_prototype: Whether the generated Signals should be prototype Signals
        :param pulumi.Input[str] name: The name of the Rule
        :param pulumi.Input[str] name_expression: The name of the generated Signals
        :param pulumi.Input['CseMatchRuleSeverityMappingArgs'] severity_mapping: The configuration of how the severity of the Signals should be mapped from the Records
        :param pulumi.Input[str] summary_expression: The summary of the generated Signals
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The tags of the generated Signals
               
               The following attributes are exported:
        """
        _CseMatchRuleState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            description_expression=description_expression,
            enabled=enabled,
            entity_selectors=entity_selectors,
            expression=expression,
            is_prototype=is_prototype,
            name=name,
            name_expression=name_expression,
            severity_mapping=severity_mapping,
            summary_expression=summary_expression,
            tags=tags,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             description_expression: Optional[pulumi.Input[str]] = None,
             enabled: Optional[pulumi.Input[bool]] = None,
             entity_selectors: Optional[pulumi.Input[Sequence[pulumi.Input['CseMatchRuleEntitySelectorArgs']]]] = None,
             expression: Optional[pulumi.Input[str]] = None,
             is_prototype: Optional[pulumi.Input[bool]] = None,
             name: Optional[pulumi.Input[str]] = None,
             name_expression: Optional[pulumi.Input[str]] = None,
             severity_mapping: Optional[pulumi.Input['CseMatchRuleSeverityMappingArgs']] = None,
             summary_expression: Optional[pulumi.Input[str]] = None,
             tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if description_expression is not None:
            _setter("description_expression", description_expression)
        if enabled is not None:
            _setter("enabled", enabled)
        if entity_selectors is not None:
            _setter("entity_selectors", entity_selectors)
        if expression is not None:
            _setter("expression", expression)
        if is_prototype is not None:
            _setter("is_prototype", is_prototype)
        if name is not None:
            _setter("name", name)
        if name_expression is not None:
            _setter("name_expression", name_expression)
        if severity_mapping is not None:
            _setter("severity_mapping", severity_mapping)
        if summary_expression is not None:
            _setter("summary_expression", summary_expression)
        if tags is not None:
            _setter("tags", tags)

    @property
    @pulumi.getter(name="descriptionExpression")
    def description_expression(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the generated Signals
        """
        return pulumi.get(self, "description_expression")

    @description_expression.setter
    def description_expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description_expression", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the rule should generate Signals
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="entitySelectors")
    def entity_selectors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CseMatchRuleEntitySelectorArgs']]]]:
        """
        The entities to generate Signals on
        """
        return pulumi.get(self, "entity_selectors")

    @entity_selectors.setter
    def entity_selectors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CseMatchRuleEntitySelectorArgs']]]]):
        pulumi.set(self, "entity_selectors", value)

    @property
    @pulumi.getter
    def expression(self) -> Optional[pulumi.Input[str]]:
        """
        The expression for which records to match on
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter(name="isPrototype")
    def is_prototype(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the generated Signals should be prototype Signals
        """
        return pulumi.get(self, "is_prototype")

    @is_prototype.setter
    def is_prototype(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_prototype", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Rule
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nameExpression")
    def name_expression(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the generated Signals
        """
        return pulumi.get(self, "name_expression")

    @name_expression.setter
    def name_expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name_expression", value)

    @property
    @pulumi.getter(name="severityMapping")
    def severity_mapping(self) -> Optional[pulumi.Input['CseMatchRuleSeverityMappingArgs']]:
        """
        The configuration of how the severity of the Signals should be mapped from the Records
        """
        return pulumi.get(self, "severity_mapping")

    @severity_mapping.setter
    def severity_mapping(self, value: Optional[pulumi.Input['CseMatchRuleSeverityMappingArgs']]):
        pulumi.set(self, "severity_mapping", value)

    @property
    @pulumi.getter(name="summaryExpression")
    def summary_expression(self) -> Optional[pulumi.Input[str]]:
        """
        The summary of the generated Signals
        """
        return pulumi.get(self, "summary_expression")

    @summary_expression.setter
    def summary_expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "summary_expression", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The tags of the generated Signals

        The following attributes are exported:
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


class CseMatchRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description_expression: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 entity_selectors: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CseMatchRuleEntitySelectorArgs']]]]] = None,
                 expression: Optional[pulumi.Input[str]] = None,
                 is_prototype: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 name_expression: Optional[pulumi.Input[str]] = None,
                 severity_mapping: Optional[pulumi.Input[pulumi.InputType['CseMatchRuleSeverityMappingArgs']]] = None,
                 summary_expression: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Provides a Sumo Logic CSE [Match Rule](https://help.sumologic.com/Cloud_SIEM_Enterprise/CSE_Rules/03_Write_a_Match_Rule).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sumologic as sumologic

        match_rule = sumologic.CseMatchRule("matchRule",
            description_expression="Signal description",
            enabled=True,
            entity_selectors=[sumologic.CseMatchRuleEntitySelectorArgs(
                entity_type="_ip",
                expression="srcDevice_ip",
            )],
            expression="objectType = \\"Network\\"",
            is_prototype=False,
            name_expression="Signal name",
            severity_mapping=sumologic.CseMatchRuleSeverityMappingArgs(
                default=5,
                type="constant",
            ),
            summary_expression="Signal summary",
            tags=["_mitreAttackTactic:TA0009"])
        ```

        ## Import

        Match Rules can be imported using the field id, e.g.hcl

        ```sh
         $ pulumi import sumologic:index/cseMatchRule:CseMatchRule match_rule id
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description_expression: The description of the generated Signals
        :param pulumi.Input[bool] enabled: Whether the rule should generate Signals
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CseMatchRuleEntitySelectorArgs']]]] entity_selectors: The entities to generate Signals on
        :param pulumi.Input[str] expression: The expression for which records to match on
        :param pulumi.Input[bool] is_prototype: Whether the generated Signals should be prototype Signals
        :param pulumi.Input[str] name: The name of the Rule
        :param pulumi.Input[str] name_expression: The name of the generated Signals
        :param pulumi.Input[pulumi.InputType['CseMatchRuleSeverityMappingArgs']] severity_mapping: The configuration of how the severity of the Signals should be mapped from the Records
        :param pulumi.Input[str] summary_expression: The summary of the generated Signals
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The tags of the generated Signals
               
               The following attributes are exported:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CseMatchRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Sumo Logic CSE [Match Rule](https://help.sumologic.com/Cloud_SIEM_Enterprise/CSE_Rules/03_Write_a_Match_Rule).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sumologic as sumologic

        match_rule = sumologic.CseMatchRule("matchRule",
            description_expression="Signal description",
            enabled=True,
            entity_selectors=[sumologic.CseMatchRuleEntitySelectorArgs(
                entity_type="_ip",
                expression="srcDevice_ip",
            )],
            expression="objectType = \\"Network\\"",
            is_prototype=False,
            name_expression="Signal name",
            severity_mapping=sumologic.CseMatchRuleSeverityMappingArgs(
                default=5,
                type="constant",
            ),
            summary_expression="Signal summary",
            tags=["_mitreAttackTactic:TA0009"])
        ```

        ## Import

        Match Rules can be imported using the field id, e.g.hcl

        ```sh
         $ pulumi import sumologic:index/cseMatchRule:CseMatchRule match_rule id
        ```

        :param str resource_name: The name of the resource.
        :param CseMatchRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CseMatchRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            CseMatchRuleArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description_expression: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 entity_selectors: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CseMatchRuleEntitySelectorArgs']]]]] = None,
                 expression: Optional[pulumi.Input[str]] = None,
                 is_prototype: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 name_expression: Optional[pulumi.Input[str]] = None,
                 severity_mapping: Optional[pulumi.Input[pulumi.InputType['CseMatchRuleSeverityMappingArgs']]] = None,
                 summary_expression: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CseMatchRuleArgs.__new__(CseMatchRuleArgs)

            if description_expression is None and not opts.urn:
                raise TypeError("Missing required property 'description_expression'")
            __props__.__dict__["description_expression"] = description_expression
            if enabled is None and not opts.urn:
                raise TypeError("Missing required property 'enabled'")
            __props__.__dict__["enabled"] = enabled
            if entity_selectors is None and not opts.urn:
                raise TypeError("Missing required property 'entity_selectors'")
            __props__.__dict__["entity_selectors"] = entity_selectors
            if expression is None and not opts.urn:
                raise TypeError("Missing required property 'expression'")
            __props__.__dict__["expression"] = expression
            __props__.__dict__["is_prototype"] = is_prototype
            __props__.__dict__["name"] = name
            if name_expression is None and not opts.urn:
                raise TypeError("Missing required property 'name_expression'")
            __props__.__dict__["name_expression"] = name_expression
            if severity_mapping is not None and not isinstance(severity_mapping, CseMatchRuleSeverityMappingArgs):
                severity_mapping = severity_mapping or {}
                def _setter(key, value):
                    severity_mapping[key] = value
                CseMatchRuleSeverityMappingArgs._configure(_setter, **severity_mapping)
            if severity_mapping is None and not opts.urn:
                raise TypeError("Missing required property 'severity_mapping'")
            __props__.__dict__["severity_mapping"] = severity_mapping
            __props__.__dict__["summary_expression"] = summary_expression
            __props__.__dict__["tags"] = tags
        super(CseMatchRule, __self__).__init__(
            'sumologic:index/cseMatchRule:CseMatchRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description_expression: Optional[pulumi.Input[str]] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            entity_selectors: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CseMatchRuleEntitySelectorArgs']]]]] = None,
            expression: Optional[pulumi.Input[str]] = None,
            is_prototype: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            name_expression: Optional[pulumi.Input[str]] = None,
            severity_mapping: Optional[pulumi.Input[pulumi.InputType['CseMatchRuleSeverityMappingArgs']]] = None,
            summary_expression: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'CseMatchRule':
        """
        Get an existing CseMatchRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description_expression: The description of the generated Signals
        :param pulumi.Input[bool] enabled: Whether the rule should generate Signals
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CseMatchRuleEntitySelectorArgs']]]] entity_selectors: The entities to generate Signals on
        :param pulumi.Input[str] expression: The expression for which records to match on
        :param pulumi.Input[bool] is_prototype: Whether the generated Signals should be prototype Signals
        :param pulumi.Input[str] name: The name of the Rule
        :param pulumi.Input[str] name_expression: The name of the generated Signals
        :param pulumi.Input[pulumi.InputType['CseMatchRuleSeverityMappingArgs']] severity_mapping: The configuration of how the severity of the Signals should be mapped from the Records
        :param pulumi.Input[str] summary_expression: The summary of the generated Signals
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The tags of the generated Signals
               
               The following attributes are exported:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CseMatchRuleState.__new__(_CseMatchRuleState)

        __props__.__dict__["description_expression"] = description_expression
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["entity_selectors"] = entity_selectors
        __props__.__dict__["expression"] = expression
        __props__.__dict__["is_prototype"] = is_prototype
        __props__.__dict__["name"] = name
        __props__.__dict__["name_expression"] = name_expression
        __props__.__dict__["severity_mapping"] = severity_mapping
        __props__.__dict__["summary_expression"] = summary_expression
        __props__.__dict__["tags"] = tags
        return CseMatchRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="descriptionExpression")
    def description_expression(self) -> pulumi.Output[str]:
        """
        The description of the generated Signals
        """
        return pulumi.get(self, "description_expression")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[bool]:
        """
        Whether the rule should generate Signals
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="entitySelectors")
    def entity_selectors(self) -> pulumi.Output[Sequence['outputs.CseMatchRuleEntitySelector']]:
        """
        The entities to generate Signals on
        """
        return pulumi.get(self, "entity_selectors")

    @property
    @pulumi.getter
    def expression(self) -> pulumi.Output[str]:
        """
        The expression for which records to match on
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter(name="isPrototype")
    def is_prototype(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether the generated Signals should be prototype Signals
        """
        return pulumi.get(self, "is_prototype")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the Rule
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nameExpression")
    def name_expression(self) -> pulumi.Output[str]:
        """
        The name of the generated Signals
        """
        return pulumi.get(self, "name_expression")

    @property
    @pulumi.getter(name="severityMapping")
    def severity_mapping(self) -> pulumi.Output['outputs.CseMatchRuleSeverityMapping']:
        """
        The configuration of how the severity of the Signals should be mapped from the Records
        """
        return pulumi.get(self, "severity_mapping")

    @property
    @pulumi.getter(name="summaryExpression")
    def summary_expression(self) -> pulumi.Output[Optional[str]]:
        """
        The summary of the generated Signals
        """
        return pulumi.get(self, "summary_expression")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The tags of the generated Signals

        The following attributes are exported:
        """
        return pulumi.get(self, "tags")

