# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CseOutlierRuleArgs', 'CseOutlierRule']

@pulumi.input_type
class CseOutlierRuleArgs:
    def __init__(__self__, *,
                 aggregation_functions: pulumi.Input['CseOutlierRuleAggregationFunctionsArgs'],
                 baseline_window_size: pulumi.Input[str],
                 description_expression: pulumi.Input[str],
                 deviation_threshold: pulumi.Input[int],
                 enabled: pulumi.Input[bool],
                 entity_selectors: pulumi.Input[Sequence[pulumi.Input['CseOutlierRuleEntitySelectorArgs']]],
                 floor_value: pulumi.Input[int],
                 match_expression: pulumi.Input[str],
                 name_expression: pulumi.Input[str],
                 retention_window_size: pulumi.Input[str],
                 severity: pulumi.Input[int],
                 window_size: pulumi.Input[str],
                 group_by_fields: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 is_prototype: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 summary_expression: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a CseOutlierRule resource.
        :param pulumi.Input[str] baseline_window_size: The baseline window size in milliseconds
        :param pulumi.Input[str] description_expression: The description of the generated Signals
        :param pulumi.Input[int] deviation_threshold: The deviation threshold used to calculate the threshold to trigger signals
        :param pulumi.Input[bool] enabled: Whether the rule should generate Signals
        :param pulumi.Input[Sequence[pulumi.Input['CseOutlierRuleEntitySelectorArgs']]] entity_selectors: The entities to generate Signals on
        :param pulumi.Input[int] floor_value: The minimum threshold to trigger signals
        :param pulumi.Input[str] match_expression: The expression for which records to match on
        :param pulumi.Input[str] name_expression: The name of the generated Signals
        :param pulumi.Input[str] retention_window_size: The retention window size in milliseconds
        :param pulumi.Input[int] severity: The severity of the generated Signals
        :param pulumi.Input[str] window_size: The window size. Current acceptable values are T60M (1 hr) or  T24H (1 day)
               
               The following attributes are exported:
        :param pulumi.Input[Sequence[pulumi.Input[str]]] group_by_fields: A list of fields to group records by
        :param pulumi.Input[bool] is_prototype: Whether the generated Signals should be prototype Signals
        :param pulumi.Input[str] name: The name of the Rule
        :param pulumi.Input[str] summary_expression: The summary of the generated Signals
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The tags of the generated Signals
        """
        CseOutlierRuleArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            aggregation_functions=aggregation_functions,
            baseline_window_size=baseline_window_size,
            description_expression=description_expression,
            deviation_threshold=deviation_threshold,
            enabled=enabled,
            entity_selectors=entity_selectors,
            floor_value=floor_value,
            match_expression=match_expression,
            name_expression=name_expression,
            retention_window_size=retention_window_size,
            severity=severity,
            window_size=window_size,
            group_by_fields=group_by_fields,
            is_prototype=is_prototype,
            name=name,
            summary_expression=summary_expression,
            tags=tags,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             aggregation_functions: pulumi.Input['CseOutlierRuleAggregationFunctionsArgs'],
             baseline_window_size: pulumi.Input[str],
             description_expression: pulumi.Input[str],
             deviation_threshold: pulumi.Input[int],
             enabled: pulumi.Input[bool],
             entity_selectors: pulumi.Input[Sequence[pulumi.Input['CseOutlierRuleEntitySelectorArgs']]],
             floor_value: pulumi.Input[int],
             match_expression: pulumi.Input[str],
             name_expression: pulumi.Input[str],
             retention_window_size: pulumi.Input[str],
             severity: pulumi.Input[int],
             window_size: pulumi.Input[str],
             group_by_fields: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             is_prototype: Optional[pulumi.Input[bool]] = None,
             name: Optional[pulumi.Input[str]] = None,
             summary_expression: Optional[pulumi.Input[str]] = None,
             tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("aggregation_functions", aggregation_functions)
        _setter("baseline_window_size", baseline_window_size)
        _setter("description_expression", description_expression)
        _setter("deviation_threshold", deviation_threshold)
        _setter("enabled", enabled)
        _setter("entity_selectors", entity_selectors)
        _setter("floor_value", floor_value)
        _setter("match_expression", match_expression)
        _setter("name_expression", name_expression)
        _setter("retention_window_size", retention_window_size)
        _setter("severity", severity)
        _setter("window_size", window_size)
        if group_by_fields is not None:
            _setter("group_by_fields", group_by_fields)
        if is_prototype is not None:
            _setter("is_prototype", is_prototype)
        if name is not None:
            _setter("name", name)
        if summary_expression is not None:
            _setter("summary_expression", summary_expression)
        if tags is not None:
            _setter("tags", tags)

    @property
    @pulumi.getter(name="aggregationFunctions")
    def aggregation_functions(self) -> pulumi.Input['CseOutlierRuleAggregationFunctionsArgs']:
        return pulumi.get(self, "aggregation_functions")

    @aggregation_functions.setter
    def aggregation_functions(self, value: pulumi.Input['CseOutlierRuleAggregationFunctionsArgs']):
        pulumi.set(self, "aggregation_functions", value)

    @property
    @pulumi.getter(name="baselineWindowSize")
    def baseline_window_size(self) -> pulumi.Input[str]:
        """
        The baseline window size in milliseconds
        """
        return pulumi.get(self, "baseline_window_size")

    @baseline_window_size.setter
    def baseline_window_size(self, value: pulumi.Input[str]):
        pulumi.set(self, "baseline_window_size", value)

    @property
    @pulumi.getter(name="descriptionExpression")
    def description_expression(self) -> pulumi.Input[str]:
        """
        The description of the generated Signals
        """
        return pulumi.get(self, "description_expression")

    @description_expression.setter
    def description_expression(self, value: pulumi.Input[str]):
        pulumi.set(self, "description_expression", value)

    @property
    @pulumi.getter(name="deviationThreshold")
    def deviation_threshold(self) -> pulumi.Input[int]:
        """
        The deviation threshold used to calculate the threshold to trigger signals
        """
        return pulumi.get(self, "deviation_threshold")

    @deviation_threshold.setter
    def deviation_threshold(self, value: pulumi.Input[int]):
        pulumi.set(self, "deviation_threshold", value)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        Whether the rule should generate Signals
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="entitySelectors")
    def entity_selectors(self) -> pulumi.Input[Sequence[pulumi.Input['CseOutlierRuleEntitySelectorArgs']]]:
        """
        The entities to generate Signals on
        """
        return pulumi.get(self, "entity_selectors")

    @entity_selectors.setter
    def entity_selectors(self, value: pulumi.Input[Sequence[pulumi.Input['CseOutlierRuleEntitySelectorArgs']]]):
        pulumi.set(self, "entity_selectors", value)

    @property
    @pulumi.getter(name="floorValue")
    def floor_value(self) -> pulumi.Input[int]:
        """
        The minimum threshold to trigger signals
        """
        return pulumi.get(self, "floor_value")

    @floor_value.setter
    def floor_value(self, value: pulumi.Input[int]):
        pulumi.set(self, "floor_value", value)

    @property
    @pulumi.getter(name="matchExpression")
    def match_expression(self) -> pulumi.Input[str]:
        """
        The expression for which records to match on
        """
        return pulumi.get(self, "match_expression")

    @match_expression.setter
    def match_expression(self, value: pulumi.Input[str]):
        pulumi.set(self, "match_expression", value)

    @property
    @pulumi.getter(name="nameExpression")
    def name_expression(self) -> pulumi.Input[str]:
        """
        The name of the generated Signals
        """
        return pulumi.get(self, "name_expression")

    @name_expression.setter
    def name_expression(self, value: pulumi.Input[str]):
        pulumi.set(self, "name_expression", value)

    @property
    @pulumi.getter(name="retentionWindowSize")
    def retention_window_size(self) -> pulumi.Input[str]:
        """
        The retention window size in milliseconds
        """
        return pulumi.get(self, "retention_window_size")

    @retention_window_size.setter
    def retention_window_size(self, value: pulumi.Input[str]):
        pulumi.set(self, "retention_window_size", value)

    @property
    @pulumi.getter
    def severity(self) -> pulumi.Input[int]:
        """
        The severity of the generated Signals
        """
        return pulumi.get(self, "severity")

    @severity.setter
    def severity(self, value: pulumi.Input[int]):
        pulumi.set(self, "severity", value)

    @property
    @pulumi.getter(name="windowSize")
    def window_size(self) -> pulumi.Input[str]:
        """
        The window size. Current acceptable values are T60M (1 hr) or  T24H (1 day)

        The following attributes are exported:
        """
        return pulumi.get(self, "window_size")

    @window_size.setter
    def window_size(self, value: pulumi.Input[str]):
        pulumi.set(self, "window_size", value)

    @property
    @pulumi.getter(name="groupByFields")
    def group_by_fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of fields to group records by
        """
        return pulumi.get(self, "group_by_fields")

    @group_by_fields.setter
    def group_by_fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "group_by_fields", value)

    @property
    @pulumi.getter(name="isPrototype")
    def is_prototype(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the generated Signals should be prototype Signals
        """
        return pulumi.get(self, "is_prototype")

    @is_prototype.setter
    def is_prototype(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_prototype", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Rule
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="summaryExpression")
    def summary_expression(self) -> Optional[pulumi.Input[str]]:
        """
        The summary of the generated Signals
        """
        return pulumi.get(self, "summary_expression")

    @summary_expression.setter
    def summary_expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "summary_expression", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The tags of the generated Signals
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _CseOutlierRuleState:
    def __init__(__self__, *,
                 aggregation_functions: Optional[pulumi.Input['CseOutlierRuleAggregationFunctionsArgs']] = None,
                 baseline_window_size: Optional[pulumi.Input[str]] = None,
                 description_expression: Optional[pulumi.Input[str]] = None,
                 deviation_threshold: Optional[pulumi.Input[int]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 entity_selectors: Optional[pulumi.Input[Sequence[pulumi.Input['CseOutlierRuleEntitySelectorArgs']]]] = None,
                 floor_value: Optional[pulumi.Input[int]] = None,
                 group_by_fields: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 is_prototype: Optional[pulumi.Input[bool]] = None,
                 match_expression: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 name_expression: Optional[pulumi.Input[str]] = None,
                 retention_window_size: Optional[pulumi.Input[str]] = None,
                 severity: Optional[pulumi.Input[int]] = None,
                 summary_expression: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 window_size: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering CseOutlierRule resources.
        :param pulumi.Input[str] baseline_window_size: The baseline window size in milliseconds
        :param pulumi.Input[str] description_expression: The description of the generated Signals
        :param pulumi.Input[int] deviation_threshold: The deviation threshold used to calculate the threshold to trigger signals
        :param pulumi.Input[bool] enabled: Whether the rule should generate Signals
        :param pulumi.Input[Sequence[pulumi.Input['CseOutlierRuleEntitySelectorArgs']]] entity_selectors: The entities to generate Signals on
        :param pulumi.Input[int] floor_value: The minimum threshold to trigger signals
        :param pulumi.Input[Sequence[pulumi.Input[str]]] group_by_fields: A list of fields to group records by
        :param pulumi.Input[bool] is_prototype: Whether the generated Signals should be prototype Signals
        :param pulumi.Input[str] match_expression: The expression for which records to match on
        :param pulumi.Input[str] name: The name of the Rule
        :param pulumi.Input[str] name_expression: The name of the generated Signals
        :param pulumi.Input[str] retention_window_size: The retention window size in milliseconds
        :param pulumi.Input[int] severity: The severity of the generated Signals
        :param pulumi.Input[str] summary_expression: The summary of the generated Signals
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The tags of the generated Signals
        :param pulumi.Input[str] window_size: The window size. Current acceptable values are T60M (1 hr) or  T24H (1 day)
               
               The following attributes are exported:
        """
        _CseOutlierRuleState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            aggregation_functions=aggregation_functions,
            baseline_window_size=baseline_window_size,
            description_expression=description_expression,
            deviation_threshold=deviation_threshold,
            enabled=enabled,
            entity_selectors=entity_selectors,
            floor_value=floor_value,
            group_by_fields=group_by_fields,
            is_prototype=is_prototype,
            match_expression=match_expression,
            name=name,
            name_expression=name_expression,
            retention_window_size=retention_window_size,
            severity=severity,
            summary_expression=summary_expression,
            tags=tags,
            window_size=window_size,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             aggregation_functions: Optional[pulumi.Input['CseOutlierRuleAggregationFunctionsArgs']] = None,
             baseline_window_size: Optional[pulumi.Input[str]] = None,
             description_expression: Optional[pulumi.Input[str]] = None,
             deviation_threshold: Optional[pulumi.Input[int]] = None,
             enabled: Optional[pulumi.Input[bool]] = None,
             entity_selectors: Optional[pulumi.Input[Sequence[pulumi.Input['CseOutlierRuleEntitySelectorArgs']]]] = None,
             floor_value: Optional[pulumi.Input[int]] = None,
             group_by_fields: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             is_prototype: Optional[pulumi.Input[bool]] = None,
             match_expression: Optional[pulumi.Input[str]] = None,
             name: Optional[pulumi.Input[str]] = None,
             name_expression: Optional[pulumi.Input[str]] = None,
             retention_window_size: Optional[pulumi.Input[str]] = None,
             severity: Optional[pulumi.Input[int]] = None,
             summary_expression: Optional[pulumi.Input[str]] = None,
             tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             window_size: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if aggregation_functions is not None:
            _setter("aggregation_functions", aggregation_functions)
        if baseline_window_size is not None:
            _setter("baseline_window_size", baseline_window_size)
        if description_expression is not None:
            _setter("description_expression", description_expression)
        if deviation_threshold is not None:
            _setter("deviation_threshold", deviation_threshold)
        if enabled is not None:
            _setter("enabled", enabled)
        if entity_selectors is not None:
            _setter("entity_selectors", entity_selectors)
        if floor_value is not None:
            _setter("floor_value", floor_value)
        if group_by_fields is not None:
            _setter("group_by_fields", group_by_fields)
        if is_prototype is not None:
            _setter("is_prototype", is_prototype)
        if match_expression is not None:
            _setter("match_expression", match_expression)
        if name is not None:
            _setter("name", name)
        if name_expression is not None:
            _setter("name_expression", name_expression)
        if retention_window_size is not None:
            _setter("retention_window_size", retention_window_size)
        if severity is not None:
            _setter("severity", severity)
        if summary_expression is not None:
            _setter("summary_expression", summary_expression)
        if tags is not None:
            _setter("tags", tags)
        if window_size is not None:
            _setter("window_size", window_size)

    @property
    @pulumi.getter(name="aggregationFunctions")
    def aggregation_functions(self) -> Optional[pulumi.Input['CseOutlierRuleAggregationFunctionsArgs']]:
        return pulumi.get(self, "aggregation_functions")

    @aggregation_functions.setter
    def aggregation_functions(self, value: Optional[pulumi.Input['CseOutlierRuleAggregationFunctionsArgs']]):
        pulumi.set(self, "aggregation_functions", value)

    @property
    @pulumi.getter(name="baselineWindowSize")
    def baseline_window_size(self) -> Optional[pulumi.Input[str]]:
        """
        The baseline window size in milliseconds
        """
        return pulumi.get(self, "baseline_window_size")

    @baseline_window_size.setter
    def baseline_window_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "baseline_window_size", value)

    @property
    @pulumi.getter(name="descriptionExpression")
    def description_expression(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the generated Signals
        """
        return pulumi.get(self, "description_expression")

    @description_expression.setter
    def description_expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description_expression", value)

    @property
    @pulumi.getter(name="deviationThreshold")
    def deviation_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        The deviation threshold used to calculate the threshold to trigger signals
        """
        return pulumi.get(self, "deviation_threshold")

    @deviation_threshold.setter
    def deviation_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "deviation_threshold", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the rule should generate Signals
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="entitySelectors")
    def entity_selectors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CseOutlierRuleEntitySelectorArgs']]]]:
        """
        The entities to generate Signals on
        """
        return pulumi.get(self, "entity_selectors")

    @entity_selectors.setter
    def entity_selectors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CseOutlierRuleEntitySelectorArgs']]]]):
        pulumi.set(self, "entity_selectors", value)

    @property
    @pulumi.getter(name="floorValue")
    def floor_value(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum threshold to trigger signals
        """
        return pulumi.get(self, "floor_value")

    @floor_value.setter
    def floor_value(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "floor_value", value)

    @property
    @pulumi.getter(name="groupByFields")
    def group_by_fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of fields to group records by
        """
        return pulumi.get(self, "group_by_fields")

    @group_by_fields.setter
    def group_by_fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "group_by_fields", value)

    @property
    @pulumi.getter(name="isPrototype")
    def is_prototype(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the generated Signals should be prototype Signals
        """
        return pulumi.get(self, "is_prototype")

    @is_prototype.setter
    def is_prototype(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_prototype", value)

    @property
    @pulumi.getter(name="matchExpression")
    def match_expression(self) -> Optional[pulumi.Input[str]]:
        """
        The expression for which records to match on
        """
        return pulumi.get(self, "match_expression")

    @match_expression.setter
    def match_expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "match_expression", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Rule
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nameExpression")
    def name_expression(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the generated Signals
        """
        return pulumi.get(self, "name_expression")

    @name_expression.setter
    def name_expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name_expression", value)

    @property
    @pulumi.getter(name="retentionWindowSize")
    def retention_window_size(self) -> Optional[pulumi.Input[str]]:
        """
        The retention window size in milliseconds
        """
        return pulumi.get(self, "retention_window_size")

    @retention_window_size.setter
    def retention_window_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "retention_window_size", value)

    @property
    @pulumi.getter
    def severity(self) -> Optional[pulumi.Input[int]]:
        """
        The severity of the generated Signals
        """
        return pulumi.get(self, "severity")

    @severity.setter
    def severity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "severity", value)

    @property
    @pulumi.getter(name="summaryExpression")
    def summary_expression(self) -> Optional[pulumi.Input[str]]:
        """
        The summary of the generated Signals
        """
        return pulumi.get(self, "summary_expression")

    @summary_expression.setter
    def summary_expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "summary_expression", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The tags of the generated Signals
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="windowSize")
    def window_size(self) -> Optional[pulumi.Input[str]]:
        """
        The window size. Current acceptable values are T60M (1 hr) or  T24H (1 day)

        The following attributes are exported:
        """
        return pulumi.get(self, "window_size")

    @window_size.setter
    def window_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "window_size", value)


class CseOutlierRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aggregation_functions: Optional[pulumi.Input[pulumi.InputType['CseOutlierRuleAggregationFunctionsArgs']]] = None,
                 baseline_window_size: Optional[pulumi.Input[str]] = None,
                 description_expression: Optional[pulumi.Input[str]] = None,
                 deviation_threshold: Optional[pulumi.Input[int]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 entity_selectors: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CseOutlierRuleEntitySelectorArgs']]]]] = None,
                 floor_value: Optional[pulumi.Input[int]] = None,
                 group_by_fields: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 is_prototype: Optional[pulumi.Input[bool]] = None,
                 match_expression: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 name_expression: Optional[pulumi.Input[str]] = None,
                 retention_window_size: Optional[pulumi.Input[str]] = None,
                 severity: Optional[pulumi.Input[int]] = None,
                 summary_expression: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 window_size: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## ___

        layout: "sumologic"
        page_title: "SumoLogic: CseOutlierRule"
        description: |-
          Provides a CSE Outlier Rule
        ---

        # CseOutlierRule
        Provides a Sumo Logic CSE [Outlier Rule](https://help.sumologic.com/docs/cse/rules/write-outlier-rule/).

        ## Import

        Outlier rules can be imported using the field id, e.g.hcl

        ```sh
         $ pulumi import sumologic:index/cseOutlierRule:CseOutlierRule outlier_rule id
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] baseline_window_size: The baseline window size in milliseconds
        :param pulumi.Input[str] description_expression: The description of the generated Signals
        :param pulumi.Input[int] deviation_threshold: The deviation threshold used to calculate the threshold to trigger signals
        :param pulumi.Input[bool] enabled: Whether the rule should generate Signals
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CseOutlierRuleEntitySelectorArgs']]]] entity_selectors: The entities to generate Signals on
        :param pulumi.Input[int] floor_value: The minimum threshold to trigger signals
        :param pulumi.Input[Sequence[pulumi.Input[str]]] group_by_fields: A list of fields to group records by
        :param pulumi.Input[bool] is_prototype: Whether the generated Signals should be prototype Signals
        :param pulumi.Input[str] match_expression: The expression for which records to match on
        :param pulumi.Input[str] name: The name of the Rule
        :param pulumi.Input[str] name_expression: The name of the generated Signals
        :param pulumi.Input[str] retention_window_size: The retention window size in milliseconds
        :param pulumi.Input[int] severity: The severity of the generated Signals
        :param pulumi.Input[str] summary_expression: The summary of the generated Signals
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The tags of the generated Signals
        :param pulumi.Input[str] window_size: The window size. Current acceptable values are T60M (1 hr) or  T24H (1 day)
               
               The following attributes are exported:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CseOutlierRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## ___

        layout: "sumologic"
        page_title: "SumoLogic: CseOutlierRule"
        description: |-
          Provides a CSE Outlier Rule
        ---

        # CseOutlierRule
        Provides a Sumo Logic CSE [Outlier Rule](https://help.sumologic.com/docs/cse/rules/write-outlier-rule/).

        ## Import

        Outlier rules can be imported using the field id, e.g.hcl

        ```sh
         $ pulumi import sumologic:index/cseOutlierRule:CseOutlierRule outlier_rule id
        ```

        :param str resource_name: The name of the resource.
        :param CseOutlierRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CseOutlierRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            CseOutlierRuleArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aggregation_functions: Optional[pulumi.Input[pulumi.InputType['CseOutlierRuleAggregationFunctionsArgs']]] = None,
                 baseline_window_size: Optional[pulumi.Input[str]] = None,
                 description_expression: Optional[pulumi.Input[str]] = None,
                 deviation_threshold: Optional[pulumi.Input[int]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 entity_selectors: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CseOutlierRuleEntitySelectorArgs']]]]] = None,
                 floor_value: Optional[pulumi.Input[int]] = None,
                 group_by_fields: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 is_prototype: Optional[pulumi.Input[bool]] = None,
                 match_expression: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 name_expression: Optional[pulumi.Input[str]] = None,
                 retention_window_size: Optional[pulumi.Input[str]] = None,
                 severity: Optional[pulumi.Input[int]] = None,
                 summary_expression: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 window_size: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CseOutlierRuleArgs.__new__(CseOutlierRuleArgs)

            if aggregation_functions is not None and not isinstance(aggregation_functions, CseOutlierRuleAggregationFunctionsArgs):
                aggregation_functions = aggregation_functions or {}
                def _setter(key, value):
                    aggregation_functions[key] = value
                CseOutlierRuleAggregationFunctionsArgs._configure(_setter, **aggregation_functions)
            if aggregation_functions is None and not opts.urn:
                raise TypeError("Missing required property 'aggregation_functions'")
            __props__.__dict__["aggregation_functions"] = aggregation_functions
            if baseline_window_size is None and not opts.urn:
                raise TypeError("Missing required property 'baseline_window_size'")
            __props__.__dict__["baseline_window_size"] = baseline_window_size
            if description_expression is None and not opts.urn:
                raise TypeError("Missing required property 'description_expression'")
            __props__.__dict__["description_expression"] = description_expression
            if deviation_threshold is None and not opts.urn:
                raise TypeError("Missing required property 'deviation_threshold'")
            __props__.__dict__["deviation_threshold"] = deviation_threshold
            if enabled is None and not opts.urn:
                raise TypeError("Missing required property 'enabled'")
            __props__.__dict__["enabled"] = enabled
            if entity_selectors is None and not opts.urn:
                raise TypeError("Missing required property 'entity_selectors'")
            __props__.__dict__["entity_selectors"] = entity_selectors
            if floor_value is None and not opts.urn:
                raise TypeError("Missing required property 'floor_value'")
            __props__.__dict__["floor_value"] = floor_value
            __props__.__dict__["group_by_fields"] = group_by_fields
            __props__.__dict__["is_prototype"] = is_prototype
            if match_expression is None and not opts.urn:
                raise TypeError("Missing required property 'match_expression'")
            __props__.__dict__["match_expression"] = match_expression
            __props__.__dict__["name"] = name
            if name_expression is None and not opts.urn:
                raise TypeError("Missing required property 'name_expression'")
            __props__.__dict__["name_expression"] = name_expression
            if retention_window_size is None and not opts.urn:
                raise TypeError("Missing required property 'retention_window_size'")
            __props__.__dict__["retention_window_size"] = retention_window_size
            if severity is None and not opts.urn:
                raise TypeError("Missing required property 'severity'")
            __props__.__dict__["severity"] = severity
            __props__.__dict__["summary_expression"] = summary_expression
            __props__.__dict__["tags"] = tags
            if window_size is None and not opts.urn:
                raise TypeError("Missing required property 'window_size'")
            __props__.__dict__["window_size"] = window_size
        super(CseOutlierRule, __self__).__init__(
            'sumologic:index/cseOutlierRule:CseOutlierRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            aggregation_functions: Optional[pulumi.Input[pulumi.InputType['CseOutlierRuleAggregationFunctionsArgs']]] = None,
            baseline_window_size: Optional[pulumi.Input[str]] = None,
            description_expression: Optional[pulumi.Input[str]] = None,
            deviation_threshold: Optional[pulumi.Input[int]] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            entity_selectors: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CseOutlierRuleEntitySelectorArgs']]]]] = None,
            floor_value: Optional[pulumi.Input[int]] = None,
            group_by_fields: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            is_prototype: Optional[pulumi.Input[bool]] = None,
            match_expression: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            name_expression: Optional[pulumi.Input[str]] = None,
            retention_window_size: Optional[pulumi.Input[str]] = None,
            severity: Optional[pulumi.Input[int]] = None,
            summary_expression: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            window_size: Optional[pulumi.Input[str]] = None) -> 'CseOutlierRule':
        """
        Get an existing CseOutlierRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] baseline_window_size: The baseline window size in milliseconds
        :param pulumi.Input[str] description_expression: The description of the generated Signals
        :param pulumi.Input[int] deviation_threshold: The deviation threshold used to calculate the threshold to trigger signals
        :param pulumi.Input[bool] enabled: Whether the rule should generate Signals
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CseOutlierRuleEntitySelectorArgs']]]] entity_selectors: The entities to generate Signals on
        :param pulumi.Input[int] floor_value: The minimum threshold to trigger signals
        :param pulumi.Input[Sequence[pulumi.Input[str]]] group_by_fields: A list of fields to group records by
        :param pulumi.Input[bool] is_prototype: Whether the generated Signals should be prototype Signals
        :param pulumi.Input[str] match_expression: The expression for which records to match on
        :param pulumi.Input[str] name: The name of the Rule
        :param pulumi.Input[str] name_expression: The name of the generated Signals
        :param pulumi.Input[str] retention_window_size: The retention window size in milliseconds
        :param pulumi.Input[int] severity: The severity of the generated Signals
        :param pulumi.Input[str] summary_expression: The summary of the generated Signals
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The tags of the generated Signals
        :param pulumi.Input[str] window_size: The window size. Current acceptable values are T60M (1 hr) or  T24H (1 day)
               
               The following attributes are exported:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CseOutlierRuleState.__new__(_CseOutlierRuleState)

        __props__.__dict__["aggregation_functions"] = aggregation_functions
        __props__.__dict__["baseline_window_size"] = baseline_window_size
        __props__.__dict__["description_expression"] = description_expression
        __props__.__dict__["deviation_threshold"] = deviation_threshold
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["entity_selectors"] = entity_selectors
        __props__.__dict__["floor_value"] = floor_value
        __props__.__dict__["group_by_fields"] = group_by_fields
        __props__.__dict__["is_prototype"] = is_prototype
        __props__.__dict__["match_expression"] = match_expression
        __props__.__dict__["name"] = name
        __props__.__dict__["name_expression"] = name_expression
        __props__.__dict__["retention_window_size"] = retention_window_size
        __props__.__dict__["severity"] = severity
        __props__.__dict__["summary_expression"] = summary_expression
        __props__.__dict__["tags"] = tags
        __props__.__dict__["window_size"] = window_size
        return CseOutlierRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="aggregationFunctions")
    def aggregation_functions(self) -> pulumi.Output['outputs.CseOutlierRuleAggregationFunctions']:
        return pulumi.get(self, "aggregation_functions")

    @property
    @pulumi.getter(name="baselineWindowSize")
    def baseline_window_size(self) -> pulumi.Output[str]:
        """
        The baseline window size in milliseconds
        """
        return pulumi.get(self, "baseline_window_size")

    @property
    @pulumi.getter(name="descriptionExpression")
    def description_expression(self) -> pulumi.Output[str]:
        """
        The description of the generated Signals
        """
        return pulumi.get(self, "description_expression")

    @property
    @pulumi.getter(name="deviationThreshold")
    def deviation_threshold(self) -> pulumi.Output[int]:
        """
        The deviation threshold used to calculate the threshold to trigger signals
        """
        return pulumi.get(self, "deviation_threshold")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[bool]:
        """
        Whether the rule should generate Signals
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="entitySelectors")
    def entity_selectors(self) -> pulumi.Output[Sequence['outputs.CseOutlierRuleEntitySelector']]:
        """
        The entities to generate Signals on
        """
        return pulumi.get(self, "entity_selectors")

    @property
    @pulumi.getter(name="floorValue")
    def floor_value(self) -> pulumi.Output[int]:
        """
        The minimum threshold to trigger signals
        """
        return pulumi.get(self, "floor_value")

    @property
    @pulumi.getter(name="groupByFields")
    def group_by_fields(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of fields to group records by
        """
        return pulumi.get(self, "group_by_fields")

    @property
    @pulumi.getter(name="isPrototype")
    def is_prototype(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether the generated Signals should be prototype Signals
        """
        return pulumi.get(self, "is_prototype")

    @property
    @pulumi.getter(name="matchExpression")
    def match_expression(self) -> pulumi.Output[str]:
        """
        The expression for which records to match on
        """
        return pulumi.get(self, "match_expression")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the Rule
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nameExpression")
    def name_expression(self) -> pulumi.Output[str]:
        """
        The name of the generated Signals
        """
        return pulumi.get(self, "name_expression")

    @property
    @pulumi.getter(name="retentionWindowSize")
    def retention_window_size(self) -> pulumi.Output[str]:
        """
        The retention window size in milliseconds
        """
        return pulumi.get(self, "retention_window_size")

    @property
    @pulumi.getter
    def severity(self) -> pulumi.Output[int]:
        """
        The severity of the generated Signals
        """
        return pulumi.get(self, "severity")

    @property
    @pulumi.getter(name="summaryExpression")
    def summary_expression(self) -> pulumi.Output[Optional[str]]:
        """
        The summary of the generated Signals
        """
        return pulumi.get(self, "summary_expression")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The tags of the generated Signals
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="windowSize")
    def window_size(self) -> pulumi.Output[str]:
        """
        The window size. Current acceptable values are T60M (1 hr) or  T24H (1 day)

        The following attributes are exported:
        """
        return pulumi.get(self, "window_size")

