# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CseTagSchemaArgs', 'CseTagSchema']

@pulumi.input_type
class CseTagSchemaArgs:
    def __init__(__self__, *,
                 free_form: pulumi.Input[bool],
                 key: pulumi.Input[str],
                 label: pulumi.Input[str],
                 content_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 value_options: Optional[pulumi.Input[Sequence[pulumi.Input['CseTagSchemaValueOptionArgs']]]] = None):
        """
        The set of arguments for constructing a CseTagSchema resource.
        :param pulumi.Input[bool] free_form: Whether the tag schema accepts free form custom values.
        :param pulumi.Input[str] key: Tag Schema key.
        :param pulumi.Input[str] label: Value option label.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] content_types: Applicable content types. Valid values: "customInsight", "entity", "rule", "threatIntelligence".
        """
        CseTagSchemaArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            free_form=free_form,
            key=key,
            label=label,
            content_types=content_types,
            value_options=value_options,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             free_form: pulumi.Input[bool],
             key: pulumi.Input[str],
             label: pulumi.Input[str],
             content_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             value_options: Optional[pulumi.Input[Sequence[pulumi.Input['CseTagSchemaValueOptionArgs']]]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("free_form", free_form)
        _setter("key", key)
        _setter("label", label)
        if content_types is not None:
            _setter("content_types", content_types)
        if value_options is not None:
            _setter("value_options", value_options)

    @property
    @pulumi.getter(name="freeForm")
    def free_form(self) -> pulumi.Input[bool]:
        """
        Whether the tag schema accepts free form custom values.
        """
        return pulumi.get(self, "free_form")

    @free_form.setter
    def free_form(self, value: pulumi.Input[bool]):
        pulumi.set(self, "free_form", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        Tag Schema key.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def label(self) -> pulumi.Input[str]:
        """
        Value option label.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: pulumi.Input[str]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter(name="contentTypes")
    def content_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Applicable content types. Valid values: "customInsight", "entity", "rule", "threatIntelligence".
        """
        return pulumi.get(self, "content_types")

    @content_types.setter
    def content_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "content_types", value)

    @property
    @pulumi.getter(name="valueOptions")
    def value_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CseTagSchemaValueOptionArgs']]]]:
        return pulumi.get(self, "value_options")

    @value_options.setter
    def value_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CseTagSchemaValueOptionArgs']]]]):
        pulumi.set(self, "value_options", value)


@pulumi.input_type
class _CseTagSchemaState:
    def __init__(__self__, *,
                 content_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 free_form: Optional[pulumi.Input[bool]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 value_options: Optional[pulumi.Input[Sequence[pulumi.Input['CseTagSchemaValueOptionArgs']]]] = None):
        """
        Input properties used for looking up and filtering CseTagSchema resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] content_types: Applicable content types. Valid values: "customInsight", "entity", "rule", "threatIntelligence".
        :param pulumi.Input[bool] free_form: Whether the tag schema accepts free form custom values.
        :param pulumi.Input[str] key: Tag Schema key.
        :param pulumi.Input[str] label: Value option label.
        """
        _CseTagSchemaState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            content_types=content_types,
            free_form=free_form,
            key=key,
            label=label,
            value_options=value_options,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             content_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             free_form: Optional[pulumi.Input[bool]] = None,
             key: Optional[pulumi.Input[str]] = None,
             label: Optional[pulumi.Input[str]] = None,
             value_options: Optional[pulumi.Input[Sequence[pulumi.Input['CseTagSchemaValueOptionArgs']]]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if content_types is not None:
            _setter("content_types", content_types)
        if free_form is not None:
            _setter("free_form", free_form)
        if key is not None:
            _setter("key", key)
        if label is not None:
            _setter("label", label)
        if value_options is not None:
            _setter("value_options", value_options)

    @property
    @pulumi.getter(name="contentTypes")
    def content_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Applicable content types. Valid values: "customInsight", "entity", "rule", "threatIntelligence".
        """
        return pulumi.get(self, "content_types")

    @content_types.setter
    def content_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "content_types", value)

    @property
    @pulumi.getter(name="freeForm")
    def free_form(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the tag schema accepts free form custom values.
        """
        return pulumi.get(self, "free_form")

    @free_form.setter
    def free_form(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "free_form", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        Tag Schema key.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[str]]:
        """
        Value option label.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter(name="valueOptions")
    def value_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CseTagSchemaValueOptionArgs']]]]:
        return pulumi.get(self, "value_options")

    @value_options.setter
    def value_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CseTagSchemaValueOptionArgs']]]]):
        pulumi.set(self, "value_options", value)


class CseTagSchema(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 content_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 free_form: Optional[pulumi.Input[bool]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 value_options: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CseTagSchemaValueOptionArgs']]]]] = None,
                 __props__=None):
        """
        Provides a Sumologic CSE Tag Schema.

        ## Import

        Tag Schema can be imported using the field id, e.g.hcl

        ```sh
         $ pulumi import sumologic:index/cseTagSchema:CseTagSchema tag_schema id
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] content_types: Applicable content types. Valid values: "customInsight", "entity", "rule", "threatIntelligence".
        :param pulumi.Input[bool] free_form: Whether the tag schema accepts free form custom values.
        :param pulumi.Input[str] key: Tag Schema key.
        :param pulumi.Input[str] label: Value option label.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CseTagSchemaArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Sumologic CSE Tag Schema.

        ## Import

        Tag Schema can be imported using the field id, e.g.hcl

        ```sh
         $ pulumi import sumologic:index/cseTagSchema:CseTagSchema tag_schema id
        ```

        :param str resource_name: The name of the resource.
        :param CseTagSchemaArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CseTagSchemaArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            CseTagSchemaArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 content_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 free_form: Optional[pulumi.Input[bool]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 label: Optional[pulumi.Input[str]] = None,
                 value_options: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CseTagSchemaValueOptionArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CseTagSchemaArgs.__new__(CseTagSchemaArgs)

            __props__.__dict__["content_types"] = content_types
            if free_form is None and not opts.urn:
                raise TypeError("Missing required property 'free_form'")
            __props__.__dict__["free_form"] = free_form
            if key is None and not opts.urn:
                raise TypeError("Missing required property 'key'")
            __props__.__dict__["key"] = key
            if label is None and not opts.urn:
                raise TypeError("Missing required property 'label'")
            __props__.__dict__["label"] = label
            __props__.__dict__["value_options"] = value_options
        super(CseTagSchema, __self__).__init__(
            'sumologic:index/cseTagSchema:CseTagSchema',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            content_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            free_form: Optional[pulumi.Input[bool]] = None,
            key: Optional[pulumi.Input[str]] = None,
            label: Optional[pulumi.Input[str]] = None,
            value_options: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CseTagSchemaValueOptionArgs']]]]] = None) -> 'CseTagSchema':
        """
        Get an existing CseTagSchema resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] content_types: Applicable content types. Valid values: "customInsight", "entity", "rule", "threatIntelligence".
        :param pulumi.Input[bool] free_form: Whether the tag schema accepts free form custom values.
        :param pulumi.Input[str] key: Tag Schema key.
        :param pulumi.Input[str] label: Value option label.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CseTagSchemaState.__new__(_CseTagSchemaState)

        __props__.__dict__["content_types"] = content_types
        __props__.__dict__["free_form"] = free_form
        __props__.__dict__["key"] = key
        __props__.__dict__["label"] = label
        __props__.__dict__["value_options"] = value_options
        return CseTagSchema(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="contentTypes")
    def content_types(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Applicable content types. Valid values: "customInsight", "entity", "rule", "threatIntelligence".
        """
        return pulumi.get(self, "content_types")

    @property
    @pulumi.getter(name="freeForm")
    def free_form(self) -> pulumi.Output[bool]:
        """
        Whether the tag schema accepts free form custom values.
        """
        return pulumi.get(self, "free_form")

    @property
    @pulumi.getter
    def key(self) -> pulumi.Output[str]:
        """
        Tag Schema key.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def label(self) -> pulumi.Output[str]:
        """
        Value option label.
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter(name="valueOptions")
    def value_options(self) -> pulumi.Output[Optional[Sequence['outputs.CseTagSchemaValueOption']]]:
        return pulumi.get(self, "value_options")

