# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CseThresholdRuleArgs', 'CseThresholdRule']

@pulumi.input_type
class CseThresholdRuleArgs:
    def __init__(__self__, *,
                 description: pulumi.Input[str],
                 enabled: pulumi.Input[bool],
                 entity_selectors: pulumi.Input[Sequence[pulumi.Input['CseThresholdRuleEntitySelectorArgs']]],
                 expression: pulumi.Input[str],
                 limit: pulumi.Input[int],
                 severity: pulumi.Input[int],
                 window_size: pulumi.Input[str],
                 count_distinct: Optional[pulumi.Input[bool]] = None,
                 count_field: Optional[pulumi.Input[str]] = None,
                 group_by_fields: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 is_prototype: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 summary_expression: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a CseThresholdRule resource.
        :param pulumi.Input[str] description: The description of the generated Signals
        :param pulumi.Input[bool] enabled: Whether the rule should generate Signals
        :param pulumi.Input[Sequence[pulumi.Input['CseThresholdRuleEntitySelectorArgs']]] entity_selectors: The entities to generate Signals on
        :param pulumi.Input[str] expression: The expression for which records to match on
        :param pulumi.Input[int] limit: A Signal will be fired when this many records/distinct field values are matched
        :param pulumi.Input[int] severity: The severity of the generated Signals
        :param pulumi.Input[str] window_size: How long of a window to aggregate records for. Current acceptable values are T05M, T10M, T30M, T60M, T24H, T12H, or T05D.
               
               The following attributes are exported:
        :param pulumi.Input[bool] count_distinct: Whether to count distinct values of a field, as opposed to just counting the number of records
        :param pulumi.Input[str] count_field: The field to count if `count_distinct` is set to true
        :param pulumi.Input[Sequence[pulumi.Input[str]]] group_by_fields: A list of fields to group records by
        :param pulumi.Input[bool] is_prototype: Whether the generated Signals should be prototype Signals
        :param pulumi.Input[str] name: The name of the Rule and the generated Signals
        :param pulumi.Input[str] summary_expression: The summary of the generated Signals
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The tags of the generated Signals
        """
        CseThresholdRuleArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            description=description,
            enabled=enabled,
            entity_selectors=entity_selectors,
            expression=expression,
            limit=limit,
            severity=severity,
            window_size=window_size,
            count_distinct=count_distinct,
            count_field=count_field,
            group_by_fields=group_by_fields,
            is_prototype=is_prototype,
            name=name,
            summary_expression=summary_expression,
            tags=tags,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             description: pulumi.Input[str],
             enabled: pulumi.Input[bool],
             entity_selectors: pulumi.Input[Sequence[pulumi.Input['CseThresholdRuleEntitySelectorArgs']]],
             expression: pulumi.Input[str],
             limit: pulumi.Input[int],
             severity: pulumi.Input[int],
             window_size: pulumi.Input[str],
             count_distinct: Optional[pulumi.Input[bool]] = None,
             count_field: Optional[pulumi.Input[str]] = None,
             group_by_fields: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             is_prototype: Optional[pulumi.Input[bool]] = None,
             name: Optional[pulumi.Input[str]] = None,
             summary_expression: Optional[pulumi.Input[str]] = None,
             tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("description", description)
        _setter("enabled", enabled)
        _setter("entity_selectors", entity_selectors)
        _setter("expression", expression)
        _setter("limit", limit)
        _setter("severity", severity)
        _setter("window_size", window_size)
        if count_distinct is not None:
            _setter("count_distinct", count_distinct)
        if count_field is not None:
            _setter("count_field", count_field)
        if group_by_fields is not None:
            _setter("group_by_fields", group_by_fields)
        if is_prototype is not None:
            _setter("is_prototype", is_prototype)
        if name is not None:
            _setter("name", name)
        if summary_expression is not None:
            _setter("summary_expression", summary_expression)
        if tags is not None:
            _setter("tags", tags)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[str]:
        """
        The description of the generated Signals
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        Whether the rule should generate Signals
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="entitySelectors")
    def entity_selectors(self) -> pulumi.Input[Sequence[pulumi.Input['CseThresholdRuleEntitySelectorArgs']]]:
        """
        The entities to generate Signals on
        """
        return pulumi.get(self, "entity_selectors")

    @entity_selectors.setter
    def entity_selectors(self, value: pulumi.Input[Sequence[pulumi.Input['CseThresholdRuleEntitySelectorArgs']]]):
        pulumi.set(self, "entity_selectors", value)

    @property
    @pulumi.getter
    def expression(self) -> pulumi.Input[str]:
        """
        The expression for which records to match on
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: pulumi.Input[str]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def limit(self) -> pulumi.Input[int]:
        """
        A Signal will be fired when this many records/distinct field values are matched
        """
        return pulumi.get(self, "limit")

    @limit.setter
    def limit(self, value: pulumi.Input[int]):
        pulumi.set(self, "limit", value)

    @property
    @pulumi.getter
    def severity(self) -> pulumi.Input[int]:
        """
        The severity of the generated Signals
        """
        return pulumi.get(self, "severity")

    @severity.setter
    def severity(self, value: pulumi.Input[int]):
        pulumi.set(self, "severity", value)

    @property
    @pulumi.getter(name="windowSize")
    def window_size(self) -> pulumi.Input[str]:
        """
        How long of a window to aggregate records for. Current acceptable values are T05M, T10M, T30M, T60M, T24H, T12H, or T05D.

        The following attributes are exported:
        """
        return pulumi.get(self, "window_size")

    @window_size.setter
    def window_size(self, value: pulumi.Input[str]):
        pulumi.set(self, "window_size", value)

    @property
    @pulumi.getter(name="countDistinct")
    def count_distinct(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to count distinct values of a field, as opposed to just counting the number of records
        """
        return pulumi.get(self, "count_distinct")

    @count_distinct.setter
    def count_distinct(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "count_distinct", value)

    @property
    @pulumi.getter(name="countField")
    def count_field(self) -> Optional[pulumi.Input[str]]:
        """
        The field to count if `count_distinct` is set to true
        """
        return pulumi.get(self, "count_field")

    @count_field.setter
    def count_field(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "count_field", value)

    @property
    @pulumi.getter(name="groupByFields")
    def group_by_fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of fields to group records by
        """
        return pulumi.get(self, "group_by_fields")

    @group_by_fields.setter
    def group_by_fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "group_by_fields", value)

    @property
    @pulumi.getter(name="isPrototype")
    def is_prototype(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the generated Signals should be prototype Signals
        """
        return pulumi.get(self, "is_prototype")

    @is_prototype.setter
    def is_prototype(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_prototype", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Rule and the generated Signals
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="summaryExpression")
    def summary_expression(self) -> Optional[pulumi.Input[str]]:
        """
        The summary of the generated Signals
        """
        return pulumi.get(self, "summary_expression")

    @summary_expression.setter
    def summary_expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "summary_expression", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The tags of the generated Signals
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _CseThresholdRuleState:
    def __init__(__self__, *,
                 count_distinct: Optional[pulumi.Input[bool]] = None,
                 count_field: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 entity_selectors: Optional[pulumi.Input[Sequence[pulumi.Input['CseThresholdRuleEntitySelectorArgs']]]] = None,
                 expression: Optional[pulumi.Input[str]] = None,
                 group_by_fields: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 is_prototype: Optional[pulumi.Input[bool]] = None,
                 limit: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 severity: Optional[pulumi.Input[int]] = None,
                 summary_expression: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 window_size: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering CseThresholdRule resources.
        :param pulumi.Input[bool] count_distinct: Whether to count distinct values of a field, as opposed to just counting the number of records
        :param pulumi.Input[str] count_field: The field to count if `count_distinct` is set to true
        :param pulumi.Input[str] description: The description of the generated Signals
        :param pulumi.Input[bool] enabled: Whether the rule should generate Signals
        :param pulumi.Input[Sequence[pulumi.Input['CseThresholdRuleEntitySelectorArgs']]] entity_selectors: The entities to generate Signals on
        :param pulumi.Input[str] expression: The expression for which records to match on
        :param pulumi.Input[Sequence[pulumi.Input[str]]] group_by_fields: A list of fields to group records by
        :param pulumi.Input[bool] is_prototype: Whether the generated Signals should be prototype Signals
        :param pulumi.Input[int] limit: A Signal will be fired when this many records/distinct field values are matched
        :param pulumi.Input[str] name: The name of the Rule and the generated Signals
        :param pulumi.Input[int] severity: The severity of the generated Signals
        :param pulumi.Input[str] summary_expression: The summary of the generated Signals
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The tags of the generated Signals
        :param pulumi.Input[str] window_size: How long of a window to aggregate records for. Current acceptable values are T05M, T10M, T30M, T60M, T24H, T12H, or T05D.
               
               The following attributes are exported:
        """
        _CseThresholdRuleState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            count_distinct=count_distinct,
            count_field=count_field,
            description=description,
            enabled=enabled,
            entity_selectors=entity_selectors,
            expression=expression,
            group_by_fields=group_by_fields,
            is_prototype=is_prototype,
            limit=limit,
            name=name,
            severity=severity,
            summary_expression=summary_expression,
            tags=tags,
            window_size=window_size,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             count_distinct: Optional[pulumi.Input[bool]] = None,
             count_field: Optional[pulumi.Input[str]] = None,
             description: Optional[pulumi.Input[str]] = None,
             enabled: Optional[pulumi.Input[bool]] = None,
             entity_selectors: Optional[pulumi.Input[Sequence[pulumi.Input['CseThresholdRuleEntitySelectorArgs']]]] = None,
             expression: Optional[pulumi.Input[str]] = None,
             group_by_fields: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             is_prototype: Optional[pulumi.Input[bool]] = None,
             limit: Optional[pulumi.Input[int]] = None,
             name: Optional[pulumi.Input[str]] = None,
             severity: Optional[pulumi.Input[int]] = None,
             summary_expression: Optional[pulumi.Input[str]] = None,
             tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             window_size: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if count_distinct is not None:
            _setter("count_distinct", count_distinct)
        if count_field is not None:
            _setter("count_field", count_field)
        if description is not None:
            _setter("description", description)
        if enabled is not None:
            _setter("enabled", enabled)
        if entity_selectors is not None:
            _setter("entity_selectors", entity_selectors)
        if expression is not None:
            _setter("expression", expression)
        if group_by_fields is not None:
            _setter("group_by_fields", group_by_fields)
        if is_prototype is not None:
            _setter("is_prototype", is_prototype)
        if limit is not None:
            _setter("limit", limit)
        if name is not None:
            _setter("name", name)
        if severity is not None:
            _setter("severity", severity)
        if summary_expression is not None:
            _setter("summary_expression", summary_expression)
        if tags is not None:
            _setter("tags", tags)
        if window_size is not None:
            _setter("window_size", window_size)

    @property
    @pulumi.getter(name="countDistinct")
    def count_distinct(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to count distinct values of a field, as opposed to just counting the number of records
        """
        return pulumi.get(self, "count_distinct")

    @count_distinct.setter
    def count_distinct(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "count_distinct", value)

    @property
    @pulumi.getter(name="countField")
    def count_field(self) -> Optional[pulumi.Input[str]]:
        """
        The field to count if `count_distinct` is set to true
        """
        return pulumi.get(self, "count_field")

    @count_field.setter
    def count_field(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "count_field", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the generated Signals
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the rule should generate Signals
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="entitySelectors")
    def entity_selectors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CseThresholdRuleEntitySelectorArgs']]]]:
        """
        The entities to generate Signals on
        """
        return pulumi.get(self, "entity_selectors")

    @entity_selectors.setter
    def entity_selectors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CseThresholdRuleEntitySelectorArgs']]]]):
        pulumi.set(self, "entity_selectors", value)

    @property
    @pulumi.getter
    def expression(self) -> Optional[pulumi.Input[str]]:
        """
        The expression for which records to match on
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter(name="groupByFields")
    def group_by_fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of fields to group records by
        """
        return pulumi.get(self, "group_by_fields")

    @group_by_fields.setter
    def group_by_fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "group_by_fields", value)

    @property
    @pulumi.getter(name="isPrototype")
    def is_prototype(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the generated Signals should be prototype Signals
        """
        return pulumi.get(self, "is_prototype")

    @is_prototype.setter
    def is_prototype(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_prototype", value)

    @property
    @pulumi.getter
    def limit(self) -> Optional[pulumi.Input[int]]:
        """
        A Signal will be fired when this many records/distinct field values are matched
        """
        return pulumi.get(self, "limit")

    @limit.setter
    def limit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "limit", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Rule and the generated Signals
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def severity(self) -> Optional[pulumi.Input[int]]:
        """
        The severity of the generated Signals
        """
        return pulumi.get(self, "severity")

    @severity.setter
    def severity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "severity", value)

    @property
    @pulumi.getter(name="summaryExpression")
    def summary_expression(self) -> Optional[pulumi.Input[str]]:
        """
        The summary of the generated Signals
        """
        return pulumi.get(self, "summary_expression")

    @summary_expression.setter
    def summary_expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "summary_expression", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The tags of the generated Signals
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="windowSize")
    def window_size(self) -> Optional[pulumi.Input[str]]:
        """
        How long of a window to aggregate records for. Current acceptable values are T05M, T10M, T30M, T60M, T24H, T12H, or T05D.

        The following attributes are exported:
        """
        return pulumi.get(self, "window_size")

    @window_size.setter
    def window_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "window_size", value)


class CseThresholdRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 count_distinct: Optional[pulumi.Input[bool]] = None,
                 count_field: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 entity_selectors: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CseThresholdRuleEntitySelectorArgs']]]]] = None,
                 expression: Optional[pulumi.Input[str]] = None,
                 group_by_fields: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 is_prototype: Optional[pulumi.Input[bool]] = None,
                 limit: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 severity: Optional[pulumi.Input[int]] = None,
                 summary_expression: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 window_size: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a Sumo Logic CSE [Threshold Rule](https://help.sumologic.com/Cloud_SIEM_Enterprise/CSE_Rules/05_Write_a_Threshold_Rule).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sumologic as sumologic

        threshold_rule = sumologic.CseThresholdRule("thresholdRule",
            count_distinct=True,
            count_field="dstDevice_hostname",
            description="Signal description",
            enabled=True,
            entity_selectors=[sumologic.CseThresholdRuleEntitySelectorArgs(
                entity_type="_ip",
                expression="srcDevice_ip",
            )],
            expression="objectType = \\"Network\\"",
            group_by_fields=["dstDevice_hostname"],
            is_prototype=False,
            limit=1000,
            severity=5,
            summary_expression="Signal summary",
            tags=["_mitreAttackTactic:TA0009"],
            window_size="T30M")
        ```

        ## Import

        Threshold Rules can be imported using the field id, e.g.hcl

        ```sh
         $ pulumi import sumologic:index/cseThresholdRule:CseThresholdRule threshold_rule id
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] count_distinct: Whether to count distinct values of a field, as opposed to just counting the number of records
        :param pulumi.Input[str] count_field: The field to count if `count_distinct` is set to true
        :param pulumi.Input[str] description: The description of the generated Signals
        :param pulumi.Input[bool] enabled: Whether the rule should generate Signals
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CseThresholdRuleEntitySelectorArgs']]]] entity_selectors: The entities to generate Signals on
        :param pulumi.Input[str] expression: The expression for which records to match on
        :param pulumi.Input[Sequence[pulumi.Input[str]]] group_by_fields: A list of fields to group records by
        :param pulumi.Input[bool] is_prototype: Whether the generated Signals should be prototype Signals
        :param pulumi.Input[int] limit: A Signal will be fired when this many records/distinct field values are matched
        :param pulumi.Input[str] name: The name of the Rule and the generated Signals
        :param pulumi.Input[int] severity: The severity of the generated Signals
        :param pulumi.Input[str] summary_expression: The summary of the generated Signals
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The tags of the generated Signals
        :param pulumi.Input[str] window_size: How long of a window to aggregate records for. Current acceptable values are T05M, T10M, T30M, T60M, T24H, T12H, or T05D.
               
               The following attributes are exported:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CseThresholdRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Sumo Logic CSE [Threshold Rule](https://help.sumologic.com/Cloud_SIEM_Enterprise/CSE_Rules/05_Write_a_Threshold_Rule).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sumologic as sumologic

        threshold_rule = sumologic.CseThresholdRule("thresholdRule",
            count_distinct=True,
            count_field="dstDevice_hostname",
            description="Signal description",
            enabled=True,
            entity_selectors=[sumologic.CseThresholdRuleEntitySelectorArgs(
                entity_type="_ip",
                expression="srcDevice_ip",
            )],
            expression="objectType = \\"Network\\"",
            group_by_fields=["dstDevice_hostname"],
            is_prototype=False,
            limit=1000,
            severity=5,
            summary_expression="Signal summary",
            tags=["_mitreAttackTactic:TA0009"],
            window_size="T30M")
        ```

        ## Import

        Threshold Rules can be imported using the field id, e.g.hcl

        ```sh
         $ pulumi import sumologic:index/cseThresholdRule:CseThresholdRule threshold_rule id
        ```

        :param str resource_name: The name of the resource.
        :param CseThresholdRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CseThresholdRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            CseThresholdRuleArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 count_distinct: Optional[pulumi.Input[bool]] = None,
                 count_field: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 entity_selectors: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CseThresholdRuleEntitySelectorArgs']]]]] = None,
                 expression: Optional[pulumi.Input[str]] = None,
                 group_by_fields: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 is_prototype: Optional[pulumi.Input[bool]] = None,
                 limit: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 severity: Optional[pulumi.Input[int]] = None,
                 summary_expression: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 window_size: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CseThresholdRuleArgs.__new__(CseThresholdRuleArgs)

            __props__.__dict__["count_distinct"] = count_distinct
            __props__.__dict__["count_field"] = count_field
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            if enabled is None and not opts.urn:
                raise TypeError("Missing required property 'enabled'")
            __props__.__dict__["enabled"] = enabled
            if entity_selectors is None and not opts.urn:
                raise TypeError("Missing required property 'entity_selectors'")
            __props__.__dict__["entity_selectors"] = entity_selectors
            if expression is None and not opts.urn:
                raise TypeError("Missing required property 'expression'")
            __props__.__dict__["expression"] = expression
            __props__.__dict__["group_by_fields"] = group_by_fields
            __props__.__dict__["is_prototype"] = is_prototype
            if limit is None and not opts.urn:
                raise TypeError("Missing required property 'limit'")
            __props__.__dict__["limit"] = limit
            __props__.__dict__["name"] = name
            if severity is None and not opts.urn:
                raise TypeError("Missing required property 'severity'")
            __props__.__dict__["severity"] = severity
            __props__.__dict__["summary_expression"] = summary_expression
            __props__.__dict__["tags"] = tags
            if window_size is None and not opts.urn:
                raise TypeError("Missing required property 'window_size'")
            __props__.__dict__["window_size"] = window_size
        super(CseThresholdRule, __self__).__init__(
            'sumologic:index/cseThresholdRule:CseThresholdRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            count_distinct: Optional[pulumi.Input[bool]] = None,
            count_field: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            entity_selectors: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CseThresholdRuleEntitySelectorArgs']]]]] = None,
            expression: Optional[pulumi.Input[str]] = None,
            group_by_fields: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            is_prototype: Optional[pulumi.Input[bool]] = None,
            limit: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            severity: Optional[pulumi.Input[int]] = None,
            summary_expression: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            window_size: Optional[pulumi.Input[str]] = None) -> 'CseThresholdRule':
        """
        Get an existing CseThresholdRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] count_distinct: Whether to count distinct values of a field, as opposed to just counting the number of records
        :param pulumi.Input[str] count_field: The field to count if `count_distinct` is set to true
        :param pulumi.Input[str] description: The description of the generated Signals
        :param pulumi.Input[bool] enabled: Whether the rule should generate Signals
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CseThresholdRuleEntitySelectorArgs']]]] entity_selectors: The entities to generate Signals on
        :param pulumi.Input[str] expression: The expression for which records to match on
        :param pulumi.Input[Sequence[pulumi.Input[str]]] group_by_fields: A list of fields to group records by
        :param pulumi.Input[bool] is_prototype: Whether the generated Signals should be prototype Signals
        :param pulumi.Input[int] limit: A Signal will be fired when this many records/distinct field values are matched
        :param pulumi.Input[str] name: The name of the Rule and the generated Signals
        :param pulumi.Input[int] severity: The severity of the generated Signals
        :param pulumi.Input[str] summary_expression: The summary of the generated Signals
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The tags of the generated Signals
        :param pulumi.Input[str] window_size: How long of a window to aggregate records for. Current acceptable values are T05M, T10M, T30M, T60M, T24H, T12H, or T05D.
               
               The following attributes are exported:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CseThresholdRuleState.__new__(_CseThresholdRuleState)

        __props__.__dict__["count_distinct"] = count_distinct
        __props__.__dict__["count_field"] = count_field
        __props__.__dict__["description"] = description
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["entity_selectors"] = entity_selectors
        __props__.__dict__["expression"] = expression
        __props__.__dict__["group_by_fields"] = group_by_fields
        __props__.__dict__["is_prototype"] = is_prototype
        __props__.__dict__["limit"] = limit
        __props__.__dict__["name"] = name
        __props__.__dict__["severity"] = severity
        __props__.__dict__["summary_expression"] = summary_expression
        __props__.__dict__["tags"] = tags
        __props__.__dict__["window_size"] = window_size
        return CseThresholdRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="countDistinct")
    def count_distinct(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to count distinct values of a field, as opposed to just counting the number of records
        """
        return pulumi.get(self, "count_distinct")

    @property
    @pulumi.getter(name="countField")
    def count_field(self) -> pulumi.Output[Optional[str]]:
        """
        The field to count if `count_distinct` is set to true
        """
        return pulumi.get(self, "count_field")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        The description of the generated Signals
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[bool]:
        """
        Whether the rule should generate Signals
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="entitySelectors")
    def entity_selectors(self) -> pulumi.Output[Sequence['outputs.CseThresholdRuleEntitySelector']]:
        """
        The entities to generate Signals on
        """
        return pulumi.get(self, "entity_selectors")

    @property
    @pulumi.getter
    def expression(self) -> pulumi.Output[str]:
        """
        The expression for which records to match on
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter(name="groupByFields")
    def group_by_fields(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of fields to group records by
        """
        return pulumi.get(self, "group_by_fields")

    @property
    @pulumi.getter(name="isPrototype")
    def is_prototype(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether the generated Signals should be prototype Signals
        """
        return pulumi.get(self, "is_prototype")

    @property
    @pulumi.getter
    def limit(self) -> pulumi.Output[int]:
        """
        A Signal will be fired when this many records/distinct field values are matched
        """
        return pulumi.get(self, "limit")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the Rule and the generated Signals
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def severity(self) -> pulumi.Output[int]:
        """
        The severity of the generated Signals
        """
        return pulumi.get(self, "severity")

    @property
    @pulumi.getter(name="summaryExpression")
    def summary_expression(self) -> pulumi.Output[Optional[str]]:
        """
        The summary of the generated Signals
        """
        return pulumi.get(self, "summary_expression")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The tags of the generated Signals
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="windowSize")
    def window_size(self) -> pulumi.Output[str]:
        """
        How long of a window to aggregate records for. Current acceptable values are T05M, T10M, T30M, T60M, T24H, T12H, or T05D.

        The following attributes are exported:
        """
        return pulumi.get(self, "window_size")

