# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DashboardArgs', 'Dashboard']

@pulumi.input_type
class DashboardArgs:
    def __init__(__self__, *,
                 time_range: pulumi.Input['DashboardTimeRangeArgs'],
                 title: pulumi.Input[str],
                 coloring_rules: Optional[pulumi.Input[Sequence[pulumi.Input['DashboardColoringRuleArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 layout: Optional[pulumi.Input['DashboardLayoutArgs']] = None,
                 panels: Optional[pulumi.Input[Sequence[pulumi.Input['DashboardPanelArgs']]]] = None,
                 refresh_interval: Optional[pulumi.Input[int]] = None,
                 theme: Optional[pulumi.Input[str]] = None,
                 topology_label_map: Optional[pulumi.Input['DashboardTopologyLabelMapArgs']] = None,
                 variables: Optional[pulumi.Input[Sequence[pulumi.Input['DashboardVariableArgs']]]] = None):
        """
        The set of arguments for constructing a Dashboard resource.
        :param pulumi.Input['DashboardTimeRangeArgs'] time_range: Time range of the dashboard. See time range schema
               for details.
        :param pulumi.Input[str] title: Title of the dashboard.
        :param pulumi.Input[str] description: Description of the dashboard.
        :param pulumi.Input[str] domain: Domain of the dashboard. If set denotes that the dashboard concerns a given domain.
        :param pulumi.Input[str] folder_id: The identifier of the folder to save the dashboard in. By default it is saved in your
               personal folder.
        :param pulumi.Input['DashboardLayoutArgs'] layout: Layout of the dashboard. See layout schema for details.
        :param pulumi.Input[Sequence[pulumi.Input['DashboardPanelArgs']]] panels: A list of panels in the dashboard. See panel schema for details.
        :param pulumi.Input[int] refresh_interval: Interval of time (in seconds) to automatically refresh the dashboard. Valid values are 120,300,900,1800,3600,7200,86400.
        :param pulumi.Input[str] theme: Theme of the dashboard.
        :param pulumi.Input['DashboardTopologyLabelMapArgs'] topology_label_map: Topology labels for the dashboard. See
               topology label map schema
               for details.
        :param pulumi.Input[Sequence[pulumi.Input['DashboardVariableArgs']]] variables: A list of variables for the dashboard. See variable schema
               for details.
        """
        DashboardArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            time_range=time_range,
            title=title,
            coloring_rules=coloring_rules,
            description=description,
            domain=domain,
            folder_id=folder_id,
            layout=layout,
            panels=panels,
            refresh_interval=refresh_interval,
            theme=theme,
            topology_label_map=topology_label_map,
            variables=variables,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             time_range: pulumi.Input['DashboardTimeRangeArgs'],
             title: pulumi.Input[str],
             coloring_rules: Optional[pulumi.Input[Sequence[pulumi.Input['DashboardColoringRuleArgs']]]] = None,
             description: Optional[pulumi.Input[str]] = None,
             domain: Optional[pulumi.Input[str]] = None,
             folder_id: Optional[pulumi.Input[str]] = None,
             layout: Optional[pulumi.Input['DashboardLayoutArgs']] = None,
             panels: Optional[pulumi.Input[Sequence[pulumi.Input['DashboardPanelArgs']]]] = None,
             refresh_interval: Optional[pulumi.Input[int]] = None,
             theme: Optional[pulumi.Input[str]] = None,
             topology_label_map: Optional[pulumi.Input['DashboardTopologyLabelMapArgs']] = None,
             variables: Optional[pulumi.Input[Sequence[pulumi.Input['DashboardVariableArgs']]]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("time_range", time_range)
        _setter("title", title)
        if coloring_rules is not None:
            _setter("coloring_rules", coloring_rules)
        if description is not None:
            _setter("description", description)
        if domain is not None:
            _setter("domain", domain)
        if folder_id is not None:
            _setter("folder_id", folder_id)
        if layout is not None:
            _setter("layout", layout)
        if panels is not None:
            _setter("panels", panels)
        if refresh_interval is not None:
            _setter("refresh_interval", refresh_interval)
        if theme is not None:
            _setter("theme", theme)
        if topology_label_map is not None:
            _setter("topology_label_map", topology_label_map)
        if variables is not None:
            _setter("variables", variables)

    @property
    @pulumi.getter(name="timeRange")
    def time_range(self) -> pulumi.Input['DashboardTimeRangeArgs']:
        """
        Time range of the dashboard. See time range schema
        for details.
        """
        return pulumi.get(self, "time_range")

    @time_range.setter
    def time_range(self, value: pulumi.Input['DashboardTimeRangeArgs']):
        pulumi.set(self, "time_range", value)

    @property
    @pulumi.getter
    def title(self) -> pulumi.Input[str]:
        """
        Title of the dashboard.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[str]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter(name="coloringRules")
    def coloring_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DashboardColoringRuleArgs']]]]:
        return pulumi.get(self, "coloring_rules")

    @coloring_rules.setter
    def coloring_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DashboardColoringRuleArgs']]]]):
        pulumi.set(self, "coloring_rules", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the dashboard.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[str]]:
        """
        Domain of the dashboard. If set denotes that the dashboard concerns a given domain.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier of the folder to save the dashboard in. By default it is saved in your
        personal folder.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "folder_id", value)

    @property
    @pulumi.getter
    def layout(self) -> Optional[pulumi.Input['DashboardLayoutArgs']]:
        """
        Layout of the dashboard. See layout schema for details.
        """
        return pulumi.get(self, "layout")

    @layout.setter
    def layout(self, value: Optional[pulumi.Input['DashboardLayoutArgs']]):
        pulumi.set(self, "layout", value)

    @property
    @pulumi.getter
    def panels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DashboardPanelArgs']]]]:
        """
        A list of panels in the dashboard. See panel schema for details.
        """
        return pulumi.get(self, "panels")

    @panels.setter
    def panels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DashboardPanelArgs']]]]):
        pulumi.set(self, "panels", value)

    @property
    @pulumi.getter(name="refreshInterval")
    def refresh_interval(self) -> Optional[pulumi.Input[int]]:
        """
        Interval of time (in seconds) to automatically refresh the dashboard. Valid values are 120,300,900,1800,3600,7200,86400.
        """
        return pulumi.get(self, "refresh_interval")

    @refresh_interval.setter
    def refresh_interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "refresh_interval", value)

    @property
    @pulumi.getter
    def theme(self) -> Optional[pulumi.Input[str]]:
        """
        Theme of the dashboard.
        """
        return pulumi.get(self, "theme")

    @theme.setter
    def theme(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "theme", value)

    @property
    @pulumi.getter(name="topologyLabelMap")
    def topology_label_map(self) -> Optional[pulumi.Input['DashboardTopologyLabelMapArgs']]:
        """
        Topology labels for the dashboard. See
        topology label map schema
        for details.
        """
        return pulumi.get(self, "topology_label_map")

    @topology_label_map.setter
    def topology_label_map(self, value: Optional[pulumi.Input['DashboardTopologyLabelMapArgs']]):
        pulumi.set(self, "topology_label_map", value)

    @property
    @pulumi.getter
    def variables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DashboardVariableArgs']]]]:
        """
        A list of variables for the dashboard. See variable schema
        for details.
        """
        return pulumi.get(self, "variables")

    @variables.setter
    def variables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DashboardVariableArgs']]]]):
        pulumi.set(self, "variables", value)


@pulumi.input_type
class _DashboardState:
    def __init__(__self__, *,
                 coloring_rules: Optional[pulumi.Input[Sequence[pulumi.Input['DashboardColoringRuleArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 layout: Optional[pulumi.Input['DashboardLayoutArgs']] = None,
                 panels: Optional[pulumi.Input[Sequence[pulumi.Input['DashboardPanelArgs']]]] = None,
                 refresh_interval: Optional[pulumi.Input[int]] = None,
                 theme: Optional[pulumi.Input[str]] = None,
                 time_range: Optional[pulumi.Input['DashboardTimeRangeArgs']] = None,
                 title: Optional[pulumi.Input[str]] = None,
                 topology_label_map: Optional[pulumi.Input['DashboardTopologyLabelMapArgs']] = None,
                 variables: Optional[pulumi.Input[Sequence[pulumi.Input['DashboardVariableArgs']]]] = None):
        """
        Input properties used for looking up and filtering Dashboard resources.
        :param pulumi.Input[str] description: Description of the dashboard.
        :param pulumi.Input[str] domain: Domain of the dashboard. If set denotes that the dashboard concerns a given domain.
        :param pulumi.Input[str] folder_id: The identifier of the folder to save the dashboard in. By default it is saved in your
               personal folder.
        :param pulumi.Input['DashboardLayoutArgs'] layout: Layout of the dashboard. See layout schema for details.
        :param pulumi.Input[Sequence[pulumi.Input['DashboardPanelArgs']]] panels: A list of panels in the dashboard. See panel schema for details.
        :param pulumi.Input[int] refresh_interval: Interval of time (in seconds) to automatically refresh the dashboard. Valid values are 120,300,900,1800,3600,7200,86400.
        :param pulumi.Input[str] theme: Theme of the dashboard.
        :param pulumi.Input['DashboardTimeRangeArgs'] time_range: Time range of the dashboard. See time range schema
               for details.
        :param pulumi.Input[str] title: Title of the dashboard.
        :param pulumi.Input['DashboardTopologyLabelMapArgs'] topology_label_map: Topology labels for the dashboard. See
               topology label map schema
               for details.
        :param pulumi.Input[Sequence[pulumi.Input['DashboardVariableArgs']]] variables: A list of variables for the dashboard. See variable schema
               for details.
        """
        _DashboardState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            coloring_rules=coloring_rules,
            description=description,
            domain=domain,
            folder_id=folder_id,
            layout=layout,
            panels=panels,
            refresh_interval=refresh_interval,
            theme=theme,
            time_range=time_range,
            title=title,
            topology_label_map=topology_label_map,
            variables=variables,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             coloring_rules: Optional[pulumi.Input[Sequence[pulumi.Input['DashboardColoringRuleArgs']]]] = None,
             description: Optional[pulumi.Input[str]] = None,
             domain: Optional[pulumi.Input[str]] = None,
             folder_id: Optional[pulumi.Input[str]] = None,
             layout: Optional[pulumi.Input['DashboardLayoutArgs']] = None,
             panels: Optional[pulumi.Input[Sequence[pulumi.Input['DashboardPanelArgs']]]] = None,
             refresh_interval: Optional[pulumi.Input[int]] = None,
             theme: Optional[pulumi.Input[str]] = None,
             time_range: Optional[pulumi.Input['DashboardTimeRangeArgs']] = None,
             title: Optional[pulumi.Input[str]] = None,
             topology_label_map: Optional[pulumi.Input['DashboardTopologyLabelMapArgs']] = None,
             variables: Optional[pulumi.Input[Sequence[pulumi.Input['DashboardVariableArgs']]]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if coloring_rules is not None:
            _setter("coloring_rules", coloring_rules)
        if description is not None:
            _setter("description", description)
        if domain is not None:
            _setter("domain", domain)
        if folder_id is not None:
            _setter("folder_id", folder_id)
        if layout is not None:
            _setter("layout", layout)
        if panels is not None:
            _setter("panels", panels)
        if refresh_interval is not None:
            _setter("refresh_interval", refresh_interval)
        if theme is not None:
            _setter("theme", theme)
        if time_range is not None:
            _setter("time_range", time_range)
        if title is not None:
            _setter("title", title)
        if topology_label_map is not None:
            _setter("topology_label_map", topology_label_map)
        if variables is not None:
            _setter("variables", variables)

    @property
    @pulumi.getter(name="coloringRules")
    def coloring_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DashboardColoringRuleArgs']]]]:
        return pulumi.get(self, "coloring_rules")

    @coloring_rules.setter
    def coloring_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DashboardColoringRuleArgs']]]]):
        pulumi.set(self, "coloring_rules", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the dashboard.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[str]]:
        """
        Domain of the dashboard. If set denotes that the dashboard concerns a given domain.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier of the folder to save the dashboard in. By default it is saved in your
        personal folder.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "folder_id", value)

    @property
    @pulumi.getter
    def layout(self) -> Optional[pulumi.Input['DashboardLayoutArgs']]:
        """
        Layout of the dashboard. See layout schema for details.
        """
        return pulumi.get(self, "layout")

    @layout.setter
    def layout(self, value: Optional[pulumi.Input['DashboardLayoutArgs']]):
        pulumi.set(self, "layout", value)

    @property
    @pulumi.getter
    def panels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DashboardPanelArgs']]]]:
        """
        A list of panels in the dashboard. See panel schema for details.
        """
        return pulumi.get(self, "panels")

    @panels.setter
    def panels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DashboardPanelArgs']]]]):
        pulumi.set(self, "panels", value)

    @property
    @pulumi.getter(name="refreshInterval")
    def refresh_interval(self) -> Optional[pulumi.Input[int]]:
        """
        Interval of time (in seconds) to automatically refresh the dashboard. Valid values are 120,300,900,1800,3600,7200,86400.
        """
        return pulumi.get(self, "refresh_interval")

    @refresh_interval.setter
    def refresh_interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "refresh_interval", value)

    @property
    @pulumi.getter
    def theme(self) -> Optional[pulumi.Input[str]]:
        """
        Theme of the dashboard.
        """
        return pulumi.get(self, "theme")

    @theme.setter
    def theme(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "theme", value)

    @property
    @pulumi.getter(name="timeRange")
    def time_range(self) -> Optional[pulumi.Input['DashboardTimeRangeArgs']]:
        """
        Time range of the dashboard. See time range schema
        for details.
        """
        return pulumi.get(self, "time_range")

    @time_range.setter
    def time_range(self, value: Optional[pulumi.Input['DashboardTimeRangeArgs']]):
        pulumi.set(self, "time_range", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        Title of the dashboard.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter(name="topologyLabelMap")
    def topology_label_map(self) -> Optional[pulumi.Input['DashboardTopologyLabelMapArgs']]:
        """
        Topology labels for the dashboard. See
        topology label map schema
        for details.
        """
        return pulumi.get(self, "topology_label_map")

    @topology_label_map.setter
    def topology_label_map(self, value: Optional[pulumi.Input['DashboardTopologyLabelMapArgs']]):
        pulumi.set(self, "topology_label_map", value)

    @property
    @pulumi.getter
    def variables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DashboardVariableArgs']]]]:
        """
        A list of variables for the dashboard. See variable schema
        for details.
        """
        return pulumi.get(self, "variables")

    @variables.setter
    def variables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DashboardVariableArgs']]]]):
        pulumi.set(self, "variables", value)


class Dashboard(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 coloring_rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DashboardColoringRuleArgs']]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 layout: Optional[pulumi.Input[pulumi.InputType['DashboardLayoutArgs']]] = None,
                 panels: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DashboardPanelArgs']]]]] = None,
                 refresh_interval: Optional[pulumi.Input[int]] = None,
                 theme: Optional[pulumi.Input[str]] = None,
                 time_range: Optional[pulumi.Input[pulumi.InputType['DashboardTimeRangeArgs']]] = None,
                 title: Optional[pulumi.Input[str]] = None,
                 topology_label_map: Optional[pulumi.Input[pulumi.InputType['DashboardTopologyLabelMapArgs']]] = None,
                 variables: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DashboardVariableArgs']]]]] = None,
                 __props__=None):
        """
        Provides a [Sumologic Dashboard (New)][1].

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_sumologic as sumologic

        personal_folder = sumologic.get_personal_folder()
        api_dashboard = sumologic.Dashboard("api-dashboard",
            title="Api Health Dashboard",
            description="Demo dashboard description",
            folder_id=personal_folder.id,
            refresh_interval=120,
            theme="Dark",
            time_range=sumologic.DashboardTimeRangeArgs(
                begin_bounded_time_range=sumologic.DashboardTimeRangeBeginBoundedTimeRangeArgs(
                    from_=sumologic.DashboardTimeRangeBeginBoundedTimeRangeFromArgs(
                        literal_time_range=sumologic.DashboardTimeRangeBeginBoundedTimeRangeFromLiteralTimeRangeArgs(
                            range_name="today",
                        ),
                    ),
                ),
            ),
            topology_label_map=sumologic.DashboardTopologyLabelMapArgs(
                datas=[
                    sumologic.DashboardTopologyLabelMapDataArgs(
                        label="cluster",
                        values=["api-prod"],
                    ),
                    sumologic.DashboardTopologyLabelMapDataArgs(
                        label="namespace",
                        values=["default"],
                    ),
                ],
            ),
            domain="app",
            panels=[
                sumologic.DashboardPanelArgs(
                    text_panel=sumologic.DashboardPanelTextPanelArgs(
                        key="text-panel-01",
                        title="Api Health",
                        visual_settings=json.dumps({
                            "text": {
                                "verticalAlignment": "top",
                                "horizontalAlignment": "left",
                                "fontSize": 12,
                            },
                        }),
                        keep_visual_settings_consistent_with_parent=True,
                        text=\"\"\"## Api Health Monitoring

        Use this dashboard to monitor API service health. It contains following panels:

        1. API errors: Errors in last 12 hours
        3. API 5xx: Count of 5xx response
        3. CPU utilization: CPU utilization in last 60 mins
        \"\"\",
                    ),
                ),
                sumologic.DashboardPanelArgs(
                    sumo_search_panel=sumologic.DashboardPanelSumoSearchPanelArgs(
                        key="search-panel-01",
                        title="Api Errors by Host",
                        description="Errors in api service since last 12 hours",
                        visual_settings=json.dumps({
                            "general": {
                                "mode": "timeSeries",
                                "type": "area",
                                "displayType": "stacked",
                                "markerSize": 5,
                                "lineDashType": "solid",
                                "markerType": "square",
                                "lineThickness": 1,
                            },
                            "title": {
                                "fontSize": 14,
                            },
                            "legend": {
                                "enabled": True,
                                "verticalAlign": "bottom",
                                "fontSize": 12,
                                "maxHeight": 50,
                                "showAsTable": False,
                                "wrap": True,
                            },
                        }),
                        keep_visual_settings_consistent_with_parent=True,
                        queries=[sumologic.DashboardPanelSumoSearchPanelQueryArgs(
                            query_string="_sourceCategory=api error | timeslice 1h | count by _timeslice, _sourceHost | transpose row _timeslice column _sourceHost",
                            query_type="Logs",
                            query_key="A",
                        )],
                        time_range=sumologic.DashboardPanelSumoSearchPanelTimeRangeArgs(
                            begin_bounded_time_range=sumologic.DashboardPanelSumoSearchPanelTimeRangeBeginBoundedTimeRangeArgs(
                                from_=sumologic.DashboardPanelSumoSearchPanelTimeRangeBeginBoundedTimeRangeFromArgs(
                                    relative_time_range=sumologic.DashboardPanelSumoSearchPanelTimeRangeBeginBoundedTimeRangeFromRelativeTimeRangeArgs(
                                        relative_time="-12h",
                                    ),
                                ),
                            ),
                        ),
                    ),
                ),
                sumologic.DashboardPanelArgs(
                    sumo_search_panel=sumologic.DashboardPanelSumoSearchPanelArgs(
                        key="metrics-panel-01",
                        title="Api 5xx Response Count",
                        description="Count of 5xx response from api service",
                        visual_settings=json.dumps({
                            "general": {
                                "mode": "distribution",
                                "type": "pie",
                                "displayType": "default",
                                "fillOpacity": 1,
                                "startAngle": 270,
                                "innerRadius": "40%",
                                "maxNumOfSlices": 10,
                                "aggregationType": "sum",
                            },
                            "title": {
                                "fontSize": 14,
                            },
                        }),
                        keep_visual_settings_consistent_with_parent=True,
                        queries=[sumologic.DashboardPanelSumoSearchPanelQueryArgs(
                            query_string="_sourceCategory=api metric=Api-5xx",
                            query_type="Metrics",
                            query_key="A",
                            metrics_query_mode="Advanced",
                        )],
                        time_range=sumologic.DashboardPanelSumoSearchPanelTimeRangeArgs(
                            begin_bounded_time_range=sumologic.DashboardPanelSumoSearchPanelTimeRangeBeginBoundedTimeRangeArgs(
                                from_=sumologic.DashboardPanelSumoSearchPanelTimeRangeBeginBoundedTimeRangeFromArgs(
                                    literal_time_range=sumologic.DashboardPanelSumoSearchPanelTimeRangeBeginBoundedTimeRangeFromLiteralTimeRangeArgs(
                                        range_name="today",
                                    ),
                                ),
                            ),
                        ),
                    ),
                ),
                sumologic.DashboardPanelArgs(
                    sumo_search_panel=sumologic.DashboardPanelSumoSearchPanelArgs(
                        key="metrics-panel-02",
                        title="CPU Utilization",
                        description="CPU utilization in api service",
                        visual_settings=json.dumps({
                            "general": {
                                "mode": "timeSeries",
                                "type": "line",
                                "displayType": "smooth",
                                "markerSize": 5,
                                "lineDashType": "dashDot",
                                "markerType": "none",
                                "lineThickness": 1,
                            },
                            "title": {
                                "fontSize": 14,
                            },
                        }),
                        keep_visual_settings_consistent_with_parent=True,
                        queries=[
                            sumologic.DashboardPanelSumoSearchPanelQueryArgs(
                                query_string="metric=Proc_CPU nite-api-1",
                                query_type="Metrics",
                                query_key="A",
                                metrics_query_mode="Basic",
                                metrics_query_data=sumologic.DashboardPanelSumoSearchPanelQueryMetricsQueryDataArgs(
                                    metric="Proc_CPU",
                                    filters=[sumologic.DashboardPanelSumoSearchPanelQueryMetricsQueryDataFilterArgs(
                                        key="_sourcehost",
                                        negation=False,
                                        value="nite-api-1",
                                    )],
                                    aggregation_type="None",
                                ),
                            ),
                            sumologic.DashboardPanelSumoSearchPanelQueryArgs(
                                query_string="metric=Proc_CPU nite-api-2",
                                query_type="Metrics",
                                query_key="B",
                                metrics_query_mode="Basic",
                                metrics_query_data=sumologic.DashboardPanelSumoSearchPanelQueryMetricsQueryDataArgs(
                                    metric="Proc_CPU",
                                    filters=[sumologic.DashboardPanelSumoSearchPanelQueryMetricsQueryDataFilterArgs(
                                        key="_sourcehost",
                                        negation=False,
                                        value="nite-api-2",
                                    )],
                                    aggregation_type="None",
                                ),
                            ),
                        ],
                        time_range=sumologic.DashboardPanelSumoSearchPanelTimeRangeArgs(
                            begin_bounded_time_range=sumologic.DashboardPanelSumoSearchPanelTimeRangeBeginBoundedTimeRangeArgs(
                                from_=sumologic.DashboardPanelSumoSearchPanelTimeRangeBeginBoundedTimeRangeFromArgs(
                                    relative_time_range=sumologic.DashboardPanelSumoSearchPanelTimeRangeBeginBoundedTimeRangeFromRelativeTimeRangeArgs(
                                        relative_time="-1h",
                                    ),
                                ),
                            ),
                        ),
                    ),
                ),
            ],
            layout=sumologic.DashboardLayoutArgs(
                grid=sumologic.DashboardLayoutGridArgs(
                    layout_structures=[
                        sumologic.DashboardLayoutGridLayoutStructureArgs(
                            key="text-panel-01",
                            structure="{\\"height\\":5,\\"width\\":24,\\"x\\":0,\\"y\\":0}",
                        ),
                        sumologic.DashboardLayoutGridLayoutStructureArgs(
                            key="search-panel-01",
                            structure="{\\"height\\":10,\\"width\\":12,\\"x\\":0,\\"y\\":5}",
                        ),
                        sumologic.DashboardLayoutGridLayoutStructureArgs(
                            key="metrics-panel-01",
                            structure="{\\"height\\":10,\\"width\\":12,\\"x\\":12,\\"y\\":5}",
                        ),
                        sumologic.DashboardLayoutGridLayoutStructureArgs(
                            key="metrics-panel-02",
                            structure="{\\"height\\":10,\\"width\\":24,\\"x\\":0,\\"y\\":25}",
                        ),
                    ],
                ),
            ),
            variables=[sumologic.DashboardVariableArgs(
                name="_sourceHost",
                display_name="Source Host",
                default_value="nite-api-1",
                source_definition=sumologic.DashboardVariableSourceDefinitionArgs(
                    csv_variable_source_definition=sumologic.DashboardVariableSourceDefinitionCsvVariableSourceDefinitionArgs(
                        values="nite-api-1,nite-api-2",
                    ),
                ),
                allow_multi_select=True,
                include_all_option=True,
                hide_from_ui=False,
            )])
        ```
        ## Attributes reference

        In addition to all arguments above, the following attributes are exported:

        - `id` - The ID of the dashboard.

        ### Schema for `topology_label_map`
        - `data` - (Block List, Required) A list of blocks containing label and it's values.
          - - `label` - (Required) The name of the topology label.
          - - `values` - (Required) The values for the topology label.

        ### Schema for `time_range`
        - `complete_literal_time_range` - (Block List, Max: 1, Optional) Literal time range. See
          complete_literal_time_range schema for details.
        - `begin_bounded_time_range` - (Block List, Max: 1, Optional) Bounded time range. See
          begin_bounded_time_range schema schema for details.
          schema for details.

        ### Schema for `complete_literal_time_range`
        - `range_name` - (Required) Name of complete literal time range. One of `today`, `yesterday`, `previous_week`, `previous_month`.

        ### Schema for `begin_bounded_time_range`
        - `from` - (Block List, Max: 1, Required) Start boundary of bounded time range. See
          time_range_boundary schema for details.
        - `to` - (Block List, Max: 1, Optional) End boundary of bounded time range. See
          time_range_boundary schema for details.

        ### Schema for `time_range_boundary`
        - `epoch_time_range` - (Block List, Optional) Time since the epoch.
            - `epoch_millis` - (Required) Time as a number of milliseconds since the epoch.

        - `iso8601_time_range` - (Block List, Optional) Time in ISO 8601 format.
            - `iso8601_time` - (Required) Time as a string in ISO 8601 format.

        - `relative_time_range` - (Block List, Optional) Time in relative format.
            - `relative_time` - (Required) Relative time as a string consists of following elements:
              1. `-` (optional): minus sign indicates time in the past,
              2. `<number>`: number of time units,
              3. `<time_unit>`: time unit; possible values are: `w` (week), `d` (day), `h` (hour), `m` (minute), `s` (second).
              
              Multiple pairs of `<number><time_unit>` may be provided, and they may be in any order. For example,
        `-2w5d3h` points to the moment in time 2 weeks, 5 days and 3 hours ago.

        - `literal_time_range` - (Block List, Optional) Time in literal format.
            - `range_name` - (Required) One of `now`, `second`, `minute`, `hour`, `day`, `today`, `week`, `month`, `year`.

        ### Schema for `panel`
        - `text_panel` - (Block List, Max: 1, Optional) A text panel. See text_panel schema for details.
        - `sumo_search_panel` - (Block List, Max: 1, Optional) A search panel. See sumo_search_panel schema
          for details.

        ### Schema for `text_panel`
        - `key` - (Required) Key for the panel. Used to create searches for the queries in the panel and configure the layout
          of the panel in the dashboard.
        - `title` - (Optional) Title of the panel.
        - `visual_settings` - (Optional) Visual settings of the panel.
        - `keep_visual_settings_consistent_with_parent` - (Optional) Keeps the visual settings, like series colors, consistent
          with the settings of the parent panel.
        - `text` - (Required) Text to display in the panel.

        ### Schema for `sumo_search_panel`
        - `key` - (Required) Key for the panel. Used to create searches for the queries in the panel and configure the layout
          of the panel in the dashboard.
        - `title` - (Optional) Title of the panel.
        - `visual_settings` - (Optional) Visual settings of the panel.
        - `keep_visual_settings_consistent_with_parent` - (Optional) Keeps the visual settings, like series colors, consistent
          with the settings of the parent panel.
        - `query` - (Block List, Required) A list of queries for the panel. Can be log or metric query. See
          query schema for details.
        - `description` - (Optional) Description of the panel.
        - `time_range` - (Block List, Max: 1, Optional) Time range of the panel. See time_range schema
          for details.
        - `linked_dashboard` - (Block List, Optional) A list of linked dashboards. See
          linked_dashboard schema for details.

        ### Schema for `query`
        - `query_string` - (Required) The metrics or logs query.
        - `query_type` - (Required) The type of the query. One of `Metrics` or `Logs`.
        - `query_key` - (Required) The key for metric or log query. Used as an identifier for queries.
        - `metric_query_mode` - (Optional) _Should only be specified for metric query_. The mode of the metric query.
          One of `Basic` or `Advanced`.
        - `metric_query_data` - (Optional) _Should only be specified for metric query_. Data format for the metric query. See
          metric_query_data schema for details.

        ### Schema for `metric_query_data`
        - `metric` - (Required) The metric of the query.
        - `aggregation_type` - (Optional) The type of aggregation. One of `Count`, `Minimum`, `Maximum`, `Sum`, `Average`, `None`.
        - `group_by` - The field to group the results by.
        - `filter` - (Block List, Required) A list of filters for the metrics query.
            - `key` - (Required) The key of the metrics filter.
            - `value` - (Required) The value of the metrics filter.
            - `negation` - (Optional) Whether or not the metrics filter is negated.
        - `operator` - (Block List, Optional) A list of operator data for the metrics query.

        ### Schema for `operator`
        - `operator_name` - (Required) The name of the metrics operator.
        - `parameter` - (Block List, Required) A list of operator parameters for the operator data.
            - `key` - (Required) The key of the operator parameter.
            - `value` - (Required) The value of the operator parameter.

        ### Schema for `linked_dashboard`
        - `id` - (Required) Identifier of the linked dashboard.
        - `relative_path` - (Optional) Relative path of the linked dashboard to the dashboard of the linking panel.
        - `include_time_range` - (Optional) Include time range from the current dashboard to the linked dashboard. _Defaults to true_.
        - `include_variables` - (Optional) Include variables from the current dashboard to the linked dashboard. _Defaults to true_.

        ### Schema for `layout`
        - `grid` - (Block List, Max: 1, Optional) Panel layout for the dashboard.

        ### Schema for `grid`
        - `layout_structure` - (Block List, Required) Layout structure for the panels in the dashboard.
            - `key` - (Required) The identifier of the panel that this structure applies to. It's same as `panel.key`.
            - `structure` - (Required) The structure of the panel.

        ### Schema for `variable`
        - `name` - (Required) Name of the variable. The variable name is case-insensitive.
        - `display_name` - (Optional) Display name of the variable shown in the UI. If this field is empty, the name field will be used.
        - `default_value` - (Optional) Default value of the variable.
        - `source_definition` - (Required) Source definition for variable values. See
          source_definition schema for details.
        - `allow_multi_select` - (Optional) Allow multiple selections in the values dropdown.
        - `include_all_option` - (Optional) Include an "All" option at the top of the variable's values dropdown. _Defaults to true._
        - `hide_from_ui` - (Optional) Hide the variable in the dashboard UI.

        ### Schema for `source_definition`
        - `log_query_variable_source_definition` - (Optional) Variable values from a log query.
            - `query` - (Required) A log query.
            - `field` - (Required) A field in log query to populate the variable values
        - `metadata_variable_source_definition` - (Optional) Variable values from a metric query.
            - `filter` - (Required) Filter to search the catalog.
            - `key` - (Required) Return the values for this given key.
        - `csv_variable_source_definition` - (Optional) Variable values in csv format.
            - `values` - (Required) A comma separated values for the variable.

        ## Import

        Dashboard can be imported using the dashboard id, e.g.hcl

        ```sh
         $ pulumi import sumologic:index/dashboard:Dashboard example-dashboard q0IKwAK5t2qRI4sgiANwnS87k5S4twN2sCpTuZFSsz6ZmbENPsG7PnpqZygc
        ```

         [1]https://help.sumologic.com/Visualizations-and-Alerts/Dashboard_(New)

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Description of the dashboard.
        :param pulumi.Input[str] domain: Domain of the dashboard. If set denotes that the dashboard concerns a given domain.
        :param pulumi.Input[str] folder_id: The identifier of the folder to save the dashboard in. By default it is saved in your
               personal folder.
        :param pulumi.Input[pulumi.InputType['DashboardLayoutArgs']] layout: Layout of the dashboard. See layout schema for details.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DashboardPanelArgs']]]] panels: A list of panels in the dashboard. See panel schema for details.
        :param pulumi.Input[int] refresh_interval: Interval of time (in seconds) to automatically refresh the dashboard. Valid values are 120,300,900,1800,3600,7200,86400.
        :param pulumi.Input[str] theme: Theme of the dashboard.
        :param pulumi.Input[pulumi.InputType['DashboardTimeRangeArgs']] time_range: Time range of the dashboard. See time range schema
               for details.
        :param pulumi.Input[str] title: Title of the dashboard.
        :param pulumi.Input[pulumi.InputType['DashboardTopologyLabelMapArgs']] topology_label_map: Topology labels for the dashboard. See
               topology label map schema
               for details.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DashboardVariableArgs']]]] variables: A list of variables for the dashboard. See variable schema
               for details.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DashboardArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a [Sumologic Dashboard (New)][1].

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_sumologic as sumologic

        personal_folder = sumologic.get_personal_folder()
        api_dashboard = sumologic.Dashboard("api-dashboard",
            title="Api Health Dashboard",
            description="Demo dashboard description",
            folder_id=personal_folder.id,
            refresh_interval=120,
            theme="Dark",
            time_range=sumologic.DashboardTimeRangeArgs(
                begin_bounded_time_range=sumologic.DashboardTimeRangeBeginBoundedTimeRangeArgs(
                    from_=sumologic.DashboardTimeRangeBeginBoundedTimeRangeFromArgs(
                        literal_time_range=sumologic.DashboardTimeRangeBeginBoundedTimeRangeFromLiteralTimeRangeArgs(
                            range_name="today",
                        ),
                    ),
                ),
            ),
            topology_label_map=sumologic.DashboardTopologyLabelMapArgs(
                datas=[
                    sumologic.DashboardTopologyLabelMapDataArgs(
                        label="cluster",
                        values=["api-prod"],
                    ),
                    sumologic.DashboardTopologyLabelMapDataArgs(
                        label="namespace",
                        values=["default"],
                    ),
                ],
            ),
            domain="app",
            panels=[
                sumologic.DashboardPanelArgs(
                    text_panel=sumologic.DashboardPanelTextPanelArgs(
                        key="text-panel-01",
                        title="Api Health",
                        visual_settings=json.dumps({
                            "text": {
                                "verticalAlignment": "top",
                                "horizontalAlignment": "left",
                                "fontSize": 12,
                            },
                        }),
                        keep_visual_settings_consistent_with_parent=True,
                        text=\"\"\"## Api Health Monitoring

        Use this dashboard to monitor API service health. It contains following panels:

        1. API errors: Errors in last 12 hours
        3. API 5xx: Count of 5xx response
        3. CPU utilization: CPU utilization in last 60 mins
        \"\"\",
                    ),
                ),
                sumologic.DashboardPanelArgs(
                    sumo_search_panel=sumologic.DashboardPanelSumoSearchPanelArgs(
                        key="search-panel-01",
                        title="Api Errors by Host",
                        description="Errors in api service since last 12 hours",
                        visual_settings=json.dumps({
                            "general": {
                                "mode": "timeSeries",
                                "type": "area",
                                "displayType": "stacked",
                                "markerSize": 5,
                                "lineDashType": "solid",
                                "markerType": "square",
                                "lineThickness": 1,
                            },
                            "title": {
                                "fontSize": 14,
                            },
                            "legend": {
                                "enabled": True,
                                "verticalAlign": "bottom",
                                "fontSize": 12,
                                "maxHeight": 50,
                                "showAsTable": False,
                                "wrap": True,
                            },
                        }),
                        keep_visual_settings_consistent_with_parent=True,
                        queries=[sumologic.DashboardPanelSumoSearchPanelQueryArgs(
                            query_string="_sourceCategory=api error | timeslice 1h | count by _timeslice, _sourceHost | transpose row _timeslice column _sourceHost",
                            query_type="Logs",
                            query_key="A",
                        )],
                        time_range=sumologic.DashboardPanelSumoSearchPanelTimeRangeArgs(
                            begin_bounded_time_range=sumologic.DashboardPanelSumoSearchPanelTimeRangeBeginBoundedTimeRangeArgs(
                                from_=sumologic.DashboardPanelSumoSearchPanelTimeRangeBeginBoundedTimeRangeFromArgs(
                                    relative_time_range=sumologic.DashboardPanelSumoSearchPanelTimeRangeBeginBoundedTimeRangeFromRelativeTimeRangeArgs(
                                        relative_time="-12h",
                                    ),
                                ),
                            ),
                        ),
                    ),
                ),
                sumologic.DashboardPanelArgs(
                    sumo_search_panel=sumologic.DashboardPanelSumoSearchPanelArgs(
                        key="metrics-panel-01",
                        title="Api 5xx Response Count",
                        description="Count of 5xx response from api service",
                        visual_settings=json.dumps({
                            "general": {
                                "mode": "distribution",
                                "type": "pie",
                                "displayType": "default",
                                "fillOpacity": 1,
                                "startAngle": 270,
                                "innerRadius": "40%",
                                "maxNumOfSlices": 10,
                                "aggregationType": "sum",
                            },
                            "title": {
                                "fontSize": 14,
                            },
                        }),
                        keep_visual_settings_consistent_with_parent=True,
                        queries=[sumologic.DashboardPanelSumoSearchPanelQueryArgs(
                            query_string="_sourceCategory=api metric=Api-5xx",
                            query_type="Metrics",
                            query_key="A",
                            metrics_query_mode="Advanced",
                        )],
                        time_range=sumologic.DashboardPanelSumoSearchPanelTimeRangeArgs(
                            begin_bounded_time_range=sumologic.DashboardPanelSumoSearchPanelTimeRangeBeginBoundedTimeRangeArgs(
                                from_=sumologic.DashboardPanelSumoSearchPanelTimeRangeBeginBoundedTimeRangeFromArgs(
                                    literal_time_range=sumologic.DashboardPanelSumoSearchPanelTimeRangeBeginBoundedTimeRangeFromLiteralTimeRangeArgs(
                                        range_name="today",
                                    ),
                                ),
                            ),
                        ),
                    ),
                ),
                sumologic.DashboardPanelArgs(
                    sumo_search_panel=sumologic.DashboardPanelSumoSearchPanelArgs(
                        key="metrics-panel-02",
                        title="CPU Utilization",
                        description="CPU utilization in api service",
                        visual_settings=json.dumps({
                            "general": {
                                "mode": "timeSeries",
                                "type": "line",
                                "displayType": "smooth",
                                "markerSize": 5,
                                "lineDashType": "dashDot",
                                "markerType": "none",
                                "lineThickness": 1,
                            },
                            "title": {
                                "fontSize": 14,
                            },
                        }),
                        keep_visual_settings_consistent_with_parent=True,
                        queries=[
                            sumologic.DashboardPanelSumoSearchPanelQueryArgs(
                                query_string="metric=Proc_CPU nite-api-1",
                                query_type="Metrics",
                                query_key="A",
                                metrics_query_mode="Basic",
                                metrics_query_data=sumologic.DashboardPanelSumoSearchPanelQueryMetricsQueryDataArgs(
                                    metric="Proc_CPU",
                                    filters=[sumologic.DashboardPanelSumoSearchPanelQueryMetricsQueryDataFilterArgs(
                                        key="_sourcehost",
                                        negation=False,
                                        value="nite-api-1",
                                    )],
                                    aggregation_type="None",
                                ),
                            ),
                            sumologic.DashboardPanelSumoSearchPanelQueryArgs(
                                query_string="metric=Proc_CPU nite-api-2",
                                query_type="Metrics",
                                query_key="B",
                                metrics_query_mode="Basic",
                                metrics_query_data=sumologic.DashboardPanelSumoSearchPanelQueryMetricsQueryDataArgs(
                                    metric="Proc_CPU",
                                    filters=[sumologic.DashboardPanelSumoSearchPanelQueryMetricsQueryDataFilterArgs(
                                        key="_sourcehost",
                                        negation=False,
                                        value="nite-api-2",
                                    )],
                                    aggregation_type="None",
                                ),
                            ),
                        ],
                        time_range=sumologic.DashboardPanelSumoSearchPanelTimeRangeArgs(
                            begin_bounded_time_range=sumologic.DashboardPanelSumoSearchPanelTimeRangeBeginBoundedTimeRangeArgs(
                                from_=sumologic.DashboardPanelSumoSearchPanelTimeRangeBeginBoundedTimeRangeFromArgs(
                                    relative_time_range=sumologic.DashboardPanelSumoSearchPanelTimeRangeBeginBoundedTimeRangeFromRelativeTimeRangeArgs(
                                        relative_time="-1h",
                                    ),
                                ),
                            ),
                        ),
                    ),
                ),
            ],
            layout=sumologic.DashboardLayoutArgs(
                grid=sumologic.DashboardLayoutGridArgs(
                    layout_structures=[
                        sumologic.DashboardLayoutGridLayoutStructureArgs(
                            key="text-panel-01",
                            structure="{\\"height\\":5,\\"width\\":24,\\"x\\":0,\\"y\\":0}",
                        ),
                        sumologic.DashboardLayoutGridLayoutStructureArgs(
                            key="search-panel-01",
                            structure="{\\"height\\":10,\\"width\\":12,\\"x\\":0,\\"y\\":5}",
                        ),
                        sumologic.DashboardLayoutGridLayoutStructureArgs(
                            key="metrics-panel-01",
                            structure="{\\"height\\":10,\\"width\\":12,\\"x\\":12,\\"y\\":5}",
                        ),
                        sumologic.DashboardLayoutGridLayoutStructureArgs(
                            key="metrics-panel-02",
                            structure="{\\"height\\":10,\\"width\\":24,\\"x\\":0,\\"y\\":25}",
                        ),
                    ],
                ),
            ),
            variables=[sumologic.DashboardVariableArgs(
                name="_sourceHost",
                display_name="Source Host",
                default_value="nite-api-1",
                source_definition=sumologic.DashboardVariableSourceDefinitionArgs(
                    csv_variable_source_definition=sumologic.DashboardVariableSourceDefinitionCsvVariableSourceDefinitionArgs(
                        values="nite-api-1,nite-api-2",
                    ),
                ),
                allow_multi_select=True,
                include_all_option=True,
                hide_from_ui=False,
            )])
        ```
        ## Attributes reference

        In addition to all arguments above, the following attributes are exported:

        - `id` - The ID of the dashboard.

        ### Schema for `topology_label_map`
        - `data` - (Block List, Required) A list of blocks containing label and it's values.
          - - `label` - (Required) The name of the topology label.
          - - `values` - (Required) The values for the topology label.

        ### Schema for `time_range`
        - `complete_literal_time_range` - (Block List, Max: 1, Optional) Literal time range. See
          complete_literal_time_range schema for details.
        - `begin_bounded_time_range` - (Block List, Max: 1, Optional) Bounded time range. See
          begin_bounded_time_range schema schema for details.
          schema for details.

        ### Schema for `complete_literal_time_range`
        - `range_name` - (Required) Name of complete literal time range. One of `today`, `yesterday`, `previous_week`, `previous_month`.

        ### Schema for `begin_bounded_time_range`
        - `from` - (Block List, Max: 1, Required) Start boundary of bounded time range. See
          time_range_boundary schema for details.
        - `to` - (Block List, Max: 1, Optional) End boundary of bounded time range. See
          time_range_boundary schema for details.

        ### Schema for `time_range_boundary`
        - `epoch_time_range` - (Block List, Optional) Time since the epoch.
            - `epoch_millis` - (Required) Time as a number of milliseconds since the epoch.

        - `iso8601_time_range` - (Block List, Optional) Time in ISO 8601 format.
            - `iso8601_time` - (Required) Time as a string in ISO 8601 format.

        - `relative_time_range` - (Block List, Optional) Time in relative format.
            - `relative_time` - (Required) Relative time as a string consists of following elements:
              1. `-` (optional): minus sign indicates time in the past,
              2. `<number>`: number of time units,
              3. `<time_unit>`: time unit; possible values are: `w` (week), `d` (day), `h` (hour), `m` (minute), `s` (second).
              
              Multiple pairs of `<number><time_unit>` may be provided, and they may be in any order. For example,
        `-2w5d3h` points to the moment in time 2 weeks, 5 days and 3 hours ago.

        - `literal_time_range` - (Block List, Optional) Time in literal format.
            - `range_name` - (Required) One of `now`, `second`, `minute`, `hour`, `day`, `today`, `week`, `month`, `year`.

        ### Schema for `panel`
        - `text_panel` - (Block List, Max: 1, Optional) A text panel. See text_panel schema for details.
        - `sumo_search_panel` - (Block List, Max: 1, Optional) A search panel. See sumo_search_panel schema
          for details.

        ### Schema for `text_panel`
        - `key` - (Required) Key for the panel. Used to create searches for the queries in the panel and configure the layout
          of the panel in the dashboard.
        - `title` - (Optional) Title of the panel.
        - `visual_settings` - (Optional) Visual settings of the panel.
        - `keep_visual_settings_consistent_with_parent` - (Optional) Keeps the visual settings, like series colors, consistent
          with the settings of the parent panel.
        - `text` - (Required) Text to display in the panel.

        ### Schema for `sumo_search_panel`
        - `key` - (Required) Key for the panel. Used to create searches for the queries in the panel and configure the layout
          of the panel in the dashboard.
        - `title` - (Optional) Title of the panel.
        - `visual_settings` - (Optional) Visual settings of the panel.
        - `keep_visual_settings_consistent_with_parent` - (Optional) Keeps the visual settings, like series colors, consistent
          with the settings of the parent panel.
        - `query` - (Block List, Required) A list of queries for the panel. Can be log or metric query. See
          query schema for details.
        - `description` - (Optional) Description of the panel.
        - `time_range` - (Block List, Max: 1, Optional) Time range of the panel. See time_range schema
          for details.
        - `linked_dashboard` - (Block List, Optional) A list of linked dashboards. See
          linked_dashboard schema for details.

        ### Schema for `query`
        - `query_string` - (Required) The metrics or logs query.
        - `query_type` - (Required) The type of the query. One of `Metrics` or `Logs`.
        - `query_key` - (Required) The key for metric or log query. Used as an identifier for queries.
        - `metric_query_mode` - (Optional) _Should only be specified for metric query_. The mode of the metric query.
          One of `Basic` or `Advanced`.
        - `metric_query_data` - (Optional) _Should only be specified for metric query_. Data format for the metric query. See
          metric_query_data schema for details.

        ### Schema for `metric_query_data`
        - `metric` - (Required) The metric of the query.
        - `aggregation_type` - (Optional) The type of aggregation. One of `Count`, `Minimum`, `Maximum`, `Sum`, `Average`, `None`.
        - `group_by` - The field to group the results by.
        - `filter` - (Block List, Required) A list of filters for the metrics query.
            - `key` - (Required) The key of the metrics filter.
            - `value` - (Required) The value of the metrics filter.
            - `negation` - (Optional) Whether or not the metrics filter is negated.
        - `operator` - (Block List, Optional) A list of operator data for the metrics query.

        ### Schema for `operator`
        - `operator_name` - (Required) The name of the metrics operator.
        - `parameter` - (Block List, Required) A list of operator parameters for the operator data.
            - `key` - (Required) The key of the operator parameter.
            - `value` - (Required) The value of the operator parameter.

        ### Schema for `linked_dashboard`
        - `id` - (Required) Identifier of the linked dashboard.
        - `relative_path` - (Optional) Relative path of the linked dashboard to the dashboard of the linking panel.
        - `include_time_range` - (Optional) Include time range from the current dashboard to the linked dashboard. _Defaults to true_.
        - `include_variables` - (Optional) Include variables from the current dashboard to the linked dashboard. _Defaults to true_.

        ### Schema for `layout`
        - `grid` - (Block List, Max: 1, Optional) Panel layout for the dashboard.

        ### Schema for `grid`
        - `layout_structure` - (Block List, Required) Layout structure for the panels in the dashboard.
            - `key` - (Required) The identifier of the panel that this structure applies to. It's same as `panel.key`.
            - `structure` - (Required) The structure of the panel.

        ### Schema for `variable`
        - `name` - (Required) Name of the variable. The variable name is case-insensitive.
        - `display_name` - (Optional) Display name of the variable shown in the UI. If this field is empty, the name field will be used.
        - `default_value` - (Optional) Default value of the variable.
        - `source_definition` - (Required) Source definition for variable values. See
          source_definition schema for details.
        - `allow_multi_select` - (Optional) Allow multiple selections in the values dropdown.
        - `include_all_option` - (Optional) Include an "All" option at the top of the variable's values dropdown. _Defaults to true._
        - `hide_from_ui` - (Optional) Hide the variable in the dashboard UI.

        ### Schema for `source_definition`
        - `log_query_variable_source_definition` - (Optional) Variable values from a log query.
            - `query` - (Required) A log query.
            - `field` - (Required) A field in log query to populate the variable values
        - `metadata_variable_source_definition` - (Optional) Variable values from a metric query.
            - `filter` - (Required) Filter to search the catalog.
            - `key` - (Required) Return the values for this given key.
        - `csv_variable_source_definition` - (Optional) Variable values in csv format.
            - `values` - (Required) A comma separated values for the variable.

        ## Import

        Dashboard can be imported using the dashboard id, e.g.hcl

        ```sh
         $ pulumi import sumologic:index/dashboard:Dashboard example-dashboard q0IKwAK5t2qRI4sgiANwnS87k5S4twN2sCpTuZFSsz6ZmbENPsG7PnpqZygc
        ```

         [1]https://help.sumologic.com/Visualizations-and-Alerts/Dashboard_(New)

        :param str resource_name: The name of the resource.
        :param DashboardArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DashboardArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            DashboardArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 coloring_rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DashboardColoringRuleArgs']]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 layout: Optional[pulumi.Input[pulumi.InputType['DashboardLayoutArgs']]] = None,
                 panels: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DashboardPanelArgs']]]]] = None,
                 refresh_interval: Optional[pulumi.Input[int]] = None,
                 theme: Optional[pulumi.Input[str]] = None,
                 time_range: Optional[pulumi.Input[pulumi.InputType['DashboardTimeRangeArgs']]] = None,
                 title: Optional[pulumi.Input[str]] = None,
                 topology_label_map: Optional[pulumi.Input[pulumi.InputType['DashboardTopologyLabelMapArgs']]] = None,
                 variables: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DashboardVariableArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DashboardArgs.__new__(DashboardArgs)

            __props__.__dict__["coloring_rules"] = coloring_rules
            __props__.__dict__["description"] = description
            __props__.__dict__["domain"] = domain
            __props__.__dict__["folder_id"] = folder_id
            if layout is not None and not isinstance(layout, DashboardLayoutArgs):
                layout = layout or {}
                def _setter(key, value):
                    layout[key] = value
                DashboardLayoutArgs._configure(_setter, **layout)
            __props__.__dict__["layout"] = layout
            __props__.__dict__["panels"] = panels
            __props__.__dict__["refresh_interval"] = refresh_interval
            __props__.__dict__["theme"] = theme
            if time_range is not None and not isinstance(time_range, DashboardTimeRangeArgs):
                time_range = time_range or {}
                def _setter(key, value):
                    time_range[key] = value
                DashboardTimeRangeArgs._configure(_setter, **time_range)
            if time_range is None and not opts.urn:
                raise TypeError("Missing required property 'time_range'")
            __props__.__dict__["time_range"] = time_range
            if title is None and not opts.urn:
                raise TypeError("Missing required property 'title'")
            __props__.__dict__["title"] = title
            if topology_label_map is not None and not isinstance(topology_label_map, DashboardTopologyLabelMapArgs):
                topology_label_map = topology_label_map or {}
                def _setter(key, value):
                    topology_label_map[key] = value
                DashboardTopologyLabelMapArgs._configure(_setter, **topology_label_map)
            __props__.__dict__["topology_label_map"] = topology_label_map
            __props__.__dict__["variables"] = variables
        super(Dashboard, __self__).__init__(
            'sumologic:index/dashboard:Dashboard',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            coloring_rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DashboardColoringRuleArgs']]]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            domain: Optional[pulumi.Input[str]] = None,
            folder_id: Optional[pulumi.Input[str]] = None,
            layout: Optional[pulumi.Input[pulumi.InputType['DashboardLayoutArgs']]] = None,
            panels: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DashboardPanelArgs']]]]] = None,
            refresh_interval: Optional[pulumi.Input[int]] = None,
            theme: Optional[pulumi.Input[str]] = None,
            time_range: Optional[pulumi.Input[pulumi.InputType['DashboardTimeRangeArgs']]] = None,
            title: Optional[pulumi.Input[str]] = None,
            topology_label_map: Optional[pulumi.Input[pulumi.InputType['DashboardTopologyLabelMapArgs']]] = None,
            variables: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DashboardVariableArgs']]]]] = None) -> 'Dashboard':
        """
        Get an existing Dashboard resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Description of the dashboard.
        :param pulumi.Input[str] domain: Domain of the dashboard. If set denotes that the dashboard concerns a given domain.
        :param pulumi.Input[str] folder_id: The identifier of the folder to save the dashboard in. By default it is saved in your
               personal folder.
        :param pulumi.Input[pulumi.InputType['DashboardLayoutArgs']] layout: Layout of the dashboard. See layout schema for details.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DashboardPanelArgs']]]] panels: A list of panels in the dashboard. See panel schema for details.
        :param pulumi.Input[int] refresh_interval: Interval of time (in seconds) to automatically refresh the dashboard. Valid values are 120,300,900,1800,3600,7200,86400.
        :param pulumi.Input[str] theme: Theme of the dashboard.
        :param pulumi.Input[pulumi.InputType['DashboardTimeRangeArgs']] time_range: Time range of the dashboard. See time range schema
               for details.
        :param pulumi.Input[str] title: Title of the dashboard.
        :param pulumi.Input[pulumi.InputType['DashboardTopologyLabelMapArgs']] topology_label_map: Topology labels for the dashboard. See
               topology label map schema
               for details.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DashboardVariableArgs']]]] variables: A list of variables for the dashboard. See variable schema
               for details.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DashboardState.__new__(_DashboardState)

        __props__.__dict__["coloring_rules"] = coloring_rules
        __props__.__dict__["description"] = description
        __props__.__dict__["domain"] = domain
        __props__.__dict__["folder_id"] = folder_id
        __props__.__dict__["layout"] = layout
        __props__.__dict__["panels"] = panels
        __props__.__dict__["refresh_interval"] = refresh_interval
        __props__.__dict__["theme"] = theme
        __props__.__dict__["time_range"] = time_range
        __props__.__dict__["title"] = title
        __props__.__dict__["topology_label_map"] = topology_label_map
        __props__.__dict__["variables"] = variables
        return Dashboard(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="coloringRules")
    def coloring_rules(self) -> pulumi.Output[Optional[Sequence['outputs.DashboardColoringRule']]]:
        return pulumi.get(self, "coloring_rules")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Description of the dashboard.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def domain(self) -> pulumi.Output[Optional[str]]:
        """
        Domain of the dashboard. If set denotes that the dashboard concerns a given domain.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> pulumi.Output[Optional[str]]:
        """
        The identifier of the folder to save the dashboard in. By default it is saved in your
        personal folder.
        """
        return pulumi.get(self, "folder_id")

    @property
    @pulumi.getter
    def layout(self) -> pulumi.Output[Optional['outputs.DashboardLayout']]:
        """
        Layout of the dashboard. See layout schema for details.
        """
        return pulumi.get(self, "layout")

    @property
    @pulumi.getter
    def panels(self) -> pulumi.Output[Optional[Sequence['outputs.DashboardPanel']]]:
        """
        A list of panels in the dashboard. See panel schema for details.
        """
        return pulumi.get(self, "panels")

    @property
    @pulumi.getter(name="refreshInterval")
    def refresh_interval(self) -> pulumi.Output[Optional[int]]:
        """
        Interval of time (in seconds) to automatically refresh the dashboard. Valid values are 120,300,900,1800,3600,7200,86400.
        """
        return pulumi.get(self, "refresh_interval")

    @property
    @pulumi.getter
    def theme(self) -> pulumi.Output[Optional[str]]:
        """
        Theme of the dashboard.
        """
        return pulumi.get(self, "theme")

    @property
    @pulumi.getter(name="timeRange")
    def time_range(self) -> pulumi.Output['outputs.DashboardTimeRange']:
        """
        Time range of the dashboard. See time range schema
        for details.
        """
        return pulumi.get(self, "time_range")

    @property
    @pulumi.getter
    def title(self) -> pulumi.Output[str]:
        """
        Title of the dashboard.
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter(name="topologyLabelMap")
    def topology_label_map(self) -> pulumi.Output[Optional['outputs.DashboardTopologyLabelMap']]:
        """
        Topology labels for the dashboard. See
        topology label map schema
        for details.
        """
        return pulumi.get(self, "topology_label_map")

    @property
    @pulumi.getter
    def variables(self) -> pulumi.Output[Optional[Sequence['outputs.DashboardVariable']]]:
        """
        A list of variables for the dashboard. See variable schema
        for details.
        """
        return pulumi.get(self, "variables")

