# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['InstalledCollectorArgs', 'InstalledCollector']

@pulumi.input_type
class InstalledCollectorArgs:
    def __init__(__self__, *,
                 ephemeral: pulumi.Input[bool],
                 category: Optional[pulumi.Input[str]] = None,
                 cutoff_timestamp: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 fields: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 host_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 source_sync_mode: Optional[pulumi.Input[str]] = None,
                 target_cpu: Optional[pulumi.Input[int]] = None,
                 timezone: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a InstalledCollector resource.
        :param pulumi.Input[bool] ephemeral: When true, the collector will be deleted after 12 hours of inactivity. For more information, see [Setting a Collector as Ephemeral][5].
        :param pulumi.Input[str] category: The default source category for any source attached to this collector. Can be overridden in the configuration of said sources.
        :param pulumi.Input[str] description: The description of the collector.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] fields: Map containing [key/value pairs][3].
        :param pulumi.Input[str] host_name: Host name of the Collector. The hostname can be a maximum of 128 characters.
        :param pulumi.Input[str] name: The name of the collector. This is required, and has to be unique. Changing this will force recreation the collector.
        :param pulumi.Input[str] source_sync_mode: For installed Collectors, whether the Collector is using local source configuration management (using a JSON file), or cloud management (using the UI)
        :param pulumi.Input[int] target_cpu: When CPU utilization exceeds this threshold, the Collector will slow down its rate of ingestion to lower its CPU utilization. Currently only Local and Remote File Sources are supported.
        :param pulumi.Input[str] timezone: The time zone to use for this collector. The value follows the [tzdata](https://en.wikipedia.org/wiki/Tz_database) naming convention.
        """
        InstalledCollectorArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            ephemeral=ephemeral,
            category=category,
            cutoff_timestamp=cutoff_timestamp,
            description=description,
            fields=fields,
            host_name=host_name,
            name=name,
            source_sync_mode=source_sync_mode,
            target_cpu=target_cpu,
            timezone=timezone,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             ephemeral: pulumi.Input[bool],
             category: Optional[pulumi.Input[str]] = None,
             cutoff_timestamp: Optional[pulumi.Input[int]] = None,
             description: Optional[pulumi.Input[str]] = None,
             fields: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
             host_name: Optional[pulumi.Input[str]] = None,
             name: Optional[pulumi.Input[str]] = None,
             source_sync_mode: Optional[pulumi.Input[str]] = None,
             target_cpu: Optional[pulumi.Input[int]] = None,
             timezone: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("ephemeral", ephemeral)
        if category is not None:
            _setter("category", category)
        if cutoff_timestamp is not None:
            _setter("cutoff_timestamp", cutoff_timestamp)
        if description is not None:
            _setter("description", description)
        if fields is not None:
            _setter("fields", fields)
        if host_name is not None:
            _setter("host_name", host_name)
        if name is not None:
            _setter("name", name)
        if source_sync_mode is not None:
            _setter("source_sync_mode", source_sync_mode)
        if target_cpu is not None:
            _setter("target_cpu", target_cpu)
        if timezone is not None:
            _setter("timezone", timezone)

    @property
    @pulumi.getter
    def ephemeral(self) -> pulumi.Input[bool]:
        """
        When true, the collector will be deleted after 12 hours of inactivity. For more information, see [Setting a Collector as Ephemeral][5].
        """
        return pulumi.get(self, "ephemeral")

    @ephemeral.setter
    def ephemeral(self, value: pulumi.Input[bool]):
        pulumi.set(self, "ephemeral", value)

    @property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input[str]]:
        """
        The default source category for any source attached to this collector. Can be overridden in the configuration of said sources.
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "category", value)

    @property
    @pulumi.getter(name="cutoffTimestamp")
    def cutoff_timestamp(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "cutoff_timestamp")

    @cutoff_timestamp.setter
    def cutoff_timestamp(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cutoff_timestamp", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the collector.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def fields(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map containing [key/value pairs][3].
        """
        return pulumi.get(self, "fields")

    @fields.setter
    def fields(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "fields", value)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[pulumi.Input[str]]:
        """
        Host name of the Collector. The hostname can be a maximum of 128 characters.
        """
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the collector. This is required, and has to be unique. Changing this will force recreation the collector.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="sourceSyncMode")
    def source_sync_mode(self) -> Optional[pulumi.Input[str]]:
        """
        For installed Collectors, whether the Collector is using local source configuration management (using a JSON file), or cloud management (using the UI)
        """
        return pulumi.get(self, "source_sync_mode")

    @source_sync_mode.setter
    def source_sync_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_sync_mode", value)

    @property
    @pulumi.getter(name="targetCpu")
    def target_cpu(self) -> Optional[pulumi.Input[int]]:
        """
        When CPU utilization exceeds this threshold, the Collector will slow down its rate of ingestion to lower its CPU utilization. Currently only Local and Remote File Sources are supported.
        """
        return pulumi.get(self, "target_cpu")

    @target_cpu.setter
    def target_cpu(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "target_cpu", value)

    @property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[str]]:
        """
        The time zone to use for this collector. The value follows the [tzdata](https://en.wikipedia.org/wiki/Tz_database) naming convention.
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timezone", value)


@pulumi.input_type
class _InstalledCollectorState:
    def __init__(__self__, *,
                 alive: Optional[pulumi.Input[bool]] = None,
                 category: Optional[pulumi.Input[str]] = None,
                 collector_version: Optional[pulumi.Input[str]] = None,
                 cutoff_timestamp: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 ephemeral: Optional[pulumi.Input[bool]] = None,
                 fields: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 host_name: Optional[pulumi.Input[str]] = None,
                 last_seen_alive: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 source_sync_mode: Optional[pulumi.Input[str]] = None,
                 target_cpu: Optional[pulumi.Input[int]] = None,
                 timezone: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering InstalledCollector resources.
        :param pulumi.Input[str] category: The default source category for any source attached to this collector. Can be overridden in the configuration of said sources.
        :param pulumi.Input[str] description: The description of the collector.
        :param pulumi.Input[bool] ephemeral: When true, the collector will be deleted after 12 hours of inactivity. For more information, see [Setting a Collector as Ephemeral][5].
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] fields: Map containing [key/value pairs][3].
        :param pulumi.Input[str] host_name: Host name of the Collector. The hostname can be a maximum of 128 characters.
        :param pulumi.Input[str] name: The name of the collector. This is required, and has to be unique. Changing this will force recreation the collector.
        :param pulumi.Input[str] source_sync_mode: For installed Collectors, whether the Collector is using local source configuration management (using a JSON file), or cloud management (using the UI)
        :param pulumi.Input[int] target_cpu: When CPU utilization exceeds this threshold, the Collector will slow down its rate of ingestion to lower its CPU utilization. Currently only Local and Remote File Sources are supported.
        :param pulumi.Input[str] timezone: The time zone to use for this collector. The value follows the [tzdata](https://en.wikipedia.org/wiki/Tz_database) naming convention.
        """
        _InstalledCollectorState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            alive=alive,
            category=category,
            collector_version=collector_version,
            cutoff_timestamp=cutoff_timestamp,
            description=description,
            ephemeral=ephemeral,
            fields=fields,
            host_name=host_name,
            last_seen_alive=last_seen_alive,
            name=name,
            source_sync_mode=source_sync_mode,
            target_cpu=target_cpu,
            timezone=timezone,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             alive: Optional[pulumi.Input[bool]] = None,
             category: Optional[pulumi.Input[str]] = None,
             collector_version: Optional[pulumi.Input[str]] = None,
             cutoff_timestamp: Optional[pulumi.Input[int]] = None,
             description: Optional[pulumi.Input[str]] = None,
             ephemeral: Optional[pulumi.Input[bool]] = None,
             fields: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
             host_name: Optional[pulumi.Input[str]] = None,
             last_seen_alive: Optional[pulumi.Input[int]] = None,
             name: Optional[pulumi.Input[str]] = None,
             source_sync_mode: Optional[pulumi.Input[str]] = None,
             target_cpu: Optional[pulumi.Input[int]] = None,
             timezone: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if alive is not None:
            _setter("alive", alive)
        if category is not None:
            _setter("category", category)
        if collector_version is not None:
            _setter("collector_version", collector_version)
        if cutoff_timestamp is not None:
            _setter("cutoff_timestamp", cutoff_timestamp)
        if description is not None:
            _setter("description", description)
        if ephemeral is not None:
            _setter("ephemeral", ephemeral)
        if fields is not None:
            _setter("fields", fields)
        if host_name is not None:
            _setter("host_name", host_name)
        if last_seen_alive is not None:
            _setter("last_seen_alive", last_seen_alive)
        if name is not None:
            _setter("name", name)
        if source_sync_mode is not None:
            _setter("source_sync_mode", source_sync_mode)
        if target_cpu is not None:
            _setter("target_cpu", target_cpu)
        if timezone is not None:
            _setter("timezone", timezone)

    @property
    @pulumi.getter
    def alive(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "alive")

    @alive.setter
    def alive(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "alive", value)

    @property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input[str]]:
        """
        The default source category for any source attached to this collector. Can be overridden in the configuration of said sources.
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "category", value)

    @property
    @pulumi.getter(name="collectorVersion")
    def collector_version(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "collector_version")

    @collector_version.setter
    def collector_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "collector_version", value)

    @property
    @pulumi.getter(name="cutoffTimestamp")
    def cutoff_timestamp(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "cutoff_timestamp")

    @cutoff_timestamp.setter
    def cutoff_timestamp(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cutoff_timestamp", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the collector.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def ephemeral(self) -> Optional[pulumi.Input[bool]]:
        """
        When true, the collector will be deleted after 12 hours of inactivity. For more information, see [Setting a Collector as Ephemeral][5].
        """
        return pulumi.get(self, "ephemeral")

    @ephemeral.setter
    def ephemeral(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ephemeral", value)

    @property
    @pulumi.getter
    def fields(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map containing [key/value pairs][3].
        """
        return pulumi.get(self, "fields")

    @fields.setter
    def fields(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "fields", value)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[pulumi.Input[str]]:
        """
        Host name of the Collector. The hostname can be a maximum of 128 characters.
        """
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_name", value)

    @property
    @pulumi.getter(name="lastSeenAlive")
    def last_seen_alive(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "last_seen_alive")

    @last_seen_alive.setter
    def last_seen_alive(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "last_seen_alive", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the collector. This is required, and has to be unique. Changing this will force recreation the collector.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="sourceSyncMode")
    def source_sync_mode(self) -> Optional[pulumi.Input[str]]:
        """
        For installed Collectors, whether the Collector is using local source configuration management (using a JSON file), or cloud management (using the UI)
        """
        return pulumi.get(self, "source_sync_mode")

    @source_sync_mode.setter
    def source_sync_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_sync_mode", value)

    @property
    @pulumi.getter(name="targetCpu")
    def target_cpu(self) -> Optional[pulumi.Input[int]]:
        """
        When CPU utilization exceeds this threshold, the Collector will slow down its rate of ingestion to lower its CPU utilization. Currently only Local and Remote File Sources are supported.
        """
        return pulumi.get(self, "target_cpu")

    @target_cpu.setter
    def target_cpu(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "target_cpu", value)

    @property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[str]]:
        """
        The time zone to use for this collector. The value follows the [tzdata](https://en.wikipedia.org/wiki/Tz_database) naming convention.
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timezone", value)


class InstalledCollector(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 category: Optional[pulumi.Input[str]] = None,
                 cutoff_timestamp: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 ephemeral: Optional[pulumi.Input[bool]] = None,
                 fields: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 host_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 source_sync_mode: Optional[pulumi.Input[str]] = None,
                 target_cpu: Optional[pulumi.Input[int]] = None,
                 timezone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_sumologic as sumologic

        installed_collector = sumologic.InstalledCollector("installedCollector",
            category="macos/test",
            ephemeral=True,
            fields={
                "key": "value",
            })
        ```

        ## Import

        Collectors can be imported using the collector id, e.g.hcl

        ```sh
         $ pulumi import sumologic:index/installedCollector:InstalledCollector test 1234567890
        ```

         Collectors can also be imported using the collector name, which is unique per Sumo Logic account, e.g.hcl

        ```sh
         $ pulumi import sumologic:index/installedCollector:InstalledCollector test my_test_collector
        ```

         [1]https://help.sumologic.com/03Send-Data/Installed-Collectors/01About-Installed-Collectors [2]https://en.wikipedia.org/wiki/Tz_database [3]https://help.sumologic.com/Manage/Fields [4]https://www.terraform.io/docs/configuration/resources.html#prevent_destroy [5]:https://help.sumologic.com/03Send-Data/Installed-Collectors/05Reference-Information-for-Collector-Installation/11Set-a-Collector-as-Ephemeral

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] category: The default source category for any source attached to this collector. Can be overridden in the configuration of said sources.
        :param pulumi.Input[str] description: The description of the collector.
        :param pulumi.Input[bool] ephemeral: When true, the collector will be deleted after 12 hours of inactivity. For more information, see [Setting a Collector as Ephemeral][5].
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] fields: Map containing [key/value pairs][3].
        :param pulumi.Input[str] host_name: Host name of the Collector. The hostname can be a maximum of 128 characters.
        :param pulumi.Input[str] name: The name of the collector. This is required, and has to be unique. Changing this will force recreation the collector.
        :param pulumi.Input[str] source_sync_mode: For installed Collectors, whether the Collector is using local source configuration management (using a JSON file), or cloud management (using the UI)
        :param pulumi.Input[int] target_cpu: When CPU utilization exceeds this threshold, the Collector will slow down its rate of ingestion to lower its CPU utilization. Currently only Local and Remote File Sources are supported.
        :param pulumi.Input[str] timezone: The time zone to use for this collector. The value follows the [tzdata](https://en.wikipedia.org/wiki/Tz_database) naming convention.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstalledCollectorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_sumologic as sumologic

        installed_collector = sumologic.InstalledCollector("installedCollector",
            category="macos/test",
            ephemeral=True,
            fields={
                "key": "value",
            })
        ```

        ## Import

        Collectors can be imported using the collector id, e.g.hcl

        ```sh
         $ pulumi import sumologic:index/installedCollector:InstalledCollector test 1234567890
        ```

         Collectors can also be imported using the collector name, which is unique per Sumo Logic account, e.g.hcl

        ```sh
         $ pulumi import sumologic:index/installedCollector:InstalledCollector test my_test_collector
        ```

         [1]https://help.sumologic.com/03Send-Data/Installed-Collectors/01About-Installed-Collectors [2]https://en.wikipedia.org/wiki/Tz_database [3]https://help.sumologic.com/Manage/Fields [4]https://www.terraform.io/docs/configuration/resources.html#prevent_destroy [5]:https://help.sumologic.com/03Send-Data/Installed-Collectors/05Reference-Information-for-Collector-Installation/11Set-a-Collector-as-Ephemeral

        :param str resource_name: The name of the resource.
        :param InstalledCollectorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstalledCollectorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            InstalledCollectorArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 category: Optional[pulumi.Input[str]] = None,
                 cutoff_timestamp: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 ephemeral: Optional[pulumi.Input[bool]] = None,
                 fields: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 host_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 source_sync_mode: Optional[pulumi.Input[str]] = None,
                 target_cpu: Optional[pulumi.Input[int]] = None,
                 timezone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstalledCollectorArgs.__new__(InstalledCollectorArgs)

            __props__.__dict__["category"] = category
            __props__.__dict__["cutoff_timestamp"] = cutoff_timestamp
            __props__.__dict__["description"] = description
            if ephemeral is None and not opts.urn:
                raise TypeError("Missing required property 'ephemeral'")
            __props__.__dict__["ephemeral"] = ephemeral
            __props__.__dict__["fields"] = fields
            __props__.__dict__["host_name"] = host_name
            __props__.__dict__["name"] = name
            __props__.__dict__["source_sync_mode"] = source_sync_mode
            __props__.__dict__["target_cpu"] = target_cpu
            __props__.__dict__["timezone"] = timezone
            __props__.__dict__["alive"] = None
            __props__.__dict__["collector_version"] = None
            __props__.__dict__["last_seen_alive"] = None
        super(InstalledCollector, __self__).__init__(
            'sumologic:index/installedCollector:InstalledCollector',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alive: Optional[pulumi.Input[bool]] = None,
            category: Optional[pulumi.Input[str]] = None,
            collector_version: Optional[pulumi.Input[str]] = None,
            cutoff_timestamp: Optional[pulumi.Input[int]] = None,
            description: Optional[pulumi.Input[str]] = None,
            ephemeral: Optional[pulumi.Input[bool]] = None,
            fields: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            host_name: Optional[pulumi.Input[str]] = None,
            last_seen_alive: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            source_sync_mode: Optional[pulumi.Input[str]] = None,
            target_cpu: Optional[pulumi.Input[int]] = None,
            timezone: Optional[pulumi.Input[str]] = None) -> 'InstalledCollector':
        """
        Get an existing InstalledCollector resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] category: The default source category for any source attached to this collector. Can be overridden in the configuration of said sources.
        :param pulumi.Input[str] description: The description of the collector.
        :param pulumi.Input[bool] ephemeral: When true, the collector will be deleted after 12 hours of inactivity. For more information, see [Setting a Collector as Ephemeral][5].
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] fields: Map containing [key/value pairs][3].
        :param pulumi.Input[str] host_name: Host name of the Collector. The hostname can be a maximum of 128 characters.
        :param pulumi.Input[str] name: The name of the collector. This is required, and has to be unique. Changing this will force recreation the collector.
        :param pulumi.Input[str] source_sync_mode: For installed Collectors, whether the Collector is using local source configuration management (using a JSON file), or cloud management (using the UI)
        :param pulumi.Input[int] target_cpu: When CPU utilization exceeds this threshold, the Collector will slow down its rate of ingestion to lower its CPU utilization. Currently only Local and Remote File Sources are supported.
        :param pulumi.Input[str] timezone: The time zone to use for this collector. The value follows the [tzdata](https://en.wikipedia.org/wiki/Tz_database) naming convention.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstalledCollectorState.__new__(_InstalledCollectorState)

        __props__.__dict__["alive"] = alive
        __props__.__dict__["category"] = category
        __props__.__dict__["collector_version"] = collector_version
        __props__.__dict__["cutoff_timestamp"] = cutoff_timestamp
        __props__.__dict__["description"] = description
        __props__.__dict__["ephemeral"] = ephemeral
        __props__.__dict__["fields"] = fields
        __props__.__dict__["host_name"] = host_name
        __props__.__dict__["last_seen_alive"] = last_seen_alive
        __props__.__dict__["name"] = name
        __props__.__dict__["source_sync_mode"] = source_sync_mode
        __props__.__dict__["target_cpu"] = target_cpu
        __props__.__dict__["timezone"] = timezone
        return InstalledCollector(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def alive(self) -> pulumi.Output[bool]:
        return pulumi.get(self, "alive")

    @property
    @pulumi.getter
    def category(self) -> pulumi.Output[Optional[str]]:
        """
        The default source category for any source attached to this collector. Can be overridden in the configuration of said sources.
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter(name="collectorVersion")
    def collector_version(self) -> pulumi.Output[str]:
        return pulumi.get(self, "collector_version")

    @property
    @pulumi.getter(name="cutoffTimestamp")
    def cutoff_timestamp(self) -> pulumi.Output[Optional[int]]:
        return pulumi.get(self, "cutoff_timestamp")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the collector.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def ephemeral(self) -> pulumi.Output[bool]:
        """
        When true, the collector will be deleted after 12 hours of inactivity. For more information, see [Setting a Collector as Ephemeral][5].
        """
        return pulumi.get(self, "ephemeral")

    @property
    @pulumi.getter
    def fields(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Map containing [key/value pairs][3].
        """
        return pulumi.get(self, "fields")

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> pulumi.Output[Optional[str]]:
        """
        Host name of the Collector. The hostname can be a maximum of 128 characters.
        """
        return pulumi.get(self, "host_name")

    @property
    @pulumi.getter(name="lastSeenAlive")
    def last_seen_alive(self) -> pulumi.Output[int]:
        return pulumi.get(self, "last_seen_alive")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the collector. This is required, and has to be unique. Changing this will force recreation the collector.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sourceSyncMode")
    def source_sync_mode(self) -> pulumi.Output[Optional[str]]:
        """
        For installed Collectors, whether the Collector is using local source configuration management (using a JSON file), or cloud management (using the UI)
        """
        return pulumi.get(self, "source_sync_mode")

    @property
    @pulumi.getter(name="targetCpu")
    def target_cpu(self) -> pulumi.Output[Optional[int]]:
        """
        When CPU utilization exceeds this threshold, the Collector will slow down its rate of ingestion to lower its CPU utilization. Currently only Local and Remote File Sources are supported.
        """
        return pulumi.get(self, "target_cpu")

    @property
    @pulumi.getter
    def timezone(self) -> pulumi.Output[Optional[str]]:
        """
        The time zone to use for this collector. The value follows the [tzdata](https://en.wikipedia.org/wiki/Tz_database) naming convention.
        """
        return pulumi.get(self, "timezone")

