# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['KinesisMetricsSourceArgs', 'KinesisMetricsSource']

@pulumi.input_type
class KinesisMetricsSourceArgs:
    def __init__(__self__, *,
                 authentication: pulumi.Input['KinesisMetricsSourceAuthenticationArgs'],
                 collector_id: pulumi.Input[int],
                 content_type: pulumi.Input[str],
                 path: pulumi.Input['KinesisMetricsSourcePathArgs'],
                 automatic_date_parsing: Optional[pulumi.Input[bool]] = None,
                 category: Optional[pulumi.Input[str]] = None,
                 cutoff_relative_time: Optional[pulumi.Input[str]] = None,
                 cutoff_timestamp: Optional[pulumi.Input[int]] = None,
                 default_date_formats: Optional[pulumi.Input[Sequence[pulumi.Input['KinesisMetricsSourceDefaultDateFormatArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 fields: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 filters: Optional[pulumi.Input[Sequence[pulumi.Input['KinesisMetricsSourceFilterArgs']]]] = None,
                 force_timezone: Optional[pulumi.Input[bool]] = None,
                 host_name: Optional[pulumi.Input[str]] = None,
                 manual_prefix_regexp: Optional[pulumi.Input[str]] = None,
                 message_per_request: Optional[pulumi.Input[bool]] = None,
                 multiline_processing_enabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 timezone: Optional[pulumi.Input[str]] = None,
                 use_autoline_matching: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a KinesisMetricsSource resource.
        :param pulumi.Input['KinesisMetricsSourceAuthenticationArgs'] authentication: Authentication details for connecting to the S3 bucket.
        :param pulumi.Input[str] content_type: The content-type of the collected data. Details can be found in the [Sumologic documentation for hosted sources](https://help.sumologic.com/Send_Data/Sources/03Use_JSON_to_Configure_Sources/JSON_Parameters_for_Hosted_Sources).
        :param pulumi.Input['KinesisMetricsSourcePathArgs'] path: The location to scan for new data.
        """
        KinesisMetricsSourceArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            authentication=authentication,
            collector_id=collector_id,
            content_type=content_type,
            path=path,
            automatic_date_parsing=automatic_date_parsing,
            category=category,
            cutoff_relative_time=cutoff_relative_time,
            cutoff_timestamp=cutoff_timestamp,
            default_date_formats=default_date_formats,
            description=description,
            fields=fields,
            filters=filters,
            force_timezone=force_timezone,
            host_name=host_name,
            manual_prefix_regexp=manual_prefix_regexp,
            message_per_request=message_per_request,
            multiline_processing_enabled=multiline_processing_enabled,
            name=name,
            timezone=timezone,
            use_autoline_matching=use_autoline_matching,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             authentication: pulumi.Input['KinesisMetricsSourceAuthenticationArgs'],
             collector_id: pulumi.Input[int],
             content_type: pulumi.Input[str],
             path: pulumi.Input['KinesisMetricsSourcePathArgs'],
             automatic_date_parsing: Optional[pulumi.Input[bool]] = None,
             category: Optional[pulumi.Input[str]] = None,
             cutoff_relative_time: Optional[pulumi.Input[str]] = None,
             cutoff_timestamp: Optional[pulumi.Input[int]] = None,
             default_date_formats: Optional[pulumi.Input[Sequence[pulumi.Input['KinesisMetricsSourceDefaultDateFormatArgs']]]] = None,
             description: Optional[pulumi.Input[str]] = None,
             fields: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
             filters: Optional[pulumi.Input[Sequence[pulumi.Input['KinesisMetricsSourceFilterArgs']]]] = None,
             force_timezone: Optional[pulumi.Input[bool]] = None,
             host_name: Optional[pulumi.Input[str]] = None,
             manual_prefix_regexp: Optional[pulumi.Input[str]] = None,
             message_per_request: Optional[pulumi.Input[bool]] = None,
             multiline_processing_enabled: Optional[pulumi.Input[bool]] = None,
             name: Optional[pulumi.Input[str]] = None,
             timezone: Optional[pulumi.Input[str]] = None,
             use_autoline_matching: Optional[pulumi.Input[bool]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("authentication", authentication)
        _setter("collector_id", collector_id)
        _setter("content_type", content_type)
        _setter("path", path)
        if automatic_date_parsing is not None:
            _setter("automatic_date_parsing", automatic_date_parsing)
        if category is not None:
            _setter("category", category)
        if cutoff_relative_time is not None:
            _setter("cutoff_relative_time", cutoff_relative_time)
        if cutoff_timestamp is not None:
            _setter("cutoff_timestamp", cutoff_timestamp)
        if default_date_formats is not None:
            _setter("default_date_formats", default_date_formats)
        if description is not None:
            _setter("description", description)
        if fields is not None:
            _setter("fields", fields)
        if filters is not None:
            _setter("filters", filters)
        if force_timezone is not None:
            _setter("force_timezone", force_timezone)
        if host_name is not None:
            _setter("host_name", host_name)
        if manual_prefix_regexp is not None:
            _setter("manual_prefix_regexp", manual_prefix_regexp)
        if message_per_request is not None:
            _setter("message_per_request", message_per_request)
        if multiline_processing_enabled is not None:
            _setter("multiline_processing_enabled", multiline_processing_enabled)
        if name is not None:
            _setter("name", name)
        if timezone is not None:
            _setter("timezone", timezone)
        if use_autoline_matching is not None:
            _setter("use_autoline_matching", use_autoline_matching)

    @property
    @pulumi.getter
    def authentication(self) -> pulumi.Input['KinesisMetricsSourceAuthenticationArgs']:
        """
        Authentication details for connecting to the S3 bucket.
        """
        return pulumi.get(self, "authentication")

    @authentication.setter
    def authentication(self, value: pulumi.Input['KinesisMetricsSourceAuthenticationArgs']):
        pulumi.set(self, "authentication", value)

    @property
    @pulumi.getter(name="collectorId")
    def collector_id(self) -> pulumi.Input[int]:
        return pulumi.get(self, "collector_id")

    @collector_id.setter
    def collector_id(self, value: pulumi.Input[int]):
        pulumi.set(self, "collector_id", value)

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> pulumi.Input[str]:
        """
        The content-type of the collected data. Details can be found in the [Sumologic documentation for hosted sources](https://help.sumologic.com/Send_Data/Sources/03Use_JSON_to_Configure_Sources/JSON_Parameters_for_Hosted_Sources).
        """
        return pulumi.get(self, "content_type")

    @content_type.setter
    def content_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "content_type", value)

    @property
    @pulumi.getter
    def path(self) -> pulumi.Input['KinesisMetricsSourcePathArgs']:
        """
        The location to scan for new data.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input['KinesisMetricsSourcePathArgs']):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="automaticDateParsing")
    def automatic_date_parsing(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "automatic_date_parsing")

    @automatic_date_parsing.setter
    def automatic_date_parsing(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "automatic_date_parsing", value)

    @property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "category", value)

    @property
    @pulumi.getter(name="cutoffRelativeTime")
    def cutoff_relative_time(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "cutoff_relative_time")

    @cutoff_relative_time.setter
    def cutoff_relative_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cutoff_relative_time", value)

    @property
    @pulumi.getter(name="cutoffTimestamp")
    def cutoff_timestamp(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "cutoff_timestamp")

    @cutoff_timestamp.setter
    def cutoff_timestamp(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cutoff_timestamp", value)

    @property
    @pulumi.getter(name="defaultDateFormats")
    def default_date_formats(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KinesisMetricsSourceDefaultDateFormatArgs']]]]:
        return pulumi.get(self, "default_date_formats")

    @default_date_formats.setter
    def default_date_formats(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KinesisMetricsSourceDefaultDateFormatArgs']]]]):
        pulumi.set(self, "default_date_formats", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def fields(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "fields")

    @fields.setter
    def fields(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "fields", value)

    @property
    @pulumi.getter
    def filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KinesisMetricsSourceFilterArgs']]]]:
        return pulumi.get(self, "filters")

    @filters.setter
    def filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KinesisMetricsSourceFilterArgs']]]]):
        pulumi.set(self, "filters", value)

    @property
    @pulumi.getter(name="forceTimezone")
    def force_timezone(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "force_timezone")

    @force_timezone.setter
    def force_timezone(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_timezone", value)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_name", value)

    @property
    @pulumi.getter(name="manualPrefixRegexp")
    def manual_prefix_regexp(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "manual_prefix_regexp")

    @manual_prefix_regexp.setter
    def manual_prefix_regexp(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "manual_prefix_regexp", value)

    @property
    @pulumi.getter(name="messagePerRequest")
    def message_per_request(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "message_per_request")

    @message_per_request.setter
    def message_per_request(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "message_per_request", value)

    @property
    @pulumi.getter(name="multilineProcessingEnabled")
    def multiline_processing_enabled(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "multiline_processing_enabled")

    @multiline_processing_enabled.setter
    def multiline_processing_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "multiline_processing_enabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timezone", value)

    @property
    @pulumi.getter(name="useAutolineMatching")
    def use_autoline_matching(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "use_autoline_matching")

    @use_autoline_matching.setter
    def use_autoline_matching(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_autoline_matching", value)


@pulumi.input_type
class _KinesisMetricsSourceState:
    def __init__(__self__, *,
                 authentication: Optional[pulumi.Input['KinesisMetricsSourceAuthenticationArgs']] = None,
                 automatic_date_parsing: Optional[pulumi.Input[bool]] = None,
                 category: Optional[pulumi.Input[str]] = None,
                 collector_id: Optional[pulumi.Input[int]] = None,
                 content_type: Optional[pulumi.Input[str]] = None,
                 cutoff_relative_time: Optional[pulumi.Input[str]] = None,
                 cutoff_timestamp: Optional[pulumi.Input[int]] = None,
                 default_date_formats: Optional[pulumi.Input[Sequence[pulumi.Input['KinesisMetricsSourceDefaultDateFormatArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 fields: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 filters: Optional[pulumi.Input[Sequence[pulumi.Input['KinesisMetricsSourceFilterArgs']]]] = None,
                 force_timezone: Optional[pulumi.Input[bool]] = None,
                 host_name: Optional[pulumi.Input[str]] = None,
                 manual_prefix_regexp: Optional[pulumi.Input[str]] = None,
                 message_per_request: Optional[pulumi.Input[bool]] = None,
                 multiline_processing_enabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input['KinesisMetricsSourcePathArgs']] = None,
                 timezone: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None,
                 use_autoline_matching: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering KinesisMetricsSource resources.
        :param pulumi.Input['KinesisMetricsSourceAuthenticationArgs'] authentication: Authentication details for connecting to the S3 bucket.
        :param pulumi.Input[str] content_type: The content-type of the collected data. Details can be found in the [Sumologic documentation for hosted sources](https://help.sumologic.com/Send_Data/Sources/03Use_JSON_to_Configure_Sources/JSON_Parameters_for_Hosted_Sources).
        :param pulumi.Input['KinesisMetricsSourcePathArgs'] path: The location to scan for new data.
        :param pulumi.Input[str] url: The HTTP endpoint to used while creating Kinesis Firehose on AWS.
        """
        _KinesisMetricsSourceState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            authentication=authentication,
            automatic_date_parsing=automatic_date_parsing,
            category=category,
            collector_id=collector_id,
            content_type=content_type,
            cutoff_relative_time=cutoff_relative_time,
            cutoff_timestamp=cutoff_timestamp,
            default_date_formats=default_date_formats,
            description=description,
            fields=fields,
            filters=filters,
            force_timezone=force_timezone,
            host_name=host_name,
            manual_prefix_regexp=manual_prefix_regexp,
            message_per_request=message_per_request,
            multiline_processing_enabled=multiline_processing_enabled,
            name=name,
            path=path,
            timezone=timezone,
            url=url,
            use_autoline_matching=use_autoline_matching,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             authentication: Optional[pulumi.Input['KinesisMetricsSourceAuthenticationArgs']] = None,
             automatic_date_parsing: Optional[pulumi.Input[bool]] = None,
             category: Optional[pulumi.Input[str]] = None,
             collector_id: Optional[pulumi.Input[int]] = None,
             content_type: Optional[pulumi.Input[str]] = None,
             cutoff_relative_time: Optional[pulumi.Input[str]] = None,
             cutoff_timestamp: Optional[pulumi.Input[int]] = None,
             default_date_formats: Optional[pulumi.Input[Sequence[pulumi.Input['KinesisMetricsSourceDefaultDateFormatArgs']]]] = None,
             description: Optional[pulumi.Input[str]] = None,
             fields: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
             filters: Optional[pulumi.Input[Sequence[pulumi.Input['KinesisMetricsSourceFilterArgs']]]] = None,
             force_timezone: Optional[pulumi.Input[bool]] = None,
             host_name: Optional[pulumi.Input[str]] = None,
             manual_prefix_regexp: Optional[pulumi.Input[str]] = None,
             message_per_request: Optional[pulumi.Input[bool]] = None,
             multiline_processing_enabled: Optional[pulumi.Input[bool]] = None,
             name: Optional[pulumi.Input[str]] = None,
             path: Optional[pulumi.Input['KinesisMetricsSourcePathArgs']] = None,
             timezone: Optional[pulumi.Input[str]] = None,
             url: Optional[pulumi.Input[str]] = None,
             use_autoline_matching: Optional[pulumi.Input[bool]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if authentication is not None:
            _setter("authentication", authentication)
        if automatic_date_parsing is not None:
            _setter("automatic_date_parsing", automatic_date_parsing)
        if category is not None:
            _setter("category", category)
        if collector_id is not None:
            _setter("collector_id", collector_id)
        if content_type is not None:
            _setter("content_type", content_type)
        if cutoff_relative_time is not None:
            _setter("cutoff_relative_time", cutoff_relative_time)
        if cutoff_timestamp is not None:
            _setter("cutoff_timestamp", cutoff_timestamp)
        if default_date_formats is not None:
            _setter("default_date_formats", default_date_formats)
        if description is not None:
            _setter("description", description)
        if fields is not None:
            _setter("fields", fields)
        if filters is not None:
            _setter("filters", filters)
        if force_timezone is not None:
            _setter("force_timezone", force_timezone)
        if host_name is not None:
            _setter("host_name", host_name)
        if manual_prefix_regexp is not None:
            _setter("manual_prefix_regexp", manual_prefix_regexp)
        if message_per_request is not None:
            _setter("message_per_request", message_per_request)
        if multiline_processing_enabled is not None:
            _setter("multiline_processing_enabled", multiline_processing_enabled)
        if name is not None:
            _setter("name", name)
        if path is not None:
            _setter("path", path)
        if timezone is not None:
            _setter("timezone", timezone)
        if url is not None:
            _setter("url", url)
        if use_autoline_matching is not None:
            _setter("use_autoline_matching", use_autoline_matching)

    @property
    @pulumi.getter
    def authentication(self) -> Optional[pulumi.Input['KinesisMetricsSourceAuthenticationArgs']]:
        """
        Authentication details for connecting to the S3 bucket.
        """
        return pulumi.get(self, "authentication")

    @authentication.setter
    def authentication(self, value: Optional[pulumi.Input['KinesisMetricsSourceAuthenticationArgs']]):
        pulumi.set(self, "authentication", value)

    @property
    @pulumi.getter(name="automaticDateParsing")
    def automatic_date_parsing(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "automatic_date_parsing")

    @automatic_date_parsing.setter
    def automatic_date_parsing(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "automatic_date_parsing", value)

    @property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "category", value)

    @property
    @pulumi.getter(name="collectorId")
    def collector_id(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "collector_id")

    @collector_id.setter
    def collector_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "collector_id", value)

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[pulumi.Input[str]]:
        """
        The content-type of the collected data. Details can be found in the [Sumologic documentation for hosted sources](https://help.sumologic.com/Send_Data/Sources/03Use_JSON_to_Configure_Sources/JSON_Parameters_for_Hosted_Sources).
        """
        return pulumi.get(self, "content_type")

    @content_type.setter
    def content_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content_type", value)

    @property
    @pulumi.getter(name="cutoffRelativeTime")
    def cutoff_relative_time(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "cutoff_relative_time")

    @cutoff_relative_time.setter
    def cutoff_relative_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cutoff_relative_time", value)

    @property
    @pulumi.getter(name="cutoffTimestamp")
    def cutoff_timestamp(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "cutoff_timestamp")

    @cutoff_timestamp.setter
    def cutoff_timestamp(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cutoff_timestamp", value)

    @property
    @pulumi.getter(name="defaultDateFormats")
    def default_date_formats(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KinesisMetricsSourceDefaultDateFormatArgs']]]]:
        return pulumi.get(self, "default_date_formats")

    @default_date_formats.setter
    def default_date_formats(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KinesisMetricsSourceDefaultDateFormatArgs']]]]):
        pulumi.set(self, "default_date_formats", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def fields(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "fields")

    @fields.setter
    def fields(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "fields", value)

    @property
    @pulumi.getter
    def filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KinesisMetricsSourceFilterArgs']]]]:
        return pulumi.get(self, "filters")

    @filters.setter
    def filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KinesisMetricsSourceFilterArgs']]]]):
        pulumi.set(self, "filters", value)

    @property
    @pulumi.getter(name="forceTimezone")
    def force_timezone(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "force_timezone")

    @force_timezone.setter
    def force_timezone(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_timezone", value)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_name", value)

    @property
    @pulumi.getter(name="manualPrefixRegexp")
    def manual_prefix_regexp(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "manual_prefix_regexp")

    @manual_prefix_regexp.setter
    def manual_prefix_regexp(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "manual_prefix_regexp", value)

    @property
    @pulumi.getter(name="messagePerRequest")
    def message_per_request(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "message_per_request")

    @message_per_request.setter
    def message_per_request(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "message_per_request", value)

    @property
    @pulumi.getter(name="multilineProcessingEnabled")
    def multiline_processing_enabled(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "multiline_processing_enabled")

    @multiline_processing_enabled.setter
    def multiline_processing_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "multiline_processing_enabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input['KinesisMetricsSourcePathArgs']]:
        """
        The location to scan for new data.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input['KinesisMetricsSourcePathArgs']]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timezone", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        The HTTP endpoint to used while creating Kinesis Firehose on AWS.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter(name="useAutolineMatching")
    def use_autoline_matching(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "use_autoline_matching")

    @use_autoline_matching.setter
    def use_autoline_matching(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_autoline_matching", value)


class KinesisMetricsSource(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication: Optional[pulumi.Input[pulumi.InputType['KinesisMetricsSourceAuthenticationArgs']]] = None,
                 automatic_date_parsing: Optional[pulumi.Input[bool]] = None,
                 category: Optional[pulumi.Input[str]] = None,
                 collector_id: Optional[pulumi.Input[int]] = None,
                 content_type: Optional[pulumi.Input[str]] = None,
                 cutoff_relative_time: Optional[pulumi.Input[str]] = None,
                 cutoff_timestamp: Optional[pulumi.Input[int]] = None,
                 default_date_formats: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['KinesisMetricsSourceDefaultDateFormatArgs']]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 fields: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 filters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['KinesisMetricsSourceFilterArgs']]]]] = None,
                 force_timezone: Optional[pulumi.Input[bool]] = None,
                 host_name: Optional[pulumi.Input[str]] = None,
                 manual_prefix_regexp: Optional[pulumi.Input[str]] = None,
                 message_per_request: Optional[pulumi.Input[bool]] = None,
                 multiline_processing_enabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[pulumi.InputType['KinesisMetricsSourcePathArgs']]] = None,
                 timezone: Optional[pulumi.Input[str]] = None,
                 use_autoline_matching: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        ## Import

        Kinesis Metrics sources can be imported using the collector and source IDs (`collector/source`), e.g.hcl

        ```sh
         $ pulumi import sumologic:index/kinesisMetricsSource:KinesisMetricsSource test 123/456
        ```

         HTTP sources can be imported using the collector name and source name (`collectorName/sourceName`), e.g.hcl

        ```sh
         $ pulumi import sumologic:index/kinesisMetricsSource:KinesisMetricsSource test my-test-collector/my-test-source
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['KinesisMetricsSourceAuthenticationArgs']] authentication: Authentication details for connecting to the S3 bucket.
        :param pulumi.Input[str] content_type: The content-type of the collected data. Details can be found in the [Sumologic documentation for hosted sources](https://help.sumologic.com/Send_Data/Sources/03Use_JSON_to_Configure_Sources/JSON_Parameters_for_Hosted_Sources).
        :param pulumi.Input[pulumi.InputType['KinesisMetricsSourcePathArgs']] path: The location to scan for new data.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: KinesisMetricsSourceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        Kinesis Metrics sources can be imported using the collector and source IDs (`collector/source`), e.g.hcl

        ```sh
         $ pulumi import sumologic:index/kinesisMetricsSource:KinesisMetricsSource test 123/456
        ```

         HTTP sources can be imported using the collector name and source name (`collectorName/sourceName`), e.g.hcl

        ```sh
         $ pulumi import sumologic:index/kinesisMetricsSource:KinesisMetricsSource test my-test-collector/my-test-source
        ```

        :param str resource_name: The name of the resource.
        :param KinesisMetricsSourceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(KinesisMetricsSourceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            KinesisMetricsSourceArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication: Optional[pulumi.Input[pulumi.InputType['KinesisMetricsSourceAuthenticationArgs']]] = None,
                 automatic_date_parsing: Optional[pulumi.Input[bool]] = None,
                 category: Optional[pulumi.Input[str]] = None,
                 collector_id: Optional[pulumi.Input[int]] = None,
                 content_type: Optional[pulumi.Input[str]] = None,
                 cutoff_relative_time: Optional[pulumi.Input[str]] = None,
                 cutoff_timestamp: Optional[pulumi.Input[int]] = None,
                 default_date_formats: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['KinesisMetricsSourceDefaultDateFormatArgs']]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 fields: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 filters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['KinesisMetricsSourceFilterArgs']]]]] = None,
                 force_timezone: Optional[pulumi.Input[bool]] = None,
                 host_name: Optional[pulumi.Input[str]] = None,
                 manual_prefix_regexp: Optional[pulumi.Input[str]] = None,
                 message_per_request: Optional[pulumi.Input[bool]] = None,
                 multiline_processing_enabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[pulumi.InputType['KinesisMetricsSourcePathArgs']]] = None,
                 timezone: Optional[pulumi.Input[str]] = None,
                 use_autoline_matching: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = KinesisMetricsSourceArgs.__new__(KinesisMetricsSourceArgs)

            if authentication is not None and not isinstance(authentication, KinesisMetricsSourceAuthenticationArgs):
                authentication = authentication or {}
                def _setter(key, value):
                    authentication[key] = value
                KinesisMetricsSourceAuthenticationArgs._configure(_setter, **authentication)
            if authentication is None and not opts.urn:
                raise TypeError("Missing required property 'authentication'")
            __props__.__dict__["authentication"] = authentication
            __props__.__dict__["automatic_date_parsing"] = automatic_date_parsing
            __props__.__dict__["category"] = category
            if collector_id is None and not opts.urn:
                raise TypeError("Missing required property 'collector_id'")
            __props__.__dict__["collector_id"] = collector_id
            if content_type is None and not opts.urn:
                raise TypeError("Missing required property 'content_type'")
            __props__.__dict__["content_type"] = content_type
            __props__.__dict__["cutoff_relative_time"] = cutoff_relative_time
            __props__.__dict__["cutoff_timestamp"] = cutoff_timestamp
            __props__.__dict__["default_date_formats"] = default_date_formats
            __props__.__dict__["description"] = description
            __props__.__dict__["fields"] = fields
            __props__.__dict__["filters"] = filters
            __props__.__dict__["force_timezone"] = force_timezone
            __props__.__dict__["host_name"] = host_name
            __props__.__dict__["manual_prefix_regexp"] = manual_prefix_regexp
            __props__.__dict__["message_per_request"] = message_per_request
            __props__.__dict__["multiline_processing_enabled"] = multiline_processing_enabled
            __props__.__dict__["name"] = name
            if path is not None and not isinstance(path, KinesisMetricsSourcePathArgs):
                path = path or {}
                def _setter(key, value):
                    path[key] = value
                KinesisMetricsSourcePathArgs._configure(_setter, **path)
            if path is None and not opts.urn:
                raise TypeError("Missing required property 'path'")
            __props__.__dict__["path"] = path
            __props__.__dict__["timezone"] = timezone
            __props__.__dict__["use_autoline_matching"] = use_autoline_matching
            __props__.__dict__["url"] = None
        super(KinesisMetricsSource, __self__).__init__(
            'sumologic:index/kinesisMetricsSource:KinesisMetricsSource',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            authentication: Optional[pulumi.Input[pulumi.InputType['KinesisMetricsSourceAuthenticationArgs']]] = None,
            automatic_date_parsing: Optional[pulumi.Input[bool]] = None,
            category: Optional[pulumi.Input[str]] = None,
            collector_id: Optional[pulumi.Input[int]] = None,
            content_type: Optional[pulumi.Input[str]] = None,
            cutoff_relative_time: Optional[pulumi.Input[str]] = None,
            cutoff_timestamp: Optional[pulumi.Input[int]] = None,
            default_date_formats: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['KinesisMetricsSourceDefaultDateFormatArgs']]]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            fields: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            filters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['KinesisMetricsSourceFilterArgs']]]]] = None,
            force_timezone: Optional[pulumi.Input[bool]] = None,
            host_name: Optional[pulumi.Input[str]] = None,
            manual_prefix_regexp: Optional[pulumi.Input[str]] = None,
            message_per_request: Optional[pulumi.Input[bool]] = None,
            multiline_processing_enabled: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            path: Optional[pulumi.Input[pulumi.InputType['KinesisMetricsSourcePathArgs']]] = None,
            timezone: Optional[pulumi.Input[str]] = None,
            url: Optional[pulumi.Input[str]] = None,
            use_autoline_matching: Optional[pulumi.Input[bool]] = None) -> 'KinesisMetricsSource':
        """
        Get an existing KinesisMetricsSource resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['KinesisMetricsSourceAuthenticationArgs']] authentication: Authentication details for connecting to the S3 bucket.
        :param pulumi.Input[str] content_type: The content-type of the collected data. Details can be found in the [Sumologic documentation for hosted sources](https://help.sumologic.com/Send_Data/Sources/03Use_JSON_to_Configure_Sources/JSON_Parameters_for_Hosted_Sources).
        :param pulumi.Input[pulumi.InputType['KinesisMetricsSourcePathArgs']] path: The location to scan for new data.
        :param pulumi.Input[str] url: The HTTP endpoint to used while creating Kinesis Firehose on AWS.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _KinesisMetricsSourceState.__new__(_KinesisMetricsSourceState)

        __props__.__dict__["authentication"] = authentication
        __props__.__dict__["automatic_date_parsing"] = automatic_date_parsing
        __props__.__dict__["category"] = category
        __props__.__dict__["collector_id"] = collector_id
        __props__.__dict__["content_type"] = content_type
        __props__.__dict__["cutoff_relative_time"] = cutoff_relative_time
        __props__.__dict__["cutoff_timestamp"] = cutoff_timestamp
        __props__.__dict__["default_date_formats"] = default_date_formats
        __props__.__dict__["description"] = description
        __props__.__dict__["fields"] = fields
        __props__.__dict__["filters"] = filters
        __props__.__dict__["force_timezone"] = force_timezone
        __props__.__dict__["host_name"] = host_name
        __props__.__dict__["manual_prefix_regexp"] = manual_prefix_regexp
        __props__.__dict__["message_per_request"] = message_per_request
        __props__.__dict__["multiline_processing_enabled"] = multiline_processing_enabled
        __props__.__dict__["name"] = name
        __props__.__dict__["path"] = path
        __props__.__dict__["timezone"] = timezone
        __props__.__dict__["url"] = url
        __props__.__dict__["use_autoline_matching"] = use_autoline_matching
        return KinesisMetricsSource(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def authentication(self) -> pulumi.Output['outputs.KinesisMetricsSourceAuthentication']:
        """
        Authentication details for connecting to the S3 bucket.
        """
        return pulumi.get(self, "authentication")

    @property
    @pulumi.getter(name="automaticDateParsing")
    def automatic_date_parsing(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "automatic_date_parsing")

    @property
    @pulumi.getter
    def category(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "category")

    @property
    @pulumi.getter(name="collectorId")
    def collector_id(self) -> pulumi.Output[int]:
        return pulumi.get(self, "collector_id")

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> pulumi.Output[str]:
        """
        The content-type of the collected data. Details can be found in the [Sumologic documentation for hosted sources](https://help.sumologic.com/Send_Data/Sources/03Use_JSON_to_Configure_Sources/JSON_Parameters_for_Hosted_Sources).
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter(name="cutoffRelativeTime")
    def cutoff_relative_time(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "cutoff_relative_time")

    @property
    @pulumi.getter(name="cutoffTimestamp")
    def cutoff_timestamp(self) -> pulumi.Output[Optional[int]]:
        return pulumi.get(self, "cutoff_timestamp")

    @property
    @pulumi.getter(name="defaultDateFormats")
    def default_date_formats(self) -> pulumi.Output[Optional[Sequence['outputs.KinesisMetricsSourceDefaultDateFormat']]]:
        return pulumi.get(self, "default_date_formats")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def fields(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        return pulumi.get(self, "fields")

    @property
    @pulumi.getter
    def filters(self) -> pulumi.Output[Optional[Sequence['outputs.KinesisMetricsSourceFilter']]]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter(name="forceTimezone")
    def force_timezone(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "force_timezone")

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "host_name")

    @property
    @pulumi.getter(name="manualPrefixRegexp")
    def manual_prefix_regexp(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "manual_prefix_regexp")

    @property
    @pulumi.getter(name="messagePerRequest")
    def message_per_request(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "message_per_request")

    @property
    @pulumi.getter(name="multilineProcessingEnabled")
    def multiline_processing_enabled(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "multiline_processing_enabled")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def path(self) -> pulumi.Output['outputs.KinesisMetricsSourcePath']:
        """
        The location to scan for new data.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def timezone(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "timezone")

    @property
    @pulumi.getter
    def url(self) -> pulumi.Output[str]:
        """
        The HTTP endpoint to used while creating Kinesis Firehose on AWS.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="useAutolineMatching")
    def use_autoline_matching(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "use_autoline_matching")

