# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MetricsSearchArgs', 'MetricsSearch']

@pulumi.input_type
class MetricsSearchArgs:
    def __init__(__self__, *,
                 description: pulumi.Input[str],
                 metrics_queries: pulumi.Input[Sequence[pulumi.Input['MetricsSearchMetricsQueryArgs']]],
                 parent_id: pulumi.Input[str],
                 time_range: pulumi.Input['MetricsSearchTimeRangeArgs'],
                 title: pulumi.Input[str],
                 desired_quantization_in_secs: Optional[pulumi.Input[int]] = None,
                 log_query: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a MetricsSearch resource.
        :param pulumi.Input[str] description: Description of the search.
        :param pulumi.Input[Sequence[pulumi.Input['MetricsSearchMetricsQueryArgs']]] metrics_queries: Array of objects MetricsSearchQuery. Metrics queries, up to the maximum of six.
        :param pulumi.Input[str] parent_id: The identifier of the folder to create the log search in.
        :param pulumi.Input['MetricsSearchTimeRangeArgs'] time_range: Time range of the log search. See time range schema
        :param pulumi.Input[str] title: Title of the search.
        :param pulumi.Input[int] desired_quantization_in_secs: Desired quantization in seconds. Default value is `0`.
        :param pulumi.Input[str] log_query: Log query used to add an overlay to the chart.
        """
        MetricsSearchArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            description=description,
            metrics_queries=metrics_queries,
            parent_id=parent_id,
            time_range=time_range,
            title=title,
            desired_quantization_in_secs=desired_quantization_in_secs,
            log_query=log_query,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             description: pulumi.Input[str],
             metrics_queries: pulumi.Input[Sequence[pulumi.Input['MetricsSearchMetricsQueryArgs']]],
             parent_id: pulumi.Input[str],
             time_range: pulumi.Input['MetricsSearchTimeRangeArgs'],
             title: pulumi.Input[str],
             desired_quantization_in_secs: Optional[pulumi.Input[int]] = None,
             log_query: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("description", description)
        _setter("metrics_queries", metrics_queries)
        _setter("parent_id", parent_id)
        _setter("time_range", time_range)
        _setter("title", title)
        if desired_quantization_in_secs is not None:
            _setter("desired_quantization_in_secs", desired_quantization_in_secs)
        if log_query is not None:
            _setter("log_query", log_query)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[str]:
        """
        Description of the search.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="metricsQueries")
    def metrics_queries(self) -> pulumi.Input[Sequence[pulumi.Input['MetricsSearchMetricsQueryArgs']]]:
        """
        Array of objects MetricsSearchQuery. Metrics queries, up to the maximum of six.
        """
        return pulumi.get(self, "metrics_queries")

    @metrics_queries.setter
    def metrics_queries(self, value: pulumi.Input[Sequence[pulumi.Input['MetricsSearchMetricsQueryArgs']]]):
        pulumi.set(self, "metrics_queries", value)

    @property
    @pulumi.getter(name="parentId")
    def parent_id(self) -> pulumi.Input[str]:
        """
        The identifier of the folder to create the log search in.
        """
        return pulumi.get(self, "parent_id")

    @parent_id.setter
    def parent_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "parent_id", value)

    @property
    @pulumi.getter(name="timeRange")
    def time_range(self) -> pulumi.Input['MetricsSearchTimeRangeArgs']:
        """
        Time range of the log search. See time range schema
        """
        return pulumi.get(self, "time_range")

    @time_range.setter
    def time_range(self, value: pulumi.Input['MetricsSearchTimeRangeArgs']):
        pulumi.set(self, "time_range", value)

    @property
    @pulumi.getter
    def title(self) -> pulumi.Input[str]:
        """
        Title of the search.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[str]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter(name="desiredQuantizationInSecs")
    def desired_quantization_in_secs(self) -> Optional[pulumi.Input[int]]:
        """
        Desired quantization in seconds. Default value is `0`.
        """
        return pulumi.get(self, "desired_quantization_in_secs")

    @desired_quantization_in_secs.setter
    def desired_quantization_in_secs(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "desired_quantization_in_secs", value)

    @property
    @pulumi.getter(name="logQuery")
    def log_query(self) -> Optional[pulumi.Input[str]]:
        """
        Log query used to add an overlay to the chart.
        """
        return pulumi.get(self, "log_query")

    @log_query.setter
    def log_query(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_query", value)


@pulumi.input_type
class _MetricsSearchState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 desired_quantization_in_secs: Optional[pulumi.Input[int]] = None,
                 log_query: Optional[pulumi.Input[str]] = None,
                 metrics_queries: Optional[pulumi.Input[Sequence[pulumi.Input['MetricsSearchMetricsQueryArgs']]]] = None,
                 parent_id: Optional[pulumi.Input[str]] = None,
                 time_range: Optional[pulumi.Input['MetricsSearchTimeRangeArgs']] = None,
                 title: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering MetricsSearch resources.
        :param pulumi.Input[str] description: Description of the search.
        :param pulumi.Input[int] desired_quantization_in_secs: Desired quantization in seconds. Default value is `0`.
        :param pulumi.Input[str] log_query: Log query used to add an overlay to the chart.
        :param pulumi.Input[Sequence[pulumi.Input['MetricsSearchMetricsQueryArgs']]] metrics_queries: Array of objects MetricsSearchQuery. Metrics queries, up to the maximum of six.
        :param pulumi.Input[str] parent_id: The identifier of the folder to create the log search in.
        :param pulumi.Input['MetricsSearchTimeRangeArgs'] time_range: Time range of the log search. See time range schema
        :param pulumi.Input[str] title: Title of the search.
        """
        _MetricsSearchState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            description=description,
            desired_quantization_in_secs=desired_quantization_in_secs,
            log_query=log_query,
            metrics_queries=metrics_queries,
            parent_id=parent_id,
            time_range=time_range,
            title=title,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             description: Optional[pulumi.Input[str]] = None,
             desired_quantization_in_secs: Optional[pulumi.Input[int]] = None,
             log_query: Optional[pulumi.Input[str]] = None,
             metrics_queries: Optional[pulumi.Input[Sequence[pulumi.Input['MetricsSearchMetricsQueryArgs']]]] = None,
             parent_id: Optional[pulumi.Input[str]] = None,
             time_range: Optional[pulumi.Input['MetricsSearchTimeRangeArgs']] = None,
             title: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if description is not None:
            _setter("description", description)
        if desired_quantization_in_secs is not None:
            _setter("desired_quantization_in_secs", desired_quantization_in_secs)
        if log_query is not None:
            _setter("log_query", log_query)
        if metrics_queries is not None:
            _setter("metrics_queries", metrics_queries)
        if parent_id is not None:
            _setter("parent_id", parent_id)
        if time_range is not None:
            _setter("time_range", time_range)
        if title is not None:
            _setter("title", title)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the search.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="desiredQuantizationInSecs")
    def desired_quantization_in_secs(self) -> Optional[pulumi.Input[int]]:
        """
        Desired quantization in seconds. Default value is `0`.
        """
        return pulumi.get(self, "desired_quantization_in_secs")

    @desired_quantization_in_secs.setter
    def desired_quantization_in_secs(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "desired_quantization_in_secs", value)

    @property
    @pulumi.getter(name="logQuery")
    def log_query(self) -> Optional[pulumi.Input[str]]:
        """
        Log query used to add an overlay to the chart.
        """
        return pulumi.get(self, "log_query")

    @log_query.setter
    def log_query(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_query", value)

    @property
    @pulumi.getter(name="metricsQueries")
    def metrics_queries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MetricsSearchMetricsQueryArgs']]]]:
        """
        Array of objects MetricsSearchQuery. Metrics queries, up to the maximum of six.
        """
        return pulumi.get(self, "metrics_queries")

    @metrics_queries.setter
    def metrics_queries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MetricsSearchMetricsQueryArgs']]]]):
        pulumi.set(self, "metrics_queries", value)

    @property
    @pulumi.getter(name="parentId")
    def parent_id(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier of the folder to create the log search in.
        """
        return pulumi.get(self, "parent_id")

    @parent_id.setter
    def parent_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent_id", value)

    @property
    @pulumi.getter(name="timeRange")
    def time_range(self) -> Optional[pulumi.Input['MetricsSearchTimeRangeArgs']]:
        """
        Time range of the log search. See time range schema
        """
        return pulumi.get(self, "time_range")

    @time_range.setter
    def time_range(self, value: Optional[pulumi.Input['MetricsSearchTimeRangeArgs']]):
        pulumi.set(self, "time_range", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        Title of the search.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)


class MetricsSearch(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 desired_quantization_in_secs: Optional[pulumi.Input[int]] = None,
                 log_query: Optional[pulumi.Input[str]] = None,
                 metrics_queries: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MetricsSearchMetricsQueryArgs']]]]] = None,
                 parent_id: Optional[pulumi.Input[str]] = None,
                 time_range: Optional[pulumi.Input[pulumi.InputType['MetricsSearchTimeRangeArgs']]] = None,
                 title: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a [Sumologic Metrics Search](https://help.sumologic.com/docs/metrics/metrics-queries/metrics-explorer/).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sumologic as sumologic

        personal_folder = sumologic.get_personal_folder()
        example_metrics_search = sumologic.MetricsSearch("exampleMetricsSearch",
            title="Demo Metrics Search",
            description="Demo search description",
            parent_id=personal_folder.id,
            metrics_queries=[sumologic.MetricsSearchMetricsQueryArgs(
                row_id="A",
                query="metric=cpu_idle | avg",
            )],
            desired_quantization_in_secs=0,
            time_range=sumologic.MetricsSearchTimeRangeArgs(
                begin_bounded_time_range=sumologic.MetricsSearchTimeRangeBeginBoundedTimeRangeArgs(
                    from_=sumologic.MetricsSearchTimeRangeBeginBoundedTimeRangeFromArgs(
                        relative_time_range=sumologic.MetricsSearchTimeRangeBeginBoundedTimeRangeFromRelativeTimeRangeArgs(
                            relative_time="-30m",
                        ),
                    ),
                ),
            ))
        ```
        ## Attributes reference

        In addition to all arguments above, the following attributes are exported:

        - `id` - The ID of the log search.

        ## Import

        A metrics search can be imported using it's identifier, e.g.hcl

        ```sh
         $ pulumi import sumologic:index/metricsSearch:MetricsSearch example_search 0000000007FFD79D
        ```

         [1]https://help.sumologic.com/docs/metrics/metrics-queries/metrics-explorer/

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Description of the search.
        :param pulumi.Input[int] desired_quantization_in_secs: Desired quantization in seconds. Default value is `0`.
        :param pulumi.Input[str] log_query: Log query used to add an overlay to the chart.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MetricsSearchMetricsQueryArgs']]]] metrics_queries: Array of objects MetricsSearchQuery. Metrics queries, up to the maximum of six.
        :param pulumi.Input[str] parent_id: The identifier of the folder to create the log search in.
        :param pulumi.Input[pulumi.InputType['MetricsSearchTimeRangeArgs']] time_range: Time range of the log search. See time range schema
        :param pulumi.Input[str] title: Title of the search.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MetricsSearchArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a [Sumologic Metrics Search](https://help.sumologic.com/docs/metrics/metrics-queries/metrics-explorer/).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sumologic as sumologic

        personal_folder = sumologic.get_personal_folder()
        example_metrics_search = sumologic.MetricsSearch("exampleMetricsSearch",
            title="Demo Metrics Search",
            description="Demo search description",
            parent_id=personal_folder.id,
            metrics_queries=[sumologic.MetricsSearchMetricsQueryArgs(
                row_id="A",
                query="metric=cpu_idle | avg",
            )],
            desired_quantization_in_secs=0,
            time_range=sumologic.MetricsSearchTimeRangeArgs(
                begin_bounded_time_range=sumologic.MetricsSearchTimeRangeBeginBoundedTimeRangeArgs(
                    from_=sumologic.MetricsSearchTimeRangeBeginBoundedTimeRangeFromArgs(
                        relative_time_range=sumologic.MetricsSearchTimeRangeBeginBoundedTimeRangeFromRelativeTimeRangeArgs(
                            relative_time="-30m",
                        ),
                    ),
                ),
            ))
        ```
        ## Attributes reference

        In addition to all arguments above, the following attributes are exported:

        - `id` - The ID of the log search.

        ## Import

        A metrics search can be imported using it's identifier, e.g.hcl

        ```sh
         $ pulumi import sumologic:index/metricsSearch:MetricsSearch example_search 0000000007FFD79D
        ```

         [1]https://help.sumologic.com/docs/metrics/metrics-queries/metrics-explorer/

        :param str resource_name: The name of the resource.
        :param MetricsSearchArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MetricsSearchArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            MetricsSearchArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 desired_quantization_in_secs: Optional[pulumi.Input[int]] = None,
                 log_query: Optional[pulumi.Input[str]] = None,
                 metrics_queries: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MetricsSearchMetricsQueryArgs']]]]] = None,
                 parent_id: Optional[pulumi.Input[str]] = None,
                 time_range: Optional[pulumi.Input[pulumi.InputType['MetricsSearchTimeRangeArgs']]] = None,
                 title: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MetricsSearchArgs.__new__(MetricsSearchArgs)

            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            __props__.__dict__["desired_quantization_in_secs"] = desired_quantization_in_secs
            __props__.__dict__["log_query"] = log_query
            if metrics_queries is None and not opts.urn:
                raise TypeError("Missing required property 'metrics_queries'")
            __props__.__dict__["metrics_queries"] = metrics_queries
            if parent_id is None and not opts.urn:
                raise TypeError("Missing required property 'parent_id'")
            __props__.__dict__["parent_id"] = parent_id
            if time_range is not None and not isinstance(time_range, MetricsSearchTimeRangeArgs):
                time_range = time_range or {}
                def _setter(key, value):
                    time_range[key] = value
                MetricsSearchTimeRangeArgs._configure(_setter, **time_range)
            if time_range is None and not opts.urn:
                raise TypeError("Missing required property 'time_range'")
            __props__.__dict__["time_range"] = time_range
            if title is None and not opts.urn:
                raise TypeError("Missing required property 'title'")
            __props__.__dict__["title"] = title
        super(MetricsSearch, __self__).__init__(
            'sumologic:index/metricsSearch:MetricsSearch',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            desired_quantization_in_secs: Optional[pulumi.Input[int]] = None,
            log_query: Optional[pulumi.Input[str]] = None,
            metrics_queries: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MetricsSearchMetricsQueryArgs']]]]] = None,
            parent_id: Optional[pulumi.Input[str]] = None,
            time_range: Optional[pulumi.Input[pulumi.InputType['MetricsSearchTimeRangeArgs']]] = None,
            title: Optional[pulumi.Input[str]] = None) -> 'MetricsSearch':
        """
        Get an existing MetricsSearch resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Description of the search.
        :param pulumi.Input[int] desired_quantization_in_secs: Desired quantization in seconds. Default value is `0`.
        :param pulumi.Input[str] log_query: Log query used to add an overlay to the chart.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MetricsSearchMetricsQueryArgs']]]] metrics_queries: Array of objects MetricsSearchQuery. Metrics queries, up to the maximum of six.
        :param pulumi.Input[str] parent_id: The identifier of the folder to create the log search in.
        :param pulumi.Input[pulumi.InputType['MetricsSearchTimeRangeArgs']] time_range: Time range of the log search. See time range schema
        :param pulumi.Input[str] title: Title of the search.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MetricsSearchState.__new__(_MetricsSearchState)

        __props__.__dict__["description"] = description
        __props__.__dict__["desired_quantization_in_secs"] = desired_quantization_in_secs
        __props__.__dict__["log_query"] = log_query
        __props__.__dict__["metrics_queries"] = metrics_queries
        __props__.__dict__["parent_id"] = parent_id
        __props__.__dict__["time_range"] = time_range
        __props__.__dict__["title"] = title
        return MetricsSearch(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        Description of the search.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="desiredQuantizationInSecs")
    def desired_quantization_in_secs(self) -> pulumi.Output[Optional[int]]:
        """
        Desired quantization in seconds. Default value is `0`.
        """
        return pulumi.get(self, "desired_quantization_in_secs")

    @property
    @pulumi.getter(name="logQuery")
    def log_query(self) -> pulumi.Output[Optional[str]]:
        """
        Log query used to add an overlay to the chart.
        """
        return pulumi.get(self, "log_query")

    @property
    @pulumi.getter(name="metricsQueries")
    def metrics_queries(self) -> pulumi.Output[Sequence['outputs.MetricsSearchMetricsQuery']]:
        """
        Array of objects MetricsSearchQuery. Metrics queries, up to the maximum of six.
        """
        return pulumi.get(self, "metrics_queries")

    @property
    @pulumi.getter(name="parentId")
    def parent_id(self) -> pulumi.Output[str]:
        """
        The identifier of the folder to create the log search in.
        """
        return pulumi.get(self, "parent_id")

    @property
    @pulumi.getter(name="timeRange")
    def time_range(self) -> pulumi.Output['outputs.MetricsSearchTimeRange']:
        """
        Time range of the log search. See time range schema
        """
        return pulumi.get(self, "time_range")

    @property
    @pulumi.getter
    def title(self) -> pulumi.Output[str]:
        """
        Title of the search.
        """
        return pulumi.get(self, "title")

