# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['ProviderArgs', 'Provider']

@pulumi.input_type
class ProviderArgs:
    def __init__(__self__, *,
                 access_id: pulumi.Input[str],
                 access_key: pulumi.Input[str],
                 admin_mode: Optional[pulumi.Input[bool]] = None,
                 base_url: Optional[pulumi.Input[str]] = None,
                 environment: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Provider resource.
        """
        ProviderArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            access_id=access_id,
            access_key=access_key,
            admin_mode=admin_mode,
            base_url=base_url,
            environment=environment,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             access_id: pulumi.Input[str],
             access_key: pulumi.Input[str],
             admin_mode: Optional[pulumi.Input[bool]] = None,
             base_url: Optional[pulumi.Input[str]] = None,
             environment: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("access_id", access_id)
        _setter("access_key", access_key)
        if admin_mode is not None:
            _setter("admin_mode", admin_mode)
        if base_url is None:
            base_url = _utilities.get_env('SUMOLOGIC_BASE_URL')
        if base_url is not None:
            _setter("base_url", base_url)
        if environment is None:
            environment = _utilities.get_env('SUMOLOGIC_ENVIRONMENT')
        if environment is not None:
            _setter("environment", environment)

    @property
    @pulumi.getter(name="accessId")
    def access_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "access_id")

    @access_id.setter
    def access_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "access_id", value)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> pulumi.Input[str]:
        return pulumi.get(self, "access_key")

    @access_key.setter
    def access_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "access_key", value)

    @property
    @pulumi.getter(name="adminMode")
    def admin_mode(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "admin_mode")

    @admin_mode.setter
    def admin_mode(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "admin_mode", value)

    @property
    @pulumi.getter(name="baseUrl")
    def base_url(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "base_url")

    @base_url.setter
    def base_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "base_url", value)

    @property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "environment", value)


class Provider(pulumi.ProviderResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_id: Optional[pulumi.Input[str]] = None,
                 access_key: Optional[pulumi.Input[str]] = None,
                 admin_mode: Optional[pulumi.Input[bool]] = None,
                 base_url: Optional[pulumi.Input[str]] = None,
                 environment: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The provider type for the sumologic package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProviderArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The provider type for the sumologic package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param ProviderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProviderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            ProviderArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_id: Optional[pulumi.Input[str]] = None,
                 access_key: Optional[pulumi.Input[str]] = None,
                 admin_mode: Optional[pulumi.Input[bool]] = None,
                 base_url: Optional[pulumi.Input[str]] = None,
                 environment: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProviderArgs.__new__(ProviderArgs)

            if access_id is None and not opts.urn:
                raise TypeError("Missing required property 'access_id'")
            __props__.__dict__["access_id"] = access_id
            if access_key is None and not opts.urn:
                raise TypeError("Missing required property 'access_key'")
            __props__.__dict__["access_key"] = access_key
            __props__.__dict__["admin_mode"] = pulumi.Output.from_input(admin_mode).apply(pulumi.runtime.to_json) if admin_mode is not None else None
            if base_url is None:
                base_url = _utilities.get_env('SUMOLOGIC_BASE_URL')
            __props__.__dict__["base_url"] = base_url
            if environment is None:
                environment = _utilities.get_env('SUMOLOGIC_ENVIRONMENT')
            __props__.__dict__["environment"] = environment
        super(Provider, __self__).__init__(
            'sumologic',
            resource_name,
            __props__,
            opts)

    @property
    @pulumi.getter(name="accessId")
    def access_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "access_id")

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> pulumi.Output[str]:
        return pulumi.get(self, "access_key")

    @property
    @pulumi.getter(name="baseUrl")
    def base_url(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "base_url")

    @property
    @pulumi.getter
    def environment(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "environment")

