# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['S3ArchiveSourceArgs', 'S3ArchiveSource']

@pulumi.input_type
class S3ArchiveSourceArgs:
    def __init__(__self__, *,
                 authentication: pulumi.Input['S3ArchiveSourceAuthenticationArgs'],
                 collector_id: pulumi.Input[int],
                 content_type: pulumi.Input[str],
                 path: pulumi.Input['S3ArchiveSourcePathArgs'],
                 paused: pulumi.Input[bool],
                 scan_interval: pulumi.Input[int],
                 automatic_date_parsing: Optional[pulumi.Input[bool]] = None,
                 category: Optional[pulumi.Input[str]] = None,
                 cutoff_relative_time: Optional[pulumi.Input[str]] = None,
                 cutoff_timestamp: Optional[pulumi.Input[int]] = None,
                 default_date_formats: Optional[pulumi.Input[Sequence[pulumi.Input['S3ArchiveSourceDefaultDateFormatArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 fields: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 filters: Optional[pulumi.Input[Sequence[pulumi.Input['S3ArchiveSourceFilterArgs']]]] = None,
                 force_timezone: Optional[pulumi.Input[bool]] = None,
                 host_name: Optional[pulumi.Input[str]] = None,
                 manual_prefix_regexp: Optional[pulumi.Input[str]] = None,
                 multiline_processing_enabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 timezone: Optional[pulumi.Input[str]] = None,
                 use_autoline_matching: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a S3ArchiveSource resource.
        :param pulumi.Input['S3ArchiveSourceAuthenticationArgs'] authentication: Authentication details for connecting to the S3 bucket.
        :param pulumi.Input[str] content_type: The content-type of the collected data. It should be `AwsS3ArchiveBucket` for archive source. Details can be found in the [Sumologic documentation for hosted sources](https://help.sumologic.com/Send_Data/Sources/03Use_JSON_to_Configure_Sources/JSON_Parameters_for_Hosted_Sources).
        :param pulumi.Input['S3ArchiveSourcePathArgs'] path: The location to scan for new data.
        :param pulumi.Input[bool] paused: When set to true, the scanner is paused. To disable, set to false.
        :param pulumi.Input[int] scan_interval: Time interval in milliseconds of scans for new data. The default is 300000 and the minimum value is 1000 milliseconds.
        """
        S3ArchiveSourceArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            authentication=authentication,
            collector_id=collector_id,
            content_type=content_type,
            path=path,
            paused=paused,
            scan_interval=scan_interval,
            automatic_date_parsing=automatic_date_parsing,
            category=category,
            cutoff_relative_time=cutoff_relative_time,
            cutoff_timestamp=cutoff_timestamp,
            default_date_formats=default_date_formats,
            description=description,
            fields=fields,
            filters=filters,
            force_timezone=force_timezone,
            host_name=host_name,
            manual_prefix_regexp=manual_prefix_regexp,
            multiline_processing_enabled=multiline_processing_enabled,
            name=name,
            timezone=timezone,
            use_autoline_matching=use_autoline_matching,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             authentication: pulumi.Input['S3ArchiveSourceAuthenticationArgs'],
             collector_id: pulumi.Input[int],
             content_type: pulumi.Input[str],
             path: pulumi.Input['S3ArchiveSourcePathArgs'],
             paused: pulumi.Input[bool],
             scan_interval: pulumi.Input[int],
             automatic_date_parsing: Optional[pulumi.Input[bool]] = None,
             category: Optional[pulumi.Input[str]] = None,
             cutoff_relative_time: Optional[pulumi.Input[str]] = None,
             cutoff_timestamp: Optional[pulumi.Input[int]] = None,
             default_date_formats: Optional[pulumi.Input[Sequence[pulumi.Input['S3ArchiveSourceDefaultDateFormatArgs']]]] = None,
             description: Optional[pulumi.Input[str]] = None,
             fields: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
             filters: Optional[pulumi.Input[Sequence[pulumi.Input['S3ArchiveSourceFilterArgs']]]] = None,
             force_timezone: Optional[pulumi.Input[bool]] = None,
             host_name: Optional[pulumi.Input[str]] = None,
             manual_prefix_regexp: Optional[pulumi.Input[str]] = None,
             multiline_processing_enabled: Optional[pulumi.Input[bool]] = None,
             name: Optional[pulumi.Input[str]] = None,
             timezone: Optional[pulumi.Input[str]] = None,
             use_autoline_matching: Optional[pulumi.Input[bool]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("authentication", authentication)
        _setter("collector_id", collector_id)
        _setter("content_type", content_type)
        _setter("path", path)
        _setter("paused", paused)
        _setter("scan_interval", scan_interval)
        if automatic_date_parsing is not None:
            _setter("automatic_date_parsing", automatic_date_parsing)
        if category is not None:
            _setter("category", category)
        if cutoff_relative_time is not None:
            _setter("cutoff_relative_time", cutoff_relative_time)
        if cutoff_timestamp is not None:
            _setter("cutoff_timestamp", cutoff_timestamp)
        if default_date_formats is not None:
            _setter("default_date_formats", default_date_formats)
        if description is not None:
            _setter("description", description)
        if fields is not None:
            _setter("fields", fields)
        if filters is not None:
            _setter("filters", filters)
        if force_timezone is not None:
            _setter("force_timezone", force_timezone)
        if host_name is not None:
            _setter("host_name", host_name)
        if manual_prefix_regexp is not None:
            _setter("manual_prefix_regexp", manual_prefix_regexp)
        if multiline_processing_enabled is not None:
            _setter("multiline_processing_enabled", multiline_processing_enabled)
        if name is not None:
            _setter("name", name)
        if timezone is not None:
            _setter("timezone", timezone)
        if use_autoline_matching is not None:
            _setter("use_autoline_matching", use_autoline_matching)

    @property
    @pulumi.getter
    def authentication(self) -> pulumi.Input['S3ArchiveSourceAuthenticationArgs']:
        """
        Authentication details for connecting to the S3 bucket.
        """
        return pulumi.get(self, "authentication")

    @authentication.setter
    def authentication(self, value: pulumi.Input['S3ArchiveSourceAuthenticationArgs']):
        pulumi.set(self, "authentication", value)

    @property
    @pulumi.getter(name="collectorId")
    def collector_id(self) -> pulumi.Input[int]:
        return pulumi.get(self, "collector_id")

    @collector_id.setter
    def collector_id(self, value: pulumi.Input[int]):
        pulumi.set(self, "collector_id", value)

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> pulumi.Input[str]:
        """
        The content-type of the collected data. It should be `AwsS3ArchiveBucket` for archive source. Details can be found in the [Sumologic documentation for hosted sources](https://help.sumologic.com/Send_Data/Sources/03Use_JSON_to_Configure_Sources/JSON_Parameters_for_Hosted_Sources).
        """
        return pulumi.get(self, "content_type")

    @content_type.setter
    def content_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "content_type", value)

    @property
    @pulumi.getter
    def path(self) -> pulumi.Input['S3ArchiveSourcePathArgs']:
        """
        The location to scan for new data.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input['S3ArchiveSourcePathArgs']):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def paused(self) -> pulumi.Input[bool]:
        """
        When set to true, the scanner is paused. To disable, set to false.
        """
        return pulumi.get(self, "paused")

    @paused.setter
    def paused(self, value: pulumi.Input[bool]):
        pulumi.set(self, "paused", value)

    @property
    @pulumi.getter(name="scanInterval")
    def scan_interval(self) -> pulumi.Input[int]:
        """
        Time interval in milliseconds of scans for new data. The default is 300000 and the minimum value is 1000 milliseconds.
        """
        return pulumi.get(self, "scan_interval")

    @scan_interval.setter
    def scan_interval(self, value: pulumi.Input[int]):
        pulumi.set(self, "scan_interval", value)

    @property
    @pulumi.getter(name="automaticDateParsing")
    def automatic_date_parsing(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "automatic_date_parsing")

    @automatic_date_parsing.setter
    def automatic_date_parsing(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "automatic_date_parsing", value)

    @property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "category", value)

    @property
    @pulumi.getter(name="cutoffRelativeTime")
    def cutoff_relative_time(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "cutoff_relative_time")

    @cutoff_relative_time.setter
    def cutoff_relative_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cutoff_relative_time", value)

    @property
    @pulumi.getter(name="cutoffTimestamp")
    def cutoff_timestamp(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "cutoff_timestamp")

    @cutoff_timestamp.setter
    def cutoff_timestamp(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cutoff_timestamp", value)

    @property
    @pulumi.getter(name="defaultDateFormats")
    def default_date_formats(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['S3ArchiveSourceDefaultDateFormatArgs']]]]:
        return pulumi.get(self, "default_date_formats")

    @default_date_formats.setter
    def default_date_formats(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['S3ArchiveSourceDefaultDateFormatArgs']]]]):
        pulumi.set(self, "default_date_formats", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def fields(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "fields")

    @fields.setter
    def fields(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "fields", value)

    @property
    @pulumi.getter
    def filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['S3ArchiveSourceFilterArgs']]]]:
        return pulumi.get(self, "filters")

    @filters.setter
    def filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['S3ArchiveSourceFilterArgs']]]]):
        pulumi.set(self, "filters", value)

    @property
    @pulumi.getter(name="forceTimezone")
    def force_timezone(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "force_timezone")

    @force_timezone.setter
    def force_timezone(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_timezone", value)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_name", value)

    @property
    @pulumi.getter(name="manualPrefixRegexp")
    def manual_prefix_regexp(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "manual_prefix_regexp")

    @manual_prefix_regexp.setter
    def manual_prefix_regexp(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "manual_prefix_regexp", value)

    @property
    @pulumi.getter(name="multilineProcessingEnabled")
    def multiline_processing_enabled(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "multiline_processing_enabled")

    @multiline_processing_enabled.setter
    def multiline_processing_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "multiline_processing_enabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timezone", value)

    @property
    @pulumi.getter(name="useAutolineMatching")
    def use_autoline_matching(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "use_autoline_matching")

    @use_autoline_matching.setter
    def use_autoline_matching(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_autoline_matching", value)


@pulumi.input_type
class _S3ArchiveSourceState:
    def __init__(__self__, *,
                 authentication: Optional[pulumi.Input['S3ArchiveSourceAuthenticationArgs']] = None,
                 automatic_date_parsing: Optional[pulumi.Input[bool]] = None,
                 category: Optional[pulumi.Input[str]] = None,
                 collector_id: Optional[pulumi.Input[int]] = None,
                 content_type: Optional[pulumi.Input[str]] = None,
                 cutoff_relative_time: Optional[pulumi.Input[str]] = None,
                 cutoff_timestamp: Optional[pulumi.Input[int]] = None,
                 default_date_formats: Optional[pulumi.Input[Sequence[pulumi.Input['S3ArchiveSourceDefaultDateFormatArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 fields: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 filters: Optional[pulumi.Input[Sequence[pulumi.Input['S3ArchiveSourceFilterArgs']]]] = None,
                 force_timezone: Optional[pulumi.Input[bool]] = None,
                 host_name: Optional[pulumi.Input[str]] = None,
                 manual_prefix_regexp: Optional[pulumi.Input[str]] = None,
                 multiline_processing_enabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input['S3ArchiveSourcePathArgs']] = None,
                 paused: Optional[pulumi.Input[bool]] = None,
                 scan_interval: Optional[pulumi.Input[int]] = None,
                 timezone: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None,
                 use_autoline_matching: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering S3ArchiveSource resources.
        :param pulumi.Input['S3ArchiveSourceAuthenticationArgs'] authentication: Authentication details for connecting to the S3 bucket.
        :param pulumi.Input[str] content_type: The content-type of the collected data. It should be `AwsS3ArchiveBucket` for archive source. Details can be found in the [Sumologic documentation for hosted sources](https://help.sumologic.com/Send_Data/Sources/03Use_JSON_to_Configure_Sources/JSON_Parameters_for_Hosted_Sources).
        :param pulumi.Input['S3ArchiveSourcePathArgs'] path: The location to scan for new data.
        :param pulumi.Input[bool] paused: When set to true, the scanner is paused. To disable, set to false.
        :param pulumi.Input[int] scan_interval: Time interval in milliseconds of scans for new data. The default is 300000 and the minimum value is 1000 milliseconds.
        :param pulumi.Input[str] url: The HTTP endpoint to use with [SNS to notify Sumo Logic of new files](https://help.sumologic.com/03Send-Data/Sources/02Sources-for-Hosted-Collectors/Amazon-Web-Services/AWS-S3-Source#Set_up_SNS_in_AWS_(Optional)).
        """
        _S3ArchiveSourceState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            authentication=authentication,
            automatic_date_parsing=automatic_date_parsing,
            category=category,
            collector_id=collector_id,
            content_type=content_type,
            cutoff_relative_time=cutoff_relative_time,
            cutoff_timestamp=cutoff_timestamp,
            default_date_formats=default_date_formats,
            description=description,
            fields=fields,
            filters=filters,
            force_timezone=force_timezone,
            host_name=host_name,
            manual_prefix_regexp=manual_prefix_regexp,
            multiline_processing_enabled=multiline_processing_enabled,
            name=name,
            path=path,
            paused=paused,
            scan_interval=scan_interval,
            timezone=timezone,
            url=url,
            use_autoline_matching=use_autoline_matching,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             authentication: Optional[pulumi.Input['S3ArchiveSourceAuthenticationArgs']] = None,
             automatic_date_parsing: Optional[pulumi.Input[bool]] = None,
             category: Optional[pulumi.Input[str]] = None,
             collector_id: Optional[pulumi.Input[int]] = None,
             content_type: Optional[pulumi.Input[str]] = None,
             cutoff_relative_time: Optional[pulumi.Input[str]] = None,
             cutoff_timestamp: Optional[pulumi.Input[int]] = None,
             default_date_formats: Optional[pulumi.Input[Sequence[pulumi.Input['S3ArchiveSourceDefaultDateFormatArgs']]]] = None,
             description: Optional[pulumi.Input[str]] = None,
             fields: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
             filters: Optional[pulumi.Input[Sequence[pulumi.Input['S3ArchiveSourceFilterArgs']]]] = None,
             force_timezone: Optional[pulumi.Input[bool]] = None,
             host_name: Optional[pulumi.Input[str]] = None,
             manual_prefix_regexp: Optional[pulumi.Input[str]] = None,
             multiline_processing_enabled: Optional[pulumi.Input[bool]] = None,
             name: Optional[pulumi.Input[str]] = None,
             path: Optional[pulumi.Input['S3ArchiveSourcePathArgs']] = None,
             paused: Optional[pulumi.Input[bool]] = None,
             scan_interval: Optional[pulumi.Input[int]] = None,
             timezone: Optional[pulumi.Input[str]] = None,
             url: Optional[pulumi.Input[str]] = None,
             use_autoline_matching: Optional[pulumi.Input[bool]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if authentication is not None:
            _setter("authentication", authentication)
        if automatic_date_parsing is not None:
            _setter("automatic_date_parsing", automatic_date_parsing)
        if category is not None:
            _setter("category", category)
        if collector_id is not None:
            _setter("collector_id", collector_id)
        if content_type is not None:
            _setter("content_type", content_type)
        if cutoff_relative_time is not None:
            _setter("cutoff_relative_time", cutoff_relative_time)
        if cutoff_timestamp is not None:
            _setter("cutoff_timestamp", cutoff_timestamp)
        if default_date_formats is not None:
            _setter("default_date_formats", default_date_formats)
        if description is not None:
            _setter("description", description)
        if fields is not None:
            _setter("fields", fields)
        if filters is not None:
            _setter("filters", filters)
        if force_timezone is not None:
            _setter("force_timezone", force_timezone)
        if host_name is not None:
            _setter("host_name", host_name)
        if manual_prefix_regexp is not None:
            _setter("manual_prefix_regexp", manual_prefix_regexp)
        if multiline_processing_enabled is not None:
            _setter("multiline_processing_enabled", multiline_processing_enabled)
        if name is not None:
            _setter("name", name)
        if path is not None:
            _setter("path", path)
        if paused is not None:
            _setter("paused", paused)
        if scan_interval is not None:
            _setter("scan_interval", scan_interval)
        if timezone is not None:
            _setter("timezone", timezone)
        if url is not None:
            _setter("url", url)
        if use_autoline_matching is not None:
            _setter("use_autoline_matching", use_autoline_matching)

    @property
    @pulumi.getter
    def authentication(self) -> Optional[pulumi.Input['S3ArchiveSourceAuthenticationArgs']]:
        """
        Authentication details for connecting to the S3 bucket.
        """
        return pulumi.get(self, "authentication")

    @authentication.setter
    def authentication(self, value: Optional[pulumi.Input['S3ArchiveSourceAuthenticationArgs']]):
        pulumi.set(self, "authentication", value)

    @property
    @pulumi.getter(name="automaticDateParsing")
    def automatic_date_parsing(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "automatic_date_parsing")

    @automatic_date_parsing.setter
    def automatic_date_parsing(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "automatic_date_parsing", value)

    @property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "category", value)

    @property
    @pulumi.getter(name="collectorId")
    def collector_id(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "collector_id")

    @collector_id.setter
    def collector_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "collector_id", value)

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[pulumi.Input[str]]:
        """
        The content-type of the collected data. It should be `AwsS3ArchiveBucket` for archive source. Details can be found in the [Sumologic documentation for hosted sources](https://help.sumologic.com/Send_Data/Sources/03Use_JSON_to_Configure_Sources/JSON_Parameters_for_Hosted_Sources).
        """
        return pulumi.get(self, "content_type")

    @content_type.setter
    def content_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content_type", value)

    @property
    @pulumi.getter(name="cutoffRelativeTime")
    def cutoff_relative_time(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "cutoff_relative_time")

    @cutoff_relative_time.setter
    def cutoff_relative_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cutoff_relative_time", value)

    @property
    @pulumi.getter(name="cutoffTimestamp")
    def cutoff_timestamp(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "cutoff_timestamp")

    @cutoff_timestamp.setter
    def cutoff_timestamp(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cutoff_timestamp", value)

    @property
    @pulumi.getter(name="defaultDateFormats")
    def default_date_formats(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['S3ArchiveSourceDefaultDateFormatArgs']]]]:
        return pulumi.get(self, "default_date_formats")

    @default_date_formats.setter
    def default_date_formats(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['S3ArchiveSourceDefaultDateFormatArgs']]]]):
        pulumi.set(self, "default_date_formats", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def fields(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "fields")

    @fields.setter
    def fields(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "fields", value)

    @property
    @pulumi.getter
    def filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['S3ArchiveSourceFilterArgs']]]]:
        return pulumi.get(self, "filters")

    @filters.setter
    def filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['S3ArchiveSourceFilterArgs']]]]):
        pulumi.set(self, "filters", value)

    @property
    @pulumi.getter(name="forceTimezone")
    def force_timezone(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "force_timezone")

    @force_timezone.setter
    def force_timezone(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_timezone", value)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_name", value)

    @property
    @pulumi.getter(name="manualPrefixRegexp")
    def manual_prefix_regexp(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "manual_prefix_regexp")

    @manual_prefix_regexp.setter
    def manual_prefix_regexp(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "manual_prefix_regexp", value)

    @property
    @pulumi.getter(name="multilineProcessingEnabled")
    def multiline_processing_enabled(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "multiline_processing_enabled")

    @multiline_processing_enabled.setter
    def multiline_processing_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "multiline_processing_enabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input['S3ArchiveSourcePathArgs']]:
        """
        The location to scan for new data.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input['S3ArchiveSourcePathArgs']]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def paused(self) -> Optional[pulumi.Input[bool]]:
        """
        When set to true, the scanner is paused. To disable, set to false.
        """
        return pulumi.get(self, "paused")

    @paused.setter
    def paused(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "paused", value)

    @property
    @pulumi.getter(name="scanInterval")
    def scan_interval(self) -> Optional[pulumi.Input[int]]:
        """
        Time interval in milliseconds of scans for new data. The default is 300000 and the minimum value is 1000 milliseconds.
        """
        return pulumi.get(self, "scan_interval")

    @scan_interval.setter
    def scan_interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "scan_interval", value)

    @property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timezone", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        The HTTP endpoint to use with [SNS to notify Sumo Logic of new files](https://help.sumologic.com/03Send-Data/Sources/02Sources-for-Hosted-Collectors/Amazon-Web-Services/AWS-S3-Source#Set_up_SNS_in_AWS_(Optional)).
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter(name="useAutolineMatching")
    def use_autoline_matching(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "use_autoline_matching")

    @use_autoline_matching.setter
    def use_autoline_matching(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_autoline_matching", value)


class S3ArchiveSource(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication: Optional[pulumi.Input[pulumi.InputType['S3ArchiveSourceAuthenticationArgs']]] = None,
                 automatic_date_parsing: Optional[pulumi.Input[bool]] = None,
                 category: Optional[pulumi.Input[str]] = None,
                 collector_id: Optional[pulumi.Input[int]] = None,
                 content_type: Optional[pulumi.Input[str]] = None,
                 cutoff_relative_time: Optional[pulumi.Input[str]] = None,
                 cutoff_timestamp: Optional[pulumi.Input[int]] = None,
                 default_date_formats: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['S3ArchiveSourceDefaultDateFormatArgs']]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 fields: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 filters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['S3ArchiveSourceFilterArgs']]]]] = None,
                 force_timezone: Optional[pulumi.Input[bool]] = None,
                 host_name: Optional[pulumi.Input[str]] = None,
                 manual_prefix_regexp: Optional[pulumi.Input[str]] = None,
                 multiline_processing_enabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[pulumi.InputType['S3ArchiveSourcePathArgs']]] = None,
                 paused: Optional[pulumi.Input[bool]] = None,
                 scan_interval: Optional[pulumi.Input[int]] = None,
                 timezone: Optional[pulumi.Input[str]] = None,
                 use_autoline_matching: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        Provides a [Sumologic AWS S3 Archive Source][2].

        __IMPORTANT:__ The AWS credentials are stored in plain-text in the state. This is a potential security issue.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sumologic as sumologic

        collector = sumologic.Collector("collector", description="Just testing this")
        terraform_s3_archive_source = sumologic.S3ArchiveSource("terraformS3ArchiveSource",
            authentication=sumologic.S3ArchiveSourceAuthenticationArgs(
                access_key="someKey",
                secret_key="******",
                type="S3BucketAuthentication",
            ),
            category="aws/s3",
            collector_id=collector.id,
            content_type="AwsS3Bucket",
            description="My description",
            path=sumologic.S3ArchiveSourcePathArgs(
                bucket_name="Bucket1",
                path_expression="*",
                type="S3BucketPathExpression",
            ),
            paused=False,
            scan_interval=300000)
        ```

        ## Import

        S3 sources can be imported using the collector and source IDs (`collector/source`), e.g.hcl

        ```sh
         $ pulumi import sumologic:index/s3ArchiveSource:S3ArchiveSource test 123/456
        ```

         S3 sources can be imported using the collector name and source name (`collectorName/sourceName`), e.g.hcl

        ```sh
         $ pulumi import sumologic:index/s3ArchiveSource:S3ArchiveSource test my-test-collector/my-test-source
        ```

         [1]https://help.sumologic.com/Send_Data/Sources/03Use_JSON_to_Configure_Sources/JSON_Parameters_for_Hosted_Sources [2]https://help.sumologic.com/docs/manage/archive/#create-an-aws-s3-archivesource

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['S3ArchiveSourceAuthenticationArgs']] authentication: Authentication details for connecting to the S3 bucket.
        :param pulumi.Input[str] content_type: The content-type of the collected data. It should be `AwsS3ArchiveBucket` for archive source. Details can be found in the [Sumologic documentation for hosted sources](https://help.sumologic.com/Send_Data/Sources/03Use_JSON_to_Configure_Sources/JSON_Parameters_for_Hosted_Sources).
        :param pulumi.Input[pulumi.InputType['S3ArchiveSourcePathArgs']] path: The location to scan for new data.
        :param pulumi.Input[bool] paused: When set to true, the scanner is paused. To disable, set to false.
        :param pulumi.Input[int] scan_interval: Time interval in milliseconds of scans for new data. The default is 300000 and the minimum value is 1000 milliseconds.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: S3ArchiveSourceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a [Sumologic AWS S3 Archive Source][2].

        __IMPORTANT:__ The AWS credentials are stored in plain-text in the state. This is a potential security issue.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sumologic as sumologic

        collector = sumologic.Collector("collector", description="Just testing this")
        terraform_s3_archive_source = sumologic.S3ArchiveSource("terraformS3ArchiveSource",
            authentication=sumologic.S3ArchiveSourceAuthenticationArgs(
                access_key="someKey",
                secret_key="******",
                type="S3BucketAuthentication",
            ),
            category="aws/s3",
            collector_id=collector.id,
            content_type="AwsS3Bucket",
            description="My description",
            path=sumologic.S3ArchiveSourcePathArgs(
                bucket_name="Bucket1",
                path_expression="*",
                type="S3BucketPathExpression",
            ),
            paused=False,
            scan_interval=300000)
        ```

        ## Import

        S3 sources can be imported using the collector and source IDs (`collector/source`), e.g.hcl

        ```sh
         $ pulumi import sumologic:index/s3ArchiveSource:S3ArchiveSource test 123/456
        ```

         S3 sources can be imported using the collector name and source name (`collectorName/sourceName`), e.g.hcl

        ```sh
         $ pulumi import sumologic:index/s3ArchiveSource:S3ArchiveSource test my-test-collector/my-test-source
        ```

         [1]https://help.sumologic.com/Send_Data/Sources/03Use_JSON_to_Configure_Sources/JSON_Parameters_for_Hosted_Sources [2]https://help.sumologic.com/docs/manage/archive/#create-an-aws-s3-archivesource

        :param str resource_name: The name of the resource.
        :param S3ArchiveSourceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(S3ArchiveSourceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            S3ArchiveSourceArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication: Optional[pulumi.Input[pulumi.InputType['S3ArchiveSourceAuthenticationArgs']]] = None,
                 automatic_date_parsing: Optional[pulumi.Input[bool]] = None,
                 category: Optional[pulumi.Input[str]] = None,
                 collector_id: Optional[pulumi.Input[int]] = None,
                 content_type: Optional[pulumi.Input[str]] = None,
                 cutoff_relative_time: Optional[pulumi.Input[str]] = None,
                 cutoff_timestamp: Optional[pulumi.Input[int]] = None,
                 default_date_formats: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['S3ArchiveSourceDefaultDateFormatArgs']]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 fields: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 filters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['S3ArchiveSourceFilterArgs']]]]] = None,
                 force_timezone: Optional[pulumi.Input[bool]] = None,
                 host_name: Optional[pulumi.Input[str]] = None,
                 manual_prefix_regexp: Optional[pulumi.Input[str]] = None,
                 multiline_processing_enabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[pulumi.InputType['S3ArchiveSourcePathArgs']]] = None,
                 paused: Optional[pulumi.Input[bool]] = None,
                 scan_interval: Optional[pulumi.Input[int]] = None,
                 timezone: Optional[pulumi.Input[str]] = None,
                 use_autoline_matching: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = S3ArchiveSourceArgs.__new__(S3ArchiveSourceArgs)

            if authentication is not None and not isinstance(authentication, S3ArchiveSourceAuthenticationArgs):
                authentication = authentication or {}
                def _setter(key, value):
                    authentication[key] = value
                S3ArchiveSourceAuthenticationArgs._configure(_setter, **authentication)
            if authentication is None and not opts.urn:
                raise TypeError("Missing required property 'authentication'")
            __props__.__dict__["authentication"] = authentication
            __props__.__dict__["automatic_date_parsing"] = automatic_date_parsing
            __props__.__dict__["category"] = category
            if collector_id is None and not opts.urn:
                raise TypeError("Missing required property 'collector_id'")
            __props__.__dict__["collector_id"] = collector_id
            if content_type is None and not opts.urn:
                raise TypeError("Missing required property 'content_type'")
            __props__.__dict__["content_type"] = content_type
            __props__.__dict__["cutoff_relative_time"] = cutoff_relative_time
            __props__.__dict__["cutoff_timestamp"] = cutoff_timestamp
            __props__.__dict__["default_date_formats"] = default_date_formats
            __props__.__dict__["description"] = description
            __props__.__dict__["fields"] = fields
            __props__.__dict__["filters"] = filters
            __props__.__dict__["force_timezone"] = force_timezone
            __props__.__dict__["host_name"] = host_name
            __props__.__dict__["manual_prefix_regexp"] = manual_prefix_regexp
            __props__.__dict__["multiline_processing_enabled"] = multiline_processing_enabled
            __props__.__dict__["name"] = name
            if path is not None and not isinstance(path, S3ArchiveSourcePathArgs):
                path = path or {}
                def _setter(key, value):
                    path[key] = value
                S3ArchiveSourcePathArgs._configure(_setter, **path)
            if path is None and not opts.urn:
                raise TypeError("Missing required property 'path'")
            __props__.__dict__["path"] = path
            if paused is None and not opts.urn:
                raise TypeError("Missing required property 'paused'")
            __props__.__dict__["paused"] = paused
            if scan_interval is None and not opts.urn:
                raise TypeError("Missing required property 'scan_interval'")
            __props__.__dict__["scan_interval"] = scan_interval
            __props__.__dict__["timezone"] = timezone
            __props__.__dict__["use_autoline_matching"] = use_autoline_matching
            __props__.__dict__["url"] = None
        super(S3ArchiveSource, __self__).__init__(
            'sumologic:index/s3ArchiveSource:S3ArchiveSource',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            authentication: Optional[pulumi.Input[pulumi.InputType['S3ArchiveSourceAuthenticationArgs']]] = None,
            automatic_date_parsing: Optional[pulumi.Input[bool]] = None,
            category: Optional[pulumi.Input[str]] = None,
            collector_id: Optional[pulumi.Input[int]] = None,
            content_type: Optional[pulumi.Input[str]] = None,
            cutoff_relative_time: Optional[pulumi.Input[str]] = None,
            cutoff_timestamp: Optional[pulumi.Input[int]] = None,
            default_date_formats: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['S3ArchiveSourceDefaultDateFormatArgs']]]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            fields: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            filters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['S3ArchiveSourceFilterArgs']]]]] = None,
            force_timezone: Optional[pulumi.Input[bool]] = None,
            host_name: Optional[pulumi.Input[str]] = None,
            manual_prefix_regexp: Optional[pulumi.Input[str]] = None,
            multiline_processing_enabled: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            path: Optional[pulumi.Input[pulumi.InputType['S3ArchiveSourcePathArgs']]] = None,
            paused: Optional[pulumi.Input[bool]] = None,
            scan_interval: Optional[pulumi.Input[int]] = None,
            timezone: Optional[pulumi.Input[str]] = None,
            url: Optional[pulumi.Input[str]] = None,
            use_autoline_matching: Optional[pulumi.Input[bool]] = None) -> 'S3ArchiveSource':
        """
        Get an existing S3ArchiveSource resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['S3ArchiveSourceAuthenticationArgs']] authentication: Authentication details for connecting to the S3 bucket.
        :param pulumi.Input[str] content_type: The content-type of the collected data. It should be `AwsS3ArchiveBucket` for archive source. Details can be found in the [Sumologic documentation for hosted sources](https://help.sumologic.com/Send_Data/Sources/03Use_JSON_to_Configure_Sources/JSON_Parameters_for_Hosted_Sources).
        :param pulumi.Input[pulumi.InputType['S3ArchiveSourcePathArgs']] path: The location to scan for new data.
        :param pulumi.Input[bool] paused: When set to true, the scanner is paused. To disable, set to false.
        :param pulumi.Input[int] scan_interval: Time interval in milliseconds of scans for new data. The default is 300000 and the minimum value is 1000 milliseconds.
        :param pulumi.Input[str] url: The HTTP endpoint to use with [SNS to notify Sumo Logic of new files](https://help.sumologic.com/03Send-Data/Sources/02Sources-for-Hosted-Collectors/Amazon-Web-Services/AWS-S3-Source#Set_up_SNS_in_AWS_(Optional)).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _S3ArchiveSourceState.__new__(_S3ArchiveSourceState)

        __props__.__dict__["authentication"] = authentication
        __props__.__dict__["automatic_date_parsing"] = automatic_date_parsing
        __props__.__dict__["category"] = category
        __props__.__dict__["collector_id"] = collector_id
        __props__.__dict__["content_type"] = content_type
        __props__.__dict__["cutoff_relative_time"] = cutoff_relative_time
        __props__.__dict__["cutoff_timestamp"] = cutoff_timestamp
        __props__.__dict__["default_date_formats"] = default_date_formats
        __props__.__dict__["description"] = description
        __props__.__dict__["fields"] = fields
        __props__.__dict__["filters"] = filters
        __props__.__dict__["force_timezone"] = force_timezone
        __props__.__dict__["host_name"] = host_name
        __props__.__dict__["manual_prefix_regexp"] = manual_prefix_regexp
        __props__.__dict__["multiline_processing_enabled"] = multiline_processing_enabled
        __props__.__dict__["name"] = name
        __props__.__dict__["path"] = path
        __props__.__dict__["paused"] = paused
        __props__.__dict__["scan_interval"] = scan_interval
        __props__.__dict__["timezone"] = timezone
        __props__.__dict__["url"] = url
        __props__.__dict__["use_autoline_matching"] = use_autoline_matching
        return S3ArchiveSource(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def authentication(self) -> pulumi.Output['outputs.S3ArchiveSourceAuthentication']:
        """
        Authentication details for connecting to the S3 bucket.
        """
        return pulumi.get(self, "authentication")

    @property
    @pulumi.getter(name="automaticDateParsing")
    def automatic_date_parsing(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "automatic_date_parsing")

    @property
    @pulumi.getter
    def category(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "category")

    @property
    @pulumi.getter(name="collectorId")
    def collector_id(self) -> pulumi.Output[int]:
        return pulumi.get(self, "collector_id")

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> pulumi.Output[str]:
        """
        The content-type of the collected data. It should be `AwsS3ArchiveBucket` for archive source. Details can be found in the [Sumologic documentation for hosted sources](https://help.sumologic.com/Send_Data/Sources/03Use_JSON_to_Configure_Sources/JSON_Parameters_for_Hosted_Sources).
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter(name="cutoffRelativeTime")
    def cutoff_relative_time(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "cutoff_relative_time")

    @property
    @pulumi.getter(name="cutoffTimestamp")
    def cutoff_timestamp(self) -> pulumi.Output[Optional[int]]:
        return pulumi.get(self, "cutoff_timestamp")

    @property
    @pulumi.getter(name="defaultDateFormats")
    def default_date_formats(self) -> pulumi.Output[Optional[Sequence['outputs.S3ArchiveSourceDefaultDateFormat']]]:
        return pulumi.get(self, "default_date_formats")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def fields(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        return pulumi.get(self, "fields")

    @property
    @pulumi.getter
    def filters(self) -> pulumi.Output[Optional[Sequence['outputs.S3ArchiveSourceFilter']]]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter(name="forceTimezone")
    def force_timezone(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "force_timezone")

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "host_name")

    @property
    @pulumi.getter(name="manualPrefixRegexp")
    def manual_prefix_regexp(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "manual_prefix_regexp")

    @property
    @pulumi.getter(name="multilineProcessingEnabled")
    def multiline_processing_enabled(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "multiline_processing_enabled")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def path(self) -> pulumi.Output['outputs.S3ArchiveSourcePath']:
        """
        The location to scan for new data.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def paused(self) -> pulumi.Output[bool]:
        """
        When set to true, the scanner is paused. To disable, set to false.
        """
        return pulumi.get(self, "paused")

    @property
    @pulumi.getter(name="scanInterval")
    def scan_interval(self) -> pulumi.Output[int]:
        """
        Time interval in milliseconds of scans for new data. The default is 300000 and the minimum value is 1000 milliseconds.
        """
        return pulumi.get(self, "scan_interval")

    @property
    @pulumi.getter
    def timezone(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "timezone")

    @property
    @pulumi.getter
    def url(self) -> pulumi.Output[str]:
        """
        The HTTP endpoint to use with [SNS to notify Sumo Logic of new files](https://help.sumologic.com/03Send-Data/Sources/02Sources-for-Hosted-Collectors/Amazon-Web-Services/AWS-S3-Source#Set_up_SNS_in_AWS_(Optional)).
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="useAutolineMatching")
    def use_autoline_matching(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "use_autoline_matching")

