# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['SubdomainArgs', 'Subdomain']

@pulumi.input_type
class SubdomainArgs:
    def __init__(__self__, *,
                 subdomain: pulumi.Input[str]):
        """
        The set of arguments for constructing a Subdomain resource.
        :param pulumi.Input[str] subdomain: The subdomain.
        """
        SubdomainArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            subdomain=subdomain,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             subdomain: pulumi.Input[str],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("subdomain", subdomain)

    @property
    @pulumi.getter
    def subdomain(self) -> pulumi.Input[str]:
        """
        The subdomain.
        """
        return pulumi.get(self, "subdomain")

    @subdomain.setter
    def subdomain(self, value: pulumi.Input[str]):
        pulumi.set(self, "subdomain", value)


@pulumi.input_type
class _SubdomainState:
    def __init__(__self__, *,
                 subdomain: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Subdomain resources.
        :param pulumi.Input[str] subdomain: The subdomain.
        """
        _SubdomainState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            subdomain=subdomain,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             subdomain: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if subdomain is not None:
            _setter("subdomain", subdomain)

    @property
    @pulumi.getter
    def subdomain(self) -> Optional[pulumi.Input[str]]:
        """
        The subdomain.
        """
        return pulumi.get(self, "subdomain")

    @subdomain.setter
    def subdomain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subdomain", value)


class Subdomain(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 subdomain: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a [Sumologic Subdomain](https://help.sumologic.com/Manage/01Account_Usage/05Manage_Organization#change-account-subdomain).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sumologic as sumologic

        example_subdomain = sumologic.Subdomain("exampleSubdomain", subdomain="my-company")
        ```
        ## Attributes reference

        The following attributes are exported:

        - `id` - Unique identifier for the subdomain.

        [1]: https://help.sumologic.com/Manage/01Account_Usage/05Manage_Organization#change-account-subdomain

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] subdomain: The subdomain.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SubdomainArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a [Sumologic Subdomain](https://help.sumologic.com/Manage/01Account_Usage/05Manage_Organization#change-account-subdomain).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sumologic as sumologic

        example_subdomain = sumologic.Subdomain("exampleSubdomain", subdomain="my-company")
        ```
        ## Attributes reference

        The following attributes are exported:

        - `id` - Unique identifier for the subdomain.

        [1]: https://help.sumologic.com/Manage/01Account_Usage/05Manage_Organization#change-account-subdomain

        :param str resource_name: The name of the resource.
        :param SubdomainArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SubdomainArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            SubdomainArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 subdomain: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SubdomainArgs.__new__(SubdomainArgs)

            if subdomain is None and not opts.urn:
                raise TypeError("Missing required property 'subdomain'")
            __props__.__dict__["subdomain"] = subdomain
        super(Subdomain, __self__).__init__(
            'sumologic:index/subdomain:Subdomain',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            subdomain: Optional[pulumi.Input[str]] = None) -> 'Subdomain':
        """
        Get an existing Subdomain resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] subdomain: The subdomain.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SubdomainState.__new__(_SubdomainState)

        __props__.__dict__["subdomain"] = subdomain
        return Subdomain(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def subdomain(self) -> pulumi.Output[str]:
        """
        The subdomain.
        """
        return pulumi.get(self, "subdomain")

