# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['UserArgs', 'User']

@pulumi.input_type
class UserArgs:
    def __init__(__self__, *,
                 email: pulumi.Input[str],
                 first_name: pulumi.Input[str],
                 is_active: pulumi.Input[bool],
                 last_name: pulumi.Input[str],
                 role_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
                 transfer_to: pulumi.Input[str]):
        """
        The set of arguments for constructing a User resource.
        :param pulumi.Input[str] email: Email of the user.
        :param pulumi.Input[str] first_name: First name of the user.
        :param pulumi.Input[bool] is_active: This has the value true if the user is active and false if they have been deactivated.
        :param pulumi.Input[str] last_name: Last name of the user.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] role_ids: List of roleIds associated with the user.
        :param pulumi.Input[str] transfer_to: UserId of user to transfer this user's content to on deletion, can be empty. Must be applied prior to deletion to take effect.
               
               The following attributes are exported:
        """
        UserArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            email=email,
            first_name=first_name,
            is_active=is_active,
            last_name=last_name,
            role_ids=role_ids,
            transfer_to=transfer_to,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             email: pulumi.Input[str],
             first_name: pulumi.Input[str],
             is_active: pulumi.Input[bool],
             last_name: pulumi.Input[str],
             role_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
             transfer_to: pulumi.Input[str],
             opts: Optional[pulumi.ResourceOptions]=None):
        _setter("email", email)
        _setter("first_name", first_name)
        _setter("is_active", is_active)
        _setter("last_name", last_name)
        _setter("role_ids", role_ids)
        _setter("transfer_to", transfer_to)

    @property
    @pulumi.getter
    def email(self) -> pulumi.Input[str]:
        """
        Email of the user.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: pulumi.Input[str]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> pulumi.Input[str]:
        """
        First name of the user.
        """
        return pulumi.get(self, "first_name")

    @first_name.setter
    def first_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "first_name", value)

    @property
    @pulumi.getter(name="isActive")
    def is_active(self) -> pulumi.Input[bool]:
        """
        This has the value true if the user is active and false if they have been deactivated.
        """
        return pulumi.get(self, "is_active")

    @is_active.setter
    def is_active(self, value: pulumi.Input[bool]):
        pulumi.set(self, "is_active", value)

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> pulumi.Input[str]:
        """
        Last name of the user.
        """
        return pulumi.get(self, "last_name")

    @last_name.setter
    def last_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "last_name", value)

    @property
    @pulumi.getter(name="roleIds")
    def role_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of roleIds associated with the user.
        """
        return pulumi.get(self, "role_ids")

    @role_ids.setter
    def role_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "role_ids", value)

    @property
    @pulumi.getter(name="transferTo")
    def transfer_to(self) -> pulumi.Input[str]:
        """
        UserId of user to transfer this user's content to on deletion, can be empty. Must be applied prior to deletion to take effect.

        The following attributes are exported:
        """
        return pulumi.get(self, "transfer_to")

    @transfer_to.setter
    def transfer_to(self, value: pulumi.Input[str]):
        pulumi.set(self, "transfer_to", value)


@pulumi.input_type
class _UserState:
    def __init__(__self__, *,
                 email: Optional[pulumi.Input[str]] = None,
                 first_name: Optional[pulumi.Input[str]] = None,
                 is_active: Optional[pulumi.Input[bool]] = None,
                 last_name: Optional[pulumi.Input[str]] = None,
                 role_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 transfer_to: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering User resources.
        :param pulumi.Input[str] email: Email of the user.
        :param pulumi.Input[str] first_name: First name of the user.
        :param pulumi.Input[bool] is_active: This has the value true if the user is active and false if they have been deactivated.
        :param pulumi.Input[str] last_name: Last name of the user.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] role_ids: List of roleIds associated with the user.
        :param pulumi.Input[str] transfer_to: UserId of user to transfer this user's content to on deletion, can be empty. Must be applied prior to deletion to take effect.
               
               The following attributes are exported:
        """
        _UserState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            email=email,
            first_name=first_name,
            is_active=is_active,
            last_name=last_name,
            role_ids=role_ids,
            transfer_to=transfer_to,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             email: Optional[pulumi.Input[str]] = None,
             first_name: Optional[pulumi.Input[str]] = None,
             is_active: Optional[pulumi.Input[bool]] = None,
             last_name: Optional[pulumi.Input[str]] = None,
             role_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
             transfer_to: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None):
        if email is not None:
            _setter("email", email)
        if first_name is not None:
            _setter("first_name", first_name)
        if is_active is not None:
            _setter("is_active", is_active)
        if last_name is not None:
            _setter("last_name", last_name)
        if role_ids is not None:
            _setter("role_ids", role_ids)
        if transfer_to is not None:
            _setter("transfer_to", transfer_to)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[str]]:
        """
        Email of the user.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> Optional[pulumi.Input[str]]:
        """
        First name of the user.
        """
        return pulumi.get(self, "first_name")

    @first_name.setter
    def first_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "first_name", value)

    @property
    @pulumi.getter(name="isActive")
    def is_active(self) -> Optional[pulumi.Input[bool]]:
        """
        This has the value true if the user is active and false if they have been deactivated.
        """
        return pulumi.get(self, "is_active")

    @is_active.setter
    def is_active(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_active", value)

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> Optional[pulumi.Input[str]]:
        """
        Last name of the user.
        """
        return pulumi.get(self, "last_name")

    @last_name.setter
    def last_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_name", value)

    @property
    @pulumi.getter(name="roleIds")
    def role_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of roleIds associated with the user.
        """
        return pulumi.get(self, "role_ids")

    @role_ids.setter
    def role_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "role_ids", value)

    @property
    @pulumi.getter(name="transferTo")
    def transfer_to(self) -> Optional[pulumi.Input[str]]:
        """
        UserId of user to transfer this user's content to on deletion, can be empty. Must be applied prior to deletion to take effect.

        The following attributes are exported:
        """
        return pulumi.get(self, "transfer_to")

    @transfer_to.setter
    def transfer_to(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transfer_to", value)


class User(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 first_name: Optional[pulumi.Input[str]] = None,
                 is_active: Optional[pulumi.Input[bool]] = None,
                 last_name: Optional[pulumi.Input[str]] = None,
                 role_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 transfer_to: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a [Sumologic User](https://help.sumologic.com/Manage/Users-and-Roles/Manage-Users).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sumologic as sumologic

        example_role = sumologic.Role("exampleRole", description="Testing resource sumologic_role")
        example_user1 = sumologic.User("exampleUser1",
            first_name="Jon",
            last_name="Doe",
            email="jon.doe@gmail.com",
            is_active=True,
            role_ids=[example_role.id],
            transfer_to="")
        example_user2 = sumologic.User("exampleUser2",
            first_name="Jane",
            last_name="Smith",
            email="jane.smith@gmail.com",
            role_ids=[example_role.id],
            transfer_to=example_user1.id)
        ```

        ## Import

        Users can be imported using the user id, e.g.hcl

        ```sh
         $ pulumi import sumologic:index/user:User user 1234567890
        ```

         [1]https://help.sumologic.com/Manage/Users-and-Roles/Manage-Users

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] email: Email of the user.
        :param pulumi.Input[str] first_name: First name of the user.
        :param pulumi.Input[bool] is_active: This has the value true if the user is active and false if they have been deactivated.
        :param pulumi.Input[str] last_name: Last name of the user.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] role_ids: List of roleIds associated with the user.
        :param pulumi.Input[str] transfer_to: UserId of user to transfer this user's content to on deletion, can be empty. Must be applied prior to deletion to take effect.
               
               The following attributes are exported:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a [Sumologic User](https://help.sumologic.com/Manage/Users-and-Roles/Manage-Users).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sumologic as sumologic

        example_role = sumologic.Role("exampleRole", description="Testing resource sumologic_role")
        example_user1 = sumologic.User("exampleUser1",
            first_name="Jon",
            last_name="Doe",
            email="jon.doe@gmail.com",
            is_active=True,
            role_ids=[example_role.id],
            transfer_to="")
        example_user2 = sumologic.User("exampleUser2",
            first_name="Jane",
            last_name="Smith",
            email="jane.smith@gmail.com",
            role_ids=[example_role.id],
            transfer_to=example_user1.id)
        ```

        ## Import

        Users can be imported using the user id, e.g.hcl

        ```sh
         $ pulumi import sumologic:index/user:User user 1234567890
        ```

         [1]https://help.sumologic.com/Manage/Users-and-Roles/Manage-Users

        :param str resource_name: The name of the resource.
        :param UserArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            UserArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 first_name: Optional[pulumi.Input[str]] = None,
                 is_active: Optional[pulumi.Input[bool]] = None,
                 last_name: Optional[pulumi.Input[str]] = None,
                 role_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 transfer_to: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserArgs.__new__(UserArgs)

            if email is None and not opts.urn:
                raise TypeError("Missing required property 'email'")
            __props__.__dict__["email"] = email
            if first_name is None and not opts.urn:
                raise TypeError("Missing required property 'first_name'")
            __props__.__dict__["first_name"] = first_name
            if is_active is None and not opts.urn:
                raise TypeError("Missing required property 'is_active'")
            __props__.__dict__["is_active"] = is_active
            if last_name is None and not opts.urn:
                raise TypeError("Missing required property 'last_name'")
            __props__.__dict__["last_name"] = last_name
            if role_ids is None and not opts.urn:
                raise TypeError("Missing required property 'role_ids'")
            __props__.__dict__["role_ids"] = role_ids
            if transfer_to is None and not opts.urn:
                raise TypeError("Missing required property 'transfer_to'")
            __props__.__dict__["transfer_to"] = transfer_to
        super(User, __self__).__init__(
            'sumologic:index/user:User',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            email: Optional[pulumi.Input[str]] = None,
            first_name: Optional[pulumi.Input[str]] = None,
            is_active: Optional[pulumi.Input[bool]] = None,
            last_name: Optional[pulumi.Input[str]] = None,
            role_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            transfer_to: Optional[pulumi.Input[str]] = None) -> 'User':
        """
        Get an existing User resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] email: Email of the user.
        :param pulumi.Input[str] first_name: First name of the user.
        :param pulumi.Input[bool] is_active: This has the value true if the user is active and false if they have been deactivated.
        :param pulumi.Input[str] last_name: Last name of the user.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] role_ids: List of roleIds associated with the user.
        :param pulumi.Input[str] transfer_to: UserId of user to transfer this user's content to on deletion, can be empty. Must be applied prior to deletion to take effect.
               
               The following attributes are exported:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserState.__new__(_UserState)

        __props__.__dict__["email"] = email
        __props__.__dict__["first_name"] = first_name
        __props__.__dict__["is_active"] = is_active
        __props__.__dict__["last_name"] = last_name
        __props__.__dict__["role_ids"] = role_ids
        __props__.__dict__["transfer_to"] = transfer_to
        return User(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def email(self) -> pulumi.Output[str]:
        """
        Email of the user.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> pulumi.Output[str]:
        """
        First name of the user.
        """
        return pulumi.get(self, "first_name")

    @property
    @pulumi.getter(name="isActive")
    def is_active(self) -> pulumi.Output[bool]:
        """
        This has the value true if the user is active and false if they have been deactivated.
        """
        return pulumi.get(self, "is_active")

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> pulumi.Output[str]:
        """
        Last name of the user.
        """
        return pulumi.get(self, "last_name")

    @property
    @pulumi.getter(name="roleIds")
    def role_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        List of roleIds associated with the user.
        """
        return pulumi.get(self, "role_ids")

    @property
    @pulumi.getter(name="transferTo")
    def transfer_to(self) -> pulumi.Output[str]:
        """
        UserId of user to transfer this user's content to on deletion, can be empty. Must be applied prior to deletion to take effect.

        The following attributes are exported:
        """
        return pulumi.get(self, "transfer_to")

