from rasa.shared.constants import (
    MAX_COMPLETION_TOKENS_CONFIG_KEY,
    MODEL_CONFIG_KEY,
    OPENAI_PROVIDER,
    PROVIDER_CONFIG_KEY,
    TEMPERATURE_CONFIG_KEY,
    TIMEOUT_CONFIG_KEY,
)
from rasa.shared.utils.llm import (
    DEFAULT_OPENAI_CHAT_MODEL_NAME_ADVANCED,
    DEFAULT_OPENAI_MAX_GENERATED_TOKENS,
)

DEFAULT_LLM_CONFIG = {
    PROVIDER_CONFIG_KEY: OPENAI_PROVIDER,
    MODEL_CONFIG_KEY: DEFAULT_OPENAI_CHAT_MODEL_NAME_ADVANCED,
    TEMPERATURE_CONFIG_KEY: 0.0,
    MAX_COMPLETION_TOKENS_CONFIG_KEY: DEFAULT_OPENAI_MAX_GENERATED_TOKENS,
    TIMEOUT_CONFIG_KEY: 7,
}

LLM_CONFIG_KEY = "llm"
USER_INPUT_CONFIG_KEY = "user_input"

FLOW_RETRIEVAL_KEY = "flow_retrieval"
FLOW_RETRIEVAL_ACTIVE_KEY = "active"
FLOW_RETRIEVAL_EMBEDDINGS_CONFIG_KEY = "embeddings"

FLOW_RETRIEVAL_FLOW_THRESHOLD = 20

COMMAND_PROMPT_FILE_NAME = "command_prompt.jinja2"
LLM_BASED_COMMAND_GENERATOR_CONFIG_FILE = "config.json"

MODEL_NAME_GPT_4O_2024_11_20 = "gpt-4o-2024-11-20"
MODEL_NAME_CLAUDE_3_5_SONNET_20240620 = "claude-3-5-sonnet-20240620"

# JINJA template filters

TO_JSON_ESCAPED_STRING_JINJA_FILTER = "to_json_escaped_string"
